/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_OAEPDigest;
import com.rsa.jsafe.JA_PSSDigest;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;

public class JA_SHA1
extends JSAFE_Object
implements JA_AlgaeDigest,
JA_OAEPDigest,
JA_PSSDigest,
JA_MGFUnderlyingAlgorithm,
Cloneable,
Serializable {
    protected int state1;
    protected int state2;
    protected int state3;
    protected int state4;
    protected int state5;
    private int[] xArray = new int[80];
    protected long count;
    private byte[] contextBuffer = new byte[64];
    private static final byte[] ENCODE_PREFIX = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private int objectState;
    private static final int NOT_INITIALIZED = 1;
    private static final int SHA1_INITIALIZED = 2;
    private static final int SHA1_FINALIZED = 3;
    private static final int SHA1_OUTPUT_SIZE = 20;
    private static final int SHA1_BLOCK_SIZE = 64;
    private static final int SHA1_PAD_SIZE = 8;
    private static final int A_INDEX = 0;
    private static final int B_INDEX = 1;
    private static final int C_INDEX = 2;
    private static final int D_INDEX = 3;
    private static final int E_INDEX = 4;

    public JA_SHA1() {
    }

    public JA_SHA1(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "SHA1";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID() {
        byte[] byArray = null;
        try {
            byArray = AlgorithmID.derEncodeAlgID("SHA1", 10, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            byArray = null;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 64;
    }

    public int getPadSize() {
        return 8;
    }

    public int getDigestSize() {
        return 20;
    }

    public int getEncodedDigestSize() {
        return ENCODE_PREFIX.length + 20;
    }

    protected JA_SHA1 newEmptyObject() {
        return new JA_SHA1();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_SHA1 jA_SHA1 = this.newEmptyObject();
        jA_SHA1.state1 = this.state1;
        jA_SHA1.state2 = this.state2;
        jA_SHA1.state3 = this.state3;
        jA_SHA1.state4 = this.state4;
        jA_SHA1.state5 = this.state5;
        if (this.xArray != null) {
            jA_SHA1.xArray = (int[])this.xArray.clone();
        }
        jA_SHA1.count = this.count;
        if (this.contextBuffer != null) {
            jA_SHA1.contextBuffer = (byte[])this.contextBuffer.clone();
        }
        jA_SHA1.objectState = this.objectState;
        return jA_SHA1;
    }

    protected long getCount() {
        return this.count;
    }

    public void digestInit() {
        this.count = 0L;
        this.state1 = 1732584193;
        this.state2 = -271733879;
        this.state3 = -1732584194;
        this.state4 = 271733878;
        this.state5 = -1009589776;
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        if (n2 <= 0) {
            return;
        }
        int n3 = (int)(this.count & 0x3FL);
        int n4 = 64 - n3;
        this.count += (long)n2;
        if (n2 >= n4) {
            if (n3 != 0) {
                System.arraycopy(byArray, n, this.contextBuffer, n3, n4);
                n3 += n4;
                n += n4;
                this.SHA1Transform(this.contextBuffer, 0);
                n2 -= n4;
                n3 = 0;
            }
            while (n2 >= 64) {
                this.SHA1Transform(byArray, n);
                n2 -= 64;
                n += 64;
            }
        }
        System.arraycopy(byArray, n, this.contextBuffer, n3, n2);
        n3 += n2;
        n += n2;
    }

    void digestAddFinalPad() throws JSAFE_InvalidUseException {
        int n = (int)(this.count & 0x3FL);
        int n2 = n < 56 ? 56 - n : 120 - n;
        byte[] byArray = new byte[n2];
        byArray[0] = -128;
        long l = this.count << 3;
        byte[] byArray2 = new byte[8];
        byArray2[7] = (byte)(l & 0xFFL);
        byArray2[6] = (byte)(l >> 8 & 0xFFL);
        byArray2[5] = (byte)(l >> 16 & 0xFFL);
        byArray2[4] = (byte)(l >> 24 & 0xFFL);
        byArray2[3] = (byte)(l >> 32 & 0xFFL);
        byArray2[2] = (byte)(l >> 40 & 0xFFL);
        byArray2[1] = (byte)(l >> 48 & 0xFFL);
        byArray2[0] = (byte)(l >> 56 & 0xFFL);
        this.digestUpdate(byArray, 0, n2);
        this.digestUpdate(byArray2, 0, 8);
    }

    public int digestFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        this.digestAddFinalPad();
        this.getState(byArray, n);
        return 20;
    }

    public int derEncode(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ENCODE_PREFIX.length + 20;
        int n4 = 0;
        while (n4 < ENCODE_PREFIX.length) {
            byArray2[n2] = ENCODE_PREFIX[n4];
            ++n4;
            ++n2;
        }
        while (n4 < n3) {
            byArray2[n2] = byArray[n];
            ++n4;
            ++n2;
            ++n;
        }
        return n3;
    }

    private void SHA1Transform(byte[] byArray, int n) {
        int n2;
        int n3 = this.state1;
        int n4 = this.state2;
        int n5 = this.state3;
        int n6 = this.state4;
        int n7 = this.state5;
        int n8 = 0;
        while (n8 < 16) {
            n2 = (byArray[n] & 0xFF) << 24;
            n2 |= (byArray[++n] & 0xFF) << 16;
            n2 |= (byArray[++n] & 0xFF) << 8;
            n2 |= byArray[++n] & 0xFF;
            ++n;
            this.xArray[n8] = n2;
            ++n8;
        }
        n8 = 16;
        while (n8 < 80) {
            n2 = this.xArray[n8 - 3] ^ this.xArray[n8 - 8] ^ this.xArray[n8 - 14] ^ this.xArray[n8 - 16];
            this.xArray[n8] = n2 << 1 | n2 >>> 31;
            ++n8;
        }
        n7 += n3 << 5 | n3 >>> 27;
        n7 += n4 & n5 | ~n4 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[0] + 1518500249) << 5 | n7 >>> 27;
        n6 += n3 & n4 | ~n3 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[1] + 1518500249) << 5 | n6 >>> 27;
        n5 += n7 & n3 | ~n7 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[2] + 1518500249) << 5 | n5 >>> 27;
        n4 += n6 & n7 | ~n6 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[3] + 1518500249) << 5 | n4 >>> 27;
        n3 += n5 & n6 | ~n5 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[4] + 1518500249) << 5 | n3 >>> 27;
        n7 += n4 & n5 | ~n4 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[5] + 1518500249) << 5 | n7 >>> 27;
        n6 += n3 & n4 | ~n3 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[6] + 1518500249) << 5 | n6 >>> 27;
        n5 += n7 & n3 | ~n7 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[7] + 1518500249) << 5 | n5 >>> 27;
        n4 += n6 & n7 | ~n6 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[8] + 1518500249) << 5 | n4 >>> 27;
        n3 += n5 & n6 | ~n5 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[9] + 1518500249) << 5 | n3 >>> 27;
        n7 += n4 & n5 | ~n4 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[10] + 1518500249) << 5 | n7 >>> 27;
        n6 += n3 & n4 | ~n3 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[11] + 1518500249) << 5 | n6 >>> 27;
        n5 += n7 & n3 | ~n7 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[12] + 1518500249) << 5 | n5 >>> 27;
        n4 += n6 & n7 | ~n6 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[13] + 1518500249) << 5 | n4 >>> 27;
        n3 += n5 & n6 | ~n5 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[14] + 1518500249) << 5 | n3 >>> 27;
        n7 += n4 & n5 | ~n4 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[15] + 1518500249) << 5 | n7 >>> 27;
        n6 += n3 & n4 | ~n3 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[16] + 1518500249) << 5 | n6 >>> 27;
        n5 += n7 & n3 | ~n7 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[17] + 1518500249) << 5 | n5 >>> 27;
        n4 += n6 & n7 | ~n6 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[18] + 1518500249) << 5 | n4 >>> 27;
        n3 += n5 & n6 | ~n5 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[19] + 1518500249) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[20] + 1859775393) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[21] + 1859775393) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[22] + 1859775393) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[23] + 1859775393) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[24] + 1859775393) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[25] + 1859775393) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[26] + 1859775393) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[27] + 1859775393) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[28] + 1859775393) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[29] + 1859775393) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[30] + 1859775393) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[31] + 1859775393) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[32] + 1859775393) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[33] + 1859775393) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[34] + 1859775393) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[35] + 1859775393) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[36] + 1859775393) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[37] + 1859775393) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[38] + 1859775393) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[39] + 1859775393) << 5 | n3 >>> 27;
        n7 += n4 & n5 | n4 & n6 | n5 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[40] + -1894007588) << 5 | n7 >>> 27;
        n6 += n3 & n4 | n3 & n5 | n4 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[41] + -1894007588) << 5 | n6 >>> 27;
        n5 += n7 & n3 | n7 & n4 | n3 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[42] + -1894007588) << 5 | n5 >>> 27;
        n4 += n6 & n7 | n6 & n3 | n7 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[43] + -1894007588) << 5 | n4 >>> 27;
        n3 += n5 & n6 | n5 & n7 | n6 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[44] + -1894007588) << 5 | n3 >>> 27;
        n7 += n4 & n5 | n4 & n6 | n5 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[45] + -1894007588) << 5 | n7 >>> 27;
        n6 += n3 & n4 | n3 & n5 | n4 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[46] + -1894007588) << 5 | n6 >>> 27;
        n5 += n7 & n3 | n7 & n4 | n3 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[47] + -1894007588) << 5 | n5 >>> 27;
        n4 += n6 & n7 | n6 & n3 | n7 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[48] + -1894007588) << 5 | n4 >>> 27;
        n3 += n5 & n6 | n5 & n7 | n6 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[49] + -1894007588) << 5 | n3 >>> 27;
        n7 += n4 & n5 | n4 & n6 | n5 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[50] + -1894007588) << 5 | n7 >>> 27;
        n6 += n3 & n4 | n3 & n5 | n4 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[51] + -1894007588) << 5 | n6 >>> 27;
        n5 += n7 & n3 | n7 & n4 | n3 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[52] + -1894007588) << 5 | n5 >>> 27;
        n4 += n6 & n7 | n6 & n3 | n7 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[53] + -1894007588) << 5 | n4 >>> 27;
        n3 += n5 & n6 | n5 & n7 | n6 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[54] + -1894007588) << 5 | n3 >>> 27;
        n7 += n4 & n5 | n4 & n6 | n5 & n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[55] + -1894007588) << 5 | n7 >>> 27;
        n6 += n3 & n4 | n3 & n5 | n4 & n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[56] + -1894007588) << 5 | n6 >>> 27;
        n5 += n7 & n3 | n7 & n4 | n3 & n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[57] + -1894007588) << 5 | n5 >>> 27;
        n4 += n6 & n7 | n6 & n3 | n7 & n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[58] + -1894007588) << 5 | n4 >>> 27;
        n3 += n5 & n6 | n5 & n7 | n6 & n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[59] + -1894007588) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[60] + -899497514) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[61] + -899497514) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[62] + -899497514) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[63] + -899497514) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[64] + -899497514) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[65] + -899497514) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[66] + -899497514) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[67] + -899497514) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[68] + -899497514) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[69] + -899497514) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[70] + -899497514) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[71] + -899497514) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[72] + -899497514) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[73] + -899497514) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        n7 += (n3 += this.xArray[74] + -899497514) << 5 | n3 >>> 27;
        n7 += n4 ^ n5 ^ n6;
        n4 = n4 << 30 | n4 >>> 2;
        n6 += (n7 += this.xArray[75] + -899497514) << 5 | n7 >>> 27;
        n6 += n3 ^ n4 ^ n5;
        n3 = n3 << 30 | n3 >>> 2;
        n5 += (n6 += this.xArray[76] + -899497514) << 5 | n6 >>> 27;
        n5 += n7 ^ n3 ^ n4;
        n7 = n7 << 30 | n7 >>> 2;
        n4 += (n5 += this.xArray[77] + -899497514) << 5 | n5 >>> 27;
        n4 += n6 ^ n7 ^ n3;
        n6 = n6 << 30 | n6 >>> 2;
        n3 += (n4 += this.xArray[78] + -899497514) << 5 | n4 >>> 27;
        n3 += n5 ^ n6 ^ n7;
        n5 = n5 << 30 | n5 >>> 2;
        this.state1 += (n3 += this.xArray[79] + -899497514);
        this.state2 += n4;
        this.state3 += n5;
        this.state4 += n6;
        this.state5 += n7;
    }

    void getState(byte[] byArray, int n) {
        byArray[n] = (byte)(this.state1 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.state1 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state1 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state1 & 0xFF);
        byArray[++n] = (byte)(this.state2 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.state2 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state2 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state2 & 0xFF);
        byArray[++n] = (byte)(this.state3 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.state3 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state3 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state3 & 0xFF);
        byArray[++n] = (byte)(this.state4 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.state4 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state4 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state4 & 0xFF);
        byArray[++n] = (byte)(this.state5 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.state5 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.state5 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.state5 & 0xFF);
        ++n;
    }

    public void clearSensitiveData() {
        int n = 0;
        while (n < this.contextBuffer.length) {
            this.contextBuffer[n] = 0;
            ++n;
        }
        this.state1 = 0;
        this.state2 = 0;
        this.state3 = 0;
        this.state4 = 0;
        this.state5 = 0;
        n = 0;
        while (n < this.xArray.length) {
            this.xArray[n] = 0;
            ++n;
        }
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

