/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_OAEPDigest;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;

public class JA_SHA256
extends JSAFE_Object
implements JA_AlgaeDigest,
JA_OAEPDigest,
JA_MGFUnderlyingAlgorithm,
Cloneable,
Serializable {
    protected int h0;
    protected int h1;
    protected int h2;
    protected int h3;
    protected int h4;
    protected int h5;
    protected int h6;
    protected int h7;
    private final int H0INIT = 1779033703;
    private final int H1INIT = -1150833019;
    private final int H2INIT = 1013904242;
    private final int H3INIT = -1521486534;
    private final int H4INIT = 1359893119;
    private final int H5INIT = -1694144372;
    private final int H6INIT = 528734635;
    private final int H7INIT = 1541459225;
    protected int[] bytes_processed = new int[2];
    protected int part_buffer_size;
    private int[] W;
    private static final int NOT_INITIALIZED = 1;
    private static final int SHA256_INITIALIZED = 2;
    private static final int SHA256_FINALIZED = 3;
    private static final int SHA256_OUTPUT_SIZE = 32;
    private static final int SHA256_BLOCK_SIZE = 64;
    private static final int SHA256_PAD_SIZE = 8;
    private static final int SHA256_NUM_ROUNDS = 64;
    private static final int SHA256_NUM_MS_ROUNDS = 64;
    private static final int W_ARRAY_SIZE = 64;
    private byte[] buffer = new byte[64];
    private int objectState = 1;
    private static final byte[] ENCODE_PREFIX = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public JA_SHA256() {
    }

    public JA_SHA256(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "SHA256";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID() {
        byte[] byArray = null;
        try {
            byArray = AlgorithmID.derEncodeAlgID("SHA256", 10, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            byArray = null;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 64;
    }

    public int getPadSize() {
        return 8;
    }

    public int getDigestSize() {
        return 32;
    }

    public int getEncodedDigestSize() {
        return ENCODE_PREFIX.length + 32;
    }

    protected JA_SHA256 newEmptyObject() {
        return new JA_SHA256();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_SHA256 jA_SHA256 = this.newEmptyObject();
        jA_SHA256.h0 = this.h0;
        jA_SHA256.h1 = this.h1;
        jA_SHA256.h2 = this.h2;
        jA_SHA256.h3 = this.h3;
        jA_SHA256.h4 = this.h4;
        jA_SHA256.h5 = this.h5;
        jA_SHA256.h6 = this.h6;
        jA_SHA256.h7 = this.h7;
        jA_SHA256.part_buffer_size = this.part_buffer_size;
        jA_SHA256.buffer = new byte[64];
        jA_SHA256.bytes_processed = new int[2];
        int n = 0;
        while (n < 2) {
            jA_SHA256.bytes_processed[n] = this.bytes_processed[n];
            ++n;
        }
        if (this.buffer != null) {
            jA_SHA256.buffer = (byte[])this.buffer.clone();
        }
        jA_SHA256.objectState = this.objectState;
        return jA_SHA256;
    }

    public void digestInit() {
        this.bytes_processed[0] = 0;
        this.bytes_processed[1] = 0;
        this.part_buffer_size = 0;
        this.h0 = 1779033703;
        this.h1 = -1150833019;
        this.h2 = 1013904242;
        this.h3 = -1521486534;
        this.h4 = 1359893119;
        this.h5 = -1694144372;
        this.h6 = 528734635;
        this.h7 = 1541459225;
        this.objectState = 2;
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        if (byArray == null) {
            throw new JSAFE_InvalidUseException("partIn is Null");
        }
        if (n > byArray.length) {
            throw new JSAFE_InvalidUseException("offset exceeds partInLength");
        }
        if (n < 0) {
            throw new JSAFE_InvalidUseException("offset below zero");
        }
        int n3 = n2;
        int n4 = this.part_buffer_size & 0x3F;
        if (n3 <= 64 - n4) {
            System.arraycopy(byArray, n, this.buffer, n4, n3);
            this.part_buffer_size += n3;
            if ((this.part_buffer_size & 0x3F) == 0) {
                this.SHA256Transform(this.buffer, 0);
                this.bytes_processed[1] = this.bytes_processed[1] + 64;
                if (this.bytes_processed[1] < 64) {
                    this.bytes_processed[0] = this.bytes_processed[0] + 1;
                }
                this.part_buffer_size = 0;
            }
        } else {
            System.arraycopy(byArray, n, this.buffer, n4, 64 - n4);
            n += 64 - n4;
            this.SHA256Transform(this.buffer, 0);
            this.bytes_processed[1] = this.bytes_processed[1] + 64;
            if (this.bytes_processed[1] < 64) {
                this.bytes_processed[0] = this.bytes_processed[0] + 1;
            }
            n3 -= 64 - n4;
            while (n3 >= 64) {
                System.arraycopy(byArray, n, this.buffer, 0, 64);
                this.SHA256Transform(this.buffer, 0);
                this.bytes_processed[1] = this.bytes_processed[1] + 64;
                if (this.bytes_processed[1] < 64) {
                    this.bytes_processed[0] = this.bytes_processed[0] + 1;
                }
                n3 -= 64;
                n += 64;
            }
            if (n3 > 0) {
                System.arraycopy(byArray, n, this.buffer, 0, n3);
                this.part_buffer_size = n3;
            }
        }
    }

    public int digestFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        int[] nArray = new int[2];
        if (byArray == null) {
            throw new JSAFE_InvalidUseException("hash output array is null");
        }
        if (byArray.length < n) {
            throw new JSAFE_InvalidUseException("offset exceeds length of array");
        }
        if (n < 0) {
            throw new JSAFE_InvalidUseException("offset below zero");
        }
        if (this.objectState == 1) {
            throw new JSAFE_InvalidUseException("digest Not Initialized\n");
        }
        byte[] byArray2 = new byte[144];
        int n2 = 64 - (this.part_buffer_size & 0x3F);
        if (n2 <= 8) {
            n2 += 64;
        }
        byArray2[0] = -128;
        int n3 = 1;
        while (n3 < n2 - 7) {
            byArray2[n3] = 0;
            ++n3;
        }
        this.bytes_processed[1] = this.bytes_processed[1] + this.part_buffer_size;
        if (this.bytes_processed[1] < this.part_buffer_size) {
            this.bytes_processed[0] = this.bytes_processed[0] + 1;
        }
        nArray[0] = this.bytes_processed[0] << 3 | this.bytes_processed[1] >>> 29;
        nArray[1] = this.bytes_processed[1] << 3;
        byArray2[n2 - 8] = (byte)((nArray[0] & 0xFF000000) >>> 24);
        byArray2[n2 - 7] = (byte)((nArray[0] & 0xFF0000) >>> 16);
        byArray2[n2 - 6] = (byte)((nArray[0] & 0xFF00) >>> 8);
        byArray2[n2 - 5] = (byte)(nArray[0] & 0xFF);
        byArray2[n2 - 4] = (byte)((nArray[1] & 0xFF000000) >> 24);
        byArray2[n2 - 3] = (byte)((nArray[1] & 0xFF0000) >> 16);
        byArray2[n2 - 2] = (byte)((nArray[1] & 0xFF00) >> 8);
        byArray2[n2 - 1] = (byte)(nArray[1] & 0xFF);
        this.digestUpdate(byArray2, 0, n2);
        this.getState(byArray, n);
        return 32;
    }

    public int derEncode(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ENCODE_PREFIX.length + 32;
        System.arraycopy(ENCODE_PREFIX, 0, byArray2, n2, ENCODE_PREFIX.length);
        System.arraycopy(byArray, n, byArray2, n2 += ENCODE_PREFIX.length, byArray.length);
        return n3;
    }

    private void SHA256Transform(byte[] byArray, int n) {
        this.W = new int[64];
        int n2 = 0;
        while (n2 < 16) {
            this.W[n2] = (byArray[n] & 0xFF) << 24;
            int n3 = n2;
            this.W[n3] = this.W[n3] | (byArray[++n] & 0xFF) << 16;
            int n4 = n2;
            this.W[n4] = this.W[n4] | (byArray[++n] & 0xFF) << 8;
            int n5 = n2++;
            this.W[n5] = this.W[n5] | byArray[++n] & 0xFF;
            ++n;
        }
        n2 = 16;
        while (n2 < 64) {
            this.W[n2] = ((this.W[n2 - 2] >>> 17 | this.W[n2 - 2] << 15) ^ (this.W[n2 - 2] >>> 19 | this.W[n2 - 2] << 13) ^ this.W[n2 - 2] >>> 10) + this.W[n2 - 7] + ((this.W[n2 - 15] >>> 7 | this.W[n2 - 15] << 25) ^ (this.W[n2 - 15] >>> 18 | this.W[n2 - 15] << 14) ^ this.W[n2 - 15] >>> 3) + this.W[n2 - 16];
            ++n2;
        }
        int n6 = this.h0;
        int n7 = this.h1;
        int n8 = this.h2;
        int n9 = this.h3;
        int n10 = this.h4;
        int n11 = this.h5;
        int n12 = this.h6;
        int n13 = this.h7;
        n2 = 0;
        while (n2 < 64) {
            int n14 = n13 + ((n10 >>> 6 | n10 << 26) ^ (n10 >>> 11 | n10 << 21) ^ (n10 >>> 25 | n10 << 7)) + (n10 & n11 ^ ~n10 & n12) + this.K[n2] + this.W[n2];
            int n15 = ((n6 >>> 2 | n6 << 30) ^ (n6 >>> 13 | n6 << 19) ^ (n6 >>> 22 | n6 << 10)) + (n6 & n7 ^ n6 & n8 ^ n7 & n8);
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9 + n14;
            n9 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n14 + n15;
            ++n2;
        }
        this.h0 = n6 + this.h0;
        this.h1 = n7 + this.h1;
        this.h2 = n8 + this.h2;
        this.h3 = n9 + this.h3;
        this.h4 = n10 + this.h4;
        this.h5 = n11 + this.h5;
        this.h6 = n12 + this.h6;
        this.h7 = n13 + this.h7;
    }

    void getState(byte[] byArray, int n) {
        byArray[n] = (byte)(this.h0 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h0 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h0 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h0 & 0xFF);
        byArray[++n] = (byte)(this.h1 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h1 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h1 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h1 & 0xFF);
        byArray[++n] = (byte)(this.h2 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h2 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h2 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h2 & 0xFF);
        byArray[++n] = (byte)(this.h3 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h3 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h3 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h3 & 0xFF);
        byArray[++n] = (byte)(this.h4 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h4 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h4 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h4 & 0xFF);
        byArray[++n] = (byte)(this.h5 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h5 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h5 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h5 & 0xFF);
        byArray[++n] = (byte)(this.h6 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h6 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h6 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h6 & 0xFF);
        byArray[++n] = (byte)(this.h7 >>> 24 & 0xFF);
        byArray[++n] = (byte)(this.h7 >> 16 & 0xFF);
        byArray[++n] = (byte)(this.h7 >> 8 & 0xFF);
        byArray[++n] = (byte)(this.h7 & 0xFF);
        ++n;
    }

    public void clearSensitiveData() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = 0;
            ++n;
        }
        this.h0 = 0;
        this.h1 = 0;
        this.h2 = 0;
        this.h3 = 0;
        this.h4 = 0;
        this.h5 = 0;
        this.h6 = 0;
        this.h7 = 0;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

