/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_OAEPDigest;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;

public class JA_SHA512
extends JSAFE_Object
implements JA_AlgaeDigest,
JA_OAEPDigest,
JA_MGFUnderlyingAlgorithm,
Cloneable,
Serializable {
    protected long h0;
    protected long h1;
    protected long h2;
    protected long h3;
    protected long h4;
    protected long h5;
    protected long h6;
    protected long h7;
    private final long H0INIT = 7640891576956012808L;
    private final long H1INIT = -4942790177534073029L;
    private final long H2INIT = 4354685564936845355L;
    private final long H3INIT = -6534734903238641935L;
    private final long H4INIT = 5840696475078001361L;
    private final long H5INIT = -7276294671716946913L;
    private final long H6INIT = 2270897969802886507L;
    private final long H7INIT = 6620516959819538809L;
    protected long[] bytes_processed = new long[2];
    protected int part_buffer_size;
    private long[] W;
    private static final int NOT_INITIALIZED = 1;
    private static final int SHA512_INITIALIZED = 2;
    private static final int SHA512_FINALIZED = 3;
    private static final int SHA512_OUTPUT_SIZE = 64;
    private static final int SHA512_BLOCK_SIZE = 128;
    private static final int SHA512_PAD_SIZE = 16;
    private static final int SHA512_NUM_ROUNDS = 80;
    private static final int SHA512_NUM_MS_ROUNDS = 80;
    private static final int W_ARRAY_SIZE = 80;
    private byte[] buffer = new byte[128];
    private int objectState = 1;
    private static final byte[] ENCODE_PREFIX = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    private final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    public JA_SHA512() {
    }

    public JA_SHA512(int[] nArray) throws JSAFE_InvalidParameterException {
        this.setInstantiationParameters(nArray);
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of parameters: expected none.");
        }
    }

    public int[] getInstantiationParameters() {
        return new int[0];
    }

    public String getAlgorithm() {
        return "SHA512";
    }

    public void setAlgorithmBER(byte[] byArray, int n) {
    }

    public byte[] getDERAlgorithmID() {
        byte[] byArray = null;
        try {
            byArray = AlgorithmID.derEncodeAlgID("SHA512", 10, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            byArray = null;
        }
        return byArray;
    }

    public int getBlockSize() {
        return 128;
    }

    public int getPadSize() {
        return 16;
    }

    public int getDigestSize() {
        return 64;
    }

    public int getEncodedDigestSize() {
        return ENCODE_PREFIX.length + 64;
    }

    protected JA_SHA512 newEmptyObject() {
        return new JA_SHA512();
    }

    public Object clone() throws CloneNotSupportedException {
        JA_SHA512 jA_SHA512 = this.newEmptyObject();
        jA_SHA512.h0 = this.h0;
        jA_SHA512.h1 = this.h1;
        jA_SHA512.h2 = this.h2;
        jA_SHA512.h3 = this.h3;
        jA_SHA512.h4 = this.h4;
        jA_SHA512.h5 = this.h5;
        jA_SHA512.h6 = this.h6;
        jA_SHA512.h7 = this.h7;
        jA_SHA512.part_buffer_size = this.part_buffer_size;
        jA_SHA512.buffer = new byte[128];
        jA_SHA512.bytes_processed = new long[2];
        int n = 0;
        while (n < 2) {
            jA_SHA512.bytes_processed[n] = this.bytes_processed[n];
            ++n;
        }
        if (this.buffer != null) {
            jA_SHA512.buffer = (byte[])this.buffer.clone();
        }
        jA_SHA512.objectState = this.objectState;
        return jA_SHA512;
    }

    public void digestInit() {
        this.bytes_processed[0] = 0L;
        this.bytes_processed[1] = 0L;
        this.part_buffer_size = 0;
        this.h0 = 7640891576956012808L;
        this.h1 = -4942790177534073029L;
        this.h2 = 4354685564936845355L;
        this.h3 = -6534734903238641935L;
        this.h4 = 5840696475078001361L;
        this.h5 = -7276294671716946913L;
        this.h6 = 2270897969802886507L;
        this.h7 = 6620516959819538809L;
        this.objectState = 2;
    }

    public void digestUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        if (byArray == null) {
            throw new JSAFE_InvalidUseException("partIn is Null");
        }
        if (n > byArray.length) {
            throw new JSAFE_InvalidUseException("offset exceeds partInLength");
        }
        if (n < 0) {
            throw new JSAFE_InvalidUseException("offset below zero");
        }
        int n3 = n2;
        int n4 = this.part_buffer_size & 0x7F;
        if (n3 <= 128 - n4) {
            System.arraycopy(byArray, n, this.buffer, n4, n3);
            this.part_buffer_size += n3;
            if ((this.part_buffer_size & 0x7F) == 0) {
                this.SHA512Transform(this.buffer, 0);
                this.bytes_processed[1] = this.bytes_processed[1] + 128L;
                if (this.bytes_processed[1] < 128L) {
                    this.bytes_processed[0] = this.bytes_processed[0] + 1L;
                }
                this.part_buffer_size = 0;
            }
        } else {
            System.arraycopy(byArray, n, this.buffer, n4, 128 - n4);
            n += 128 - n4;
            this.SHA512Transform(this.buffer, 0);
            this.bytes_processed[1] = this.bytes_processed[1] + 128L;
            if (this.bytes_processed[1] < 128L) {
                this.bytes_processed[0] = this.bytes_processed[0] + 1L;
            }
            n3 -= 128 - n4;
            while (n3 >= 128) {
                System.arraycopy(byArray, n, this.buffer, 0, 128);
                this.SHA512Transform(this.buffer, 0);
                this.bytes_processed[1] = this.bytes_processed[1] + 128L;
                if (this.bytes_processed[1] < 128L) {
                    this.bytes_processed[0] = this.bytes_processed[0] + 1L;
                }
                n3 -= 128;
                n += 128;
            }
            if (n3 > 0) {
                System.arraycopy(byArray, n, this.buffer, 0, n3);
                this.part_buffer_size = n3;
            }
        }
    }

    public int digestFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        long[] lArray = new long[2];
        if (byArray == null) {
            throw new JSAFE_InvalidUseException("hash output array is null");
        }
        if (byArray.length < n) {
            throw new JSAFE_InvalidUseException("offset exceeds length of array");
        }
        if (n < 0) {
            throw new JSAFE_InvalidUseException("offset below zero");
        }
        if (this.objectState == 1) {
            throw new JSAFE_InvalidUseException("digest Not Initialized\n");
        }
        byte[] byArray2 = new byte[144];
        int n2 = 128 - (this.part_buffer_size & 0x7F);
        if (n2 <= 16) {
            n2 += 128;
        }
        byArray2[0] = -128;
        int n3 = 1;
        while (n3 < n2 - 15) {
            byArray2[n3] = 0;
            ++n3;
        }
        this.bytes_processed[1] = this.bytes_processed[1] + (long)this.part_buffer_size;
        if (this.bytes_processed[1] < (long)this.part_buffer_size) {
            this.bytes_processed[0] = this.bytes_processed[0] + 1L;
        }
        lArray[0] = this.bytes_processed[0] << 3 | this.bytes_processed[1] >>> 61;
        lArray[1] = this.bytes_processed[1] << 3;
        byArray2[n2 - 16] = (byte)((lArray[0] & 0xFF00000000000000L) >>> 56);
        byArray2[n2 - 15] = (byte)((lArray[0] & 0xFF000000000000L) >>> 48);
        byArray2[n2 - 14] = (byte)((lArray[0] & 0xFF0000000000L) >>> 40);
        byArray2[n2 - 13] = (byte)((lArray[0] & 0xFF00000000L) >>> 32);
        byArray2[n2 - 12] = (byte)((lArray[0] & 0xFF000000L) >>> 24);
        byArray2[n2 - 11] = (byte)((lArray[0] & 0xFF0000L) >>> 16);
        byArray2[n2 - 10] = (byte)((lArray[0] & 0xFF00L) >>> 8);
        byArray2[n2 - 9] = (byte)(lArray[0] & 0xFFL);
        byArray2[n2 - 8] = (byte)((lArray[1] & 0xFF00000000000000L) >>> 56);
        byArray2[n2 - 7] = (byte)((lArray[1] & 0xFF000000000000L) >>> 48);
        byArray2[n2 - 6] = (byte)((lArray[1] & 0xFF0000000000L) >>> 40);
        byArray2[n2 - 5] = (byte)((lArray[1] & 0xFF00000000L) >>> 32);
        byArray2[n2 - 4] = (byte)((lArray[1] & 0xFF000000L) >>> 24);
        byArray2[n2 - 3] = (byte)((lArray[1] & 0xFF0000L) >>> 16);
        byArray2[n2 - 2] = (byte)((lArray[1] & 0xFF00L) >>> 8);
        byArray2[n2 - 1] = (byte)(lArray[1] & 0xFFL);
        this.digestUpdate(byArray2, 0, n2);
        this.getState(byArray, n);
        return 64;
    }

    public int derEncode(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ENCODE_PREFIX.length + 64;
        System.arraycopy(ENCODE_PREFIX, 0, byArray2, n2, ENCODE_PREFIX.length);
        System.arraycopy(byArray, n, byArray2, n2 += ENCODE_PREFIX.length, byArray.length);
        return n3;
    }

    private void SHA512Transform(byte[] byArray, int n) {
        this.W = new long[80];
        int n2 = 0;
        while (n2 < 16) {
            this.W[n2] = (long)(byArray[n] & 0xFF) << 56;
            int n3 = n2;
            this.W[n3] = this.W[n3] | (long)(byArray[++n] & 0xFF) << 48;
            int n4 = n2;
            this.W[n4] = this.W[n4] | (long)(byArray[++n] & 0xFF) << 40;
            int n5 = n2;
            this.W[n5] = this.W[n5] | (long)(byArray[++n] & 0xFF) << 32;
            int n6 = n2;
            this.W[n6] = this.W[n6] | (long)(byArray[++n] & 0xFF) << 24;
            int n7 = n2;
            this.W[n7] = this.W[n7] | (long)(byArray[++n] & 0xFF) << 16;
            int n8 = n2;
            this.W[n8] = this.W[n8] | (long)(byArray[++n] & 0xFF) << 8;
            int n9 = n2++;
            this.W[n9] = this.W[n9] | (long)byArray[++n] & 0xFFL;
            ++n;
        }
        n2 = 16;
        while (n2 < 80) {
            this.W[n2] = ((this.W[n2 - 2] >>> 19 | this.W[n2 - 2] << 45) ^ (this.W[n2 - 2] >>> 61 | this.W[n2 - 2] << 3) ^ this.W[n2 - 2] >>> 6) + this.W[n2 - 7] + ((this.W[n2 - 15] >>> 1 | this.W[n2 - 15] << 63) ^ (this.W[n2 - 15] >>> 8 | this.W[n2 - 15] << 56) ^ this.W[n2 - 15] >>> 7) + this.W[n2 - 16];
            ++n2;
        }
        long l = this.h0;
        long l2 = this.h1;
        long l3 = this.h2;
        long l4 = this.h3;
        long l5 = this.h4;
        long l6 = this.h5;
        long l7 = this.h6;
        long l8 = this.h7;
        n2 = 0;
        while (n2 < 80) {
            long l9 = l8 + ((l5 >>> 14 | l5 << 50) ^ (l5 >>> 18 | l5 << 46) ^ (l5 >>> 41 | l5 << 23)) + (l5 & l6 ^ (l5 ^ 0xFFFFFFFFFFFFFFFFL) & l7) + this.K[n2] + this.W[n2];
            long l10 = ((l >>> 28 | l << 36) ^ (l >>> 34 | l << 30) ^ (l >>> 39 | l << 25)) + (l & l2 ^ l & l3 ^ l2 & l3);
            l8 = l7;
            l7 = l6;
            l6 = l5;
            l5 = l4 + l9;
            l4 = l3;
            l3 = l2;
            l2 = l;
            l = l9 + l10;
            ++n2;
        }
        this.h0 = l + this.h0;
        this.h1 = l2 + this.h1;
        this.h2 = l3 + this.h2;
        this.h3 = l4 + this.h3;
        this.h4 = l5 + this.h4;
        this.h5 = l6 + this.h5;
        this.h6 = l7 + this.h6;
        this.h7 = l8 + this.h7;
    }

    void getState(byte[] byArray, int n) {
        byArray[n] = (byte)(this.h0 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h0 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h0 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h0 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h0 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h0 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h0 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h0 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h1 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h1 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h2 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h2 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h3 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h3 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h4 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h4 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h5 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h5 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h6 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h6 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >>> 56 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >> 48 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >> 40 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >> 32 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >> 24 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >> 16 & 0xFFL);
        byArray[++n] = (byte)(this.h7 >> 8 & 0xFFL);
        byArray[++n] = (byte)(this.h7 & 0xFFL);
        ++n;
    }

    public void clearSensitiveData() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = 0;
            ++n;
        }
        this.h0 = 0L;
        this.h1 = 0L;
        this.h2 = 0L;
        this.h3 = 0L;
        this.h4 = 0L;
        this.h5 = 0L;
        this.h6 = 0L;
        this.h7 = 0L;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

