/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.Utils;

public class JA_SSLCKeyEncode {
    static final String LINE_SEP = System.getProperty("line.separator");
    static final byte[] LINE_SEPARATOR_BYTES = LINE_SEP.getBytes();

    public static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static byte[] pemEncode(byte[] byArray, String string, byte[] byArray2) {
        String string2 = new String(byArray);
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string.equals("CLEAR")) {
            stringBuffer = stringBuffer.append("-----BEGIN RSA PRIVATE KEY-----").append(LINE_SEP);
            stringBuffer = stringBuffer.append(string2).append(LINE_SEP);
            stringBuffer = stringBuffer.append("-----END RSA PRIVATE KEY-----");
            String string3 = stringBuffer.toString();
            return string3.getBytes();
        }
        String string4 = null;
        String string5 = null;
        if (string.equals("DES")) {
            string4 = "Proc-Type: 4,ENCRYPTED\nDEK-Info: DES-CBC,";
        } else if (string.equals("3DES_EDE")) {
            string4 = "Proc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC,";
        }
        string5 = JA_SSLCKeyEncode.byteArrayToHexString(byArray2, 0, byArray2.length);
        stringBuffer = stringBuffer.append("-----BEGIN RSA PRIVATE KEY-----").append(LINE_SEP);
        stringBuffer = stringBuffer.append(string4).append(string5).append("\n\n");
        stringBuffer = stringBuffer.append(string2).append(LINE_SEP).append("-----END RSA PRIVATE KEY-----");
        return stringBuffer.toString().getBytes();
    }

    public static byte[] pemDecodeNotEncrypted(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = null;
        String string = null;
        int n = -1;
        int n2 = -1;
        Object var5_5 = null;
        string = new String(byArray, 0, byArray.length);
        String string2 = "-----BEGIN RSA PRIVATE KEY-----";
        int n3 = string.indexOf(string2);
        if (n3 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSLC key, missing header");
        }
        n = n3 + string2.length();
        while (JA_SSLCKeyEncode.isSpace(string.charAt(n))) {
            ++n;
        }
        n2 = string.indexOf("-", n);
        if (n2 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSLC key, missing footer");
        }
        int n4 = n2 - n;
        int n5 = n2;
        while (Character.isWhitespace(string.charAt(n + n4 - 1))) {
            --n4;
            --n5;
        }
        String string3 = string.substring(n, n5);
        byArray2 = string3.getBytes();
        return byArray2;
    }

    public static byte[] base64Decode(byte[] byArray) throws JSAFE_InvalidKeyException {
        JSAFE_Recode jSAFE_Recode = null;
        try {
            try {
                byte[] byArray2;
                jSAFE_Recode = JSAFE_Recode.getInstance("Base64-64", "Java");
                jSAFE_Recode.decodeInit();
                int n = jSAFE_Recode.getOutputBufferSize(byArray.length);
                byte[] byArray3 = new byte[n];
                int n2 = jSAFE_Recode.decodeUpdate(byArray, 0, byArray.length, byArray3, 0);
                int n3 = jSAFE_Recode.decodeFinal(byArray3, n2);
                int n4 = n2 + n3;
                if (n4 != n) {
                    byArray2 = new byte[n4];
                    System.arraycopy(byArray3, 0, byArray2, 0, n4);
                    byArray3 = byArray2;
                }
                byArray2 = byArray3;
                Object var9_12 = null;
                if (jSAFE_Recode != null) {
                    jSAFE_Recode.clearSensitiveData();
                }
                return byArray2;
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidKeyException(jSAFE_UnimplementedException.getMessage());
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new JSAFE_InvalidKeyException(jSAFE_InvalidUseException.getMessage());
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidKeyException(jSAFE_InputException.getMessage());
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                throw new JSAFE_InvalidKeyException(jSAFE_InvalidParameterException.getMessage());
            }
        }
        catch (Throwable throwable) {
            block9: {
                Object var9_13 = null;
                if (jSAFE_Recode == null) break block9;
                jSAFE_Recode.clearSensitiveData();
            }
            throw throwable;
        }
    }

    static byte[] addLineBreaks(byte[] byArray, int n, int n2) {
        int n3 = n / n2;
        int n4 = n - n3 * n2;
        if (n4 > 0) {
            ++n3;
        }
        int n5 = n3 * LINE_SEPARATOR_BYTES.length;
        int n6 = n + n5;
        byte[] byArray2 = new byte[n6];
        int n7 = 0;
        while (n7 < byArray2.length) {
            byArray2[n7] = 0;
            ++n7;
        }
        int n8 = 0;
        int n9 = 0;
        while (n8 < n) {
            byArray2[n9++] = byArray[n8];
            if (n8 % n2 == n2 - 1) {
                int n10 = 0;
                while (n10 < LINE_SEPARATOR_BYTES.length) {
                    byArray2[n9++] = LINE_SEPARATOR_BYTES[n10];
                    ++n10;
                }
            }
            ++n8;
        }
        return byArray2;
    }

    public static byte[] base64Encode(byte[] byArray) throws JSAFE_InvalidKeyException {
        JSAFE_Recode jSAFE_Recode = null;
        try {
            try {
                byte[] byArray2;
                jSAFE_Recode = JSAFE_Recode.getInstance("Base64-64", "Java");
                jSAFE_Recode.encodeInit();
                int n = jSAFE_Recode.getOutputBufferSize(byArray.length);
                byte[] byArray3 = new byte[n];
                int n2 = jSAFE_Recode.encodeUpdate(byArray, 0, byArray.length, byArray3, 0);
                int n3 = jSAFE_Recode.encodeFinal(byArray3, n2);
                int n4 = n2 + n3;
                byte[] byArray4 = byArray3;
                if (n4 != n) {
                    byArray2 = new byte[n4];
                    System.arraycopy(byArray4, 0, byArray2, 0, n4);
                    byArray4 = byArray2;
                }
                byArray2 = byArray4;
                Object var10_12 = null;
                if (jSAFE_Recode != null) {
                    jSAFE_Recode.clearSensitiveData();
                }
                return byArray2;
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidKeyException(jSAFE_UnimplementedException.getMessage());
            }
            catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                throw new JSAFE_InvalidKeyException(jSAFE_InvalidUseException.getMessage());
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                throw new JSAFE_InvalidKeyException(jSAFE_InvalidParameterException.getMessage());
            }
        }
        catch (Throwable throwable) {
            block8: {
                Object var10_13 = null;
                if (jSAFE_Recode == null) break block8;
                jSAFE_Recode.clearSensitiveData();
            }
            throw throwable;
        }
    }

    public static byte[] pemDecodeEncrypted(byte[] byArray, String[] stringArray, byte[] byArray2) throws JSAFE_InvalidKeyException {
        String string = "-----BEGIN RSA PRIVATE KEY-----";
        String string2 = "-----END RSA PRIVATE KEY-----";
        String string3 = "DEK-Info: DES-CBC,";
        String string4 = "DEK-Info: DES-EDE3-CBC,";
        String string5 = new String(byArray, 0, byArray.length);
        int n = string5.indexOf(string);
        if (n < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSLC key, missing header");
        }
        int n2 = string5.indexOf(string3);
        int n3 = string5.indexOf(string4);
        int n4 = 8;
        int n5 = -1;
        if (n2 > 0) {
            stringArray[0] = "DES";
            n5 = n2 + string3.length();
        } else if (n3 > 0) {
            stringArray[0] = "3DES_EDE";
            n5 = n3 + string4.length();
        } else {
            throw new JSAFE_InvalidKeyException("Not a valid SSL-C PEM encoded RSA private key, missing encryption algorithm indicator expected either " + string3 + " or " + string4);
        }
        int n6 = n4 * 2;
        String string6 = string5.substring(n5, n5 + n6);
        byte[] byArray3 = JA_SSLCKeyEncode.hexStringToByteArray(string6);
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        n5 += n6;
        while (JA_SSLCKeyEncode.isSpace(string5.charAt(n5))) {
            ++n5;
        }
        int n7 = string5.indexOf("-----END RSA PRIVATE KEY-----", n5);
        if (n7 < 0) {
            throw new JSAFE_InvalidKeyException("Not a valid RSA private SSL-C key, missing footer");
        }
        int n8 = n7 - n5;
        int n9 = n7;
        while (JA_SSLCKeyEncode.isSpace(string5.charAt(n9 - 1))) {
            --n8;
            --n9;
        }
        String string7 = string5.substring(n5, n9);
        byte[] byArray4 = string7.getBytes();
        if (byArray4.length != n8) {
            System.err.println("ERROR");
        }
        return byArray4;
    }

    public static void decodeASN1Len(byte[] byArray, int n, int[] nArray) throws JSAFE_InvalidKeyException {
        if ((byArray[n] & 0x80) == 0) {
            nArray[0] = 1;
            nArray[1] = byArray[n];
            return;
        }
        int n2 = byArray[n] & 0x7F;
        if (n2 > 5) {
            throw new JSAFE_InvalidKeyException("Invalid SSL-C key, too may octets");
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            ++n3;
            int n6 = byArray[n + 1 + n5] & 0xFF;
            n4 += n6 << 8 * (n2 - n5 - 1);
            ++n5;
        }
        nArray[0] = n3;
        nArray[1] = n4;
    }

    static int[] getUnencryptedKeyInfo(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InvalidUseException("Cannot build the PKCS #8 unencrypted key: " + aSN_Exception.getMessage());
        }
        int[] nArray = new int[]{octetStringContainer.dataOffset, octetStringContainer.dataLen};
        return nArray;
    }

    public static byte[] convertPKCS8ToPKCS1(byte[] byArray) throws JSAFE_InvalidKeyException {
        int n = 1;
        int n2 = byArray.length - 1;
        int[] nArray = new int[]{0, 0};
        JA_SSLCKeyEncode.decodeASN1Len(byArray, n, nArray);
        n += nArray[0];
        n2 -= nArray[0];
        int n3 = 0;
        while (n3 < 2) {
            --n2;
            JA_SSLCKeyEncode.decodeASN1Len(byArray, ++n, nArray);
            n += nArray[0] + nArray[1];
            n2 -= nArray[0] + nArray[1];
            ++n3;
        }
        --n2;
        JA_SSLCKeyEncode.decodeASN1Len(byArray, ++n, nArray);
        JA_SSLCKeyEncode.decodeASN1Len(byArray, (n += nArray[0]) + 1, nArray);
        int n4 = nArray[1] + nArray[0] + 1;
        if (n4 != (n2 -= nArray[0])) {
            throw new RuntimeException("FATAL ERROR: dataLen = " + n2 + ", but computed len = " + n4);
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n, byArray2, 0, n4);
        return byArray2;
    }

    public static byte[] extractIV(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = null;
        String[] stringArray = new String[1];
        byte[] byArray3 = new byte[8];
        byArray2 = JA_SSLCKeyEncode.pemDecodeEncrypted(byArray, stringArray, byArray3);
        return byArray3;
    }

    public static byte[] convertPKCS1ToPKCS8(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = new byte[]{2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4};
        int n = byArray.length;
        byte[] byArray3 = JA_SSLCKeyEncode.encodeASN1Len(n);
        int n2 = byArray2.length + byArray3.length + byArray.length;
        byte[] byArray4 = JA_SSLCKeyEncode.encodeASN1Len(n2);
        byte[] byArray5 = new byte[1 + byArray4.length + n2];
        int n3 = 0;
        byArray5[n3++] = 48;
        System.arraycopy(byArray4, 0, byArray5, n3, byArray4.length);
        System.arraycopy(byArray2, 0, byArray5, n3 += byArray4.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, n3 += byArray2.length, byArray3.length);
        System.arraycopy(byArray, 0, byArray5, n3 += byArray3.length, byArray.length);
        n3 += byArray.length;
        return byArray5;
    }

    public static byte[] encodeASN1Len(int n) throws JSAFE_InvalidKeyException {
        byte[] byArray = null;
        if (n < 128) {
            byArray = new byte[]{(byte)n};
        } else if (n < 255) {
            byArray = new byte[]{-127, (byte)n};
        } else if (n < 65535) {
            byArray = new byte[]{-126, (byte)(n >> 8), (byte)n};
        } else {
            throw new JSAFE_InvalidKeyException("key length is too big");
        }
        return byArray;
    }

    public static String decodeSSLCEncodedKey(byte[] byArray, int n, byte[] byArray2) throws JSAFE_InvalidKeyException {
        String[] stringArray = new String[1];
        byte[] byArray3 = JA_SSLCKeyEncode.pemDecodeEncrypted(byArray, stringArray, byArray2);
        String string = "PBE/MD5/" + stringArray[0] + "/CBC/SSLCPBE";
        return string;
    }

    public static final String byteArrayToHexString(byte[] byArray, int n, int n2) {
        return Utils.byteArrayToHexString(byArray, n, n2);
    }

    public static final byte[] hexStringToByteArray(String string) {
        return Utils.hexStringToByteArray(string);
    }
}

