/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSymmetricCipher;
import com.rsa.jsafe.JA_ExtendedPasswordStandard;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PKCS5PBEBER;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JA_SSLCKeyEncode;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

final class JA_SSLCPBE
extends JSAFE_Object
implements JA_PasswordStandard,
JA_ExtendedPasswordStandard,
Cloneable,
Serializable {
    private int iterationCount;
    private int keySize = -1;
    private byte[] salt;
    private String encryptionAlgorithm;

    JA_SSLCPBE() {
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length == 1) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKCS 5 PBE iteration count must be greater than 0.");
            }
            return;
        }
        if (nArray.length == 2) {
            this.iterationCount = nArray[0];
            if (this.iterationCount <= 0) {
                throw new JSAFE_InvalidParameterException("PKCS 5 PBE iteration count must be greater than 0.");
            }
            this.keySize = nArray[1];
            return;
        }
        throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected one (iteration count) or two (iteration count, keySize)");
    }

    public int[] getInstantiationParameters() {
        if (this.keySize == -1) {
            int[] nArray = new int[]{this.iterationCount};
            return nArray;
        }
        int[] nArray = new int[]{this.iterationCount, this.keySize};
        return nArray;
    }

    public String getAlgorithm() {
        return "SSLCPBE";
    }

    public String getFullAlgorithm() {
        return "SSLCPBE";
    }

    public void setAlgorithmBER(JA_AlgaeSymmetricCipher jA_AlgaeSymmetricCipher, byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException {
        JA_PKCS5PBEBER.setAlgorithmBER(this, jA_AlgaeSymmetricCipher, byArray, n, n2);
    }

    public byte[] getParamsDER(String string, String string2) throws JSAFE_UnimplementedException {
        return JA_PKCS5PBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public byte[] getParamsDER() throws JSAFE_UnimplementedException {
        return JA_PKCS5PBEBER.getParamsDER(this.iterationCount, this.salt);
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        this.salt = new byte[n2];
        System.arraycopy(byArray, n, this.salt, 0, n2);
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] byArray = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, byArray, 0, this.salt.length);
        return byArray;
    }

    public boolean outsideIV() {
        return false;
    }

    public byte[] keyUnwrapPreProcess(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        String[] stringArray = new String[1];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = JA_SSLCKeyEncode.pemDecodeEncrypted(byArray2, stringArray, byArray3);
        return JA_SSLCKeyEncode.base64Decode(byArray4);
    }

    public byte[] keyUnwrapPostProcess(byte[] byArray) throws JSAFE_InvalidKeyException {
        return JA_SSLCKeyEncode.convertPKCS1ToPKCS8(byArray);
    }

    public byte[] keyWrapPreProcess(byte[] byArray) throws JSAFE_InvalidKeyException {
        return JA_SSLCKeyEncode.convertPKCS8ToPKCS1(byArray);
    }

    public byte[] keyWrapPostProcess(byte[] byArray) throws JSAFE_InvalidKeyException {
        byte[] byArray2 = JA_SSLCKeyEncode.base64Encode(byArray);
        return JA_SSLCKeyEncode.pemEncode(byArray2, this.encryptionAlgorithm, this.salt);
    }

    public void generateKeyAndIV(JA_AlgaeDigest jA_AlgaeDigest, JA_FeedbackMode jA_FeedbackMode, int n, JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.encryptionAlgorithm = jSAFE_SecretKey.getAlgorithm();
        int n2 = jSAFE_SecretKey.getKeyBitLength(this.keySize);
        int n3 = this.encryptionAlgorithm.equals("DES") ? 8 : 24;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        if (jA_FeedbackMode != null) {
            n4 = jA_FeedbackMode.getIVSize(n);
        }
        int n5 = jA_AlgaeDigest.getDigestSize();
        jA_AlgaeDigest.digestInit();
        char[] cArray = jSAFE_SecretKey.getPassword();
        byte[] byArray2 = new byte[cArray.length];
        int n6 = cArray.length;
        if (cArray[cArray.length - 1] == '\u0000') {
            --n6;
        }
        int n7 = 0;
        while (n7 < cArray.length) {
            byArray2[n7] = (byte)cArray[n7];
            cArray[n7] = '\u0000';
            ++n7;
        }
        byte[] byArray3 = new byte[n5];
        int n8 = 0;
        int n9 = 0;
        while (true) {
            byte by;
            jA_AlgaeDigest.digestUpdate(byArray2, 0, n6);
            jA_AlgaeDigest.digestUpdate(this.salt, 0, this.salt.length);
            n8 = jA_AlgaeDigest.digestFinal(byArray3, 0);
            int n10 = this.iterationCount - 1;
            while (n10 > 0) {
                jA_AlgaeDigest.digestInit();
                jA_AlgaeDigest.digestUpdate(byArray3, 0, n8);
                n8 = jA_AlgaeDigest.digestFinal(byArray3, 0);
                --n10;
            }
            int n11 = n3 * 8 - n2;
            if (n11 > 0) {
                by = (byte)(255 >>> n11);
                byArray3[0] = (byte)(byArray3[0] & by);
            }
            by = 0;
            while (n9 < n3 && by < n8) {
                byArray[n9] = byArray3[by];
                by = (byte)(by + 1);
                ++n9;
            }
            if (n9 == n3) break;
            jA_AlgaeDigest.digestInit();
            jA_AlgaeDigest.digestUpdate(byArray3, 0, n8);
        }
        JSAFE_Obfuscator.overwrite(byArray2);
        jSAFE_SecretKey.setSecretKeyData(byArray, 0, n3);
        try {
            if (n4 > 0) {
                jA_FeedbackMode.setIV(this.salt, 0, this.salt.length);
            }
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException("Could not set the IV in PKCS 5 PBE.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_SSLCPBE jA_SSLCPBE = new JA_SSLCPBE();
        jA_SSLCPBE.iterationCount = this.iterationCount;
        jA_SSLCPBE.keySize = this.keySize;
        if (this.salt != null) {
            jA_SSLCPBE.salt = (byte[])this.salt.clone();
        }
        return jA_SSLCPBE;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.keySize = -1;
        this.salt = null;
        this.iterationCount = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

