/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

class JA_SignatureAlgID
extends JSAFE_Object {
    String transformation;
    private static final String[] pssTransformations = new String[]{"RSA/PKCS1V2PSS"};

    JA_SignatureAlgID() {
    }

    void decodeAlgID(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        EncodedContainer encodedContainer = new EncodedContainer(130816);
        try {
            this.transformation = AlgorithmID.berDecodeAlgID(byArray, n, 1, encodedContainer);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data. (" + aSN_Exception.getMessage() + ")");
        }
        if (this.transformation == null) {
            return;
        }
        int n2 = 0;
        while (n2 < pssTransformations.length) {
            if (this.transformation.compareTo(pssTransformations[n2]) == 0) break;
            ++n2;
        }
        if (n2 >= pssTransformations.length) {
            return;
        }
        this.readPSSAlgIDParams(n2, encodedContainer.data, encodedContainer.dataOffset);
    }

    private void readPSSAlgIDParams(int n, byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        try {
            ASN1Container[] aSN1ContainerArray = JA_SignatureAlgID.getPSSContainerArray(null, null, null, 0);
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (aSN1ContainerArray[1].dataPresent) {
                String string = ((OIDContainer)aSN1ContainerArray[2]).transformation;
                this.transformation = string.concat("/" + this.transformation);
            } else {
                this.transformation = "SHA1/".concat(this.transformation);
            }
            this.transformation = aSN1ContainerArray[9].dataPresent ? (((IntegerContainer)aSN1ContainerArray[6]).getValueAsInt() == 1 ? this.transformation.concat("-1") : this.transformation.concat("-2")) : this.transformation.concat("-1");
            if (aSN1ContainerArray[5].dataPresent) {
                this.transformation = this.transformation.concat("/" + ((OIDContainer)aSN1ContainerArray[6]).transformation);
                this.transformation = this.transformation.concat("/" + ((OIDContainer)aSN1ContainerArray[8]).transformation);
            } else {
                this.transformation = this.transformation.concat("/MGF1/SHA1");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Invalid RSA PSS parameter BER encoding. (" + aSN_Exception.getMessage() + ")");
        }
    }

    static byte[] getPSSAlgIDParams(String string, String string2, String string3, int n) throws JSAFE_UnimplementedException {
        try {
            ASN1Container[] aSN1ContainerArray = JA_SignatureAlgID.getPSSContainerArray(string, string2, string3, n);
            return ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode the PSS AlgID parameters.(" + aSN_Exception.getMessage() + ")");
        }
    }

    private static ASN1Container[] getPSSContainerArray(String string, String string2, String string3, int n) throws ASN_Exception {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        boolean bl = false;
        if (string != null && string.compareTo("SHA1") != 0) {
            bl = true;
        }
        SequenceContainer sequenceContainer2 = new SequenceContainer(0xA20000, bl, 0);
        OIDContainer oIDContainer = new OIDContainer(0, true, 0, string, 10);
        EncodedContainer encodedContainer = new EncodedContainer(130816, true, 5, null, 0, 0);
        bl = false;
        if (string2 != null && string2.compareTo("MGF1") != 0 && string3 != null && string3.compareTo("SHA1") != 0) {
            bl = true;
        }
        SequenceContainer sequenceContainer3 = new SequenceContainer(10616833, bl, 0);
        OIDContainer oIDContainer2 = new OIDContainer(0, true, 0, string2, 12);
        SequenceContainer sequenceContainer4 = new SequenceContainer(0, true, 0);
        OIDContainer oIDContainer3 = new OIDContainer(0, true, 0, string3, 11);
        EncodedContainer encodedContainer2 = new EncodedContainer(130816, true, 5, null, 0, 0);
        bl = false;
        if (n != 1) {
            bl = true;
        }
        IntegerContainer integerContainer = new IntegerContainer(0xA20002, bl, 5, n);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, sequenceContainer2, oIDContainer, encodedContainer, endContainer, sequenceContainer3, oIDContainer2, sequenceContainer4, oIDContainer3, encodedContainer2, endContainer, endContainer, integerContainer, endContainer};
        return aSN1ContainerArray;
    }
}

