/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JA_AlgaeChainDigestRandom;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JCMPInt;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;

public class JA_X931Random
extends JSAFE_SecureRandom
implements JA_AlgaeChainDigestRandom {
    private int numStreams = 1;
    private int currentIndex = 0;
    private JA_SHA1[] theStreams;
    private int[] initFlags;
    private static final int NO_INIT = 0;
    private static final int INIT_FROM_STATE = 1;
    private static final int INIT_FROM_X = 2;
    private byte[] xBuffer;
    private static final int[] extraSeedOffsets = new int[]{84, 149, 214, 279, 344, 409};
    private boolean extraSeedFlag = false;
    private boolean checkSeedFlag = false;
    private byte[] padBuffer = new byte[44];
    private JCMPInt jcmpQ;
    private static final byte[] theQ = new byte[]{-78, 13, -80, -79, 1, -33, 12, 102, 36, -4, 19, -110, -70, 85, -9, 125, 87, 116, -127, -27};
    private JCMPInt valueToReduce;
    private JCMPInt reducedValue;
    private boolean firstTime = true;
    byte[] previousBlock = new byte[20];
    private transient ObfuscatorItem previousBlockOI;
    private static final int DIGEST_SIZE = 20;
    private transient ObfuscatorItem tableOI;
    static final int Sha1StateSize = 20;

    JA_X931Random() {
        if (this.previousBlockOI == null) {
            this.previousBlockOI = JSAFE_Obfuscator.register(this.previousBlock);
        }
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray == null || nArray.length == 0) {
            this.numStreams = 1;
            this.createStreams();
            return;
        }
        if (nArray.length > 1) {
            throw new JSAFE_InvalidParameterException("Wrong Number of Parameters: expected one - number of streams.");
        }
        this.numStreams = nArray[0];
        this.createStreams();
    }

    private void createStreams() throws JSAFE_InvalidParameterException {
        if (this.numStreams < 1 || this.numStreams > 6) {
            throw new JSAFE_InvalidParameterException("Invalid Number of Streams: expected 1 to 6.");
        }
        this.theStreams = new JA_SHA1[this.numStreams];
        this.initFlags = new int[this.numStreams];
        int n = 0;
        while (n < this.numStreams) {
            this.theStreams[n] = new JA_SHA1();
            this.theStreams[n].digestInit();
            this.initFlags[n] = 2;
            ++n;
        }
        this.jcmpQ = new JCMPInt();
        this.jcmpQ.setValue(theQ, 0, theQ.length);
        this.valueToReduce = new JCMPInt();
        this.reducedValue = new JCMPInt();
        this.xBuffer = new byte[84 + 65 * this.numStreams];
        this.currentIndex = 0;
        this.extraSeedFlag = false;
        this.checkSeedFlag = false;
        this.tableOI = JSAFE_Obfuscator.register(this.xBuffer);
    }

    public int[] getAlgorithmParameters() {
        return this.getInstantiationParameters();
    }

    public int[] getInstantiationParameters() {
        int[] nArray = new int[]{this.numStreams};
        return nArray;
    }

    public String getAlgorithm() {
        return "X931Random";
    }

    public JA_AlgaeDigest getDigestObject() {
        return null;
    }

    public byte[] getOddConstant() {
        return null;
    }

    public void seed(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length / this.numStreams;
        int n2 = byArray.length - n;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.numStreams) {
            try {
                this.theStreams[n3].digestUpdate(byArray, n4, n);
                this.theStreams[n3].digestAddFinalPad();
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                // empty catch block
            }
            this.initFlags[n3] = 1;
            n4 += n;
            n = n3 < this.numStreams - 1 ? n2 / (this.numStreams - n3 - 1) : n2;
            n2 -= n;
            ++n3;
        }
    }

    public void extraSeed(byte[] byArray) throws JSAFE_InputException {
        if (this.extraSeedFlag) {
            throw new JSAFE_InputException("Can call extraSeed method only once.");
        }
        if (this.checkSeedFlag) {
            throw new JSAFE_InputException("Cannot call extraSeed method after generating random bytes.");
        }
        this.extraSeedFlag = true;
        int n = this.numStreams * 64;
        int n2 = this.numStreams * 20;
        if (byArray.length > n || byArray.length < n2) {
            throw new JSAFE_InputException("Invalid extraSeed length, must be 20 to 64 times number of streams.");
        }
        this.deobfuscate();
        int n3 = byArray.length / this.numStreams;
        int n4 = byArray.length - n3;
        int n5 = 0;
        int n6 = 0;
        while (n5 < this.numStreams) {
            this.xBuffer[JA_X931Random.extraSeedOffsets[n5]] = (byte)n3;
            System.arraycopy(byArray, n6, this.xBuffer, extraSeedOffsets[n5] + 1, n3);
            n6 += n3;
            n3 = n5 < this.numStreams - 1 ? n4 / (this.numStreams - n5 - 1) : n4;
            n4 -= n3;
            ++n5;
        }
        this.obfuscate();
    }

    public void autoseed() {
        SecureRandom secureRandom = new SecureRandom(new byte[4]);
        int n = 0;
        while (n < this.numStreams) {
            byte[] byArray = SecureRandom.getSeed(20);
            this.seed(byArray);
            secureRandom.setSeed(byArray);
            JSAFE_Obfuscator.overwrite(byArray);
            ++n;
        }
    }

    void prngCheck(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!this.fipsIsRequired()) {
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return;
            }
            ++n4;
        }
        CryptoJ.verified = 2;
        throw new RuntimeException("Continuous Random Number Generator check has failed. Crypto-J has entered a FAILED state and is inoperable");
    }

    private void doGenerateRandomBytes(byte[] byArray, int n, int n2) {
        if (!this.checkSeedFlag) {
            this.checkSeed();
        }
        JA_SHA1 jA_SHA1 = this.theStreams[this.currentIndex];
        this.deobfuscate();
        int n3 = extraSeedOffsets[this.currentIndex];
        byte by = this.xBuffer[n3];
        ++n3;
        ++this.currentIndex;
        if (this.currentIndex >= this.numStreams) {
            this.currentIndex = 0;
        }
        while (n2 > 0) {
            n2 -= this.generateBlock(jA_SHA1, n2, by, n3, this.initFlags[this.currentIndex], byArray, n);
            n += 20;
            this.initFlags[this.currentIndex] = 0;
        }
        this.initFlags[this.currentIndex] = 2;
        this.obfuscate();
    }

    public void generateRandomBytes(byte[] byArray, int n, int n2) {
        if (this.firstTime && this.fipsIsRequired()) {
            this.doGenerateRandomBytes(this.previousBlock, 0, 20);
        }
        this.doGenerateRandomBytes(byArray, n, n2);
    }

    private int generateBlock(JA_SHA1 jA_SHA1, int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6;
        if (n4 == 1) {
            jA_SHA1.getState(this.xBuffer, 64);
            if (this.extraSeedFlag) {
                n6 = 0;
                while (n6 < 20) {
                    int n7 = n6 + n3;
                    this.xBuffer[n7] = (byte)(this.xBuffer[n7] ^ this.xBuffer[n6 + 64]);
                    ++n6;
                }
            } else {
                System.arraycopy(this.xBuffer, 64, this.xBuffer, n3, 20);
            }
            n4 = 2;
        }
        if (n4 == 2) {
            n6 = 0;
            while (n6 < 20) {
                this.xBuffer[n6] = this.xBuffer[n6 + n3];
                ++n6;
            }
            while (n6 < n2) {
                this.xBuffer[n6] = this.xBuffer[n6 + n3];
                ++n6;
            }
        }
        if (n2 < 20) {
            n2 = 20;
        }
        byte[] byArray2 = this.modQGHash(n2);
        int n8 = 1;
        int n9 = n2 - 1;
        int n10 = 19;
        while (n10 >= 0) {
            byArray2[n10] = 0;
            this.xBuffer[n9] = (byte)(n8 += (this.xBuffer[n9] & 0xFF) + (byArray2[n10] & 0xFF));
            n8 >>>= 8;
            --n10;
            --n9;
        }
        while (n8 > 0 && n9 >= 0) {
            this.xBuffer[n9] = (byte)(n8 += this.xBuffer[n9] & 0xFF);
            n8 >>>= 8;
            --n9;
        }
        int n11 = 20;
        if (n < n11) {
            n11 = n;
        }
        System.arraycopy(this.xBuffer, n2 - 20, byArray, n5, n11);
        if (this.firstTime) {
            this.firstTime = false;
        } else {
            this.prngCheck(this.previousBlock, 0, this.xBuffer, n2 - 20, 20);
            System.arraycopy(this.xBuffer, n2 - 20, this.previousBlock, 0, 20);
        }
        if (n - n11 == 0) {
            System.arraycopy(this.xBuffer, 0, this.xBuffer, n3, n2);
        }
        return n11;
    }

    private byte[] modQGHash(int n) {
        try {
            try {
                JA_SHA1 jA_SHA1 = new JA_SHA1();
                jA_SHA1.digestInit();
                jA_SHA1.digestUpdate(this.xBuffer, 0, n);
                int n2 = 64 - n;
                jA_SHA1.digestUpdate(this.padBuffer, 0, n2);
                jA_SHA1.getState(this.xBuffer, 64);
                this.valueToReduce.setValue(this.xBuffer, 64, 20);
                this.valueToReduce.modReduce(this.jcmpQ, this.reducedValue);
                byte[] byArray = this.reducedValue.toFixedLenOctetString(20);
                Object var6_7 = null;
                this.valueToReduce.clearSensitiveData();
                this.reducedValue.clearSensitiveData();
                return byArray;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                byte[] byArray = new byte[20];
                Object var6_8 = null;
                this.valueToReduce.clearSensitiveData();
                this.reducedValue.clearSensitiveData();
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.valueToReduce.clearSensitiveData();
            this.reducedValue.clearSensitiveData();
            throw throwable;
        }
    }

    private void checkSeed() {
        if (this.numStreams < 1) {
            this.checkSeedFlag = false;
            return;
        }
        try {
            try {
                int n = 1;
                while (n < this.numStreams) {
                    int n2 = 0;
                    while (n2 < n) {
                        this.pseudoIndepCheck(n2, n);
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                this.autoseed();
                Object var4_5 = null;
                this.checkSeedFlag = true;
            }
            Object var4_4 = null;
            this.checkSeedFlag = true;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.checkSeedFlag = true;
            throw throwable;
        }
    }

    private void pseudoIndepCheck(int n, int n2) throws JSAFE_InputException {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        this.theStreams[n].getState(byArray, 0);
        this.theStreams[n2].getState(byArray2, 0);
        if (!this.byteArrEqual(byArray, 0, byArray2, 0, 20)) {
            return;
        }
        if (this.byteArrEqual(this.xBuffer, extraSeedOffsets[n], this.xBuffer, extraSeedOffsets[n2], 64)) {
            throw new JSAFE_InputException("Streams are not independent");
        }
    }

    private boolean byteArrEqual(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        while (n6 < n3) {
            if (byArray[n4] != byArray2[n5]) {
                return false;
            }
            ++n6;
            ++n4;
            ++n5;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
        if (this.previousBlockOI != null) {
            this.previousBlockOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
        if (this.previousBlockOI != null) {
            this.previousBlockOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.xBuffer == null || this.previousBlock == null) {
            return;
        }
        this.tableOI = JSAFE_Obfuscator.register(this.xBuffer);
        this.tableOI.obfuscate();
        this.previousBlockOI = JSAFE_Obfuscator.register(this.previousBlock);
        this.previousBlockOI.obfuscate();
    }

    public void obfuscate() {
        this.tableOI.obfuscate();
        this.previousBlockOI.obfuscate();
    }

    public void deobfuscate() {
        this.tableOI.deobfuscate();
        this.previousBlockOI.deobfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        JA_X931Random jA_X931Random = new JA_X931Random();
        jA_X931Random.numStreams = this.numStreams;
        jA_X931Random.currentIndex = this.currentIndex;
        jA_X931Random.extraSeedFlag = this.extraSeedFlag;
        jA_X931Random.checkSeedFlag = this.checkSeedFlag;
        jA_X931Random.firstTime = this.firstTime;
        if (this.theStreams != null) {
            jA_X931Random.theStreams = new JA_SHA1[this.numStreams];
            n = 0;
            while (n < this.numStreams) {
                jA_X931Random.theStreams[n] = (JA_SHA1)this.theStreams[n].clone();
                ++n;
            }
        }
        if (this.xBuffer != null) {
            jA_X931Random.xBuffer = (byte[])JSAFE_Obfuscator.copy(this.xBuffer, this.tableOI);
            jA_X931Random.tableOI = JSAFE_Obfuscator.getObfuscatorItem(jA_X931Random.xBuffer);
        }
        if (this.previousBlock != null) {
            jA_X931Random.previousBlock = (byte[])JSAFE_Obfuscator.copy(this.previousBlock, this.previousBlockOI);
            jA_X931Random.previousBlockOI = JSAFE_Obfuscator.getObfuscatorItem(jA_X931Random.previousBlock);
        }
        if (this.initFlags != null) {
            jA_X931Random.initFlags = new int[this.numStreams];
            n = 0;
            while (n < this.numStreams) {
                jA_X931Random.initFlags[n] = this.initFlags[n];
                ++n;
            }
        }
        if (this.jcmpQ != null) {
            jA_X931Random.jcmpQ = (JCMPInt)this.jcmpQ.clone();
        }
        if (this.valueToReduce != null) {
            jA_X931Random.valueToReduce = (JCMPInt)this.valueToReduce.clone();
        }
        if (this.reducedValue != null) {
            jA_X931Random.reducedValue = (JCMPInt)this.reducedValue.clone();
        }
        return jA_X931Random;
    }

    public void clearSensitiveData() {
        if (this.theStreams != null) {
            int n = 0;
            while (n < this.numStreams) {
                this.theStreams[n].clearSensitiveData();
                ++n;
            }
        }
        JSAFE_Obfuscator.deregister(this.xBuffer, this.tableOI);
        this.tableOI = null;
        JSAFE_Obfuscator.deregister(this.previousBlock, this.previousBlockOI);
        this.previousBlockOI = null;
    }
}

