/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeChainDigestRandom;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JCMPInt;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;

public class JA_X962Random_V0
extends JSAFE_SecureRandom
implements JA_AlgaeChainDigestRandom {
    private JA_SHA1 theStream;
    private int initFlag;
    private static final int NO_INIT = 0;
    private static final int INIT_FROM_STATE = 1;
    private static final int INIT_FROM_X = 2;
    private byte[] XKEY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] XVAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] XSEED = new byte[128];
    private static final int[] extraSeedOffsets = new int[]{84};
    private boolean extraSeedFlag = false;
    private int extraSeedLen;
    private boolean checkSeedFlag = false;
    private byte[] padBuffer = new byte[44];
    private JCMPInt jcmpQ;
    private static final byte[] theQ = new byte[]{-78, 13, -80, -79, 1, -33, 12, 102, 36, -4, 19, -110, -70, 85, -9, 125, 87, 116, -127, -27};
    private JCMPInt valueToReduce;
    private JCMPInt reducedValue;
    private transient ObfuscatorItem tableOI;

    protected static final int maxExtraSeed() {
        return 128;
    }

    protected static final int minExtraSeed() {
        return 20;
    }

    public void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Wrong Number of Parameters: expected None.");
        }
        this.createStreams();
    }

    private void createStreams() throws JSAFE_InvalidParameterException {
        this.theStream = new JA_SHA1();
        this.initFlag = 2;
        this.theStream.digestInit();
        this.jcmpQ = new JCMPInt();
        this.jcmpQ.setValue(theQ, 0, theQ.length);
        this.valueToReduce = new JCMPInt();
        this.reducedValue = new JCMPInt();
        this.extraSeedFlag = false;
        this.checkSeedFlag = false;
    }

    public int[] getAlgorithmParameters() {
        return this.getInstantiationParameters();
    }

    public int[] getInstantiationParameters() {
        return null;
    }

    public String getAlgorithm() {
        return "X962Random_V0";
    }

    public JA_AlgaeDigest getDigestObject() {
        return null;
    }

    public byte[] getOddConstant() {
        return null;
    }

    public void seed(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        try {
            this.theStream.digestUpdate(byArray, 0, byArray.length);
            this.initFlag = 1;
            this.theStream.digestAddFinalPad();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            // empty catch block
        }
    }

    public void extraSeed(byte[] byArray) throws JSAFE_InputException {
        if (this.extraSeedFlag) {
            throw new JSAFE_InputException("Can call extraSeed method only once.");
        }
        if (this.checkSeedFlag) {
            throw new JSAFE_InputException("Cannot call extraSeed method after generating random bytes.");
        }
        this.extraSeedFlag = true;
        if (byArray.length > JA_X962Random_V0.maxExtraSeed() || byArray.length < JA_X962Random_V0.minExtraSeed()) {
            throw new JSAFE_InputException("Invalid extraSeed length, must be within limits.");
        }
        this.deobfuscate();
        this.extraSeedLen = (byte)byArray.length;
        int n = extraSeedOffsets[0];
        System.arraycopy(byArray, 0, this.XSEED, 0, byArray.length);
        this.obfuscate();
    }

    public void autoseed() {
        SecureRandom secureRandom = new SecureRandom(new byte[4]);
        byte[] byArray = SecureRandom.getSeed(20);
        this.seed(byArray);
        JSAFE_Obfuscator.overwrite(byArray);
        secureRandom.setSeed(byArray);
    }

    public void generateRandomBytes(byte[] byArray, int n, int n2) {
        JA_SHA1 jA_SHA1 = this.theStream;
        this.deobfuscate();
        int n3 = extraSeedOffsets[0];
        while (n2 > 0) {
            n2 -= this.generateBlock(jA_SHA1, n2, this.extraSeedLen, n3, this.initFlag, byArray, n);
            n += 20;
            this.initFlag = 0;
        }
        this.initFlag = 2;
        this.obfuscate();
    }

    private int generateBlock(JA_SHA1 jA_SHA1, int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        int n6;
        int n7 = n6 = n < 20 ? n : 20;
        if (n4 == 1) {
            jA_SHA1.getState(this.XKEY, 0);
            n4 = 2;
        }
        System.arraycopy(this.XKEY, 0, this.XVAL, 0, 20);
        if (this.extraSeedFlag) {
            int n8 = n2 < 20 ? n2 : 20;
            int n9 = 0;
            while (n9 < 20 && n9 < n2) {
                int n10 = n9;
                this.XVAL[n10] = (byte)(this.XVAL[n10] ^ this.XSEED[n9]);
                ++n9;
            }
            n9 = 20;
            while (n9 < n2) {
                this.XSEED[n9 - 20] = this.XSEED[n9];
                ++n9;
            }
            n2 -= n8;
        }
        byte[] byArray2 = this.modQGHash(this.XVAL);
        System.arraycopy(byArray2, 0, byArray, n5, n6);
        int n11 = 1;
        int n12 = 19;
        while (n12 >= 0) {
            this.XKEY[n12] = (byte)(n11 += (this.XKEY[n12] & 0xFF) + (byArray2[n12] & 0xFF));
            n11 >>>= 8;
            --n12;
        }
        return n6;
    }

    private byte[] modQGHash(byte[] byArray) {
        try {
            try {
                byte[] byArray2 = new byte[20];
                JA_SHA1 jA_SHA1 = new JA_SHA1();
                jA_SHA1.digestInit();
                jA_SHA1.digestUpdate(byArray, 0, byArray.length);
                int n = 64 - byArray.length;
                jA_SHA1.digestUpdate(this.padBuffer, 0, n);
                jA_SHA1.getState(byArray2, 0);
                this.valueToReduce.setValue(byArray2, 0, 20);
                this.valueToReduce.modReduce(this.jcmpQ, this.reducedValue);
                byte[] byArray3 = this.reducedValue.toFixedLenOctetString(20);
                Object var7_8 = null;
                this.valueToReduce.clearSensitiveData();
                this.reducedValue.clearSensitiveData();
                return byArray3;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                byte[] byArray4 = new byte[20];
                Object var7_9 = null;
                this.valueToReduce.clearSensitiveData();
                this.reducedValue.clearSensitiveData();
                return byArray4;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.valueToReduce.clearSensitiveData();
            this.reducedValue.clearSensitiveData();
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if (this.tableOI != null) {
            this.tableOI.deobfuscate();
        }
    }

    private void restoreAfterSerialization() {
        if (this.tableOI != null) {
            this.tableOI.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
    }

    public void obfuscate() {
    }

    public void deobfuscate() {
    }

    public Object clone() throws CloneNotSupportedException {
        JA_X962Random_V0 jA_X962Random_V0 = new JA_X962Random_V0();
        jA_X962Random_V0.extraSeedFlag = this.extraSeedFlag;
        jA_X962Random_V0.checkSeedFlag = this.checkSeedFlag;
        if (this.theStream != null) {
            jA_X962Random_V0.theStream = (JA_SHA1)this.theStream.clone();
        }
        jA_X962Random_V0.initFlag = this.initFlag;
        if (this.jcmpQ != null) {
            jA_X962Random_V0.jcmpQ = (JCMPInt)this.jcmpQ.clone();
        }
        if (this.valueToReduce != null) {
            jA_X962Random_V0.valueToReduce = (JCMPInt)this.valueToReduce.clone();
        }
        if (this.reducedValue != null) {
            jA_X962Random_V0.reducedValue = (JCMPInt)this.reducedValue.clone();
        }
        return jA_X962Random_V0;
    }

    public void clearSensitiveData() {
        if (this.theStream != null) {
            this.theStream.clearSensitiveData();
        }
        this.tableOI = null;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[128];
        JA_X962Random_V0 jA_X962Random_V0 = new JA_X962Random_V0();
        try {
            jA_X962Random_V0.createStreams();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        jA_X962Random_V0.generateRandomBytes(byArray, 0, 128);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        while (n2 < 16) {
            int n3 = 0;
            while (n3 < 8) {
                System.out.print(Integer.toHexString(byArray[n] < 0 ? byArray[n] + 256 : byArray[n]) + " ");
                ++n;
                ++n3;
            }
            System.out.println();
            ++n2;
        }
    }
}

