/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_Prime;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JCMPInt
implements JCMPInteger,
Cloneable,
Serializable {
    private int[] value;
    private int valueLen;
    private transient ObfuscatorItem valueOI;
    private int obfuscateFlag;
    private static final int NOT_OBFUSCATED = 0;
    private static final int OBFUSCATED = 1;
    private static final int OBFUSCATE_OFF = 2;
    private static final int DEOBFUSCATED = 4;
    private static final int BITS_PER_WORD = 32;
    private static final long VALUE_INITIAL_MASK_L = 0xFFFFFFFFL;
    private static final String negativeResultString = "JCMPInt operation yields negative result.";

    public void setValue(int n) throws JSAFE_InputException {
        if (n < 0) {
            throw new JSAFE_InputException(negativeResultString);
        }
        this.allocateValue(1);
        this.value[0] = n;
        this.valueLen = 1;
    }

    private void setValueNoException(int n) {
        this.allocateValue(1);
        this.value[0] = n;
        this.valueLen = 1;
    }

    public void setValue(JCMPInteger jCMPInteger) {
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        if (jCMPInt.valueLen == 0) {
            jCMPInt.setValueNoException(0);
        }
        this.allocateValue(jCMPInt.valueLen);
        int n = jCMPInt.obfuscateFlag;
        if ((n & 1) != 0) {
            jCMPInt.deobfuscate();
        }
        int n2 = 0;
        while (n2 < jCMPInt.valueLen) {
            this.value[n2] = jCMPInt.value[n2];
            ++n2;
        }
        if ((n & 1) != 0) {
            jCMPInt.obfuscate();
        }
        this.valueLen = jCMPInt.valueLen;
        this.normalize();
    }

    public void setValue(byte[] byArray, int n, int n2) {
        int n3 = (n2 * 8 + 31) / 32;
        this.allocateValue(n3);
        this.valueLen = n3;
        int n4 = n + n2 - 1;
        int n5 = 0;
        while (n5 < this.valueLen) {
            int n6 = 24;
            if (n2 < 4) {
                n6 = n2 - 1 << 3;
            }
            int n7 = 0;
            int n8 = 0;
            while (n8 <= n6) {
                n7 |= (byArray[n4] & 0xFF) << n8;
                n8 += 8;
                --n4;
            }
            this.value[n5] = n7;
            ++n5;
            n2 -= 4;
        }
        this.normalize();
    }

    public void setPowerOfTwo(int n) throws JSAFE_InputException {
        if (n < 0) {
            this.resetVariables();
            throw new JSAFE_InputException("Cannot create a JCMPInt with a negative exponent.");
        }
        int n2 = n / 32 + 1;
        this.setVectorZero(n2);
        this.setBit(n, 1);
    }

    private void setVectorZero(int n) {
        if (!this.allocateValue(n)) {
            int n2 = 0;
            while (n2 < this.value.length) {
                this.value[n2] = 0;
                ++n2;
            }
        }
        this.valueLen = 1;
    }

    private boolean allocateValue(int n) {
        if (this.value == null) {
            this.value = new int[n];
            return true;
        }
        if (this.value.length < n) {
            if (this.valueOI != null) {
                this.clearSensitiveData();
            }
            this.value = new int[n];
            return true;
        }
        this.resetVariables();
        return false;
    }

    boolean isEven() {
        if ((this.obfuscateFlag & 1) == 0) {
            return (this.value[0] & 1) == 0;
        }
        this.deobfuscate();
        boolean bl = (this.value[0] & 1) == 0;
        this.obfuscate();
        return bl;
    }

    public boolean isZero() {
        if ((this.obfuscateFlag & 1) == 0) {
            return this.valueLen == 1 && this.value[0] == 0;
        }
        this.deobfuscate();
        boolean bl = this.valueLen == 1 && this.value[0] == 0;
        this.obfuscate();
        return bl;
    }

    boolean isThree() {
        if ((this.obfuscateFlag & 1) == 0) {
            return this.valueLen == 1 && this.value[0] == 3;
        }
        this.deobfuscate();
        boolean bl = this.valueLen == 1 && this.value[0] == 3;
        this.obfuscate();
        return bl;
    }

    public byte[] toOctetString() {
        if (this.valueLen == 0) {
            return new byte[1];
        }
        int n = this.obfuscateFlag;
        if ((n & 1) != 0) {
            this.deobfuscate();
        }
        int n2 = this.getBitLength();
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = n3 - 1;
        int n5 = 0;
        while (n5 < this.valueLen) {
            int n6 = this.value[n5];
            int n7 = 4;
            if (n3 < 4) {
                n7 = n3;
            }
            int n8 = 0;
            while (n8 < n7) {
                byArray[n4] = (byte)n6;
                n6 >>>= 8;
                ++n8;
                --n4;
            }
            ++n5;
            n3 -= 4;
        }
        if ((n & 1) != 0) {
            this.obfuscate();
        }
        return byArray;
    }

    public byte[] toFixedLenOctetString(int n) throws JSAFE_InputException {
        byte[] byArray = this.toOctetString();
        if (byArray.length == n) {
            return byArray;
        }
        if (byArray.length > n) {
            JSAFE_Obfuscator.overwrite(byArray);
            throw new JSAFE_InputException("JCMPInt too large for toFixedLenOctetString (" + n + ")");
        }
        byte[] byArray2 = new byte[n];
        int n2 = n - byArray.length;
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        JSAFE_Obfuscator.overwrite(byArray);
        return byArray2;
    }

    public int getBitLength() {
        int n;
        if (this.valueLen == 0) {
            this.setValueNoException(0);
        }
        if (((n = this.obfuscateFlag) & 1) != 0) {
            this.deobfuscate();
        }
        this.normalize();
        int n2 = this.value[this.valueLen - 1];
        if ((n & 1) != 0) {
            this.obfuscate();
        }
        if (this.valueLen == 1 && n2 == 0) {
            return 1;
        }
        int n3 = this.valueLen * 32;
        if ((n2 & 0xFFFF0000) == 0) {
            n3 -= 16;
            n2 <<= 16;
        }
        if ((n2 & 0xFF000000) == 0) {
            n3 -= 8;
            n2 <<= 8;
        }
        if ((n2 & 0xF0000000) == 0) {
            n3 -= 4;
            n2 <<= 4;
        }
        while ((n2 & Integer.MIN_VALUE) == 0) {
            n2 <<= 1;
            if (--n3 > 0) continue;
        }
        return n3;
    }

    public int getBit(int n) {
        int n2;
        int n3 = this.obfuscateFlag;
        if ((n3 & 1) != 0) {
            this.deobfuscate();
        }
        if ((n2 = this.getBitLength()) <= n) {
            if ((n3 & 1) != 0) {
                this.obfuscate();
            }
            return 0;
        }
        int n4 = n / 32;
        n %= 32;
        int n5 = this.value[n4];
        if ((n3 & 1) != 0) {
            this.obfuscate();
        }
        n5 = n5 >>> n & 1;
        return n5;
    }

    public void setBit(int n, int n2) {
        int n3 = n / 32;
        n %= 32;
        if (n3 >= this.valueLen) {
            if (n2 == 0) {
                return;
            }
            int n4 = this.obfuscateFlag;
            if ((n4 & 1) != 0) {
                this.deobfuscate();
            }
            int n5 = n3 - this.valueLen + 1;
            int[] nArray = new int[n5];
            nArray[n5 - 1] = 1 << n;
            this.expandValue(nArray, 0, n5);
            if ((n4 & 1) != 0) {
                this.obfuscate();
            }
            return;
        }
        int n6 = this.obfuscateFlag;
        if ((n6 & 1) != 0) {
            this.deobfuscate();
        }
        int n7 = this.value[n3];
        int n8 = 1 << n;
        int n9 = ~n8;
        n7 &= n9;
        if (n2 != 0) {
            n7 |= n8;
        }
        this.value[n3] = n7;
        this.normalize();
        if ((n6 & 1) != 0) {
            this.obfuscate();
        }
    }

    public int compareTo(JCMPInteger jCMPInteger) {
        long l;
        long l2;
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        if (this.valueLen == 0) {
            this.setValueNoException(0);
        }
        if (jCMPInt.valueLen == 0) {
            jCMPInt.setValueNoException(0);
        }
        if (this.valueLen > jCMPInt.valueLen) {
            return 1;
        }
        if (this.valueLen < jCMPInt.valueLen) {
            return -1;
        }
        int n = this.initializeValues(this, jCMPInt, null);
        int n2 = 0;
        int n3 = this.valueLen - 1;
        while (n3 >= 0) {
            l2 = (long)this.value[n3] & 0xFFFFFFFFL;
            l = (long)jCMPInt.value[n3] & 0xFFFFFFFFL;
            if (l2 != l) {
                n2 = -1;
                if (l2 <= l) break;
                n2 = 1;
                break;
            }
            --n3;
        }
        if (n != 0) {
            this.reobfuscateOperands(n, this, jCMPInt, null);
        }
        l = 0L;
        l2 = 0L;
        return n2;
    }

    private int compareToInitialized(JCMPInt jCMPInt) {
        long l;
        long l2;
        if (this.valueLen > jCMPInt.valueLen) {
            return 1;
        }
        if (this.valueLen < jCMPInt.valueLen) {
            return -1;
        }
        int n = 0;
        int n2 = this.valueLen - 1;
        while (n2 >= 0) {
            l2 = (long)this.value[n2] & 0xFFFFFFFFL;
            l = (long)jCMPInt.value[n2] & 0xFFFFFFFFL;
            if (l2 != l) {
                n = -1;
                if (l2 <= l) break;
                n = 1;
                break;
            }
            --n2;
        }
        l = 0L;
        l2 = 0L;
        return n;
    }

    public void add(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2) {
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        JCMPInt jCMPInt2 = (JCMPInt)jCMPInteger2;
        int n = this.initializeValues(this, jCMPInt, null);
        int n2 = this.valueLen;
        if (jCMPInt.valueLen > n2) {
            n2 = jCMPInt.valueLen;
        }
        jCMPInt2.allocateValue(n2);
        int n3 = this.addVectors(this.value, this.valueLen, jCMPInt.value, jCMPInt.valueLen, jCMPInt2.value);
        if (n != 0) {
            this.reobfuscateOperands(n, this, jCMPInt, null);
        }
        jCMPInt2.valueLen = n2;
        if (n3 != 0) {
            jCMPInt2.propagateCarry(n2);
        }
        jCMPInt2.normalize();
    }

    public void addInPlace(int n) throws JSAFE_InputException {
        int n2;
        if (this.valueLen == 0) {
            this.setValueNoException(0);
        }
        if (((n2 = this.obfuscateFlag) & 1) != 0) {
            this.deobfuscate();
        }
        long l = ((long)this.value[0] & 0xFFFFFFFFL) + (long)n;
        this.value[0] = (int)l;
        if ((l >>>= 32) != 0L) {
            if (n >= 0) {
                this.propagateCarry(1);
            } else {
                this.propagateBorrow(1);
            }
        }
        this.normalize();
        if ((n2 & 1) != 0) {
            this.obfuscate();
        }
    }

    public void addInPlace(JCMPInteger jCMPInteger) {
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        int n = this.initializeValues(this, jCMPInt, null);
        int n2 = this.valueLen;
        if (jCMPInt.valueLen > n2) {
            n2 = jCMPInt.valueLen;
        }
        int[] nArray = this.value;
        if (this.value.length < n2) {
            nArray = new int[n2];
        }
        int n3 = this.addVectors(this.value, this.valueLen, jCMPInt.value, jCMPInt.valueLen, nArray);
        if (nArray != this.value) {
            this.clearSensitiveData();
            this.value = nArray;
        }
        this.valueLen = n2;
        if (n3 != 0) {
            this.propagateCarry(n2);
        }
        this.normalize();
        if (n != 0) {
            this.reobfuscateOperands(n, this, jCMPInt, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int addVectors(int[] var1_1, int var2_2, int[] var3_3, int var4_4, int[] var5_5) {
        var6_6 = 0;
        var7_7 = 0L;
        if (var2_2 < var4_4) ** GOTO lbl29
        while (var6_6 < var4_4) {
            var9_8 = ((long)var1_1[var6_6] & 0xFFFFFFFFL) + ((long)var3_3[var6_6] & 0xFFFFFFFFL) + var7_7;
            var5_5[var6_6] = (int)var9_8;
            var7_7 = var9_8 >>> 32;
            ++var6_6;
        }
        if (var2_2 == var4_4) {
            return (int)var7_7;
        }
        if (var5_5 != var1_1) {
            while (var6_6 < var2_2) {
                var5_5[var6_6] = var1_1[var6_6];
                ++var6_6;
            }
            var6_6 = var4_4;
        }
        while (var7_7 != 0L && var6_6 < var2_2) {
            var9_8 = ((long)var5_5[var6_6] & 0xFFFFFFFFL) + var7_7;
            var5_5[var6_6] = (int)var9_8;
            var7_7 = var9_8 >>> 32;
            ++var6_6;
        }
        return (int)var7_7;
lbl-1000:
        // 1 sources

        {
            var9_9 = ((long)var1_1[var6_6] & 0xFFFFFFFFL) + ((long)var3_3[var6_6] & 0xFFFFFFFFL) + var7_7;
            var5_5[var6_6] = (int)var9_9;
            var7_7 = var9_9 >>> 32;
            ++var6_6;
lbl29:
            // 2 sources

            ** while (var6_6 < var2_2)
        }
lbl30:
        // 2 sources

        while (var6_6 < var4_4) {
            var5_5[var6_6] = var3_3[var6_6];
            ++var6_6;
        }
        var6_6 = var2_2;
        while (var7_7 != 0L && var6_6 < var4_4) {
            var9_9 = ((long)var5_5[var6_6] & 0xFFFFFFFFL) + var7_7;
            var5_5[var6_6] = (int)var9_9;
            var7_7 = var9_9 >>> 32;
            ++var6_6;
        }
        return (int)var7_7;
    }

    public void subtract(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2) throws JSAFE_InputException {
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        JCMPInt jCMPInt2 = (JCMPInt)jCMPInteger2;
        int n = this.initializeValues(this, jCMPInt, null);
        int n2 = this.compareToInitialized(jCMPInt);
        if (n2 <= 0) {
            if (n != 0) {
                this.reobfuscateOperands(n, this, jCMPInt, null);
            }
            jCMPInt2.setValueNoException(0);
            if (n2 == 0) {
                return;
            }
            throw new JSAFE_InputException(negativeResultString);
        }
        int n3 = this.valueLen;
        jCMPInt2.allocateValue(n3);
        this.subtractVectors(this.value, this.valueLen, jCMPInt.value, jCMPInt.valueLen, jCMPInt2.value);
        if (n != 0) {
            this.reobfuscateOperands(n, this, jCMPInt, null);
        }
        jCMPInt2.valueLen = n3;
        jCMPInt2.normalize();
    }

    public void subtractInPlace(int n) throws JSAFE_InputException {
        this.addInPlace(-n);
    }

    public void subtractInPlace(JCMPInteger jCMPInteger) throws JSAFE_InputException {
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        int n = this.initializeValues(this, jCMPInt, null);
        int n2 = this.compareToInitialized(jCMPInt);
        if (n2 <= 0) {
            this.setValueNoException(0);
            if (n != 0) {
                this.reobfuscateOperands(n, this, jCMPInt, null);
            }
            if (n2 == 0) {
                return;
            }
            throw new JSAFE_InputException(negativeResultString);
        }
        this.subtractVectors(this.value, this.valueLen, jCMPInt.value, jCMPInt.valueLen, this.value);
        this.normalize();
    }

    private int subtractVectors(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        long l;
        int n3 = 0;
        long l2 = 0L;
        while (n3 < n2) {
            l = ((long)nArray[n3] & 0xFFFFFFFFL) - ((long)nArray2[n3] & 0xFFFFFFFFL) + l2;
            nArray3[n3] = (int)l;
            l2 = l >> 32;
            ++n3;
        }
        if (n == n2) {
            return (int)l2;
        }
        if (nArray3 != nArray) {
            while (n3 < n) {
                nArray3[n3] = nArray[n3];
                ++n3;
            }
            n3 = n2;
        }
        while (l2 != 0L && n3 < n) {
            l = ((long)nArray3[n3] & 0xFFFFFFFFL) + l2;
            nArray3[n3] = (int)l;
            l2 = l >> 32;
            ++n3;
        }
        return (int)l2;
    }

    public void multiply(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2) {
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        JCMPInt jCMPInt2 = (JCMPInt)jCMPInteger2;
        int n = this.initializeValues(this, jCMPInt, null);
        int n2 = this.valueLen + jCMPInt.valueLen;
        jCMPInt2.setVectorZero(n2);
        long l = (long)this.value[0] & 0xFFFFFFFFL;
        int n3 = jCMPInt.valueLen;
        long l2 = 0L;
        long l3 = 0L;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            l3 = ((long)jCMPInt.value[n5] & 0xFFFFFFFFL) * l + l2;
            jCMPInt2.value[n4] = (int)l3;
            l2 = l3 >>> 32;
            ++n5;
            ++n4;
        }
        jCMPInt2.value[n4] = (int)l2;
        int n6 = 1;
        while (n6 < this.valueLen) {
            l = (long)this.value[n6] & 0xFFFFFFFFL;
            n4 = n6;
            l2 = 0L;
            int n7 = 0;
            while (n7 < n3) {
                l3 = ((long)jCMPInt.value[n7] & 0xFFFFFFFFL) * l + ((long)jCMPInt2.value[n4] & 0xFFFFFFFFL) + l2;
                jCMPInt2.value[n4] = (int)l3;
                l2 = l3 >>> 32;
                ++n7;
                ++n4;
            }
            jCMPInt2.value[n4] = (int)l2;
            ++n6;
        }
        if (n != 0) {
            this.reobfuscateOperands(n, this, jCMPInt, null);
        }
        jCMPInt2.valueLen = n4 + 1;
        jCMPInt2.normalize();
    }

    private void vectorMultiply(int n, int n2, int n3, JCMPInt jCMPInt, int n4) {
        long l;
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = 0L;
        int n5 = 0;
        while (n5 < n3) {
            l = l2 * ((long)this.value[n2 + n5] & 0xFFFFFFFFL) + ((long)jCMPInt.value[n4] & 0xFFFFFFFFL) + l3;
            jCMPInt.value[n4] = (int)l;
            l3 = l >>> 32;
            ++n5;
            ++n4;
        }
        jCMPInt.value[n4] = (int)(l3 += (long)jCMPInt.value[n4] & 0xFFFFFFFFL);
        l3 >>>= 32;
        if (n4 + 1 > jCMPInt.valueLen) {
            jCMPInt.valueLen = n4 + 1;
        }
        if (l3 != 0L) {
            jCMPInt.propagateCarry(n4 + 1);
        }
        l = 0L;
    }

    public void modMultiply(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2, JCMPInteger jCMPInteger3) throws JSAFE_InputException {
        JCMPInt jCMPInt = new JCMPInt();
        int n = this.initializeValues(this, (JCMPInt)jCMPInteger, (JCMPInt)jCMPInteger2);
        this.multiply(jCMPInteger, jCMPInt);
        try {
            jCMPInt.modReduce(jCMPInteger2, jCMPInteger3);
            Object var7_6 = null;
            if (n != 0) {
                this.reobfuscateOperands(n, this, (JCMPInt)jCMPInteger, (JCMPInt)jCMPInteger2);
            }
            jCMPInt.clearSensitiveData();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (n != 0) {
                this.reobfuscateOperands(n, this, (JCMPInt)jCMPInteger, (JCMPInt)jCMPInteger2);
            }
            jCMPInt.clearSensitiveData();
            throw throwable;
        }
    }

    public void divide(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2, JCMPInteger jCMPInteger3) throws JSAFE_InputException {
        long l;
        int n;
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        JCMPInt jCMPInt2 = (JCMPInt)jCMPInteger2;
        JCMPInt jCMPInt3 = (JCMPInt)jCMPInteger3;
        int n2 = this.initializeValues(this, jCMPInt, null);
        jCMPInt.normalize();
        int[] nArray = null;
        int n3 = this.valueLen + 2 - jCMPInt.valueLen;
        if (n3 > 0) {
            nArray = new int[n3];
        }
        if (jCMPInt.valueLen == 1 && jCMPInt.value[0] == 0) {
            jCMPInt2.setValueNoException(0);
            jCMPInt3.setValueNoException(0);
            if (n2 != 0) {
                this.reobfuscateOperands(n2, this, jCMPInt, null);
            }
            throw new JSAFE_InputException("Cannot divide by zero.");
        }
        int n4 = this.compareToInitialized(jCMPInt);
        if (n4 <= 0) {
            if (n2 != 0) {
                this.reobfuscateOperands(n2, this, jCMPInt, null);
            }
            if (n4 == 0) {
                jCMPInt2.setValueNoException(1);
                jCMPInt3.setValueNoException(0);
                return;
            }
            jCMPInt2.setValue(0);
            jCMPInt3.setValue(this);
            return;
        }
        int n5 = this.getBitLength();
        if (n5 == (n = jCMPInt.getBitLength())) {
            jCMPInt2.setValueNoException(1);
            this.subtract(jCMPInt, jCMPInt3);
            if (n2 != 0) {
                this.reobfuscateOperands(n2, this, jCMPInt, null);
            }
            return;
        }
        int n6 = n % 32;
        if (n6 != 0) {
            n6 = 32 - n6;
        }
        if (n3 > jCMPInt.valueLen) {
            jCMPInt2.setVectorZero(n3);
        }
        jCMPInt2.setValue(jCMPInt);
        jCMPInt3.setVectorZero(this.valueLen + 1);
        jCMPInt3.setValue(this);
        if (n2 != 0) {
            this.reobfuscateOperands(n2, this, jCMPInt, null);
        }
        if (n6 != 0) {
            jCMPInt3.shiftLeftByBits(n6);
            jCMPInt2.shiftLeftByBits(n6);
        }
        int[] nArray2 = jCMPInt3.value;
        int n7 = jCMPInt3.valueLen;
        int[] nArray3 = jCMPInt2.value;
        int n8 = jCMPInt2.valueLen;
        int n9 = n7 - n8;
        int n10 = n7 - 1;
        int n11 = n7 - 1;
        int n12 = n8 - 1;
        while (n12 > 0) {
            if (nArray2[n11] != nArray3[n12]) break;
            --n11;
            --n12;
        }
        long l2 = (long)nArray2[n11] & 0xFFFFFFFFL;
        long l3 = (long)nArray3[n12] & 0xFFFFFFFFL;
        if (l2 > l3) {
            l = 0L;
            n12 = 0;
            n11 = n9;
            while (n12 < n8) {
                l += (long)nArray2[n11] & 0xFFFFFFFFL;
                nArray2[n11] = (int)(l -= (long)nArray3[n12] & 0xFFFFFFFFL);
                l >>= 32;
                ++n12;
                ++n11;
            }
            nArray[n9] = 1;
        }
        --n9;
        l2 = (long)nArray3[0] & 0xFFFFFFFFL;
        l3 = (long)nArray3[n8 - 1] & 0xFFFFFFFFL;
        l = l3 >>> 1;
        long l4 = 0L;
        if (n8 > 1) {
            l4 = (long)nArray3[n8 - 2] & 0xFFFFFFFFL;
        }
        while (n9 >= 0) {
            long l5 = (long)nArray2[n10] << 32;
            long l6 = 0L;
            long l7 = 0L;
            if ((l5 |= (long)nArray2[n10 - 1] & 0xFFFFFFFFL) >= 0L) {
                l6 = l5 / l3;
                l7 = l5 - l6 * l3;
            } else {
                l6 = (l5 >>> 1) / l;
                l7 = l5 - l6 * l3;
                while (l7 < 0L) {
                    l7 += l3;
                    --l6;
                }
                while (l7 > l3) {
                    l7 -= l3;
                    ++l6;
                }
            }
            if (n8 == 1 || l6 == 0L) {
                nArray[n9] = (int)l6;
                nArray2[n10] = 0;
                nArray2[n10 - 1] = (int)l7;
                --n10;
            } else {
                long l8 = l6 * l4;
                long l9 = l8 & 0xFFFFFFFFL;
                l8 >>>= 32;
                while (l7 <= l8 && (l7 != l8 || ((long)nArray2[n10 - 2] & 0xFFFFFFFFL) < l9)) {
                    --l6;
                    l7 += l3;
                    l8 -= l4;
                }
                if (l6 > 0xFFFFFFFFL) {
                    l6 = 0xFFFFFFFFL;
                }
                long l10 = l6 * l2;
                long l11 = ((long)nArray2[n9] & 0xFFFFFFFFL) - (l10 & 0xFFFFFFFFL);
                nArray2[n9] = (int)l11;
                long l12 = (l10 >>> 32) - (l11 >>= 32);
                n12 = 1;
                n11 = n9 + 1;
                while (n12 < n8) {
                    l10 = l6 * ((long)nArray3[n12] & 0xFFFFFFFFL) + l12;
                    l11 = ((long)nArray2[n11] & 0xFFFFFFFFL) - (l10 & 0xFFFFFFFFL);
                    nArray2[n11] = (int)l11;
                    l12 = (l10 >>> 32) - (l11 >>= 32);
                    ++n12;
                    ++n11;
                }
                if (l12 != 0L) {
                    l12 = ((long)nArray2[n10] & 0xFFFFFFFFL) - l12;
                    nArray2[n10] = 0;
                    if (l12 < 0L) {
                        --l6;
                        l12 = 0L;
                        n12 = 0;
                        n11 = n9;
                        while (n12 < n8) {
                            nArray2[n11] = (int)(l12 += ((long)nArray2[n11] & 0xFFFFFFFFL) + ((long)nArray3[n12] & 0xFFFFFFFFL));
                            l12 >>>= 32;
                            ++n12;
                            ++n11;
                        }
                    }
                }
                nArray[n9] = (int)l6;
                --n10;
            }
            --n9;
        }
        System.arraycopy(nArray, 0, jCMPInt2.value, 0, n3);
        jCMPInt2.valueLen = n3;
        jCMPInt2.normalize();
        jCMPInt3.valueLen = n7;
        jCMPInt3.shiftRightByBits(n6);
        jCMPInt3.normalize();
    }

    public void modReduce(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2) throws JSAFE_InputException {
        JCMPInt jCMPInt = new JCMPInt();
        try {
            this.divide(jCMPInteger, jCMPInt, jCMPInteger2);
            Object var5_4 = null;
            jCMPInt.clearSensitiveData();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            jCMPInt.clearSensitiveData();
            throw throwable;
        }
    }

    public boolean modInvert(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2) throws JSAFE_InputException {
        boolean bl;
        int n;
        JCMPInt jCMPInt = (JCMPInt)jCMPInteger;
        JCMPInt jCMPInt2 = (JCMPInt)jCMPInteger2;
        int n2 = this.initializeValues(this, jCMPInt, null);
        if (this.compareToInitialized(jCMPInt) >= 0) {
            jCMPInt2.setValueNoException(0);
            if (n2 != 0) {
                this.reobfuscateOperands(n2, this, jCMPInt, null);
            }
            throw new JSAFE_InputException("Cannot invert, operand >= modulus");
        }
        if (this.valueLen == 1) {
            if (this.value[0] == 0) {
                jCMPInt2.setValueNoException(0);
                if (n2 != 0) {
                    this.reobfuscateOperands(n2, this, jCMPInt, null);
                }
                return false;
            }
            if (this.value[0] == 1) {
                jCMPInt2.setValueNoException(1);
                if (n2 != 0) {
                    this.reobfuscateOperands(n2, this, jCMPInt, null);
                }
                return true;
            }
        }
        if ((jCMPInt.value[0] & 1) != 0 && this.valueLen >= 1) {
            boolean bl2 = this.modInvertSchroeppel(jCMPInt, jCMPInt2);
            if (n2 != 0) {
                this.reobfuscateOperands(n2, this, jCMPInt, null);
            }
            return bl2;
        }
        JCMPInt jCMPInt3 = null;
        JCMPInt jCMPInt4 = null;
        JCMPInt jCMPInt5 = null;
        JCMPInt jCMPInt6 = null;
        JCMPInt jCMPInt7 = null;
        jCMPInt3 = new JCMPInt();
        jCMPInt4 = new JCMPInt();
        jCMPInt.divide(this, jCMPInt3, jCMPInt4);
        if (jCMPInt4.valueLen == 1 && jCMPInt4.value[0] == 0) {
            jCMPInt2.setValueNoException(0);
            if (n2 != 0) {
                this.reobfuscateOperands(n2, this, jCMPInt, null);
            }
            return false;
        }
        jCMPInt5 = new JCMPInt();
        jCMPInt5.setValue(this);
        if (n2 != 0) {
            this.reobfuscateOperands(n2, this, jCMPInt, null);
        }
        jCMPInt6 = new JCMPInt();
        jCMPInt6.setVectorZero(this.valueLen);
        jCMPInt6.setValueNoException(1);
        int n3 = 1;
        int n4 = -1;
        jCMPInt7 = new JCMPInt();
        while (true) {
            n = 1;
            bl = true;
            if (jCMPInt4.valueLen == 1 && jCMPInt4.value[0] == 1) break;
            jCMPInt5.divide(jCMPInt4, jCMPInt2, jCMPInt7);
            bl = false;
            if (jCMPInt7.valueLen == 1 && jCMPInt7.value[0] == 0) break;
            jCMPInt2.multiply(jCMPInt3, jCMPInt5);
            int n5 = n4;
            n4 = jCMPInt6.subtractSigned(n3, jCMPInt5, n4, jCMPInt2);
            n3 = n5;
            JCMPInt.swapContents(jCMPInt5, jCMPInt7);
            n = 4;
            bl = true;
            if (jCMPInt5.valueLen == 1 && jCMPInt5.value[0] == 1) break;
            jCMPInt4.divide(jCMPInt5, jCMPInt2, jCMPInt7);
            bl = false;
            if (jCMPInt7.valueLen == 1 && jCMPInt7.value[0] == 0) break;
            jCMPInt2.multiply(jCMPInt6, jCMPInt4);
            n5 = n4;
            n4 = jCMPInt3.subtractSigned(n3, jCMPInt4, n4, jCMPInt2);
            n3 = n5;
            JCMPInt.swapContents(jCMPInt4, jCMPInt7);
        }
        if (!bl) {
            jCMPInt2.resetVariables();
        } else {
            switch (n) {
                case 1: {
                    if (n4 == 1) {
                        jCMPInt2.setValue(jCMPInt3);
                        break;
                    }
                    jCMPInt.subtract(jCMPInt3, jCMPInt2);
                    break;
                }
                case 4: {
                    if (n4 == 1) {
                        jCMPInt2.setValue(jCMPInt6);
                        break;
                    }
                    jCMPInt.subtract(jCMPInt6, jCMPInt2);
                    break;
                }
                default: {
                    jCMPInt2.resetVariables();
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean modInvertSchroeppel(JCMPInt jCMPInt, JCMPInt jCMPInt2) throws JSAFE_InputException {
        int n;
        JCMPInt jCMPInt3 = new JCMPInt();
        JCMPInt jCMPInt4 = new JCMPInt();
        JCMPInt jCMPInt5 = new JCMPInt();
        JCMPInt jCMPInt6 = new JCMPInt();
        JCMPInt jCMPInt7 = null;
        jCMPInt3.setVectorZero(jCMPInt.valueLen);
        jCMPInt3.setValueNoException(1);
        jCMPInt4.setVectorZero(jCMPInt.valueLen);
        jCMPInt5.setValue(this);
        jCMPInt6.setValue(jCMPInt);
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        n4 = jCMPInt5.shiftToOdd();
        boolean bl = true;
        while (true) {
            if (jCMPInt5.valueLen == 1) {
                if (jCMPInt5.value[0] == 1) break;
                if (jCMPInt5.value[0] == 0) {
                    bl = false;
                    break;
                }
            }
            if (jCMPInt5.compareTo(jCMPInt6) < 0) {
                jCMPInt7 = jCMPInt5;
                jCMPInt5 = jCMPInt6;
                jCMPInt6 = jCMPInt7;
                jCMPInt7 = jCMPInt3;
                jCMPInt3 = jCMPInt4;
                jCMPInt4 = jCMPInt7;
                int n5 = n2;
                n2 = n3;
                n3 = n5;
            }
            if ((n = (jCMPInt5.value[0] ^ jCMPInt6.value[0]) & 3) == 0) {
                jCMPInt5.subtractInPlace(jCMPInt6);
                n2 = jCMPInt3.subtractSigned(n2, jCMPInt4, n3, jCMPInt2);
            } else {
                jCMPInt5.addInPlace(jCMPInt6);
                n2 = jCMPInt3.subtractSigned(n2, jCMPInt4, -n3, jCMPInt2);
            }
            if ((n = jCMPInt5.shiftToOdd()) == 0) continue;
            jCMPInt4.shiftLeftByBits(n);
            n4 += n;
        }
        if (bl) {
            int n6;
            while (n2 < 0) {
                n2 = jCMPInt3.subtractSigned(n2, jCMPInt, -1, jCMPInt2);
            }
            n = jCMPInt.value[0];
            int n7 = 0;
            while (n7 < 4) {
                n *= 2 - n * jCMPInt.value[0];
                ++n7;
            }
            n = -n;
            int n8 = n4 >> 5;
            jCMPInt2.setVectorZero(jCMPInt.valueLen + 1 + n8);
            jCMPInt2.setValue(jCMPInt3);
            int n9 = 0;
            while (n9 < n8) {
                n6 = n * jCMPInt2.value[n9];
                jCMPInt.vectorMultiply(n6, 0, jCMPInt.valueLen, jCMPInt2, n9);
                ++n9;
            }
            jCMPInt2.shiftRightByWords(n8);
            n6 = jCMPInt2.valueLen;
            while (n6 < jCMPInt2.value.length) {
                jCMPInt2.value[n6] = 0;
                ++n6;
            }
            if ((n4 &= 0x1F) != 0) {
                int n10 = n * jCMPInt2.value[0];
                jCMPInt.vectorMultiply(n10 &= (1 << n4) - 1, 0, jCMPInt.valueLen, jCMPInt2, 0);
                jCMPInt2.shiftRightByBits(n4);
            }
        }
        if (jCMPInt2.compareTo(jCMPInt) >= 0) {
            jCMPInt2.subtractInPlace(jCMPInt);
        }
        return bl;
    }

    private int shiftToOdd() {
        int n = 0;
        while (n < this.valueLen) {
            if (this.value[n] != 0) break;
            ++n;
        }
        if (n >= this.valueLen) {
            return 0;
        }
        int n2 = this.value[n];
        n *= 8;
        while ((n2 & 1) != 1) {
            n2 >>>= 1;
            ++n;
        }
        if (n != 0) {
            this.shiftRightByBits(n);
        }
        return n;
    }

    public int subtractSigned(int n, JCMPInt jCMPInt, int n2, JCMPInt jCMPInt2) throws JSAFE_InputException {
        if (this.compareTo(jCMPInt) >= 0) {
            if (n == n2) {
                this.subtractInPlace(jCMPInt);
            } else {
                this.addInPlace(jCMPInt);
            }
            return n;
        }
        if (n != n2) {
            this.addInPlace(jCMPInt);
            return -n2;
        }
        JCMPInt.swapContents(this, jCMPInt2);
        jCMPInt.subtract(jCMPInt2, this);
        return -n2;
    }

    private static void swapContents(JCMPInt jCMPInt, JCMPInt jCMPInt2) {
        int[] nArray = jCMPInt.value;
        int n = jCMPInt.valueLen;
        jCMPInt.value = jCMPInt2.value;
        jCMPInt.valueLen = jCMPInt2.valueLen;
        jCMPInt2.value = nArray;
        jCMPInt2.valueLen = n;
    }

    protected void modExpSpecialExponent(JCMPInt jCMPInt, JCMPInt jCMPInt2, JCMPInt jCMPInt3, int n) throws JSAFE_InputException {
        if (n < 0) {
            if (jCMPInt.value[0] == 0) {
                jCMPInt3.setValueNoException(1);
            } else {
                jCMPInt3.setValue(this);
            }
            return;
        }
        if (jCMPInt.isThree()) {
            this.modCube(jCMPInt2, jCMPInt3);
            return;
        }
        this.modMultiply(this, jCMPInt2, jCMPInt3);
    }

    public void modCube(JCMPInt jCMPInt, JCMPInt jCMPInt2) throws JSAFE_InputException {
        JCMPInt jCMPInt3 = new JCMPInt();
        JCMPInt jCMPInt4 = new JCMPInt();
        try {
            this.multiply(this, jCMPInt3);
            jCMPInt3.divide(jCMPInt, jCMPInt4, jCMPInt2);
            jCMPInt2.multiply(this, jCMPInt3);
            jCMPInt3.divide(jCMPInt, jCMPInt4, jCMPInt2);
            Object var6_5 = null;
            jCMPInt3.clearSensitiveData();
            jCMPInt4.clearSensitiveData();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            jCMPInt3.clearSensitiveData();
            jCMPInt4.clearSensitiveData();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modExp(JCMPInteger jCMPInteger, JCMPInteger jCMPInteger2, JCMPInteger jCMPInteger3) throws JSAFE_InputException {
        Throwable throwable2;
        int n;
        JCMPInt jCMPInt;
        JCMPInt jCMPInt2;
        block23: {
            int n2;
            JCMPInt[] jCMPIntArray;
            block24: {
                jCMPInt2 = (JCMPInt)jCMPInteger;
                jCMPInt = (JCMPInt)jCMPInteger2;
                JCMPInt jCMPInt3 = (JCMPInt)jCMPInteger3;
                JCMPInt jCMPInt4 = null;
                jCMPIntArray = null;
                n = this.initializeValues(this, jCMPInt2, jCMPInt);
                try {
                    if (this.compareToInitialized(jCMPInt) >= 0) {
                        jCMPInt3.setValueNoException(0);
                        throw new JSAFE_InputException("Cannot compute modExp, the base is larger than the modulus.");
                    }
                    int n3 = jCMPInt2.getBitLength() - 2;
                    if (n3 <= 0) {
                        this.modExpSpecialExponent(jCMPInt2, jCMPInt, jCMPInt3, n3);
                        Object var20_11 = null;
                        if (jCMPInt4 != null) {
                            jCMPInt4.clearSensitiveData();
                        }
                        if (jCMPIntArray != null) {
                            int n4 = 0;
                            while (n4 < jCMPIntArray.length) {
                                if (jCMPIntArray[n4] != null) {
                                    jCMPIntArray[n4].clearSensitiveData();
                                }
                                ++n4;
                            }
                        }
                        if (n == 0) return;
                        this.reobfuscateOperands(n, this, jCMPInt2, jCMPInt);
                        return;
                    }
                    int n5 = jCMPInt.computeMontCoefficient();
                    int n6 = this.getWindowSize(n3);
                    int n7 = 1 << n6 - 1;
                    jCMPIntArray = new JCMPInt[++n7];
                    jCMPIntArray[0] = new JCMPInt();
                    jCMPInt4 = new JCMPInt();
                    int n8 = jCMPInt.valueLen;
                    jCMPInt3.setVectorZero(2 * n8 + 1);
                    jCMPInt4.setVectorZero(2 * n8 + 1);
                    jCMPInt3.setValue(this);
                    jCMPInt3.shiftLeftByWords(n8);
                    jCMPInt3.divide(jCMPInt, jCMPInt4, jCMPIntArray[0]);
                    jCMPInt4.setValue(jCMPIntArray[0]);
                    boolean bl = false;
                    int[] nArray = new int[2];
                    do {
                        if (n6 > n3 + 1) {
                            n6 = n3 + 1;
                        }
                        jCMPInt2.getBitsAtIndex(n6, n3, nArray);
                        int n9 = nArray[0];
                        n3 -= n9;
                        if (bl) {
                            jCMPInt3.montSquare(jCMPInt, n5, jCMPInt4);
                            --n9;
                            bl = false;
                        }
                        while (n9 > 0) {
                            jCMPInt4.montSquare(jCMPInt, n5, jCMPInt3);
                            bl = true;
                            if (--n9 <= 0) break;
                            jCMPInt3.montSquare(jCMPInt, n5, jCMPInt4);
                            bl = false;
                            --n9;
                        }
                        int n10 = nArray[1];
                        if (n10 == 0) continue;
                        if (jCMPIntArray[n10 = n10 - 1 >>> 1] == null) {
                            this.generateNewExponent(jCMPInt, n5, n10, jCMPIntArray);
                        }
                        if (!bl) {
                            jCMPIntArray[n10].montMultiply(jCMPInt4, jCMPInt, n5, jCMPInt3);
                        } else {
                            jCMPIntArray[n10].montMultiply(jCMPInt3, jCMPInt, n5, jCMPInt4);
                        }
                        bl ^= true;
                    } while (n3 >= 0);
                    if (bl) {
                        JCMPInt.swapContents(jCMPInt4, jCMPInt3);
                    }
                    jCMPIntArray[0].setValueNoException(1);
                    jCMPIntArray[0].montMultiply(jCMPInt4, jCMPInt, n5, jCMPInt3);
                }
                catch (Throwable throwable2) {
                    Object var20_13 = null;
                    if (jCMPInt4 != null) {
                        jCMPInt4.clearSensitiveData();
                    }
                    if (jCMPIntArray == null) break block23;
                    n2 = 0;
                    break block24;
                }
                Object var20_12 = null;
                if (jCMPInt4 != null) {
                    jCMPInt4.clearSensitiveData();
                }
                if (jCMPIntArray != null) {
                    int n11 = 0;
                    while (n11 < jCMPIntArray.length) {
                        if (jCMPIntArray[n11] != null) {
                            jCMPIntArray[n11].clearSensitiveData();
                        }
                        ++n11;
                    }
                }
                if (n == 0) return;
                this.reobfuscateOperands(n, this, jCMPInt2, jCMPInt);
                return;
            }
            while (n2 < jCMPIntArray.length) {
                if (jCMPIntArray[n2] != null) {
                    jCMPIntArray[n2].clearSensitiveData();
                }
                ++n2;
            }
        }
        if (n == 0) throw throwable2;
        this.reobfuscateOperands(n, this, jCMPInt2, jCMPInt);
        throw throwable2;
    }

    private int getWindowSize(int n) {
        if (n >= 1018) {
            return 6;
        }
        if (n >= 380) {
            return 5;
        }
        if (n >= 78) {
            return 4;
        }
        if (n >= 17) {
            return 3;
        }
        return 2;
    }

    private void getBitsAtIndex(int n, int n2, int[] nArray) {
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        int n5 = 31 - n4;
        int n6 = this.value[n3];
        --n3;
        n6 <<= n5;
        ++n5;
        int n7 = 0;
        while ((n6 & Integer.MIN_VALUE) == 0) {
            ++n7;
            --n4;
            if (--n2 < 0) {
                nArray[0] = n7;
                nArray[1] = n6 >> 31;
                return;
            }
            if (n4 < 0) {
                n6 = this.value[n3];
                --n3;
                n4 = 31;
                continue;
            }
            n6 <<= 1;
        }
        if (n4 + 1 < n) {
            if (n3 >= 0) {
                int n8 = this.value[n3];
                n6 |= (n8 >>>= n4 + 1);
            } else {
                n = n4 + 1;
            }
        }
        n6 >>>= 32 - n;
        while ((n6 & 1) == 0) {
            n6 >>>= 1;
            --n;
        }
        nArray[0] = n7 + n;
        nArray[1] = n6;
    }

    private void generateNewExponent(JCMPInt jCMPInt, int n, int n2, JCMPInt[] jCMPIntArray) throws JSAFE_InputException {
        int n3 = jCMPIntArray.length - 1;
        if (jCMPIntArray[n3] == null) {
            jCMPIntArray[n3] = new JCMPInt();
            jCMPIntArray[0].montSquare(jCMPInt, n, jCMPIntArray[n3]);
        }
        if (jCMPIntArray[n2 - 1] == null) {
            this.generateNewExponent(jCMPInt, n, n2 - 1, jCMPIntArray);
        }
        jCMPIntArray[n2] = new JCMPInt();
        jCMPIntArray[n2 - 1].montMultiply(jCMPIntArray[n3], jCMPInt, n, jCMPIntArray[n2]);
    }

    /*
     * Unable to fully structure code
     */
    public void modExpCRT(int var1_1, JCMPInteger[] var2_2, JCMPInteger var3_3) throws JSAFE_InputException {
        block28: {
            block29: {
                var4_4 = var2_2.length;
                if (var4_4 != var1_1 * 3) {
                    throw new JSAFE_InputException("Invalid CRT data.");
                }
                var5_5 = new JCMPInt[var4_4];
                var6_6 = new JCMPInt[var1_1];
                var7_7 = new JCMPInt();
                var8_8 = new JCMPInt();
                var9_9 = new JCMPInt();
                var10_10 = new boolean[var4_4 + 1];
                try {
                    var11_11 = 0;
                    var12_13 = 0;
                    while (var11_11 < var4_4) {
                        var12_13 = var11_11;
                        if (var11_11 == 1) {
                            var12_13 = 2;
                        } else if (var11_11 == 2) {
                            var12_13 = 1;
                        } else if (var11_11 == var1_1 + 1) {
                            var12_13 = var1_1 + 2;
                        } else if (var11_11 == var1_1 + 2) {
                            var12_13 = var1_1 + 1;
                        }
                        var5_5[var12_13] = (JCMPInt)var2_2[var11_11];
                        if ((var5_5[var12_13].obfuscateFlag & 1) == 1) {
                            var10_10[var12_13] = true;
                            var10_10[var4_4] = true;
                            var5_5[var12_13].deobfuscate();
                        }
                        ++var11_11;
                    }
                    var13_14 = 0;
                    while (var13_14 < var1_1) {
                        var6_6[var13_14] = var13_14 == 0 ? (JCMPInt)var3_3 : new JCMPInt();
                        this.modReduce(var5_5[var13_14 + 1], var7_7);
                        var7_7.modExp(var5_5[var13_14 + var1_1 + 1], var5_5[var13_14 + 1], var6_6[var13_14]);
                        ++var13_14;
                    }
                    var9_9.setValue(var5_5[1]);
                    var14_15 = 1;
                    while (true) {
                        if ((var15_16 = var6_6[var14_15].subtractSigned(1, var6_6[0], 1, var7_7)) < 0) {
                            if (var6_6[var14_15].compareTo(var5_5[var14_15 + 1]) <= 0) {
                                var6_6[var14_15].subtractSigned(1, var5_5[var14_15 + 1], 1, var7_7);
                            } else {
                                var6_6[var14_15].divide(var5_5[var14_15 + 1], var7_7, var8_8);
                                var5_5[var14_15 + 1].subtract(var8_8, var6_6[var14_15]);
                            }
                        }
                        var6_6[var14_15].multiply(var5_5[var14_15 + 2 * var1_1], var7_7);
                        var7_7.divide(var5_5[var14_15 + 1], var8_8, var6_6[var14_15]);
                        var9_9.multiply(var6_6[var14_15], var7_7);
                        var6_6[0].addInPlace(var7_7);
                        if (var14_15 == var1_1 - 1) break;
                        var9_9.multiply(var5_5[var14_15 + 1], var7_7);
                        var9_9.setValue(var7_7);
                        ++var14_15;
                    }
                    var17_17 = null;
                }
                catch (Throwable var16_21) {
                    var17_18 = null;
                    if (!var10_10[var4_4]) break block29;
                    var18_20 = 0;
                    ** while (var18_20 < var4_4)
                }
                if (var10_10[var4_4]) {
                    var18_19 = 0;
                    while (var18_19 < var4_4) {
                        if (var10_10[var18_19]) {
                            var5_5[var18_19].obfuscate();
                        }
                        ++var18_19;
                    }
                }
                var18_19 = 1;
                while (var18_19 < var1_1) {
                    if (var6_6[var18_19] != null) {
                        var6_6[var18_19].clearSensitiveData();
                    }
                    ++var18_19;
                }
                {
                    break block28;
                    catch (ClassCastException var11_12) {
                        throw new JSAFE_InputException("Invalid JCMPInt input.");
                    }
                }
lbl-1000:
                // 1 sources

                {
                    if (var10_10[var18_20]) {
                        var5_5[var18_20].obfuscate();
                    }
                    ++var18_20;
                    continue;
                }
            }
            var18_20 = 1;
            while (var18_20 < var1_1) {
                if (var6_6[var18_20] != null) {
                    var6_6[var18_20].clearSensitiveData();
                }
                ++var18_20;
            }
            var7_7.clearSensitiveData();
            var8_8.clearSensitiveData();
            var9_9.clearSensitiveData();
            throw var16_21;
        }
        var7_7.clearSensitiveData();
        var8_8.clearSensitiveData();
        var9_9.clearSensitiveData();
    }

    private int computeMontCoefficient() throws JSAFE_InputException {
        long l = (long)this.value[0] & 0xFFFFFFFFL;
        if ((l & 1L) == 0L) {
            throw new JSAFE_InputException("Cannot find the Montgomery coefficient of an even number.");
        }
        long l2 = 1L;
        long l3 = 3L;
        long l4 = l3 & l;
        long l5 = 2L;
        if (l4 >= l5) {
            l2 += l5;
        }
        int n = 3;
        while (n <= 32) {
            l4 = l * l2 & (l3 |= (l5 <<= 1));
            if (l4 > l5) {
                l2 += l5;
            }
            ++n;
        }
        return (int)(-l2 & 0xFFFFFFFFL);
    }

    private void montMultiply(JCMPInt jCMPInt, JCMPInt jCMPInt2, int n, JCMPInt jCMPInt3) throws JSAFE_InputException {
        long l;
        int n2 = jCMPInt2.valueLen;
        jCMPInt3.setVectorZero(n2 * 2 + 1);
        int[] nArray = this.value;
        int[] nArray2 = jCMPInt.value;
        int[] nArray3 = jCMPInt2.value;
        int[] nArray4 = jCMPInt3.value;
        int n3 = jCMPInt.valueLen;
        int n4 = this.valueLen;
        long l2 = (long)nArray[0] & 0xFFFFFFFFL;
        long l3 = 0L;
        int n5 = 0;
        while (n5 < n3) {
            l = l2 * ((long)nArray2[n5] & 0xFFFFFFFFL) + l3;
            nArray4[n5] = (int)l;
            l3 = l >>> 32;
            ++n5;
        }
        nArray4[n5] = (int)l3;
        l2 = (long)(nArray4[0] * n) & 0xFFFFFFFFL;
        int n6 = 0;
        l3 = 0L;
        int n7 = 0;
        while (n7 < n2) {
            l = l2 * ((long)nArray3[n7] & 0xFFFFFFFFL) + ((long)nArray4[n6] & 0xFFFFFFFFL) + l3;
            nArray4[n6] = (int)l;
            l3 = l >>> 32;
            ++n7;
            ++n6;
        }
        nArray4[n6] = (int)(l3 += (long)nArray4[n6] & 0xFFFFFFFFL);
        if ((l3 >>>= 32) != 0L) {
            int n8 = n6 + 1;
            nArray4[n8] = nArray4[n8] + 1;
            if (nArray4[n6 + 1] == 0) {
                jCMPInt3.valueLen = n6 + 2;
                jCMPInt3.propagateCarry(n6 + 2);
            }
        }
        int n9 = 1;
        while (n9 < n4) {
            l2 = (long)nArray[n9] & 0xFFFFFFFFL;
            n6 = n9;
            l3 = 0L;
            n5 = 0;
            while (n5 < n3) {
                l = l2 * ((long)nArray2[n5] & 0xFFFFFFFFL) + ((long)nArray4[n6] & 0xFFFFFFFFL) + l3;
                nArray4[n6] = (int)l;
                l3 = l >>> 32;
                ++n5;
                ++n6;
            }
            nArray4[n6] = (int)(l3 += (long)nArray4[n6] & 0xFFFFFFFFL);
            if ((l3 >>>= 32) != 0L) {
                int n10 = n6 + 1;
                nArray4[n10] = nArray4[n10] + 1;
                if (nArray4[n6 + 1] == 0) {
                    jCMPInt3.valueLen = n6 + 2;
                    jCMPInt3.propagateCarry(n6 + 2);
                }
            }
            l2 = (long)(nArray4[n9] * n) & 0xFFFFFFFFL;
            n6 = n9;
            l3 = 0L;
            n7 = 0;
            while (n7 < n2) {
                l = l2 * ((long)nArray3[n7] & 0xFFFFFFFFL) + ((long)nArray4[n6] & 0xFFFFFFFFL) + l3;
                nArray4[n6] = (int)l;
                l3 = l >>> 32;
                ++n7;
                ++n6;
            }
            nArray4[n6] = (int)(l3 += (long)nArray4[n6] & 0xFFFFFFFFL);
            if ((l3 >>>= 32) != 0L) {
                int n11 = n6 + 1;
                nArray4[n11] = nArray4[n11] + 1;
                if (nArray4[n6 + 1] == 0) {
                    jCMPInt3.valueLen = n6 + 2;
                    jCMPInt3.propagateCarry(n6 + 2);
                }
            }
            ++n9;
        }
        while (n9 < n2) {
            l2 = (long)(nArray4[n9] * n) & 0xFFFFFFFFL;
            n6 = n9;
            l3 = 0L;
            n7 = 0;
            while (n7 < n2) {
                l = l2 * ((long)nArray3[n7] & 0xFFFFFFFFL) + ((long)nArray4[n6] & 0xFFFFFFFFL) + l3;
                nArray4[n6] = (int)l;
                l3 = l >>> 32;
                ++n7;
                ++n6;
            }
            nArray4[n6] = (int)(l3 += (long)nArray4[n6] & 0xFFFFFFFFL);
            if ((l3 >>>= 32) != 0L) {
                int n12 = n6 + 1;
                nArray4[n12] = nArray4[n12] + 1;
                if (nArray4[n6 + 1] == 0) {
                    jCMPInt3.valueLen = n6 + 2;
                    jCMPInt3.propagateCarry(n6 + 2);
                }
            }
            ++n9;
        }
        jCMPInt3.valueLen = n2 * 2 + 1;
        jCMPInt3.normalize();
        jCMPInt3.shiftRightByWords(n2);
        jCMPInt3.normalize();
        if (jCMPInt3.compareTo(jCMPInt2) >= 0) {
            jCMPInt3.subtractInPlace(jCMPInt2);
        }
    }

    private void montSquare(JCMPInt jCMPInt, int n, JCMPInt jCMPInt2) throws JSAFE_InputException {
        int n2;
        long l;
        int n3 = jCMPInt.valueLen;
        jCMPInt2.setVectorZero(n3 * 2 + 1);
        int[] nArray = this.value;
        int[] nArray2 = jCMPInt.value;
        int[] nArray3 = jCMPInt2.value;
        int n4 = this.valueLen;
        long l2 = (long)nArray[0] & 0xFFFFFFFFL;
        long l3 = 0L;
        int n5 = 1;
        while (n5 < n4) {
            l = l2 * ((long)nArray[n5] & 0xFFFFFFFFL) + l3;
            nArray3[n5] = (int)l;
            l3 = l >>> 32;
            ++n5;
        }
        nArray3[n5] = (int)l3;
        int n6 = 1;
        while (n6 < n4 - 1) {
            l2 = (long)nArray[n6] & 0xFFFFFFFFL;
            l3 = 0L;
            n2 = 2 * n6 + 1;
            n5 = n6 + 1;
            while (n5 < n4) {
                l = l2 * ((long)nArray[n5] & 0xFFFFFFFFL) + ((long)nArray3[n2] & 0xFFFFFFFFL) + l3;
                nArray3[n2] = (int)l;
                l3 = l >>> 32;
                ++n5;
                ++n2;
            }
            nArray3[n2] = (int)(l3 += (long)nArray3[n2] & 0xFFFFFFFFL);
            if ((l3 >>>= 32) != 0L) {
                int n7 = n2 + 1;
                nArray3[n7] = nArray3[n7] + 1;
                if (nArray3[n2 + 1] == 0) {
                    jCMPInt2.valueLen = n2 + 2;
                    jCMPInt2.propagateCarry(n2 + 2);
                }
            }
            ++n6;
        }
        jCMPInt2.valueLen = n3 * 2 + 1;
        jCMPInt2.normalize();
        jCMPInt2.shiftLeftByBits(1);
        jCMPInt2.normalize();
        this.addInTrace(jCMPInt2);
        n6 = 0;
        while (n6 < n3) {
            l2 = (long)(nArray3[n6] * n) & 0xFFFFFFFFL;
            n2 = n6;
            l3 = 0L;
            int n8 = 0;
            while (n8 < n3) {
                l = l2 * ((long)nArray2[n8] & 0xFFFFFFFFL) + ((long)nArray3[n2] & 0xFFFFFFFFL) + l3;
                nArray3[n2] = (int)l;
                l3 = l >>> 32;
                ++n8;
                ++n2;
            }
            nArray3[n2] = (int)(l3 += (long)nArray3[n2] & 0xFFFFFFFFL);
            if ((l3 >>>= 32) != 0L) {
                int n9 = n2 + 1;
                nArray3[n9] = nArray3[n9] + 1;
                if (nArray3[n2 + 1] == 0) {
                    jCMPInt2.valueLen = n2 + 2;
                    jCMPInt2.propagateCarry(n2 + 2);
                }
            }
            ++n6;
        }
        jCMPInt2.valueLen = n3 * 2 + 1;
        jCMPInt2.normalize();
        jCMPInt2.shiftRightByWords(n3);
        jCMPInt2.normalize();
        if (jCMPInt2.compareTo(jCMPInt) >= 0) {
            jCMPInt2.subtractInPlace(jCMPInt);
        }
    }

    private void addInTrace(JCMPInt jCMPInt) {
        long l;
        long l2;
        int n = this.valueLen;
        long l3 = 0L;
        int[] nArray = jCMPInt.value;
        int[] nArray2 = this.value;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            l2 = (long)nArray2[n2] & 0xFFFFFFFFL;
            l2 *= l2;
            l = l2 >>> 32;
            nArray[n3] = (int)(l3 += (l2 &= 0xFFFFFFFFL) + ((long)nArray[n3] & 0xFFFFFFFFL));
            l3 >>>= 32;
            nArray[n3 + 1] = (int)(l3 += l + ((long)nArray[n3 + 1] & 0xFFFFFFFFL));
            l3 >>>= 32;
            ++n2;
            n3 += 2;
        }
        if (n3 > jCMPInt.valueLen) {
            jCMPInt.valueLen = n3;
        }
        if (l3 != 0L) {
            jCMPInt.propagateCarry(n3);
        }
        l = 0L;
        l2 = 0L;
    }

    public boolean buildPrime(JCMPInteger jCMPInteger, SecureRandom secureRandom) throws JSAFE_InputException {
        if (this.valueLen == 0) {
            throw new JSAFE_InputException("Cannot build a prime, the JCMPInt is not set.");
        }
        int n = this.getBitLength();
        if (n < 101 || n > 2048) {
            throw new JSAFE_InputException("Cannot build a prime, the length is inappropriate.");
        }
        this.value[0] = this.value[0] | 1;
        return JA_Prime.findPrime(this, null, null, jCMPInteger, 0, secureRandom);
    }

    public boolean generatePrime(int n, JCMPInteger jCMPInteger, int n2, boolean bl, SecureRandom secureRandom) throws JSAFE_InputException {
        if (n <= 9) {
            throw new JSAFE_InputException("Cannot generate a prime of length <= 9");
        }
        JCMPInt jCMPInt = null;
        JCMPInt jCMPInt2 = null;
        int n3 = (n + 7) / 8;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n4 = 16;
        int n5 = 31;
        if (bl) {
            byArray2 = new byte[13];
            byArray3 = new byte[13];
        }
        int n6 = 128;
        int n7 = 0;
        int n8 = n % 8;
        if (!bl) {
            n6 = 192;
            if (n8 == 1) {
                n7 = 128;
            }
            if (n8 != 0) {
                n8 = 8 - n8;
            }
            n6 >>>= n8;
        }
        int n9 = 255 >>> n8;
        if (bl) {
            secureRandom.nextBytes(byArray2);
            secureRandom.nextBytes(byArray3);
            byArray2[0] = (byte)(byArray2[0] & n5);
            byArray2[0] = (byte)(byArray2[0] | n4);
            byArray2[12] = (byte)(byArray2[12] | 1);
            byArray3[0] = (byte)(byArray3[0] & n5);
            byArray3[0] = (byte)(byArray3[0] | n4);
            byArray3[12] = (byte)(byArray3[12] | 1);
        }
        secureRandom.nextBytes(byArray);
        byArray[0] = (byte)(byArray[0] & n9);
        byArray[0] = (byte)(byArray[0] | n6);
        byArray[1] = (byte)(byArray[1] | n7);
        int n10 = n3 - 1;
        byArray[n10] = (byte)(byArray[n10] | 1);
        if (bl) {
            int[] nArray = new int[]{181, 4, 243, 51};
            int n11 = 0;
            while (n11 < 4) {
                if ((byArray[n11] & 0xFF) > nArray[n11]) break;
                if ((byArray[n11] & 0xFF) < nArray[n11]) {
                    return false;
                }
                ++n11;
            }
            jCMPInt = new JCMPInt();
            jCMPInt2 = new JCMPInt();
            jCMPInt.setValue(byArray2, 0, byArray2.length);
            jCMPInt2.setValue(byArray3, 0, byArray3.length);
            JSAFE_Obfuscator.overwrite(byArray2);
            JSAFE_Obfuscator.overwrite(byArray3);
            if (!jCMPInt.buildPrime(jCMPInteger, secureRandom) || !jCMPInt2.buildPrime(jCMPInteger, secureRandom)) {
                jCMPInt.clearSensitiveData();
                jCMPInt2.clearSensitiveData();
                return false;
            }
        }
        this.setValue(byArray, 0, n3);
        JSAFE_Obfuscator.overwrite(byArray);
        boolean bl2 = JA_Prime.findPrime(this, jCMPInt, jCMPInt2, jCMPInteger, n2, secureRandom);
        if (jCMPInt != null) {
            jCMPInt.clearSensitiveData();
        }
        if (jCMPInt2 != null) {
            jCMPInt2.clearSensitiveData();
        }
        return bl2;
    }

    public void shiftLeftByBits(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        if (n2 != 0) {
            this.shiftLeftByWords(n2);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.valueLen - 2;
        int n5 = 32 - n3;
        int n6 = this.value[this.valueLen - 1] >>> n5;
        int n7 = this.valueLen - 1;
        this.value[n7] = this.value[n7] << n3;
        if (n6 != 0) {
            int[] nArray = new int[]{n6};
            this.expandValue(nArray, 0, 1);
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 <= n4) {
            n6 = this.value[n9] << n3 | n8;
            n8 = this.value[n9] >>> n5;
            this.value[n9] = n6;
            ++n9;
        }
        int n10 = n9;
        this.value[n10] = this.value[n10] | n8;
        n6 = 0;
        n8 = 0;
        this.normalize();
    }

    public void shiftLeftByWords(int n) {
        if (n <= 0) {
            return;
        }
        if (this.value.length < this.valueLen + n) {
            int[] nArray = new int[this.value.length + n];
            System.arraycopy(this.value, 0, nArray, n, this.valueLen);
            this.value = nArray;
            this.valueLen += n;
            this.normalize();
            return;
        }
        int n2 = this.valueLen - 1;
        while (n2 >= 0) {
            this.value[n2 + n] = this.value[n2];
            --n2;
        }
        int n3 = 0;
        while (n3 < n) {
            this.value[n3] = 0;
            ++n3;
        }
        this.valueLen += n;
        this.normalize();
    }

    public void shiftRightByBits(int n) {
        int n2;
        if (n <= 0) {
            return;
        }
        int n3 = n >>> 5;
        int n4 = n & 0x1F;
        if (n3 != 0) {
            this.shiftRightByWords(n3);
        }
        if (n4 == 0) {
            return;
        }
        int n5 = 32 - n4;
        int n6 = 0;
        int n7 = this.valueLen - 1;
        while (n7 >= 0) {
            n2 = this.value[n7] << n5;
            this.value[n7] = this.value[n7] >>> n4;
            int n8 = n7--;
            this.value[n8] = this.value[n8] | n6;
            n6 = n2;
        }
        n2 = 0;
        n6 = 0;
        this.normalize();
    }

    public void shiftRightByWords(int n) {
        if (n <= 0) {
            return;
        }
        if (n >= this.valueLen) {
            this.value[0] = 0;
            this.valueLen = 1;
            return;
        }
        int n2 = 0;
        while (n2 < this.valueLen - n) {
            this.value[n2] = this.value[n2 + n];
            ++n2;
        }
        this.valueLen -= n;
        this.normalize();
    }

    private void propagateCarry(int n) {
        while (n < this.valueLen) {
            long l = ((long)this.value[n] & 0xFFFFFFFFL) + 1L;
            this.value[n] = (int)l;
            if (l >>> 32 == 0L) {
                return;
            }
            ++n;
        }
        int[] nArray = new int[]{1};
        this.expandValue(nArray, 0, 1);
    }

    /*
     * Unable to fully structure code
     */
    private void propagateBorrow(int var1_1) throws JSAFE_InputException {
        if (var1_1 < this.valueLen) ** GOTO lbl10
        throw new JSAFE_InputException("JCMPInt operation yields negative result.");
lbl-1000:
        // 1 sources

        {
            var2_2 = (long)this.value[var1_1] & 0xFFFFFFFFL;
            this.value[var1_1] = (int)(var2_2 - 1L);
            if (var2_2 >>> 32 == 0L) {
                if (this.value[var1_1] == 0 && var1_1 == this.valueLen - 1) {
                    --this.valueLen;
                }
                return;
            }
            ++var1_1;
lbl10:
            // 2 sources

            ** while (var1_1 < this.valueLen)
        }
lbl11:
        // 1 sources

        throw new JSAFE_InputException("JCMPInt operation yields negative result.");
    }

    private void normalize() {
        if (this.value == null) {
            this.valueLen = 0;
            return;
        }
        int n = this.valueLen - 1;
        while (n > 0) {
            if (this.value[n] != 0) break;
            --this.valueLen;
            --n;
        }
    }

    private void expandValue(int[] nArray, int n, int n2) {
        if (this.value == null) {
            this.value = new int[n2];
        }
        if (this.value.length < this.valueLen + n2) {
            int[] nArray2 = new int[this.valueLen + n2];
            int n3 = this.valueLen;
            System.arraycopy(this.value, 0, nArray2, 0, this.valueLen);
            this.clearSensitiveData();
            this.value = nArray2;
            this.valueLen = n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            this.value[this.valueLen + n4] = nArray[n4 + n];
            ++n4;
        }
        this.valueLen += n2;
        this.normalize();
    }

    private int initializeValues(JCMPInt jCMPInt, JCMPInt jCMPInt2, JCMPInt jCMPInt3) {
        int n = 0;
        if (jCMPInt.valueLen == 0) {
            jCMPInt.setValueNoException(0);
        }
        if ((jCMPInt.obfuscateFlag & 1) != 0) {
            n |= 1;
            jCMPInt.deobfuscate();
        }
        if (jCMPInt2.valueLen == 0) {
            jCMPInt2.setValueNoException(0);
        }
        if ((jCMPInt2.obfuscateFlag & 1) != 0) {
            n |= 2;
            jCMPInt2.deobfuscate();
        }
        if (jCMPInt3 != null) {
            if (jCMPInt3.valueLen == 0) {
                jCMPInt3.setValueNoException(0);
            }
            if ((jCMPInt3.obfuscateFlag & 1) != 0) {
                n |= 2;
                jCMPInt3.deobfuscate();
            }
        }
        return n;
    }

    private void reobfuscateOperands(int n, JCMPInt jCMPInt, JCMPInt jCMPInt2, JCMPInt jCMPInt3) {
        if ((n & 1) == 1) {
            jCMPInt.obfuscate();
        }
        if ((n & 2) == 1) {
            jCMPInt2.obfuscate();
        }
        if ((n & 4) == 1) {
            jCMPInt3.obfuscate();
        }
    }

    public void obfuscate() {
        if ((this.obfuscateFlag & 2) != 0) {
            return;
        }
        if (this.valueOI != null) {
            this.valueOI.obfuscate();
            this.obfuscateFlag = 1;
            return;
        }
        if (this.valueLen == 0) {
            this.setValueNoException(0);
        }
        this.valueOI = JSAFE_Obfuscator.register(this.value);
        this.obfuscateFlag = !this.valueOI.getPower() ? 2 : 1;
    }

    public void deobfuscate() {
        if ((this.obfuscateFlag & 1) != 0) {
            this.valueOI.deobfuscate();
            this.obfuscateFlag = 4;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        if ((this.obfuscateFlag & 1) == 0) {
            return;
        }
        this.deobfuscate();
        this.obfuscateFlag = 1;
    }

    private void restoreAfterSerialization() {
        if (this.obfuscateFlag == 1) {
            this.obfuscateFlag = 4;
            this.obfuscate();
        }
    }

    private void restoreAfterDeserialization() {
        if (this.obfuscateFlag == 1) {
            this.obfuscateFlag = 0;
            this.obfuscate();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JCMPInt jCMPInt = new JCMPInt();
        jCMPInt.setValue(this);
        if (this.obfuscateFlag == 1) {
            jCMPInt.obfuscate();
        }
        return jCMPInt;
    }

    private void resetVariables() {
        this.valueLen = 0;
        if (this.valueOI == null) {
            return;
        }
        this.valueOI.overwrite();
        this.obfuscateFlag = 4;
    }

    public void clearSensitiveData() {
        JSAFE_Obfuscator.deregisterOrOverwrite(this.value, this.valueOI);
        this.valueOI = null;
        this.value = null;
        this.valueLen = 0;
        this.obfuscateFlag = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

