/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeAsymmetricCipher;
import com.rsa.jsafe.JA_AsymmetricPaddingScheme;
import com.rsa.jsafe.JA_OAEPPaddingScheme;
import com.rsa.jsafe.JA_PKCS8;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class JG_AsymmetricCipher
extends JSAFE_AsymmetricCipher
implements Cloneable,
Serializable {
    private JA_AlgaeAsymmetricCipher algaeAsymmetricCipher;
    private JA_AsymmetricPaddingScheme paddingScheme;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private int inputBlockSize;
    private int outputBlockSize;
    private int maxInputLen;
    private byte[] unprocessedData;
    private int unprocessedDataLen;
    private int objectState;
    private static final int NOT_INITIALIZED = 1;
    private static final int ENCRYPT_INIT = 2;
    private static final int ENCRYPT_UPDATE = 3;
    private static final int ENCRYPT_FINAL = 4;
    private static final int DECRYPT_INIT = 5;
    private static final int DECRYPT_UPDATE = 6;
    private static final int DECRYPT_FINAL = 7;
    private static final int UNLIMITED_DATA = -1;

    JG_AsymmetricCipher(JA_AlgaeAsymmetricCipher jA_AlgaeAsymmetricCipher, JA_AsymmetricPaddingScheme jA_AsymmetricPaddingScheme) {
        this.algaeAsymmetricCipher = jA_AlgaeAsymmetricCipher;
        this.paddingScheme = jA_AsymmetricPaddingScheme;
        this.objectState = 1;
    }

    private JG_AsymmetricCipher() {
    }

    public void setOAEPParameters(byte[] byArray, int n, int n2) {
        if (this.paddingScheme instanceof JA_OAEPPaddingScheme) {
            ((JA_OAEPPaddingScheme)this.paddingScheme).setOAEPParameters(byArray, n, n2);
        }
    }

    public byte[] getOAEPParameters() {
        if (this.paddingScheme instanceof JA_OAEPPaddingScheme) {
            return ((JA_OAEPPaddingScheme)this.paddingScheme).getOAEPParameters();
        }
        return null;
    }

    public String getEncryptionAlgorithm() {
        return this.algaeAsymmetricCipher.getAlgorithm();
    }

    protected void setAlgBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        this.algaeAsymmetricCipher.setAlgorithmBER(byArray, n);
    }

    public byte[] getDERAlgID() throws JSAFE_UnimplementedException {
        return this.algaeAsymmetricCipher.getDERAlgorithmID(this.paddingScheme);
    }

    public String getPaddingScheme() {
        return this.paddingScheme.getPaddingScheme();
    }

    public String getOAEPDigestAlgorithm() {
        if (this.paddingScheme instanceof JA_OAEPPaddingScheme) {
            return ((JA_OAEPPaddingScheme)this.paddingScheme).getDigest();
        }
        return null;
    }

    public String getOAEPMaskGeneratingFunction() {
        if (this.paddingScheme instanceof JA_OAEPPaddingScheme) {
            return ((JA_OAEPPaddingScheme)this.paddingScheme).getMGF();
        }
        return null;
    }

    public String getOAEPMaskUnderlyingAlgorithm() {
        if (this.paddingScheme instanceof JA_OAEPPaddingScheme) {
            return ((JA_OAEPPaddingScheme)this.paddingScheme).getMGFAlg();
        }
        return null;
    }

    public String getOAEPParameterSource() {
        if (this.paddingScheme instanceof JA_OAEPPaddingScheme) {
            return ((JA_OAEPPaddingScheme)this.paddingScheme).getParamSource();
        }
        return null;
    }

    protected int doGetMaxInputLen() {
        return this.algaeAsymmetricCipher.getMaxInputLen(this.paddingScheme);
    }

    protected int doGetInputBlockSize() {
        return this.inputBlockSize;
    }

    protected int doGetOutputBlockSize() {
        return this.outputBlockSize;
    }

    public int[] getAlgorithmParameters() {
        return this.algaeAsymmetricCipher.getInstantiationParameters();
    }

    protected int doGetOutputBufferSize(int n) {
        int n2 = n + this.unprocessedDataLen;
        return n2 + this.paddingScheme.getPadLength(n2, this.inputBlockSize);
    }

    protected String doEncryptInit(JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray, int[] nArray) {
        nArray[0] = 3;
        switch (this.objectState) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                if (secureRandom != null) {
                    this.random = secureRandom;
                }
                if (this.paddingScheme.needRandom() && this.random == null) {
                    return "This operation needs a random object.";
                }
                nArray[0] = 1;
                String string = this.algaeAsymmetricCipher.encryptInit(jSAFE_PublicKey, this.paddingScheme, secureRandom, jSAFE_SessionArray);
                if (string != null) {
                    return string;
                }
                this.algaeAsymmetricCipher.obfuscate();
                this.inputBlockSize = this.algaeAsymmetricCipher.getEncryptInputBlockSize();
                this.outputBlockSize = this.algaeAsymmetricCipher.getEncryptOutputBlockSize();
                this.unprocessedData = new byte[this.inputBlockSize];
                this.maxInputLen = this.paddingScheme.getMaxInputLen(this.inputBlockSize);
                this.unprocessedDataLen = 0;
                this.objectState = 2;
                return null;
            }
        }
        return "Object already initialized.";
    }

    protected void doEncryptReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: 
            case 4: {
                this.unprocessedDataLen = 0;
                this.objectState = 2;
                return;
            }
            case 5: 
            case 6: 
            case 7: {
                throw new JSAFE_InvalidUseException("Object initialized for decryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    protected byte[] doWrapSecretKey(JSAFE_SecretKey jSAFE_SecretKey, boolean bl) throws JSAFE_InvalidUseException {
        byte[] byArray;
        if (this.objectState != 2) {
            throw new JSAFE_InvalidUseException("Cannot wrap key, object needs new initialization.");
        }
        byte[] byArray2 = null;
        int n = 0;
        if (bl) {
            try {
                byArray2 = this.getDERAlgorithmID();
                if (byArray2 == null) {
                    throw new JSAFE_InvalidUseException("Cannot wrap the given key into a BER.");
                }
                n = byArray2.length;
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidUseException("Cannot wrap the given key into a BER.");
            }
        }
        byte[] byArray3 = null;
        int n2 = 0;
        if (this.algaeAsymmetricCipher.canWrapKey(bl)) {
            byArray3 = this.algaeAsymmetricCipher.wrapSecretKey(jSAFE_SecretKey, bl, this.paddingScheme);
            n2 = byArray3.length;
            this.objectState = 4;
        } else {
            byArray = null;
            try {
                try {
                    String string = jSAFE_SecretKey.getKeyWrappingFormat(bl);
                    byArray = jSAFE_SecretKey.getSecretKeyData(string);
                    n2 = this.getOutputBufferSize(byArray.length);
                    byArray3 = new byte[n2];
                    n2 = this.encryptUpdate(byArray, 0, byArray.length, byArray3, 0);
                    n2 += this.encryptFinal(byArray3, n2);
                }
                catch (JSAFE_InputException jSAFE_InputException) {
                    throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
                }
                catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                    throw new JSAFE_InvalidUseException(jSAFE_UnimplementedException.getMessage());
                }
                catch (JSAFE_PaddingException jSAFE_PaddingException) {
                    throw new JSAFE_InvalidUseException(jSAFE_PaddingException.getMessage());
                }
                Object var12_11 = null;
                if (byArray != null) {
                    this.overwrite(byArray);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (byArray != null) {
                    this.overwrite(byArray);
                }
                throw throwable;
            }
        }
        if (!bl) {
            if (n2 == byArray3.length) {
                return byArray3;
            }
            byArray = new byte[n2];
            System.arraycopy(byArray3, 0, byArray, 0, n2);
            return byArray;
        }
        return JA_PKCS8.buildEncryptedKeyInfo(byArray2, 0, n, byArray3, 0, n2);
    }

    protected int doEncryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException, JSAFE_InputException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                int n4;
                int n5;
                if (n2 <= 0) {
                    this.objectState = 3;
                    return 0;
                }
                int n6 = 0;
                int n7 = this.unprocessedDataLen + n2;
                if (this.maxInputLen != -1 && n7 > this.maxInputLen) {
                    throw new JSAFE_InputException("Invalid Input Length");
                }
                if (this.unprocessedDataLen != 0) {
                    if (n7 < this.inputBlockSize) {
                        int n8 = this.unprocessedDataLen;
                        while (n8 < n7) {
                            this.unprocessedData[n8] = byArray[n];
                            ++n8;
                            ++n;
                        }
                        this.unprocessedDataLen = n7;
                        this.objectState = 3;
                        return 0;
                    }
                    n5 = this.unprocessedDataLen;
                    while (n5 < this.inputBlockSize) {
                        this.unprocessedData[n5] = byArray[n];
                        ++n5;
                        ++n;
                    }
                    if (!this.algaeAsymmetricCipher.isValidInputBlock(this.unprocessedData, 0)) {
                        throw new JSAFE_InputException("Invalid Input Data");
                    }
                    this.algaeAsymmetricCipher.deobfuscate();
                    n4 = this.algaeAsymmetricCipher.encryptBlock(this.unprocessedData, 0, byArray2, n3);
                    n6 += n4;
                    if (n4 == 0) {
                        throw new JSAFE_InvalidUseException("Could not perform RSA operation.");
                    }
                    n3 += this.outputBlockSize;
                    n7 -= this.inputBlockSize;
                    this.unprocessedDataLen = 0;
                }
                while (n7 >= this.inputBlockSize) {
                    if (!this.algaeAsymmetricCipher.isValidInputBlock(byArray, n)) {
                        throw new JSAFE_InputException("Invalid Input Data");
                    }
                    this.algaeAsymmetricCipher.deobfuscate();
                    n4 = this.algaeAsymmetricCipher.encryptBlock(byArray, n, byArray2, n3);
                    n6 += n4;
                    if (n4 == 0) {
                        throw new JSAFE_InvalidUseException("Could not perform RSA operation.");
                    }
                    n += this.inputBlockSize;
                    n3 += this.outputBlockSize;
                    n7 -= this.inputBlockSize;
                }
                this.algaeAsymmetricCipher.obfuscate();
                this.unprocessedDataLen = n7;
                if (this.unprocessedDataLen > 0) {
                    n5 = 0;
                    while (n5 < this.unprocessedDataLen) {
                        this.unprocessedData[n5] = byArray[n];
                        ++n5;
                        ++n;
                    }
                }
                this.objectState = 3;
                return n6;
            }
            case 5: 
            case 6: 
            case 7: {
                throw new JSAFE_InvalidUseException("Object initialized for decrypt");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized");
    }

    protected int doEncryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                int n2 = this.paddingScheme.performPadding(this.unprocessedData, 0, this.unprocessedDataLen, this.inputBlockSize, null, this.random);
                this.unprocessedDataLen += n2;
                if (this.unprocessedDataLen == 0) {
                    this.objectState = 4;
                    return 0;
                }
                if (this.unprocessedDataLen != this.inputBlockSize) {
                    throw new JSAFE_InputException("Invalid input length for encryption. Length should be multiple of " + this.inputBlockSize + " - Block Size.");
                }
                if (!this.algaeAsymmetricCipher.isValidInputBlock(this.unprocessedData, 0)) {
                    throw new JSAFE_InputException("Invalid input.");
                }
                this.algaeAsymmetricCipher.deobfuscate();
                int n3 = this.algaeAsymmetricCipher.encryptBlock(this.unprocessedData, 0, byArray, n);
                if (n3 == 0) {
                    throw new JSAFE_InvalidUseException("Could not perform RSA operation.");
                }
                this.unprocessedDataLen = 0;
                this.algaeAsymmetricCipher.obfuscate();
                this.objectState = 4;
                return n3;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for decryption");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized");
    }

    public String doDecryptInit(JSAFE_PrivateKey jSAFE_PrivateKey, JSAFE_Session[] jSAFE_SessionArray, int[] nArray) {
        nArray[0] = 3;
        switch (this.objectState) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                nArray[0] = 1;
                String string = this.algaeAsymmetricCipher.decryptInit(jSAFE_PrivateKey, this.paddingScheme, null, jSAFE_SessionArray);
                if (string != null) {
                    return string;
                }
                this.algaeAsymmetricCipher.obfuscate();
                this.inputBlockSize = this.algaeAsymmetricCipher.getDecryptInputBlockSize();
                this.outputBlockSize = this.algaeAsymmetricCipher.getDecryptOutputBlockSize();
                this.unprocessedData = new byte[this.inputBlockSize];
                this.maxInputLen = this.paddingScheme.getMaxInputLen(this.inputBlockSize);
                if (this.maxInputLen != -1) {
                    this.maxInputLen = this.inputBlockSize;
                }
                this.unprocessedDataLen = 0;
                this.objectState = 5;
                return null;
            }
        }
        return "Object already initialized.";
    }

    protected void doDecryptReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: 
            case 7: {
                this.unprocessedDataLen = 0;
                this.objectState = 5;
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                throw new JSAFE_InvalidUseException("Object initialized for encryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public JSAFE_SecretKey doUnwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, String string, String string2) throws JSAFE_InvalidUseException {
        Object[] objectArray;
        if (this.objectState != 5) {
            throw new JSAFE_InvalidUseException("Cannot unwrap key, object needs new initialization.");
        }
        if (string2 == null) {
            string2 = this.getDevice();
        }
        if (bl) {
            objectArray = JA_PKCS8.getEncryptedKeyInfo(byArray, n);
            n = objectArray[0];
            n2 = objectArray[1];
        }
        if (this.algaeAsymmetricCipher.canWrapKey(bl)) {
            this.objectState = 4;
            return this.algaeAsymmetricCipher.unwrapSecretKey(byArray, n, n2, bl, this.paddingScheme, string2);
        }
        objectArray = null;
        try {
            try {
                objectArray = new byte[this.getOutputBufferSize(n2)];
                int n3 = this.decryptUpdate(byArray, n, n2, (byte[])objectArray, 0);
                n3 += this.decryptFinal((byte[])objectArray, n3);
                JSAFE_SecretKey jSAFE_SecretKey = null;
                if (bl) {
                    jSAFE_SecretKey = JSAFE_SecretKey.getInstance((byte[])objectArray, 0, string2);
                } else {
                    jSAFE_SecretKey = JSAFE_SecretKey.getInstance(string, string2);
                    jSAFE_SecretKey.setSecretKeyData((byte[])objectArray, 0, n3);
                }
                JSAFE_SecretKey jSAFE_SecretKey2 = jSAFE_SecretKey;
                Object var13_14 = null;
                if (objectArray != null) {
                    this.overwrite((byte[])objectArray);
                }
                return jSAFE_SecretKey2;
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidUseException("Could not unwrap secret key.");
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_InvalidUseException(jSAFE_InvalidKeyException.getMessage());
            }
            catch (JSAFE_InputException jSAFE_InputException) {
                throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
            }
            catch (JSAFE_PaddingException jSAFE_PaddingException) {
                throw new JSAFE_InvalidUseException(jSAFE_PaddingException.getMessage());
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var13_15 = null;
                if (objectArray == null) break block14;
                this.overwrite((byte[])objectArray);
            }
            throw throwable;
        }
    }

    public int doDecryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException, JSAFE_InputException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                int n4;
                int n5;
                if (n2 <= 0) {
                    this.objectState = 6;
                    return 0;
                }
                int n6 = 0;
                int n7 = n2 + this.unprocessedDataLen;
                int n8 = this.inputBlockSize - this.unprocessedDataLen;
                if (this.maxInputLen != -1 && n7 > this.maxInputLen) {
                    throw new JSAFE_InputException("Invalid input Length.");
                }
                int n9 = n5 = this.paddingScheme.getPadLength(0, this.inputBlockSize) == 0 ? this.inputBlockSize - 1 : this.inputBlockSize;
                if (n8 == this.inputBlockSize) {
                    if (n7 <= n5) {
                        int n10 = 0;
                        while (n10 < n7) {
                            this.unprocessedData[n10] = byArray[n];
                            ++n10;
                            ++n;
                        }
                        this.unprocessedDataLen = n7;
                        this.objectState = 6;
                        return 0;
                    }
                } else if (n8 == 0) {
                    this.algaeAsymmetricCipher.deobfuscate();
                    n6 += this.algaeAsymmetricCipher.decryptBlock(this.unprocessedData, 0, byArray2, n3);
                    n3 += this.outputBlockSize;
                    n7 -= this.inputBlockSize;
                    this.unprocessedDataLen = 0;
                } else {
                    if (n7 <= n5) {
                        int n11 = this.unprocessedDataLen;
                        while (n11 < n7) {
                            this.unprocessedData[n11] = byArray[n];
                            ++n11;
                            ++n;
                        }
                        this.unprocessedDataLen = n7;
                        this.objectState = 6;
                        return 0;
                    }
                    n4 = this.unprocessedDataLen;
                    while (n4 < this.inputBlockSize) {
                        this.unprocessedData[n4] = byArray[n];
                        ++n4;
                        ++n;
                    }
                    this.algaeAsymmetricCipher.deobfuscate();
                    n6 += this.algaeAsymmetricCipher.decryptBlock(this.unprocessedData, 0, byArray2, n3);
                    n3 += this.outputBlockSize;
                    n7 -= this.inputBlockSize;
                    this.unprocessedDataLen = 0;
                }
                this.algaeAsymmetricCipher.deobfuscate();
                while (n7 > n5) {
                    n6 += this.algaeAsymmetricCipher.decryptBlock(byArray, n, byArray2, n3);
                    n += this.inputBlockSize;
                    n3 += this.outputBlockSize;
                    n7 -= this.inputBlockSize;
                }
                this.algaeAsymmetricCipher.obfuscate();
                this.unprocessedDataLen = n7;
                if (n7 > 0) {
                    n4 = 0;
                    while (n4 < this.unprocessedDataLen) {
                        this.unprocessedData[n4] = byArray[n];
                        ++n4;
                        ++n;
                    }
                }
                this.objectState = 6;
                return n6;
            }
            case 2: 
            case 3: 
            case 4: {
                throw new JSAFE_InvalidUseException("Object Not Initialized for Decrypt");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized");
    }

    public int doDecryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                byte[] byArray2 = null;
                int n2 = 0;
                if (this.unprocessedDataLen != 0) {
                    if (this.unprocessedDataLen != this.inputBlockSize) {
                        throw new JSAFE_InputException("Invalid input length for decryption. Length should be multiple of " + this.inputBlockSize + " - Block Size.");
                    }
                    byArray2 = new byte[this.outputBlockSize];
                    this.algaeAsymmetricCipher.deobfuscate();
                    int n3 = this.algaeAsymmetricCipher.decryptBlock(this.unprocessedData, 0, byArray2, 0);
                    this.algaeAsymmetricCipher.obfuscate();
                    n2 = this.paddingScheme.performUnpadding(byArray2, 0, this.outputBlockSize, null);
                    if (n2 > 0) {
                        int n4 = 0;
                        while (n4 < n2) {
                            byArray[n] = byArray2[n4];
                            ++n4;
                            ++n;
                        }
                    }
                    this.overwrite(byArray2);
                }
                this.objectState = 7;
                return n2;
            }
            case 2: 
            case 3: 
            case 4: {
                throw new JSAFE_InvalidUseException("Object not initialized for Decrypt.");
            }
        }
        throw new JSAFE_InvalidUseException("Object Not Initialized");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JG_AsymmetricCipher jG_AsymmetricCipher = new JG_AsymmetricCipher();
        if (this.algaeAsymmetricCipher != null) {
            jG_AsymmetricCipher.algaeAsymmetricCipher = (JA_AlgaeAsymmetricCipher)this.algaeAsymmetricCipher.clone();
        }
        if (this.paddingScheme != null) {
            jG_AsymmetricCipher.paddingScheme = (JA_AsymmetricPaddingScheme)this.paddingScheme.clone();
        }
        jG_AsymmetricCipher.random = this.random;
        jG_AsymmetricCipher.inputBlockSize = this.inputBlockSize;
        jG_AsymmetricCipher.outputBlockSize = this.outputBlockSize;
        jG_AsymmetricCipher.maxInputLen = this.maxInputLen;
        if (this.unprocessedData != null) {
            jG_AsymmetricCipher.unprocessedData = (byte[])this.unprocessedData.clone();
        }
        jG_AsymmetricCipher.unprocessedDataLen = this.unprocessedDataLen;
        jG_AsymmetricCipher.objectState = this.objectState;
        jG_AsymmetricCipher.setJSAFELevelValues(this);
        return jG_AsymmetricCipher;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    protected void doClearSensitiveData() {
        if (this.algaeAsymmetricCipher != null) {
            this.algaeAsymmetricCipher.clearSensitiveData();
        }
        this.overwrite(this.unprocessedData);
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

