/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PKCS8;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

class JG_BlockCipher
extends JSAFE_SymmetricCipher
implements Cloneable,
Serializable {
    protected JA_AlgaeBlockCipher algaeBlockCipher;
    protected JA_FeedbackMode feedbackMode;
    private JA_SymmetricPaddingScheme paddingScheme;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private int blockSize;
    private int ivSize;
    private byte[] unprocessedData;
    private byte[] replacementIV;
    private int unprocessedDataLen;
    private int bufferLen;
    private int objectState;
    protected static final int NOT_INITIALIZED = 1;
    protected static final int ENCRYPT_INIT = 2;
    protected static final int ENCRYPT_UPDATE = 3;
    protected static final int ENCRYPT_FINAL = 4;
    protected static final int DECRYPT_INIT = 5;
    protected static final int DECRYPT_UPDATE = 6;
    protected static final int DECRYPT_FINAL = 7;

    JG_BlockCipher(JA_AlgaeBlockCipher jA_AlgaeBlockCipher, JA_FeedbackMode jA_FeedbackMode, JA_SymmetricPaddingScheme jA_SymmetricPaddingScheme) {
        int n = jA_FeedbackMode.getBlockSize();
        if (n == -1) {
            n = jA_AlgaeBlockCipher.getBlockSize();
        }
        this.ivSize = jA_AlgaeBlockCipher.getBlockSize();
        byte[] byArray = new byte[n];
        this.algaeBlockCipher = jA_AlgaeBlockCipher;
        this.feedbackMode = jA_FeedbackMode;
        this.paddingScheme = jA_SymmetricPaddingScheme;
        this.blockSize = n;
        this.unprocessedData = byArray;
        this.objectState = 1;
    }

    protected JG_BlockCipher() {
    }

    void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        this.algaeBlockCipher.setAlgorithmBER(byArray, n, n2, this.feedbackMode, this.paddingScheme);
        int n3 = this.feedbackMode.getBlockSize();
        if (n3 == -1) {
            n3 = this.algaeBlockCipher.getBlockSize();
        }
        if (n3 == this.blockSize) {
            return;
        }
        this.blockSize = n3;
        this.unprocessedData = new byte[this.blockSize];
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        byte[] byArray = this.feedbackMode.getParamsDER();
        byte[] byArray2 = this.algaeBlockCipher.getParamsDER(byArray);
        int n = 0;
        if (byArray2 != null) {
            n = byArray2.length;
        }
        String string = this.algaeBlockCipher.getAlgorithm();
        String string2 = this.feedbackMode.getFeedbackMode();
        String string3 = this.paddingScheme.getPaddingScheme();
        String string4 = string + "/" + string2 + "/" + string3;
        try {
            return AlgorithmID.derEncodeAlgID(string4, 8, byArray2, 0, n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode given transformation.(" + aSN_Exception.getMessage() + ")");
        }
    }

    protected int getState() {
        return this.objectState;
    }

    public String getEncryptionAlgorithm() {
        return this.algaeBlockCipher.getAlgorithm();
    }

    public String getFeedbackMode() {
        return this.feedbackMode.getFeedbackMode();
    }

    public String getPaddingScheme() {
        return this.paddingScheme.getPaddingScheme();
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int[] getAlgorithmParameters() {
        return this.algaeBlockCipher.getInstantiationParameters();
    }

    public void setAlgorithmParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (this.algaeBlockCipher != null) {
            this.algaeBlockCipher.setInstantiationParameters(nArray);
            this.ivSize = this.algaeBlockCipher.getBlockSize();
            int n = this.algaeBlockCipher.getBlockSize();
            if (n != this.blockSize) {
                if (this.unprocessedData != null) {
                    int n2 = 0;
                    while (n2 < this.unprocessedData.length) {
                        this.unprocessedData[n2] = 0;
                        ++n2;
                    }
                }
                this.blockSize = n;
                this.unprocessedData = new byte[this.blockSize];
                this.unprocessedDataLen = 0;
                this.bufferLen = 0;
                this.replacementIV = null;
                this.objectState = 1;
            }
        }
    }

    public int[] getFeedbackParameters() {
        return this.feedbackMode.getInstantiationParameters();
    }

    public int[] getPaddingParameters() {
        return this.paddingScheme.getInstantiationParameters();
    }

    public void setIV(byte[] byArray, int n, int n2) throws JSAFE_IVException {
        if (n2 != this.feedbackMode.getIVSize(this.ivSize)) {
            throw new JSAFE_IVException("Invalid IV length. Should be " + this.feedbackMode.getIVSize(this.ivSize));
        }
        if (this.objectState == 3 || this.objectState == 4 || this.objectState == 6 || this.objectState == 7) {
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray2[n3] = byArray[n];
                ++n3;
                ++n;
            }
            this.replacementIV = byArray2;
        } else {
            this.feedbackMode.setIV(byArray, n, n2);
            this.replacementIV = null;
        }
    }

    public void generateIV(SecureRandom secureRandom) throws JSAFE_IVException, JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException("IV generation needs a random object.");
        }
        byte[] byArray = new byte[this.ivSize];
        secureRandom.nextBytes(byArray);
        this.setIV(byArray, 0, byArray.length);
    }

    public byte[] getIV() {
        return this.feedbackMode.getIV();
    }

    public int getOutputBufferSize(int n) {
        int n2 = n + this.unprocessedDataLen;
        return n2 + this.paddingScheme.getPadLength(n2, this.blockSize);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JG_BlockCipher jG_BlockCipher = (JG_BlockCipher)super.clone();
        if (this.algaeBlockCipher != null) {
            jG_BlockCipher.algaeBlockCipher = (JA_AlgaeBlockCipher)this.algaeBlockCipher.clone();
        }
        if (this.feedbackMode != null) {
            jG_BlockCipher.feedbackMode = (JA_FeedbackMode)this.feedbackMode.clone();
        }
        jG_BlockCipher.paddingScheme = this.paddingScheme;
        jG_BlockCipher.random = this.random;
        jG_BlockCipher.blockSize = this.blockSize;
        if (this.unprocessedData != null) {
            jG_BlockCipher.unprocessedData = (byte[])this.unprocessedData.clone();
        }
        if (this.replacementIV != null) {
            jG_BlockCipher.replacementIV = (byte[])this.replacementIV.clone();
        }
        jG_BlockCipher.unprocessedDataLen = this.unprocessedDataLen;
        jG_BlockCipher.bufferLen = this.bufferLen;
        jG_BlockCipher.objectState = this.objectState;
        jG_BlockCipher.setJSAFELevelValues(this);
        return jG_BlockCipher;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        switch (this.objectState) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                if (this.replacementIV == null) {
                    this.feedbackMode.setIV(this.feedbackMode.getIV(), 0, this.ivSize);
                    break;
                }
                this.feedbackMode.setIV(this.replacementIV, 0, this.ivSize);
                this.replacementIV = null;
            }
        }
        this.feedbackMode.encryptInit(this.algaeBlockCipher, jSAFE_SecretKey, secureRandom);
        this.algaeBlockCipher.obfuscate();
        this.random = secureRandom;
        this.unprocessedDataLen = 0;
        this.objectState = 2;
    }

    public void encryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException {
        switch (this.objectState) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                if (this.replacementIV == null) {
                    this.feedbackMode.setIV(this.feedbackMode.getIV(), 0, this.ivSize);
                } else {
                    this.feedbackMode.setIV(this.replacementIV, 0, this.ivSize);
                    this.replacementIV = null;
                }
            }
            case 2: 
            case 5: {
                this.unprocessedDataLen = 0;
                this.objectState = 2;
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    protected byte[] wrapKeyObject(JSAFE_Key jSAFE_Key, boolean bl, byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        return this.wrapKeyObject(jSAFE_Key, bl, null, byArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] wrapKeyObject(JSAFE_Key jSAFE_Key, boolean bl, String string, byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        Object object;
        int n3;
        byte[] byArray2;
        block14: {
            if (this.objectState != 2) {
                throw new JSAFE_InvalidUseException("Cannot wrap key, object needs new initialization.");
            }
            byArray2 = null;
            n3 = 0;
            if (this.algaeBlockCipher.canWrapKey(bl)) {
                byArray2 = this.algaeBlockCipher.wrapKey(jSAFE_Key, bl, this.feedbackMode, this.paddingScheme);
                n3 = byArray2.length;
                this.objectState = 4;
            } else {
                object = null;
                try {
                    try {
                        String string2 = string != null ? string : jSAFE_Key.getKeyWrappingFormat(bl);
                        object = jSAFE_Key.getKeyData(string2);
                        n3 = this.getOutputBufferSize(object[0].length);
                        byArray2 = new byte[n3];
                        n3 = this.encryptUpdate(object[0], 0, object[0].length, byArray2, 0);
                        n3 += this.encryptFinal(byArray2, n3);
                    }
                    catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                        throw new JSAFE_InvalidUseException("The key given cannot be wrapped.");
                    }
                    catch (JSAFE_IVException jSAFE_IVException) {
                        throw new JSAFE_InvalidUseException(jSAFE_IVException.getMessage());
                    }
                    catch (JSAFE_InputException jSAFE_InputException) {
                        throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
                    }
                    catch (JSAFE_PaddingException jSAFE_PaddingException) {
                        throw new JSAFE_InvalidUseException(jSAFE_PaddingException.getMessage());
                    }
                    Object var15_12 = null;
                    if (object == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    if (object != null && (object).length > 0) {
                        JSAFE_Obfuscator.overwrite(object[0]);
                    }
                    throw throwable;
                }
                if (((byte[][])object).length > 0) {
                    JSAFE_Obfuscator.overwrite(object[0]);
                }
            }
        }
        if (bl) {
            return JA_PKCS8.buildEncryptedKeyInfo(byArray, n, n2, byArray2, 0, n3);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        object = new byte[n3];
        System.arraycopy(byArray2, 0, object, 0, n3);
        return object;
    }

    public int encryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException, JSAFE_IVException {
        switch (this.objectState) {
            case 2: {
                if (this.feedbackMode.IVRequired() && this.feedbackMode.getIVLength() == 0) {
                    throw new JSAFE_InvalidUseException("IV missing.");
                }
            }
            case 3: {
                int n4;
                if (n2 <= 0) {
                    this.objectState = 3;
                    return 0;
                }
                int n5 = 0;
                int n6 = this.unprocessedDataLen + n2;
                if (this.unprocessedDataLen != 0) {
                    if (n6 < this.blockSize) {
                        int n7 = this.unprocessedDataLen;
                        while (n7 < n6) {
                            this.unprocessedData[n7] = byArray[n];
                            ++n7;
                            ++n;
                        }
                        this.unprocessedDataLen = n6;
                        this.objectState = 3;
                        return 0;
                    }
                    n4 = this.unprocessedDataLen;
                    while (n4 < this.blockSize) {
                        this.unprocessedData[n4] = byArray[n];
                        ++n4;
                        ++n;
                    }
                    this.algaeBlockCipher.deobfuscate();
                    n5 += this.feedbackMode.encryptBlock(this.algaeBlockCipher, this.unprocessedData, 0, byArray2, n3);
                    n3 += this.blockSize;
                    n6 -= this.blockSize;
                    this.unprocessedDataLen = 0;
                }
                this.algaeBlockCipher.deobfuscate();
                while (n6 >= this.blockSize) {
                    n5 += this.feedbackMode.encryptBlock(this.algaeBlockCipher, byArray, n, byArray2, n3);
                    n += this.blockSize;
                    n3 += this.blockSize;
                    n6 -= this.blockSize;
                }
                this.algaeBlockCipher.obfuscate();
                this.unprocessedDataLen = n6;
                if (this.unprocessedDataLen > 0) {
                    n4 = 0;
                    while (n4 < this.unprocessedDataLen) {
                        this.unprocessedData[n4] = byArray[n];
                        ++n4;
                        ++n;
                    }
                }
                this.objectState = 3;
                return n5;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for decryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int encryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                int n2 = this.paddingScheme.performPadding(this.unprocessedData, 0, this.unprocessedDataLen, this.blockSize, null, this.random);
                this.unprocessedDataLen += n2;
                if (this.unprocessedDataLen == 0) {
                    this.objectState = 4;
                    return 0;
                }
                if (this.unprocessedDataLen != this.blockSize) {
                    throw new JSAFE_InputException("Invalid input length for encryption.Should be a multiple of the block size - " + this.blockSize + ".");
                }
                this.algaeBlockCipher.deobfuscate();
                int n3 = this.feedbackMode.encryptBlock(this.algaeBlockCipher, this.unprocessedData, 0, byArray, n);
                this.unprocessedDataLen = 0;
                this.algaeBlockCipher.obfuscate();
                this.objectState = 4;
                return n3;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for decryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        switch (this.objectState) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                if (this.replacementIV == null) {
                    this.feedbackMode.setIV(this.feedbackMode.getIV(), 0, this.ivSize);
                    break;
                }
                this.feedbackMode.setIV(this.replacementIV, 0, this.ivSize);
                this.replacementIV = null;
            }
        }
        this.feedbackMode.decryptInit(this.algaeBlockCipher, jSAFE_SecretKey, secureRandom);
        this.random = secureRandom;
        this.unprocessedDataLen = 0;
        this.bufferLen = this.paddingScheme.getPadLength(0, this.blockSize) == 0 ? this.blockSize - 1 : this.blockSize;
        this.objectState = 5;
    }

    public void decryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException {
        switch (this.objectState) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                if (this.replacementIV == null) {
                    this.feedbackMode.setIV(this.feedbackMode.getIV(), 0, this.ivSize);
                } else {
                    this.feedbackMode.setIV(this.replacementIV, 0, this.ivSize);
                    this.replacementIV = null;
                }
            }
            case 2: 
            case 5: {
                this.unprocessedDataLen = 0;
                this.objectState = 5;
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    /*
     * Exception decompiling
     */
    public JSAFE_PrivateKey doUnwrapPrivateKey(byte[] var1_1, int var2_2, int var3_3, String var4_4) throws JSAFE_InvalidUseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, boolean bl, String string) throws JSAFE_InvalidUseException {
        if (this.objectState != 5) {
            throw new JSAFE_InvalidUseException("Cannot unwrap key, object needs new initialization.");
        }
        if (string == null) {
            string = this.getDevice();
        }
        if (bl) {
            int[] nArray = JA_PKCS8.getEncryptedKeyInfo(byArray, n);
            n = nArray[0];
            n2 = nArray[1];
        }
        if (this.algaeBlockCipher.canWrapKey(false)) {
            this.objectState = 7;
            return this.algaeBlockCipher.unwrapPrivateKey(byArray, n, n2, this.feedbackMode, this.paddingScheme, string);
        }
        return this.doUnwrapPrivateKey(byArray, n, n2, string);
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, boolean bl, String string) throws JSAFE_InvalidUseException {
        Object[] objectArray;
        if (this.objectState != 5) {
            throw new JSAFE_InvalidUseException("Cannot unwrap key, object needs new initialization.");
        }
        if (string == null) {
            string = this.getDevice();
        }
        if (bl) {
            objectArray = JA_PKCS8.getEncryptedKeyInfo(byArray, n);
            n = objectArray[0];
            n2 = objectArray[1];
        }
        if (this.algaeBlockCipher.canWrapKey(false)) {
            this.objectState = 7;
            return this.algaeBlockCipher.unwrapPublicKey(byArray, n, n2, this.feedbackMode, this.paddingScheme, string);
        }
        try {
            objectArray = new byte[this.getOutputBufferSize(n2)];
            int n3 = this.decryptUpdate(byArray, n, n2, (byte[])objectArray, 0);
            n3 += this.decryptFinal((byte[])objectArray, n3);
            JSAFE_PublicKey jSAFE_PublicKey = JSAFE_PublicKey.getInstance((byte[])objectArray, 0, string);
            return jSAFE_PublicKey;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidUseException("Could not unwrap public key.");
        }
        catch (JSAFE_IVException jSAFE_IVException) {
            throw new JSAFE_InvalidUseException(jSAFE_IVException.getMessage());
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            throw new JSAFE_InvalidUseException(jSAFE_PaddingException.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public JSAFE_SecretKey unwrapSecretKey(byte[] var1_1, int var2_2, int var3_3, boolean var4_4, String var5_5, String var6_6) throws JSAFE_InvalidUseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int decryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException, JSAFE_IVException {
        switch (this.objectState) {
            case 5: {
                if (this.feedbackMode.IVRequired() && this.feedbackMode.getIVLength() == 0) {
                    throw new JSAFE_InvalidUseException("IV missing.");
                }
            }
            case 6: {
                int n4;
                if (n2 <= 0) {
                    this.objectState = 6;
                    return 0;
                }
                int n5 = 0;
                int n6 = n2 + this.unprocessedDataLen;
                int n7 = this.blockSize - this.unprocessedDataLen;
                if (n7 == this.blockSize) {
                    if (n6 <= this.bufferLen) {
                        int n8 = 0;
                        while (n8 < n6) {
                            this.unprocessedData[n8] = byArray[n];
                            ++n8;
                            ++n;
                        }
                        this.unprocessedDataLen = n6;
                        this.objectState = 6;
                        return 0;
                    }
                } else if (n7 == 0) {
                    this.algaeBlockCipher.deobfuscate();
                    n5 += this.feedbackMode.decryptBlock(this.algaeBlockCipher, this.unprocessedData, 0, byArray2, n3);
                    n3 += this.blockSize;
                    n6 -= this.blockSize;
                    this.unprocessedDataLen = 0;
                } else {
                    if (n6 <= this.bufferLen) {
                        int n9 = this.unprocessedDataLen;
                        while (n9 < n6) {
                            this.unprocessedData[n9] = byArray[n];
                            ++n9;
                            ++n;
                        }
                        this.unprocessedDataLen = n6;
                        this.objectState = 6;
                        return 0;
                    }
                    n4 = this.unprocessedDataLen;
                    while (n4 < this.blockSize) {
                        this.unprocessedData[n4] = byArray[n];
                        ++n4;
                        ++n;
                    }
                    this.algaeBlockCipher.deobfuscate();
                    n5 += this.feedbackMode.decryptBlock(this.algaeBlockCipher, this.unprocessedData, 0, byArray2, n3);
                    n3 += this.blockSize;
                    n6 -= this.blockSize;
                    this.unprocessedDataLen = 0;
                }
                this.algaeBlockCipher.deobfuscate();
                while (n6 > this.bufferLen) {
                    n5 += this.feedbackMode.decryptBlock(this.algaeBlockCipher, byArray, n, byArray2, n3);
                    n += this.blockSize;
                    n3 += this.blockSize;
                    n6 -= this.blockSize;
                }
                this.algaeBlockCipher.obfuscate();
                this.unprocessedDataLen = n6;
                if (n6 > 0) {
                    n4 = 0;
                    while (n4 < this.unprocessedDataLen) {
                        this.unprocessedData[n4] = byArray[n];
                        ++n4;
                        ++n;
                    }
                }
                this.objectState = 6;
                return n5;
            }
            case 2: 
            case 3: {
                throw new JSAFE_InvalidUseException("Object initialized for encryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int decryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                byte[] byArray2 = null;
                int n2 = 0;
                if (this.unprocessedDataLen != 0) {
                    int n3;
                    if (this.unprocessedDataLen != this.blockSize) {
                        throw new JSAFE_InputException("Invalid input length for decryption.Should be a multiple of the block size - " + this.blockSize + ".");
                    }
                    this.algaeBlockCipher.deobfuscate();
                    byArray2 = new byte[this.blockSize];
                    int n4 = this.feedbackMode.decryptBlock(this.algaeBlockCipher, this.unprocessedData, 0, byArray2, 0);
                    this.algaeBlockCipher.obfuscate();
                    n2 = this.paddingScheme.performUnpadding(byArray2, 0, this.blockSize, null);
                    this.unprocessedDataLen = 0;
                    if (n2 > 0) {
                        n3 = 0;
                        while (n3 < n2) {
                            byArray[n] = byArray2[n3];
                            ++n3;
                            ++n;
                        }
                    }
                    n3 = 0;
                    while (n3 < this.blockSize) {
                        byArray2[n3] = 0;
                        ++n3;
                    }
                }
                this.objectState = 7;
                return n2;
            }
            case 2: 
            case 3: {
                throw new JSAFE_InvalidUseException("Object initialized for encryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.algaeBlockCipher != null) {
            this.algaeBlockCipher.clearSensitiveData();
        }
        if (this.feedbackMode != null) {
            this.feedbackMode.clearSensitiveData();
        }
        if (this.unprocessedData != null) {
            this.overwrite(this.unprocessedData);
        }
        this.unprocessedDataLen = 0;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

