/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeChainDigestRandom;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JG_ChainDigestRandom
extends JSAFE_SecureRandom
implements Cloneable,
Serializable {
    private boolean seedToFinalize;
    private JA_AlgaeDigest algaeDigest;
    private int digestSize;
    private int bytesAvailable;
    private int seedReverseCount;
    private byte[] state;
    private boolean obfuscateFlag;
    private byte[] oddConstant;
    private transient ObfuscatorItem stateOI;

    protected JG_ChainDigestRandom() {
    }

    JG_ChainDigestRandom(JA_AlgaeChainDigestRandom jA_AlgaeChainDigestRandom) {
        this(jA_AlgaeChainDigestRandom, true);
    }

    JG_ChainDigestRandom(JA_AlgaeChainDigestRandom jA_AlgaeChainDigestRandom, boolean bl) {
        this.seedReverseCount = 2;
        this.algaeDigest = jA_AlgaeChainDigestRandom.getDigestObject();
        this.digestSize = this.algaeDigest.getDigestSize();
        this.oddConstant = jA_AlgaeChainDigestRandom.getOddConstant();
        this.state = new byte[2 * this.digestSize];
        this.obfuscateFlag = bl;
    }

    public String getAlgorithm() {
        return this.algaeDigest.getAlgorithm() + "Random";
    }

    public synchronized void autoseed() {
        SecureRandom secureRandom = new SecureRandom(new byte[4]);
        byte[] byArray = SecureRandom.getSeed(20);
        this.seed(byArray);
        JSAFE_Obfuscator.overwrite(byArray);
        secureRandom.setSeed(byArray);
    }

    public synchronized void seed(byte[] byArray) {
        if (this.seedReverseCount > 0) {
            --this.seedReverseCount;
        }
        try {
            if (!this.seedToFinalize) {
                this.algaeDigest.digestInit();
                if (this.seedReverseCount == 0) {
                    this.deobfuscate();
                    this.algaeDigest.digestUpdate(this.state, 0, this.digestSize);
                    this.obfuscate();
                }
            }
            this.algaeDigest.digestUpdate(byArray, 0, byArray.length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.autoseed();
        }
        this.seedToFinalize = true;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void generateRandomBytes(byte[] var1_1, int var2_2, int var3_3) {
        block7: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            this.deobfuscate();
            try {
                if (this.seedToFinalize) {
                    this.algaeDigest.digestFinal(this.state, 0);
                    this.bytesAvailable = 0;
                    this.seedToFinalize = false;
                }
                while (var5_5 > this.bytesAvailable) {
                    if (this.bytesAvailable > 0) {
                        var6_6 = 2 * this.digestSize - this.bytesAvailable;
                        System.arraycopy(this.state, var6_6, var1_1, var4_4, this.bytesAvailable);
                        var5_5 -= this.bytesAvailable;
                        var4_4 += this.bytesAvailable;
                        this.bytesAvailable = 0;
                    }
                    this.algaeDigest.digestInit();
                    this.algaeDigest.digestUpdate(this.state, 0, this.digestSize);
                    this.algaeDigest.digestFinal(this.state, this.digestSize);
                    this.updateState();
                    this.bytesAvailable = this.digestSize;
                }
                var6_6 = 2 * this.digestSize - this.bytesAvailable;
                System.arraycopy(this.state, var6_6, var1_1, var4_4, var5_5);
                this.bytesAvailable -= var5_5;
                break block7;
            }
            catch (JSAFE_Exception var6_7) {
                var7_8 = new SecureRandom(new byte[4]);
                var8_9 = SecureRandom.getSeed(20);
                var7_8.setSeed(var8_9);
                var5_5 = var3_3;
                var4_4 = var2_2;
                ** while (var5_5 > 0)
            }
lbl-1000:
            // 1 sources

            {
                var7_8.nextBytes(var8_9);
                if (var5_5 >= 20) {
                    System.arraycopy(var8_9, 0, var1_1, var4_4, 20);
                    var5_5 -= 20;
                    var4_4 += 20;
                    continue;
                }
                System.arraycopy(var8_9, 0, var1_1, var4_4, var5_5);
                var4_4 += var5_5;
                var5_5 = 0;
                continue;
            }
lbl45:
            // 1 sources

            var7_8.nextBytes(var8_9);
        }
        this.obfuscate();
    }

    private void updateState() {
        if (this.seedReverseCount != 0) {
            int n = this.digestSize - 1;
            while (n >= 0) {
                int n2 = n;
                this.state[n2] = (byte)(this.state[n2] + 1);
                if (this.state[n] == 1) {
                    --n;
                    continue;
                }
                break;
            }
        } else {
            int n = 0;
            int n3 = this.digestSize - 1;
            while (n3 >= 0) {
                n = (this.state[n3] & 0xFF) + (this.oddConstant[n3] & 0xFF) + ((n & 0x100) >>> 8);
                this.state[n3] = (byte)(n & 0xFF);
                --n3;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private void prepareSerialization() {
        this.deobfuscate();
    }

    private void restoreAfterSerialization() {
        this.obfuscate();
    }

    private void restoreAfterDeserialization() {
        this.obfuscate();
    }

    public Object clone() throws CloneNotSupportedException {
        JG_ChainDigestRandom jG_ChainDigestRandom = new JG_ChainDigestRandom();
        jG_ChainDigestRandom.seedToFinalize = this.seedToFinalize;
        jG_ChainDigestRandom.digestSize = this.digestSize;
        jG_ChainDigestRandom.bytesAvailable = this.bytesAvailable;
        jG_ChainDigestRandom.seedReverseCount = this.seedReverseCount;
        if (this.algaeDigest != null) {
            jG_ChainDigestRandom.algaeDigest = (JA_AlgaeDigest)this.algaeDigest.clone();
        }
        if (this.stateOI == null) {
            jG_ChainDigestRandom.state = (byte[])this.state.clone();
        } else {
            jG_ChainDigestRandom.state = (byte[])JSAFE_Obfuscator.copy(this.state, this.stateOI);
            jG_ChainDigestRandom.stateOI = JSAFE_Obfuscator.getObfuscatorItem(jG_ChainDigestRandom.state);
            jG_ChainDigestRandom.obfuscateFlag = true;
        }
        if (this.oddConstant != null) {
            jG_ChainDigestRandom.oddConstant = (byte[])this.oddConstant.clone();
        }
        jG_ChainDigestRandom.setJSAFELevelValues(this);
        return jG_ChainDigestRandom;
    }

    private void obfuscate() {
        if (!this.obfuscateFlag) {
            return;
        }
        if (this.stateOI == null) {
            this.stateOI = JSAFE_Obfuscator.register(this.state);
        }
        if (this.stateOI.getPower()) {
            this.stateOI.obfuscate();
        }
    }

    private void deobfuscate() {
        if (!this.obfuscateFlag || this.stateOI == null) {
            return;
        }
        if (this.stateOI.getPower()) {
            this.stateOI.deobfuscate();
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.algaeDigest != null) {
            this.algaeDigest.clearSensitiveData();
        }
        if (this.stateOI != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.state, this.stateOI);
        }
        this.stateOI = null;
        this.seedToFinalize = false;
        this.seedReverseCount = 2;
        this.bytesAvailable = 0;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

