/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeDigestMAC;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public class JG_DigestMAC
extends JSAFE_MAC
implements Cloneable,
Serializable {
    protected static final int NOT_INITIALIZED = 1;
    protected static final int MAC_INIT = 2;
    protected static final int MAC_UPDATE = 3;
    protected static final int MAC_FINAL = 4;
    protected static final int VERIFY_INIT = 5;
    protected static final int VERIFY_UPDATE = 6;
    protected static final int VERIFY_FINAL = 7;
    private int objectState;
    protected JA_AlgaeDigest algaeDigest;
    protected JA_AlgaeDigestMAC algaeMAC;

    JG_DigestMAC(JA_AlgaeDigestMAC jA_AlgaeDigestMAC, JA_AlgaeDigest jA_AlgaeDigest) {
        this.algaeMAC = jA_AlgaeDigestMAC;
        this.algaeDigest = jA_AlgaeDigest;
        this.objectState = 1;
    }

    protected JG_DigestMAC() {
    }

    protected JA_AlgaeDigest getAlgaeDigest() {
        return this.algaeDigest;
    }

    protected JA_AlgaeDigestMAC getAlgaeMAC() {
        return this.algaeMAC;
    }

    public int[] getAlgorithmParameters() {
        return this.algaeMAC.getInstantiationParameters();
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        return this.algaeMAC.getDERAlgorithmID(this.algaeDigest);
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        this.algaeMAC.setAlgorithmBER(byArray, n);
    }

    public String getMACAlgorithm() {
        return this.algaeMAC.getAlgorithm();
    }

    public String getDigestAlgorithm() {
        if (this.algaeDigest != null) {
            return this.algaeDigest.getAlgorithm();
        }
        return null;
    }

    public int getMACSize() {
        switch (this.objectState) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return this.algaeMAC.getMACSize();
            }
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        JG_DigestMAC jG_DigestMAC = new JG_DigestMAC();
        if (this.algaeMAC != null) {
            jG_DigestMAC.algaeMAC = (JA_AlgaeDigestMAC)this.algaeMAC.clone();
        }
        if (this.algaeDigest != null) {
            jG_DigestMAC.algaeDigest = (JA_AlgaeDigest)this.algaeDigest.clone();
        }
        jG_DigestMAC.objectState = this.objectState;
        jG_DigestMAC.setJSAFELevelValues(this);
        return jG_DigestMAC;
    }

    public void macInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.algaeMAC.macInit(this.algaeDigest, jSAFE_SecretKey, secureRandom);
        this.objectState = 2;
    }

    public void macReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: 
            case 4: {
                this.algaeMAC.macReInit();
                this.objectState = 2;
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object not Initialized for MAC");
    }

    public void macUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                this.algaeMAC.deobfuscate();
                this.algaeMAC.macUpdate(byArray, n, n2);
                this.objectState = 3;
                this.algaeMAC.obfuscate();
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object not Initialized for MAC");
    }

    public int macFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                this.algaeMAC.deobfuscate();
                int n2 = this.algaeMAC.macFinal(byArray, n);
                this.objectState = 4;
                this.algaeMAC.obfuscate();
                return n2;
            }
        }
        throw new JSAFE_InvalidUseException("Object Not Initialized");
    }

    public void verifyInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.algaeMAC.macInit(this.algaeDigest, jSAFE_SecretKey, secureRandom);
        this.objectState = 5;
    }

    public void verifyReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: 
            case 7: {
                this.algaeMAC.macReInit();
                this.objectState = 5;
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object not Initialized for verify");
    }

    public void verifyUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                this.algaeMAC.deobfuscate();
                this.algaeMAC.macUpdate(byArray, n, n2);
                this.algaeMAC.obfuscate();
                this.objectState = 6;
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object Not Initialized for verify");
    }

    public boolean verifyFinal(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                this.algaeMAC.deobfuscate();
                byte[] byArray2 = new byte[this.algaeMAC.getMACSize()];
                int n3 = this.algaeMAC.macFinal(byArray2, 0);
                this.algaeMAC.obfuscate();
                this.objectState = 7;
                boolean bl = JG_DigestMAC.compare(byArray, n, n2, byArray2, 0, n3);
                return bl;
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized for verify.");
    }

    private static boolean compare(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        if (n2 != n4) {
            return false;
        }
        int n5 = 0;
        while (n5 < n2) {
            if (byArray[n] != byArray2[n3]) {
                return false;
            }
            ++n5;
            ++n;
            ++n3;
        }
        return true;
    }

    public void clearSensitiveData() {
        if (this.algaeDigest != null) {
            this.algaeDigest.clearSensitiveData();
        }
        if (this.algaeMAC != null) {
            this.algaeMAC.clearSensitiveData();
        }
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

