/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeKeyAgree;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyAgree;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class JG_KeyAgree
extends JSAFE_KeyAgree
implements Cloneable,
Serializable {
    private JA_AlgaeKeyAgree algaeKeyAgree;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private int outputSize;
    private boolean parametersFlag;
    private int objectState;
    private static final int NOT_INITIALIZED = 1;
    private static final int INITIALIZED = 2;
    private static final int PHASE1 = 3;
    private static final int PHASE2 = 4;
    private int style;
    private static final int NO_STYLE = 1;
    private static final int CLASSICAL = 2;
    private static final int KEY_BASED_SEND = 3;
    private static final int KEY_BASED_RECEIVE = 4;

    JG_KeyAgree(JA_AlgaeKeyAgree jA_AlgaeKeyAgree) {
        this.algaeKeyAgree = jA_AlgaeKeyAgree;
        this.outputSize = 0;
        this.parametersFlag = false;
        this.style = 1;
        this.objectState = 1;
    }

    private JG_KeyAgree() {
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        return this.algaeKeyAgree.getDERAlgorithmID();
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        this.parametersFlag = this.algaeKeyAgree.setAlgorithmBER(byArray, n);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
    }

    public String getKeyAgreeAlgorithm() {
        return this.algaeKeyAgree.getAlgorithm();
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public JSAFE_Parameters getSharedParameters() throws JSAFE_InvalidUseException {
        if (!this.parametersFlag) {
            throw new JSAFE_InvalidUseException("Parameters have not been set.");
        }
        byte[][] byArray = this.algaeKeyAgree.getSharedParameters();
        JSAFE_Parameters jSAFE_Parameters = null;
        try {
            jSAFE_Parameters = JSAFE_Parameters.getInstance(this.algaeKeyAgree.getAlgorithm(), this.getDevice());
            jSAFE_Parameters.setParameterData(byArray);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException("Could not create a JSAFE_Parameters object.");
        }
        return jSAFE_Parameters;
    }

    public void keyAgreeInit(SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        if (!this.parametersFlag) {
            throw new JSAFE_InvalidUseException("Parameters have not been set.");
        }
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (this.random == null) {
            throw new JSAFE_InvalidUseException("Random number generator not set.");
        }
        this.algaeKeyAgree.keyAgreeInitRandom(this.random);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
        this.style = 2;
        this.objectState = 2;
    }

    public void keyAgreeInit(JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (this.random == null) {
            throw new JSAFE_InvalidUseException("Random number generator not set.");
        }
        this.algaeKeyAgree.keyAgreeInitParameters(jSAFE_Parameters);
        this.algaeKeyAgree.keyAgreeInitRandom(this.random);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
        this.parametersFlag = true;
        this.style = 2;
        this.objectState = 2;
    }

    public void keyAgreeInit(JSAFE_Parameters jSAFE_Parameters, JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (this.random == null) {
            throw new JSAFE_InvalidUseException("Random number generator not set.");
        }
        this.algaeKeyAgree.keyAgreeInitParameters(jSAFE_Parameters);
        this.algaeKeyAgree.keyAgreeInitRandom(this.random);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
        this.algaeKeyAgree.setCorrespondentPublicValue(jSAFE_PublicKey);
        this.parametersFlag = true;
        this.style = 3;
        this.objectState = 2;
    }

    public void keyAgreeInit(JSAFE_Parameters jSAFE_Parameters, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidKeyException {
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        this.algaeKeyAgree.keyAgreeInitParameters(jSAFE_Parameters);
        this.algaeKeyAgree.keyAgreeInitRandom(this.random);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
        this.algaeKeyAgree.setMyPrivateValue(jSAFE_PrivateKey);
        this.parametersFlag = true;
        this.style = 4;
        this.objectState = 3;
    }

    public void keyAgreeInit(JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (this.random == null) {
            throw new JSAFE_InvalidUseException("Random number generator not set.");
        }
        boolean bl = this.algaeKeyAgree.keyAgreeInitPublicKey(jSAFE_PublicKey);
        if (bl) {
            this.parametersFlag = true;
        }
        if (!this.parametersFlag) {
            throw new JSAFE_InvalidUseException("Parameters have not been set.");
        }
        this.algaeKeyAgree.keyAgreeInitRandom(this.random);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
        this.algaeKeyAgree.setCorrespondentPublicValue(jSAFE_PublicKey);
        this.style = 3;
        this.objectState = 2;
    }

    public void keyAgreeInit(JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws JSAFE_InvalidKeyException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        boolean bl;
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (bl = this.algaeKeyAgree.keyAgreeInitPrivateKey(jSAFE_PrivateKey)) {
            this.parametersFlag = true;
        }
        if (!this.parametersFlag) {
            throw new JSAFE_InvalidUseException("Parameters have not been set.");
        }
        this.algaeKeyAgree.keyAgreeInitRandom(this.random);
        this.outputSize = this.algaeKeyAgree.getOutputBufferSize();
        this.algaeKeyAgree.setMyPrivateValue(jSAFE_PrivateKey);
        this.style = 4;
        this.objectState = 3;
    }

    public void keyAgreeReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: 
            case 4: {
                switch (this.style) {
                    case 2: 
                    case 3: {
                        this.objectState = 2;
                        return;
                    }
                    case 4: {
                        this.objectState = 3;
                    }
                }
                return;
            }
        }
        throw new JSAFE_InvalidUseException("Object Not Initialized");
    }

    public int keyAgreePhase1(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        if (this.style != 2) {
            throw new JSAFE_InvalidUseException("Improper method call order.");
        }
        switch (this.objectState) {
            case 2: {
                this.algaeKeyAgree.generateMyPrivateValue();
                this.algaeKeyAgree.generateMyPublicValue();
                int n2 = this.algaeKeyAgree.getMyPublicValue(byArray, n);
                this.objectState = 3;
                return n2;
            }
            case 3: 
            case 4: {
                throw new JSAFE_InvalidUseException("Improper method call order.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public JSAFE_PublicKey generateMyPublicValue() throws JSAFE_InvalidUseException {
        if (this.style != 3) {
            throw new JSAFE_InvalidUseException("Improper method call order.");
        }
        switch (this.objectState) {
            case 2: {
                this.algaeKeyAgree.generateMyPrivateValue();
                this.algaeKeyAgree.generateMyPublicValue();
                try {
                    JSAFE_PublicKey jSAFE_PublicKey = JSAFE_PublicKey.getInstance(this.algaeKeyAgree.getAlgorithm(), this.getDevice());
                    byte[][] byArray = this.algaeKeyAgree.getSharedParameters();
                    byte[] byArray2 = new byte[this.outputSize];
                    int n = this.algaeKeyAgree.getMyPublicValue(byArray2, 0);
                    byte[][] byArrayArray = new byte[byArray.length + 1][];
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        byArrayArray[n2] = byArray[n2];
                        ++n2;
                    }
                    byArrayArray[n2] = byArray2;
                    jSAFE_PublicKey.setKeyData(byArrayArray);
                    this.objectState = 3;
                    return jSAFE_PublicKey;
                }
                catch (JSAFE_Exception jSAFE_Exception) {
                    throw new JSAFE_InvalidUseException("Could not build public key.");
                }
            }
            case 3: 
            case 4: {
                throw new JSAFE_InvalidUseException("Improper method call order.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int keyAgreePhase2(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException {
        if (this.style != 2) {
            throw new JSAFE_InvalidUseException("Improper method call order.");
        }
        switch (this.objectState) {
            case 2: {
                throw new JSAFE_InvalidUseException("Improper method call order.");
            }
            case 3: 
            case 4: {
                this.algaeKeyAgree.setCorrespondentPublicValue(byArray, n, n2);
                int n4 = this.algaeKeyAgree.generateSharedSecret(byArray2, n3);
                this.objectState = 4;
                return n4;
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int generateSharedSecret(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        if (this.style != 3) {
            throw new JSAFE_InvalidUseException("Improper method call order.");
        }
        switch (this.objectState) {
            case 2: {
                throw new JSAFE_InvalidUseException("Improper method call order.");
            }
            case 3: {
                int n2 = this.algaeKeyAgree.generateSharedSecret(byArray, n);
                this.objectState = 4;
                return n2;
            }
            case 4: {
                throw new JSAFE_InvalidUseException("Improper method call order.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int generateSharedSecret(JSAFE_PublicKey jSAFE_PublicKey, byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        if (this.style != 4) {
            throw new JSAFE_InvalidUseException("Improper method call order.");
        }
        switch (this.objectState) {
            case 2: 
            case 3: {
                this.algaeKeyAgree.setCorrespondentPublicValue(jSAFE_PublicKey);
                int n2 = this.algaeKeyAgree.generateSharedSecret(byArray, n);
                this.objectState = 4;
                return n2;
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int getPrivateValue(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        return this.algaeKeyAgree.getMyPrivateValue(byArray, n);
    }

    public JSAFE_PrivateKey getPrivateValueAsKey() throws JSAFE_InvalidUseException {
        try {
            JSAFE_PrivateKey jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance(this.algaeKeyAgree.getAlgorithm(), this.getDevice());
            byte[][] byArray = this.algaeKeyAgree.getSharedParameters();
            byte[] byArray2 = new byte[this.outputSize];
            int n = this.algaeKeyAgree.getMyPublicValue(byArray2, 0);
            byte[][] byArrayArray = new byte[byArray.length + 2][];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArrayArray[n2] = byArray[n2];
                ++n2;
            }
            byArrayArray[n2] = byArray2;
            byte[] byArray3 = new byte[this.outputSize];
            n = this.algaeKeyAgree.getMyPrivateValue(byArray3, 0);
            byArrayArray[n2 + 1] = byArray3;
            jSAFE_PrivateKey.setKeyData(byArrayArray);
            n2 = 0;
            while (n2 < byArray3.length) {
                byArray3[n2] = 0;
                ++n2;
            }
            return jSAFE_PrivateKey;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException("Could not get private value as key.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JG_KeyAgree jG_KeyAgree = new JG_KeyAgree();
        jG_KeyAgree.random = this.random;
        jG_KeyAgree.outputSize = this.outputSize;
        jG_KeyAgree.parametersFlag = this.parametersFlag;
        jG_KeyAgree.objectState = this.objectState;
        jG_KeyAgree.style = this.style;
        if (this.algaeKeyAgree != null) {
            jG_KeyAgree.algaeKeyAgree = (JA_AlgaeKeyAgree)this.algaeKeyAgree.clone();
        }
        jG_KeyAgree.setJSAFELevelValues(this);
        return jG_KeyAgree;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.algaeKeyAgree != null) {
            this.algaeKeyAgree.clearSensitiveData();
        }
        this.outputSize = 0;
        this.parametersFlag = false;
        this.style = 1;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

