/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_ExtendedPasswordStandard;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_PKCS5Padding;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JG_BlockCipher;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

class JG_PasswordBlockCipher
extends JG_BlockCipher
implements Cloneable,
Serializable {
    private JA_AlgaeDigest algaeDigest;
    private JA_PasswordStandard passwordStandard;
    private byte[] replacementSalt;

    JG_PasswordBlockCipher(JA_AlgaeDigest jA_AlgaeDigest, JA_AlgaeBlockCipher jA_AlgaeBlockCipher, JA_FeedbackMode jA_FeedbackMode, JA_PasswordStandard jA_PasswordStandard) {
        super(jA_AlgaeBlockCipher, jA_FeedbackMode, new JA_PKCS5Padding());
        this.algaeDigest = jA_AlgaeDigest;
        this.passwordStandard = jA_PasswordStandard;
    }

    private JG_PasswordBlockCipher() {
    }

    void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        this.passwordStandard.setAlgorithmBER(this.algaeBlockCipher, byArray, n, n2);
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        byte[] byArray = this.passwordStandard.getParamsDER();
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        String string = "PBE/" + this.algaeDigest.getAlgorithm() + "/" + this.algaeBlockCipher.getAlgorithm() + "/" + this.feedbackMode.getFeedbackMode() + "/" + this.passwordStandard.getFullAlgorithm();
        try {
            return AlgorithmID.derEncodeAlgID(string, 9, byArray, 0, n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode given transformation.(" + aSN_Exception.getMessage() + ")");
        }
    }

    public String getDigestAlgorithm() {
        return this.algaeDigest.getAlgorithm();
    }

    public String getPasswordStandard() {
        return this.passwordStandard.getAlgorithm();
    }

    public int[] getPBEParameters() {
        return this.passwordStandard.getInstantiationParameters();
    }

    public void setPBEParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        this.passwordStandard.setInstantiationParameters(nArray);
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        int n3 = this.getState();
        if (n3 == 3 || n3 == 4 || n3 == 6 || n3 == 7) {
            this.replacementSalt = new byte[n2];
            System.arraycopy(byArray, n, this.replacementSalt, 0, n2);
        } else {
            this.passwordStandard.setSalt(byArray, n, n2);
            this.replacementSalt = null;
        }
    }

    public void generateSalt(SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException("Salt generation needs a random object.");
        }
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        this.setSalt(byArray, 0, byArray.length);
    }

    public byte[] getSalt() {
        return this.passwordStandard.getSalt();
    }

    public Object clone() throws CloneNotSupportedException {
        JG_PasswordBlockCipher jG_PasswordBlockCipher = (JG_PasswordBlockCipher)super.clone();
        if (this.algaeDigest != null) {
            jG_PasswordBlockCipher.algaeDigest = (JA_AlgaeDigest)this.algaeDigest.clone();
        }
        if (this.passwordStandard != null) {
            jG_PasswordBlockCipher.passwordStandard = (JA_PasswordStandard)this.passwordStandard.clone();
        }
        if (this.replacementSalt != null) {
            jG_PasswordBlockCipher.replacementSalt = (byte[])this.replacementSalt.clone();
        }
        return jG_PasswordBlockCipher;
    }

    public void setIV(byte[] byArray, int n, int n2) throws JSAFE_IVException {
        if (this.passwordStandard != null) {
            if (this.passwordStandard.outsideIV()) {
                super.setIV(byArray, n, n2);
            }
        } else {
            throw new JSAFE_IVException("With the current PBE, the IV must come from the password and salt.");
        }
    }

    public void generateIV(SecureRandom secureRandom) throws JSAFE_IVException, JSAFE_InvalidUseException {
        if (this.passwordStandard != null) {
            if (this.passwordStandard.outsideIV()) {
                super.generateIV(secureRandom);
            }
        } else {
            throw new JSAFE_IVException("With the current PBE, the IV must come from the password and salt.");
        }
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.replaceSalt();
        this.passwordStandard.generateKeyAndIV(this.algaeDigest, this.feedbackMode, this.getBlockSize(), jSAFE_SecretKey);
        super.encryptInit(jSAFE_SecretKey, secureRandom);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.replaceSalt();
        this.passwordStandard.generateKeyAndIV(this.algaeDigest, this.feedbackMode, this.getBlockSize(), jSAFE_SecretKey);
        super.decryptInit(jSAFE_SecretKey, secureRandom);
    }

    public void encryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException {
        this.replaceSalt();
        super.encryptReInit();
    }

    public void decryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException {
        this.replaceSalt();
        super.decryptReInit();
    }

    private void replaceSalt() {
        int n = this.getState();
        if ((n == 3 || n == 4 || n == 6 || n == 7) && this.replacementSalt != null) {
            this.passwordStandard.setSalt(this.replacementSalt, 0, this.replacementSalt.length);
            this.replacementSalt = null;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.algaeDigest != null) {
            this.algaeDigest.clearSensitiveData();
        }
        if (this.passwordStandard != null) {
            this.passwordStandard.clearSensitiveData();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSAFE_PrivateKey doUnwrapPrivateKey(byte[] byArray, int n, int n2, String string) throws JSAFE_InvalidUseException {
        JSAFE_PrivateKey jSAFE_PrivateKey;
        byte[] byArray2;
        block12: {
            JA_ExtendedPasswordStandard jA_ExtendedPasswordStandard = null;
            if (this.passwordStandard instanceof JA_ExtendedPasswordStandard) {
                jA_ExtendedPasswordStandard = (JA_ExtendedPasswordStandard)((Object)this.passwordStandard);
            }
            byte[] byArray3 = byArray;
            int n3 = n;
            int n4 = n2;
            byte[] byArray4 = null;
            byArray2 = null;
            try {
                try {
                    JSAFE_PrivateKey jSAFE_PrivateKey2;
                    if (jA_ExtendedPasswordStandard != null) {
                        byArray3 = jA_ExtendedPasswordStandard.keyUnwrapPreProcess(byArray, n, n2);
                    }
                    if (byArray3 != byArray) {
                        n3 = 0;
                        n4 = byArray3.length;
                    }
                    byArray4 = new byte[this.getOutputBufferSize(byArray3.length)];
                    int n5 = this.decryptUpdate(byArray3, n3, n4, byArray4, 0);
                    n5 += this.decryptFinal(byArray4, n5);
                    byArray2 = jA_ExtendedPasswordStandard != null ? jA_ExtendedPasswordStandard.keyUnwrapPostProcess(byArray4) : byArray4;
                    jSAFE_PrivateKey = jSAFE_PrivateKey2 = JSAFE_PrivateKey.getInstance(byArray2, 0, string);
                    Object var17_17 = null;
                    if (byArray4 == null) break block12;
                }
                catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                    throw new JSAFE_InvalidUseException("Could not unwrap private key: " + jSAFE_InvalidKeyException.getMessage());
                }
                catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                    throw new JSAFE_InvalidUseException("Could not unwrap private key: " + jSAFE_UnimplementedException.toString());
                }
                catch (JSAFE_IVException jSAFE_IVException) {
                    throw new JSAFE_InvalidUseException("Could not unwrap private key: " + jSAFE_IVException.getMessage());
                }
                catch (JSAFE_InputException jSAFE_InputException) {
                    throw new JSAFE_InvalidUseException("Could not unwrap private key: " + jSAFE_InputException.getMessage());
                }
                catch (JSAFE_PaddingException jSAFE_PaddingException) {
                    throw new JSAFE_InvalidUseException("Could not unwrap private key: " + jSAFE_PaddingException.toString());
                }
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                if (byArray4 != null) {
                    JSAFE_Obfuscator.overwrite(byArray4);
                }
                if (byArray2 == null) throw throwable;
                JSAFE_Obfuscator.overwrite(byArray2);
                throw throwable;
            }
            JSAFE_Obfuscator.overwrite(byArray4);
        }
        if (byArray2 == null) return jSAFE_PrivateKey;
        JSAFE_Obfuscator.overwrite(byArray2);
        return jSAFE_PrivateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] wrapPrivateKeySpecialFormat(JSAFE_PrivateKey jSAFE_PrivateKey, String string) throws JSAFE_InvalidUseException {
        byte[] byArray;
        int n;
        byte[] byArray2;
        JA_ExtendedPasswordStandard jA_ExtendedPasswordStandard;
        block17: {
            if (this.getState() != 2) {
                throw new JSAFE_InvalidUseException("Cannot wrap key, object needs new initialization.");
            }
            jA_ExtendedPasswordStandard = null;
            if (this.passwordStandard instanceof JA_ExtendedPasswordStandard) {
                jA_ExtendedPasswordStandard = (JA_ExtendedPasswordStandard)((Object)this.passwordStandard);
            }
            byte[] byArray3 = null;
            byArray2 = null;
            n = 0;
            byte[][] byArray4 = null;
            try {
                try {
                    byArray4 = jSAFE_PrivateKey.getKeyData("RSAPrivateKeyBER");
                    byArray = byArray3 = byArray4[0];
                    if (jA_ExtendedPasswordStandard != null) {
                        byArray = jA_ExtendedPasswordStandard.keyWrapPreProcess(byArray3);
                    }
                    if (byArray != byArray4[0]) {
                        byArray3 = byArray;
                    }
                    n = this.getOutputBufferSize(byArray3.length);
                    byArray2 = new byte[n];
                    n = this.encryptUpdate(byArray3, 0, byArray3.length, byArray2, 0);
                    n += this.encryptFinal(byArray2, n);
                }
                catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                    throw new JSAFE_InvalidUseException("The key given cannot be wrapped.");
                }
                catch (JSAFE_IVException jSAFE_IVException) {
                    throw new JSAFE_InvalidUseException(jSAFE_IVException.getMessage());
                }
                catch (JSAFE_InputException jSAFE_InputException) {
                    throw new JSAFE_InvalidUseException(jSAFE_InputException.getMessage());
                }
                catch (JSAFE_PaddingException jSAFE_PaddingException) {
                    throw new JSAFE_InvalidUseException(jSAFE_PaddingException.getMessage());
                }
                catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                    throw new JSAFE_InvalidUseException(jSAFE_InvalidKeyException.getMessage());
                }
                Object var14_11 = null;
                if (byArray3 == null) break block17;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (byArray3 == null) throw throwable;
                if (byArray3.length <= 0) throw throwable;
                JSAFE_Obfuscator.overwrite(byArray3);
                throw throwable;
            }
            if (byArray3.length > 0) {
                JSAFE_Obfuscator.overwrite(byArray3);
            }
        }
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        if (jA_ExtendedPasswordStandard == null) {
            return byArray2;
        }
        try {
            return jA_ExtendedPasswordStandard.keyWrapPostProcess(byArray2);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new JSAFE_InvalidUseException(jSAFE_InvalidKeyException.getMessage());
        }
    }
}

