/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeDigestMAC;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JG_DigestMAC;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public class JG_PasswordDigestMAC
extends JG_DigestMAC
implements Cloneable,
Serializable {
    private boolean isSaltInUse = false;
    private JA_PasswordStandard passwordStandard;
    JSAFE_SecretKey derivedKey;
    SecureRandom random;

    public JG_PasswordDigestMAC(JA_AlgaeDigestMAC jA_AlgaeDigestMAC, JA_AlgaeDigest jA_AlgaeDigest, JA_PasswordStandard jA_PasswordStandard) {
        super(jA_AlgaeDigestMAC, jA_AlgaeDigest);
        this.passwordStandard = jA_PasswordStandard;
    }

    protected JG_PasswordDigestMAC() {
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        this.passwordStandard.setSalt(byArray, n, n2);
        this.isSaltInUse = false;
    }

    public void generateSalt(SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException("Salt generation needs a random object.");
        }
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        this.setSalt(byArray, 0, byArray.length);
    }

    public byte[] getSalt() {
        return this.passwordStandard.getSalt();
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        this.passwordStandard.setAlgorithmBER(null, byArray, n, 0);
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        String string = this.algaeMAC.getAlgorithm() + "/" + this.algaeDigest.getAlgorithm();
        byte[] byArray = this.passwordStandard.getParamsDER(string, this.algaeDigest.getAlgorithm());
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        string = "PBE/" + string + "/" + this.passwordStandard.getFullAlgorithm();
        try {
            return AlgorithmID.derEncodeAlgID(string, 9, byArray, 0, n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode given transformation.(" + aSN_Exception.getMessage() + ")");
        }
    }

    public int[] getAlgorithmParameters() {
        return this.passwordStandard.getInstantiationParameters();
    }

    public Object clone() throws CloneNotSupportedException {
        JG_PasswordDigestMAC jG_PasswordDigestMAC = (JG_PasswordDigestMAC)super.clone();
        jG_PasswordDigestMAC.random = this.random;
        jG_PasswordDigestMAC.isSaltInUse = this.isSaltInUse;
        if (this.passwordStandard != null) {
            jG_PasswordDigestMAC.passwordStandard = (JA_PasswordStandard)this.passwordStandard.clone();
        }
        if (this.derivedKey != null) {
            jG_PasswordDigestMAC.derivedKey = (JSAFE_SecretKey)this.derivedKey.clone();
        }
        return jG_PasswordDigestMAC;
    }

    public String getPasswordStandard() {
        return this.passwordStandard.getAlgorithm();
    }

    public int getMACSize() {
        try {
            return this.getAlgaeDigest().getDigestSize();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void commonInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.derivedKey = jSAFE_SecretKey;
        this.random = secureRandom;
        int n = 1;
        this.passwordStandard.generateKeyAndIV(this.getAlgaeDigest(), null, n, jSAFE_SecretKey);
        this.isSaltInUse = true;
    }

    public void macInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.commonInit(jSAFE_SecretKey, secureRandom);
        super.macInit(jSAFE_SecretKey, secureRandom);
    }

    public void macReinit() throws JSAFE_InvalidUseException {
        if (this.isSaltInUse) {
            super.macReInit();
        } else {
            try {
                this.macInit(this.derivedKey, this.random);
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_InvalidUseException("tried to macInit after having done it before");
            }
        }
    }

    public void verifyInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.commonInit(jSAFE_SecretKey, secureRandom);
        super.verifyInit(jSAFE_SecretKey, secureRandom);
    }

    public void verifyReInit() throws JSAFE_InvalidUseException {
        if (this.isSaltInUse) {
            super.verifyReInit();
        } else {
            try {
                this.verifyInit(this.derivedKey, this.random);
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_InvalidUseException("tried to macInit after having done it before");
            }
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.passwordStandard != null) {
            this.passwordStandard.clearSensitiveData();
        }
    }
}

