/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeStreamCipher;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JG_StreamCipher;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

class JG_PasswordStreamCipher
extends JG_StreamCipher
implements Cloneable,
Serializable {
    private JA_AlgaeDigest algaeDigest;
    private JA_PasswordStandard passwordStandard;
    private byte[] replacementSalt;

    JG_PasswordStreamCipher(JA_AlgaeDigest jA_AlgaeDigest, JA_AlgaeStreamCipher jA_AlgaeStreamCipher, JA_PasswordStandard jA_PasswordStandard) {
        super(jA_AlgaeStreamCipher);
        this.algaeDigest = jA_AlgaeDigest;
        this.passwordStandard = jA_PasswordStandard;
    }

    private JG_PasswordStreamCipher() {
    }

    void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        this.passwordStandard.setAlgorithmBER(this.algaeStreamCipher, byArray, n, n2);
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        byte[] byArray = this.passwordStandard.getParamsDER();
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        String string = "PBE/" + this.algaeDigest.getAlgorithm() + "/" + this.algaeStreamCipher.getAlgorithm() + "/" + this.passwordStandard.getFullAlgorithm();
        try {
            return AlgorithmID.derEncodeAlgID(string, 9, byArray, 0, n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode given transformation.(" + aSN_Exception.getMessage() + ")");
        }
    }

    public String getDigestAlgorithm() {
        return this.algaeDigest.getAlgorithm();
    }

    public String getPasswordStandard() {
        return this.passwordStandard.getAlgorithm();
    }

    public int[] getPBEParameters() {
        return this.passwordStandard.getInstantiationParameters();
    }

    public void setPBEParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        this.passwordStandard.setInstantiationParameters(nArray);
    }

    public void setSalt(byte[] byArray, int n, int n2) {
        int n3 = this.getState();
        if (n3 == 3 || n3 == 4 || n3 == 6 || n3 == 7) {
            this.replacementSalt = new byte[n2];
            System.arraycopy(byArray, n, this.replacementSalt, 0, n2);
        } else {
            this.passwordStandard.setSalt(byArray, n, n2);
            this.replacementSalt = null;
        }
    }

    public void generateSalt(SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException("Salt generation needs a random object.");
        }
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        this.setSalt(byArray, 0, byArray.length);
    }

    public byte[] getSalt() {
        return this.passwordStandard.getSalt();
    }

    public Object clone() throws CloneNotSupportedException {
        JG_PasswordStreamCipher jG_PasswordStreamCipher = (JG_PasswordStreamCipher)super.clone();
        if (this.algaeDigest != null) {
            jG_PasswordStreamCipher.algaeDigest = (JA_AlgaeDigest)this.algaeDigest.clone();
        }
        if (this.passwordStandard != null) {
            jG_PasswordStreamCipher.passwordStandard = (JA_PasswordStandard)this.passwordStandard.clone();
        }
        if (this.replacementSalt != null) {
            jG_PasswordStreamCipher.replacementSalt = (byte[])this.replacementSalt.clone();
        }
        return jG_PasswordStreamCipher;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.replaceSalt();
        this.passwordStandard.generateKeyAndIV(this.algaeDigest, null, this.getBlockSize(), jSAFE_SecretKey);
        super.encryptInit(jSAFE_SecretKey, secureRandom);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.replaceSalt();
        this.passwordStandard.generateKeyAndIV(this.algaeDigest, null, this.getBlockSize(), jSAFE_SecretKey);
        super.decryptInit(jSAFE_SecretKey, secureRandom);
    }

    public void encryptReInit() throws JSAFE_InvalidUseException {
        this.replaceSalt();
        super.encryptReInit();
    }

    public void decryptReInit() throws JSAFE_InvalidUseException {
        this.replaceSalt();
        super.decryptReInit();
    }

    private void replaceSalt() {
        int n = this.getState();
        if ((n == 3 || n == 4 || n == 6 || n == 7) && this.replacementSalt != null) {
            this.passwordStandard.setSalt(this.replacementSalt, 0, this.replacementSalt.length);
            this.replacementSalt = null;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.algaeDigest != null) {
            this.algaeDigest.clearSensitiveData();
        }
        if (this.passwordStandard != null) {
            this.passwordStandard.clearSensitiveData();
        }
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

