/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSignature;
import com.rsa.jsafe.JA_SignaturePaddingScheme;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JG_Signature
extends JSAFE_Signature
implements Cloneable,
Serializable {
    private JA_AlgaeDigest algaeDigest;
    private JA_AlgaeSignature algaeSignature;
    private JA_SignaturePaddingScheme paddingScheme;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private int inputBlockSize;
    private int outputBlockSize;
    private int maxInputLen;
    private boolean doUpdate;
    private byte[] unprocessedData;
    private int unprocessedDataLen;
    private int objectState;
    private static final int NOT_INITIALIZED = 1;
    private static final int SIGN_INIT = 2;
    private static final int SIGN_UPDATE = 3;
    private static final int SIGN_FINAL = 4;
    private static final int VERIFY_INIT = 5;
    private static final int VERIFY_UPDATE = 6;
    private static final int VERIFY_FINAL = 7;

    JG_Signature(JA_AlgaeDigest jA_AlgaeDigest, JA_AlgaeSignature jA_AlgaeSignature, JA_SignaturePaddingScheme jA_SignaturePaddingScheme) {
        this.algaeDigest = jA_AlgaeDigest;
        this.algaeSignature = jA_AlgaeSignature;
        this.paddingScheme = jA_SignaturePaddingScheme;
        this.objectState = 1;
    }

    protected JG_Signature() {
    }

    protected byte[] getDERAlgID(String string, boolean bl) throws JSAFE_UnimplementedException {
        if (this.algaeSignature != null) {
            return this.algaeSignature.getDERAlgorithmID(this.algaeDigest, this.paddingScheme, string, bl);
        }
        return null;
    }

    protected void setAlgBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        this.algaeSignature.setAlgorithmBER(byArray, n);
    }

    public String getSignatureAlgorithm() {
        return this.algaeSignature.getAlgorithm();
    }

    public String getDigestAlgorithm() {
        return this.algaeDigest.getAlgorithm();
    }

    public String getPaddingScheme() {
        if (this.paddingScheme == null) {
            return "NoPad";
        }
        return this.paddingScheme.getPaddingScheme();
    }

    protected int doGetMaxInputLen() {
        return this.maxInputLen;
    }

    protected int doGetSignatureSize() {
        return this.outputBlockSize;
    }

    protected String doSignInit(JSAFE_PrivateKey jSAFE_PrivateKey, JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray, int[] nArray) {
        String string = null;
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (jSAFE_Parameters != null) {
            nArray[0] = 2;
            string = this.algaeSignature.setSignatureParameters(jSAFE_Parameters);
            if (string != null) {
                return string;
            }
        }
        if (this.random == null) {
            nArray[0] = 3;
            if (this.paddingScheme.needRandom() || this.algaeSignature.needRandom()) {
                return "This operation needs a random object.";
            }
        }
        this.algaeDigest.digestInit();
        nArray[0] = 1;
        string = this.algaeSignature.signInit(jSAFE_PrivateKey, this.algaeDigest, this.paddingScheme, secureRandom, jSAFE_SessionArray);
        if (string != null) {
            return string;
        }
        this.algaeSignature.obfuscate();
        this.doUpdate = true;
        if (this.algaeSignature.doesSignUpdate()) {
            this.doUpdate = false;
        }
        this.inputBlockSize = this.algaeSignature.getInputBlockSize();
        this.outputBlockSize = this.algaeSignature.getSignatureBlockSize();
        this.maxInputLen = this.algaeDigest.getAlgorithm().equals("NoDigest") && this.paddingScheme.getPaddingScheme().equals("NoPad") ? this.inputBlockSize : this.algaeSignature.getMaxInputLen();
        if (this.maxInputLen == 0) {
            return "Invalid Key Length";
        }
        if (this.unprocessedData != null) {
            this.overwrite(this.unprocessedData);
            this.unprocessedData = null;
        }
        this.unprocessedDataLen = 0;
        if (this.maxInputLen > 0) {
            this.unprocessedData = this.inputBlockSize > this.maxInputLen ? new byte[this.inputBlockSize] : new byte[this.maxInputLen];
        }
        this.objectState = 2;
        return null;
    }

    protected void doSignReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: 
            case 4: {
                this.unprocessedDataLen = 0;
                this.algaeDigest.digestInit();
                this.algaeSignature.signReInit();
                this.objectState = 2;
                return;
            }
            case 5: 
            case 6: 
            case 7: {
                throw new JSAFE_InvalidUseException("Object not initialized for signing");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized");
    }

    protected void doSignUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                if (n2 <= 0) {
                    return;
                }
                if (!this.doUpdate) {
                    this.algaeSignature.signUpdate(byArray, n, n2);
                    return;
                }
                if (this.unprocessedData == null) {
                    this.algaeDigest.digestUpdate(byArray, n, n2);
                    this.objectState = 3;
                    return;
                }
                if (this.unprocessedDataLen + n2 > this.maxInputLen) {
                    throw new JSAFE_InputException("Invalid input length. Maximum: " + this.maxInputLen + " bytes.");
                }
                System.arraycopy(byArray, n, this.unprocessedData, this.unprocessedDataLen, n2);
                this.unprocessedDataLen += n2;
                this.objectState = 3;
                return;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for verification");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    protected int doSignFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                if (this.doUpdate && this.unprocessedData == null) {
                    this.unprocessedData = new byte[this.inputBlockSize];
                    this.unprocessedDataLen = this.algaeDigest.digestFinal(this.unprocessedData, 0);
                }
                if (this.unprocessedData != null) {
                    this.unprocessedDataLen += this.paddingScheme.performPadding(this.unprocessedData, 0, this.unprocessedDataLen, this.inputBlockSize, this.algaeDigest, this.random);
                }
                this.algaeSignature.deobfuscate();
                int n2 = this.algaeSignature.sign(this.unprocessedData, 0, this.unprocessedDataLen, this.algaeDigest, this.paddingScheme, byArray, n);
                this.algaeSignature.obfuscate();
                if (n2 == 0) {
                    throw new JSAFE_InputException("Invalid input length");
                }
                if (this.unprocessedData != null) {
                    this.overwrite(this.unprocessedData);
                    this.unprocessedData = null;
                    this.unprocessedDataLen = 0;
                }
                this.objectState = 4;
                return n2;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for verification.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    protected String doVerifyInit(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray, int[] nArray) {
        String string = null;
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (jSAFE_Parameters != null) {
            nArray[0] = 2;
            string = this.algaeSignature.setSignatureParameters(jSAFE_Parameters);
            if (string != null) {
                return string;
            }
        }
        this.algaeDigest.digestInit();
        nArray[0] = 1;
        string = this.algaeSignature.verifyInit(jSAFE_PublicKey, this.algaeDigest, this.paddingScheme, secureRandom, jSAFE_SessionArray);
        if (string != null) {
            return string;
        }
        this.algaeSignature.obfuscate();
        this.doUpdate = true;
        if (this.algaeSignature.doesSignUpdate()) {
            this.doUpdate = false;
        }
        this.inputBlockSize = this.algaeSignature.getInputBlockSize();
        this.maxInputLen = this.algaeDigest.getAlgorithm().equals("NoDigest") && this.paddingScheme.getPaddingScheme().equals("NoPad") ? this.inputBlockSize : this.algaeSignature.getMaxInputLen();
        if (this.maxInputLen == 0) {
            return "Invalid Key Length";
        }
        if (this.unprocessedData != null) {
            this.overwrite(this.unprocessedData);
            this.unprocessedData = null;
        }
        this.unprocessedDataLen = 0;
        if (this.maxInputLen > 0) {
            this.unprocessedData = this.inputBlockSize > this.maxInputLen ? new byte[this.inputBlockSize] : new byte[this.maxInputLen];
        }
        this.objectState = 5;
        return null;
    }

    protected void doVerifyReInit() throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: 
            case 7: {
                this.unprocessedDataLen = 0;
                this.algaeDigest.digestInit();
                this.algaeSignature.verifyReInit();
                this.objectState = 5;
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                throw new JSAFE_InvalidUseException("Object not initialized for verification.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    protected void doVerifyUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                if (n2 <= 0) {
                    return;
                }
                if (!this.doUpdate) {
                    this.algaeSignature.verifyUpdate(byArray, n, n2);
                    return;
                }
                if (this.unprocessedData == null) {
                    this.algaeDigest.digestUpdate(byArray, n, n2);
                    this.objectState = 6;
                    return;
                }
                if (this.unprocessedDataLen + n2 > this.maxInputLen) {
                    throw new JSAFE_InputException("Invalid input length. Maximum: " + this.maxInputLen + " bytes.");
                }
                System.arraycopy(byArray, n, this.unprocessedData, this.unprocessedDataLen, n2);
                this.unprocessedDataLen += n2;
                this.objectState = 6;
                return;
            }
            case 2: 
            case 3: {
                throw new JSAFE_InvalidUseException("Object initialized for signing.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    protected boolean doVerifyFinal(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                if (this.doUpdate && this.unprocessedData == null) {
                    this.unprocessedData = new byte[this.inputBlockSize];
                    this.unprocessedDataLen = this.algaeDigest.digestFinal(this.unprocessedData, 0);
                }
                this.algaeSignature.deobfuscate();
                boolean bl = this.algaeSignature.verify(this.unprocessedData, 0, this.unprocessedDataLen, this.algaeDigest, this.paddingScheme, byArray, n, n2);
                this.algaeSignature.obfuscate();
                this.overwrite(this.unprocessedData);
                this.unprocessedDataLen = 0;
                this.unprocessedData = null;
                this.objectState = 7;
                return bl;
            }
            case 2: 
            case 3: {
                throw new JSAFE_InvalidUseException("Object initialized for signing");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JG_Signature jG_Signature = new JG_Signature();
        if (this.algaeDigest != null) {
            jG_Signature.algaeDigest = (JA_AlgaeDigest)this.algaeDigest.clone();
        }
        if (this.algaeSignature != null) {
            jG_Signature.algaeSignature = (JA_AlgaeSignature)this.algaeSignature.clone();
        }
        if (this.paddingScheme != null) {
            jG_Signature.paddingScheme = (JA_SignaturePaddingScheme)this.paddingScheme.clone();
        }
        jG_Signature.random = this.random;
        jG_Signature.inputBlockSize = this.inputBlockSize;
        jG_Signature.outputBlockSize = this.outputBlockSize;
        jG_Signature.maxInputLen = this.maxInputLen;
        if (this.unprocessedData != null) {
            jG_Signature.unprocessedData = (byte[])this.unprocessedData.clone();
        }
        jG_Signature.unprocessedDataLen = this.unprocessedDataLen;
        jG_Signature.doUpdate = this.doUpdate;
        jG_Signature.objectState = this.objectState;
        jG_Signature.setJSAFELevelValues(this);
        return jG_Signature;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    public void doClearSensitiveData() {
        if (this.algaeSignature != null) {
            this.algaeSignature.clearSensitiveData();
        }
        if (this.algaeDigest != null) {
            this.algaeDigest.clearSensitiveData();
        }
        this.overwrite(this.unprocessedData);
        this.unprocessedData = null;
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

