/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeStreamCipher;
import com.rsa.jsafe.JA_PKCS8;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

class JG_StreamCipher
extends JSAFE_SymmetricCipher
implements Cloneable,
Serializable {
    protected JA_AlgaeStreamCipher algaeStreamCipher;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    private int objectState;
    protected static final int NOT_INITIALIZED = 1;
    protected static final int ENCRYPT_INIT = 2;
    protected static final int ENCRYPT_UPDATE = 3;
    protected static final int ENCRYPT_FINAL = 4;
    protected static final int DECRYPT_INIT = 5;
    protected static final int DECRYPT_UPDATE = 6;
    protected static final int DECRYPT_FINAL = 7;

    JG_StreamCipher(JA_AlgaeStreamCipher jA_AlgaeStreamCipher) {
        this.algaeStreamCipher = jA_AlgaeStreamCipher;
        this.objectState = 1;
    }

    protected JG_StreamCipher() {
    }

    void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        this.algaeStreamCipher.setAlgorithmBER(byArray, n, n2);
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        byte[] byArray = this.algaeStreamCipher.getParamsDER();
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        String string = this.algaeStreamCipher.getAlgorithm();
        try {
            return AlgorithmID.derEncodeAlgID(string, 7, byArray, 0, n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not DER encode given transformation.(" + aSN_Exception.getMessage() + ")");
        }
    }

    protected int getState() {
        return this.objectState;
    }

    public String getEncryptionAlgorithm() {
        return this.algaeStreamCipher.getAlgorithm();
    }

    public int[] getAlgorithmParameters() {
        if (this.algaeStreamCipher != null) {
            return this.algaeStreamCipher.getInstantiationParameters();
        }
        return new int[0];
    }

    public void setAlgorithmParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (this.algaeStreamCipher != null) {
            this.algaeStreamCipher.setInstantiationParameters(nArray);
        }
    }

    public int getOutputBufferSize(int n) {
        return this.algaeStreamCipher.getOutputBufferSize(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JG_StreamCipher jG_StreamCipher = (JG_StreamCipher)super.clone();
        if (this.algaeStreamCipher != null) {
            jG_StreamCipher.algaeStreamCipher = (JA_AlgaeStreamCipher)this.algaeStreamCipher.clone();
        }
        jG_StreamCipher.random = this.random;
        jG_StreamCipher.objectState = this.objectState;
        jG_StreamCipher.setJSAFELevelValues(this);
        return jG_StreamCipher;
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.algaeStreamCipher.encryptInit(jSAFE_SecretKey, secureRandom);
        this.algaeStreamCipher.obfuscate();
        this.random = secureRandom;
        this.objectState = 2;
    }

    public void encryptReInit() throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot re-initialize this object.");
    }

    protected byte[] wrapKeyObject(JSAFE_Key jSAFE_Key, boolean bl, byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        return this.wrapKeyObject(jSAFE_Key, bl, null, byArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] wrapKeyObject(JSAFE_Key jSAFE_Key, boolean bl, String string, byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        Object object;
        int n3;
        byte[] byArray2;
        block11: {
            if (this.objectState != 2) {
                throw new JSAFE_InvalidUseException("Cannot wrap key, object needs new initialization.");
            }
            byArray2 = null;
            n3 = 0;
            if (this.algaeStreamCipher.canWrapKey(bl)) {
                byArray2 = this.algaeStreamCipher.wrapKey(jSAFE_Key, bl, null, null);
                n3 = byArray2.length;
                this.objectState = 4;
            } else {
                object = null;
                try {
                    try {
                        String string2 = string != null ? string : jSAFE_Key.getKeyWrappingFormat(bl);
                        object = jSAFE_Key.getKeyData(string2);
                        n3 = this.getOutputBufferSize(object[0].length);
                        byArray2 = new byte[n3];
                        n3 = this.encryptUpdate(object[0], 0, object[0].length, byArray2, 0);
                        n3 += this.encryptFinal(byArray2, n3);
                    }
                    catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                        throw new JSAFE_InvalidUseException("The key given cannot be wrapped.");
                    }
                    Object var12_12 = null;
                    if (object == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (object != null && (object).length > 0) {
                        JSAFE_Obfuscator.overwrite(object[0]);
                    }
                    throw throwable;
                }
                if (((byte[][])object).length > 0) {
                    JSAFE_Obfuscator.overwrite(object[0]);
                }
            }
        }
        if (bl) {
            return JA_PKCS8.buildEncryptedKeyInfo(byArray, n, n2, byArray2, 0, n3);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        object = new byte[n3];
        System.arraycopy(byArray2, 0, object, 0, n3);
        return object;
    }

    public int encryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                if (n2 <= 0) {
                    return 0;
                }
                this.algaeStreamCipher.deobfuscate();
                int n4 = this.algaeStreamCipher.encryptUpdate(byArray, n, n2, byArray2, n3);
                this.objectState = 3;
                this.algaeStreamCipher.obfuscate();
                return n4;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for decryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int encryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 2: 
            case 3: {
                this.algaeStreamCipher.deobfuscate();
                int n2 = this.algaeStreamCipher.encryptFinal(byArray, n);
                this.objectState = 4;
                this.algaeStreamCipher.obfuscate();
                return n2;
            }
            case 5: 
            case 6: {
                throw new JSAFE_InvalidUseException("Object initialized for decryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.algaeStreamCipher.decryptInit(jSAFE_SecretKey, secureRandom);
        this.algaeStreamCipher.obfuscate();
        this.random = secureRandom;
        this.objectState = 5;
    }

    public void decryptReInit() throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Cannot re-initialize this object.");
    }

    /*
     * Exception decompiling
     */
    public JSAFE_PrivateKey unwrapPrivateKey(byte[] var1_1, int var2_2, int var3_3, boolean var4_4, String var5_5) throws JSAFE_InvalidUseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, boolean bl, String string) throws JSAFE_InvalidUseException {
        Object[] objectArray;
        if (this.objectState != 5) {
            throw new JSAFE_InvalidUseException("Cannot unwrap key, object needs new initialization.");
        }
        if (string == null) {
            string = this.getDevice();
        }
        if (bl) {
            objectArray = JA_PKCS8.getEncryptedKeyInfo(byArray, n);
            n = objectArray[0];
            n2 = objectArray[1];
        }
        if (this.algaeStreamCipher.canWrapKey(false)) {
            this.objectState = 7;
            return this.algaeStreamCipher.unwrapPublicKey(byArray, n, n2, null, null, string);
        }
        try {
            objectArray = new byte[this.getOutputBufferSize(n2)];
            int n3 = this.decryptUpdate(byArray, n, n2, (byte[])objectArray, 0);
            n3 += this.decryptFinal((byte[])objectArray, n3);
            JSAFE_PublicKey jSAFE_PublicKey = JSAFE_PublicKey.getInstance((byte[])objectArray, 0, string);
            return jSAFE_PublicKey;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidUseException("Could not unwrap public key.");
        }
    }

    /*
     * Exception decompiling
     */
    public JSAFE_SecretKey unwrapSecretKey(byte[] var1_1, int var2_2, int var3_3, boolean var4_4, String var5_5, String var6_6) throws JSAFE_InvalidUseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int decryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                if (n2 <= 0) {
                    return 0;
                }
                this.algaeStreamCipher.deobfuscate();
                int n4 = this.algaeStreamCipher.decryptUpdate(byArray, n, n2, byArray2, n3);
                this.objectState = 6;
                this.algaeStreamCipher.obfuscate();
                return n4;
            }
            case 2: 
            case 3: {
                throw new JSAFE_InvalidUseException("Object initialized for encryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public int decryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException {
        switch (this.objectState) {
            case 5: 
            case 6: {
                this.algaeStreamCipher.deobfuscate();
                int n2 = this.algaeStreamCipher.decryptFinal(byArray, n);
                this.objectState = 7;
                this.algaeStreamCipher.obfuscate();
                return n2;
            }
            case 2: 
            case 3: {
                throw new JSAFE_InvalidUseException("Object initialized for encryption.");
            }
        }
        throw new JSAFE_InvalidUseException("Object not initialized.");
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.algaeStreamCipher != null) {
            this.algaeStreamCipher.clearSensitiveData();
        }
        this.objectState = 1;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

