/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeAsymmetricCipher;
import com.rsa.jsafe.JA_AsymmetricAlgID;
import com.rsa.jsafe.JA_AsymmetricPaddingScheme;
import com.rsa.jsafe.JA_MGF1;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_MaskGeneratingFunction;
import com.rsa.jsafe.JA_NoPad;
import com.rsa.jsafe.JA_OAEPDigest;
import com.rsa.jsafe.JA_OAEPPaddingScheme;
import com.rsa.jsafe.JA_OAEPParameterSource;
import com.rsa.jsafe.JA_PKCS1Block02Pad;
import com.rsa.jsafe.JA_PKCS1V2OAEPPad;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_RSA;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JA_SpecifiedParams;
import com.rsa.jsafe.JA_X931Pad;
import com.rsa.jsafe.JG_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_AsymmetricCipher
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private JSAFE_AsymmetricCipher[] allObjects;
    private int chosenIndex;
    private static final boolean[] strictRegular = new boolean[]{true, false};
    private static final String[] interfaceRegular = new String[]{"com.rsa.jsafe.JA_AlgaeAsymmetricCipher", "com.rsa.jsafe.JA_AsymmetricPaddingScheme"};
    private static boolean[] strictUnknownPad = new boolean[]{true};
    private static String[] interfaceUnknownPad = new String[]{"com.rsa.jsafe.JA_AlgaeAsymmetricCipher"};
    private static boolean[] strictPad = new boolean[]{false};
    private static String[] interfacePad = new String[]{"com.rsa.jsafe.JA_AsymmetricPaddingScheme"};
    private static boolean[] strictOAEP = new boolean[]{true, false, true, false, true, false};
    private static String[] interfaceOAEP = new String[]{"com.rsa.jsafe.JA_AlgaeAsymmetricCipher", "com.rsa.jsafe.JA_OAEPPaddingScheme", "com.rsa.jsafe.JA_OAEPDigest", "com.rsa.jsafe.JA_MaskGeneratingFunction", "com.rsa.jsafe.JA_MGFUnderlyingAlgorithm", "com.rsa.jsafe.JA_OAEPParameterSource"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_AsymmetricCipher";

    public static JSAFE_AsymmetricCipher getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JA_AsymmetricAlgID jA_AsymmetricAlgID = new JA_AsymmetricAlgID();
        jA_AsymmetricAlgID.decodeAlgID(byArray, n);
        JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance(jA_AsymmetricAlgID.transformation, string);
        jSAFE_AsymmetricCipher.setAlgorithmBER(byArray, n);
        if (jA_AsymmetricAlgID.paramsP != null) {
            jSAFE_AsymmetricCipher.setOAEPParameters(jA_AsymmetricAlgID.paramsP, jA_AsymmetricAlgID.paramsPOffset, jA_AsymmetricAlgID.paramsPLen);
        }
        return jSAFE_AsymmetricCipher;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, 2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (this.allObjects == null) {
            this.setAlgBER(byArray, n);
            return;
        }
        int n2 = 0;
        while (n2 < this.allObjects.length) {
            if (this.allObjects[n2] != null) {
                this.allObjects[n2].setAlgBER(byArray, n);
            }
            ++n2;
        }
    }

    protected abstract void setAlgBER(byte[] var1, int var2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException;

    /*
     * Unable to fully structure code
     */
    public static JSAFE_AsymmetricCipher getInstance(String var0, String var1_1) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (var1_1 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (var0 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        var2_2 = JA_ParseList.parseElements(var1_1);
        var3_3 = new JSAFE_DeviceBuilder[var2_2.length];
        var4_4 = new JSAFE_AsymmetricCipher[var2_2.length];
        var5_5 = JA_ParseList.parseElements(var0);
        var6_6 = 0;
        while (var6_6 < var2_2.length) {
            block14: {
                if (var3_3[var6_6] == null) {
                    var3_3[var6_6] = JA_ParseDevice.getDeviceObject(var2_2[var6_6]);
                }
                try {
                    var7_7 = JSAFE_AsymmetricCipher.getInstance(var5_5, var2_2, var3_3[var6_6], var3_3);
                    if (var7_7 != null) {
                        var7_7.theDevice = var3_3[var6_6].getDevice();
                        if (var7_7.theDeviceList == null) {
                            var7_7.theDeviceList = var3_3[var6_6].getDeviceList();
                        }
                        var4_4[var6_6] = var7_7;
                    }
                    break block14;
                }
                catch (JSAFE_InvalidParameterException var7_8) {
                    if (var6_6 < var2_2.length) break block14;
                    var8_10 = 0;
                    ** while (var8_10 < var4_4.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (var4_4[var8_10] != null) break;
                    ++var8_10;
                    continue;
                }
lbl29:
                // 2 sources

                if (var8_10 >= var4_4.length) {
                    throw var7_8;
                }
            }
            ++var6_6;
        }
        var7_9 = 0;
        var8_10 = -1;
        while (var7_9 < var4_4.length) {
            if (var4_4[var7_9] != null) {
                if (var8_10 == -1) {
                    var8_10 = var7_9;
                    var4_4[var8_10].allObjects = var4_4;
                }
                var4_4[var7_9].chosenIndex = -1;
            }
            ++var7_9;
        }
        if (var8_10 != -1) {
            return var4_4[var8_10];
        }
        throw new JSAFE_UnimplementedException("A JSAFE_AsymmetricCipher object of " + var0 + " is not available on any of the devices. (" + var1_1 + ")");
    }

    private static JSAFE_AsymmetricCipher getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length == 1) {
            return JSAFE_AsymmetricCipher.getInstanceUnknownPadding(stringArray, stringArray2, jSAFE_DeviceBuilder, jSAFE_DeviceBuilderArray);
        }
        if (stringArray.length == 6) {
            return JSAFE_AsymmetricCipher.getInstanceOAEP(stringArray, stringArray2, jSAFE_DeviceBuilder, jSAFE_DeviceBuilderArray);
        }
        if (stringArray.length != 2) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 0, strictRegular, interfaceRegular, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_AsymmetricCipher) {
            return (JSAFE_AsymmetricCipher)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeAsymmetricCipher)objectArray[0]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[1]);
        ((JA_AsymmetricPaddingScheme)objectArray[1]).setInstantiationParameters(nArray);
        return new JG_AsymmetricCipher((JA_AlgaeAsymmetricCipher)objectArray[0], (JA_AsymmetricPaddingScheme)objectArray[1]);
    }

    private static JSAFE_AsymmetricCipher getInstanceUnknownPadding(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 0, strictUnknownPad, interfaceUnknownPad, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_AsymmetricCipher) {
            return (JSAFE_AsymmetricCipher)objectArray[0];
        }
        String[] stringArray3 = new String[2];
        stringArray3[0] = jSAFE_DeviceBuilder.getDeviceList()[0];
        JA_AlgaeAsymmetricCipher jA_AlgaeAsymmetricCipher = (JA_AlgaeAsymmetricCipher)objectArray[0];
        String string = jA_AlgaeAsymmetricCipher.getDefaultCipherPaddingName();
        String[] stringArray4 = new String[]{string};
        Object[] objectArray2 = jSAFE_DeviceBuilder.buildObjects(stringArray4, null, 0, strictPad, interfacePad, null, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray2 == null) {
            return null;
        }
        stringArray3[1] = jSAFE_DeviceBuilder.getDeviceList()[0];
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeAsymmetricCipher)objectArray[0]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(string);
        ((JA_AsymmetricPaddingScheme)objectArray2[0]).setInstantiationParameters(nArray);
        JG_AsymmetricCipher jG_AsymmetricCipher = new JG_AsymmetricCipher((JA_AlgaeAsymmetricCipher)objectArray[0], (JA_AsymmetricPaddingScheme)objectArray2[0]);
        jG_AsymmetricCipher.theDeviceList = stringArray3;
        return jG_AsymmetricCipher;
    }

    private static JSAFE_AsymmetricCipher getInstanceOAEP(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 0, strictOAEP, interfaceOAEP, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_AsymmetricCipher) {
            return (JSAFE_AsymmetricCipher)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeAsymmetricCipher)objectArray[0]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[1]);
        ((JA_OAEPPaddingScheme)objectArray[1]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[2]);
        ((JA_OAEPDigest)objectArray[2]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[3]);
        ((JA_MaskGeneratingFunction)objectArray[3]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[4]);
        ((JA_MGFUnderlyingAlgorithm)objectArray[4]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[5]);
        ((JA_OAEPParameterSource)objectArray[5]).setInstantiationParameters(nArray);
        ((JA_MaskGeneratingFunction)objectArray[3]).setUnderlyingAlgorithm((JA_MGFUnderlyingAlgorithm)objectArray[4]);
        ((JA_OAEPPaddingScheme)objectArray[1]).setOAEPComponents((JA_OAEPDigest)objectArray[2], (JA_MaskGeneratingFunction)objectArray[3], (JA_OAEPParameterSource)objectArray[5]);
        return new JG_AsymmetricCipher((JA_AlgaeAsymmetricCipher)objectArray[0], (JA_AsymmetricPaddingScheme)objectArray[1]);
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        if (this.allObjects == null) {
            return this.getDERAlgID();
        }
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].getDERAlgID();
        }
        int n = 0;
        while (n < this.allObjects.length) {
            block6: {
                try {
                    if (this.allObjects[n] != null) {
                        return this.allObjects[n].getDERAlgID();
                    }
                }
                catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                    if (n != this.allObjects.length - 1) break block6;
                    throw jSAFE_UnimplementedException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("Unknown Alg ID");
    }

    protected abstract byte[] getDERAlgID() throws JSAFE_UnimplementedException;

    public String getDevice() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].theDevice;
        }
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = null;
        int n = 0;
        if (this.chosenIndex == -1) {
            stringArray = new String[this.theDeviceList.length];
            while (n < this.theDeviceList.length) {
                stringArray[n] = this.theDeviceList[n];
                ++n;
            }
        } else {
            stringArray = new String[this.allObjects[this.chosenIndex].theDeviceList.length];
            while (n < this.allObjects[this.chosenIndex].theDeviceList.length) {
                stringArray[n] = this.allObjects[this.chosenIndex].theDeviceList[n];
                ++n;
            }
        }
        return stringArray;
    }

    public abstract void setOAEPParameters(byte[] var1, int var2, int var3);

    public abstract byte[] getOAEPParameters();

    public abstract String getEncryptionAlgorithm();

    public abstract String getPaddingScheme();

    public abstract String getOAEPDigestAlgorithm();

    public abstract String getOAEPMaskGeneratingFunction();

    public abstract String getOAEPMaskUnderlyingAlgorithm();

    public abstract String getOAEPParameterSource();

    public int getMaxInputLen() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].doGetMaxInputLen();
        }
        return this.doGetMaxInputLen();
    }

    protected abstract int doGetMaxInputLen();

    public int getInputBlockSize() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].doGetInputBlockSize();
        }
        return this.doGetInputBlockSize();
    }

    protected abstract int doGetInputBlockSize();

    public int getOutputBlockSize() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].doGetOutputBlockSize();
        }
        return this.doGetOutputBlockSize();
    }

    protected abstract int doGetOutputBlockSize();

    public int getOutputBufferSize(int n) {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].doGetOutputBufferSize(n);
        }
        return this.doGetOutputBufferSize(n);
    }

    protected abstract int doGetOutputBufferSize(int var1);

    public JSAFE_KeyPair getBlankKeyPair() {
        String string = this.getEncryptionAlgorithm();
        String string2 = this.getDevice();
        try {
            return JSAFE_KeyPair.getInstance(string, string2);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            return null;
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            return null;
        }
    }

    public abstract int[] getAlgorithmParameters();

    public int[] getPaddingParameters() {
        return new int[0];
    }

    public void encryptInit(JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.encryptInit(jSAFE_PublicKey, null, null);
    }

    public void encryptInit(JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.encryptInit(jSAFE_PublicKey, secureRandom, null);
    }

    public void encryptInit(JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        int[] nArray = new int[1];
        String string = null;
        if (this.allObjects == null) {
            string = this.doEncryptInit(jSAFE_PublicKey, secureRandom, jSAFE_SessionArray, nArray);
            if (string == null) {
                return;
            }
        } else {
            this.chosenIndex = -1;
            int n = 0;
            while (n < this.allObjects.length) {
                if (this.allObjects[n] != null && (string = this.allObjects[n].doEncryptInit(jSAFE_PublicKey, secureRandom, jSAFE_SessionArray, nArray)) == null) {
                    this.chosenIndex = n;
                    return;
                }
                ++n;
            }
        }
        switch (nArray[0]) {
            case 1: {
                throw new JSAFE_InvalidKeyException(string);
            }
        }
        throw new JSAFE_InvalidUseException(string);
    }

    protected abstract String doEncryptInit(JSAFE_PublicKey var1, SecureRandom var2, JSAFE_Session[] var3, int[] var4);

    public void encryptReInit() throws JSAFE_InvalidUseException {
        if (this.allObjects == null) {
            this.doEncryptReInit();
            return;
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot encryptReInit, not initialized.");
        }
        this.allObjects[this.chosenIndex].doEncryptReInit();
    }

    protected abstract void doEncryptReInit() throws JSAFE_InvalidUseException;

    public byte[] wrapSecretKey(JSAFE_SecretKey jSAFE_SecretKey, boolean bl) throws JSAFE_InvalidUseException {
        if (this.allObjects == null) {
            return this.doWrapSecretKey(jSAFE_SecretKey, bl);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        return this.allObjects[this.chosenIndex].doWrapSecretKey(jSAFE_SecretKey, bl);
    }

    protected abstract byte[] doWrapSecretKey(JSAFE_SecretKey var1, boolean var2) throws JSAFE_InvalidUseException;

    public byte[] encryptUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        int n3 = this.getOutputBufferSize(n2);
        byte[] byArray2 = new byte[n3];
        if ((n3 = this.encryptUpdate(byArray, n, n2, byArray2, 0)) == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray3[n4] = byArray2[n4];
            ++n4;
        }
        this.overwrite(byArray2);
        return byArray3;
    }

    public int encryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException, JSAFE_InputException {
        if (this.allObjects == null) {
            return this.doEncryptUpdate(byArray, n, n2, byArray2, n3);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot encryptUpdate, not initialized.");
        }
        return this.allObjects[this.chosenIndex].doEncryptUpdate(byArray, n, n2, byArray2, n3);
    }

    protected abstract int doEncryptUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException, JSAFE_InputException;

    public byte[] encryptFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        int n = this.getOutputBufferSize(0);
        byte[] byArray = new byte[n];
        if ((n = this.encryptFinal(byArray, 0)) == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        this.overwrite(byArray);
        return byArray2;
    }

    public int encryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        if (this.allObjects == null) {
            return this.doEncryptFinal(byArray, n);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot encryptFinal, not initialized.");
        }
        return this.allObjects[this.chosenIndex].doEncryptFinal(byArray, n);
    }

    protected abstract int doEncryptFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException;

    public void decryptInit(JSAFE_PrivateKey jSAFE_PrivateKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        this.decryptInit(jSAFE_PrivateKey, null);
    }

    public void decryptInit(JSAFE_PrivateKey jSAFE_PrivateKey, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        int[] nArray = new int[1];
        String string = null;
        if (this.allObjects == null) {
            string = this.doDecryptInit(jSAFE_PrivateKey, jSAFE_SessionArray, nArray);
            if (string == null) {
                return;
            }
        } else {
            this.chosenIndex = -1;
            int n = 0;
            while (n < this.allObjects.length) {
                if (this.allObjects[n] != null && (string = this.allObjects[n].doDecryptInit(jSAFE_PrivateKey, jSAFE_SessionArray, nArray)) == null) {
                    this.chosenIndex = n;
                    return;
                }
                ++n;
            }
        }
        switch (nArray[0]) {
            case 1: {
                throw new JSAFE_InvalidKeyException(string);
            }
        }
        throw new JSAFE_InvalidUseException(string);
    }

    protected abstract String doDecryptInit(JSAFE_PrivateKey var1, JSAFE_Session[] var2, int[] var3);

    public void decryptReInit() throws JSAFE_InvalidUseException {
        if (this.allObjects == null) {
            this.doDecryptReInit();
            return;
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot decryptReInit, not initialized.");
        }
        this.allObjects[this.chosenIndex].doDecryptReInit();
    }

    protected abstract void doDecryptReInit() throws JSAFE_InvalidUseException;

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, String string) throws JSAFE_InvalidUseException {
        return this.unwrapSecretKey(byArray, n, n2, bl, string, null);
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, String string, String string2) throws JSAFE_InvalidUseException {
        if (this.allObjects == null) {
            return this.doUnwrapSecretKey(byArray, n, n2, bl, string, string2);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        return this.allObjects[this.chosenIndex].doUnwrapSecretKey(byArray, n, n2, bl, string, string2);
    }

    protected abstract JSAFE_SecretKey doUnwrapSecretKey(byte[] var1, int var2, int var3, boolean var4, String var5, String var6) throws JSAFE_InvalidUseException;

    public byte[] decryptUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        int n3 = this.getOutputBufferSize(n2);
        byte[] byArray2 = new byte[n3];
        if ((n3 = this.decryptUpdate(byArray, n, n2, byArray2, 0)) == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray3[n4] = byArray2[n4];
            ++n4;
        }
        this.overwrite(byArray2);
        return byArray3;
    }

    public int decryptUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws JSAFE_InvalidUseException, JSAFE_InputException {
        if (this.allObjects == null) {
            return this.doDecryptUpdate(byArray, n, n2, byArray2, n3);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot decryptUpdate, not initialized.");
        }
        return this.allObjects[this.chosenIndex].doDecryptUpdate(byArray, n, n2, byArray2, n3);
    }

    protected abstract int doDecryptUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException, JSAFE_InputException;

    public byte[] decryptFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        int n = this.getOutputBufferSize(0);
        byte[] byArray = new byte[n];
        if ((n = this.decryptFinal(byArray, 0)) == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        this.overwrite(byArray);
        return byArray2;
    }

    public int decryptFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        if (this.allObjects == null) {
            return this.doDecryptFinal(byArray, n);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot decryptFinal, not initialized.");
        }
        return this.allObjects[this.chosenIndex].doDecryptFinal(byArray, n);
    }

    protected abstract int doDecryptFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException;

    protected void setJSAFELevelValues(JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher) {
        this.theDevice = jSAFE_AsymmetricCipher.theDevice;
        this.theDeviceList = new String[jSAFE_AsymmetricCipher.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_AsymmetricCipher.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_AsymmetricCipher.theDeviceList[n];
            ++n;
        }
        this.chosenIndex = jSAFE_AsymmetricCipher.chosenIndex;
        if (jSAFE_AsymmetricCipher.allObjects != null) {
            this.allObjects = new JSAFE_AsymmetricCipher[jSAFE_AsymmetricCipher.allObjects.length];
            boolean bl = false;
            try {
                int n2 = 0;
                while (n2 < jSAFE_AsymmetricCipher.allObjects.length) {
                    if (jSAFE_AsymmetricCipher.allObjects[n2] != null) {
                        if (!bl) {
                            this.allObjects[n2] = this;
                            bl = true;
                        } else {
                            this.allObjects[n2] = (JSAFE_AsymmetricCipher)jSAFE_AsymmetricCipher.allObjects[n2].clone();
                        }
                    }
                    ++n2;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.allObjects == null) {
            this.doClearSensitiveData();
        } else {
            int n = 0;
            while (n < this.allObjects.length) {
                if (this.allObjects[n] != null) {
                    this.allObjects[n].doClearSensitiveData();
                }
                ++n;
            }
        }
        this.chosenIndex = -1;
    }

    protected abstract void doClearSensitiveData();

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            switch (n) {
                case 0: {
                    if (stringArray[n].startsWith("RSA", 0)) {
                        return new JA_RSA();
                    }
                }
                case 1: {
                    if (stringArray[n].startsWith("PKCS1Block02Pad", 0)) {
                        return new JA_PKCS1Block02Pad();
                    }
                    if (stringArray[n].startsWith("PKCS1V2OAEPPad", 0)) {
                        return new JA_PKCS1V2OAEPPad();
                    }
                    if (stringArray[n].startsWith("X931Pad", 0)) {
                        return new JA_X931Pad();
                    }
                    if (stringArray[n].startsWith("NoPad", 0)) {
                        return new JA_NoPad();
                    }
                    return null;
                }
                case 2: {
                    if (stringArray[n].startsWith("SHA1", 0)) {
                        return new JA_SHA1();
                    }
                    return null;
                }
                case 3: {
                    if (stringArray[n].startsWith("MGF1", 0)) {
                        return new JA_MGF1();
                    }
                    return null;
                }
                case 4: {
                    if (stringArray[n].startsWith("SHA1", 0)) {
                        return new JA_SHA1();
                    }
                    return null;
                }
                case 5: {
                    if (!stringArray[n].startsWith("SpecifiedParams", 0)) break;
                    return new JA_SpecifiedParams();
                }
            }
            return null;
        }
    }
}

