/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeKeyAgree;
import com.rsa.jsafe.JA_DH;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JG_KeyAgree;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_KeyAgree
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private static final boolean[] strict = new boolean[]{true};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JA_AlgaeKeyAgree"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_KeyAgree";

    public static JSAFE_KeyAgree getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        String string2 = null;
        try {
            string2 = AlgorithmID.berDecodeAlgID(byArray, n, 5, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
        JSAFE_KeyAgree jSAFE_KeyAgree = JSAFE_KeyAgree.getInstance(string2, string);
        jSAFE_KeyAgree.setAlgorithmBER(byArray, n);
        return jSAFE_KeyAgree;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, 5);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        throw new JSAFE_UnimplementedException("Cannot instantiate, unknown BER algorithm ID.");
    }

    public static JSAFE_KeyAgree getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                if (jSAFE_DeviceBuilderArray[n] == null) {
                    jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
                }
                try {
                    JSAFE_KeyAgree jSAFE_KeyAgree = JSAFE_KeyAgree.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                    if (jSAFE_KeyAgree != null) {
                        jSAFE_KeyAgree.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                        jSAFE_KeyAgree.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                        return jSAFE_KeyAgree;
                    }
                }
                catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                    if (n < stringArray.length) break block7;
                    throw jSAFE_InvalidParameterException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_KeyAgree object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_KeyAgree getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length != 1) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 1, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_KeyAgree) {
            return (JSAFE_KeyAgree)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeKeyAgree)objectArray[0]).setInstantiationParameters(nArray);
        return new JG_KeyAgree((JA_AlgaeKeyAgree)objectArray[0]);
    }

    public abstract byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException;

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getKeyAgreeAlgorithm();

    public abstract JSAFE_Parameters getSharedParameters() throws JSAFE_InvalidUseException;

    public JSAFE_KeyPair getBlankKeyPair() {
        String string = this.getKeyAgreeAlgorithm();
        try {
            JSAFE_KeyPair jSAFE_KeyPair = JSAFE_KeyPair.getInstance(string, this.theDevice);
            return jSAFE_KeyPair;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            return null;
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            return null;
        }
    }

    public abstract int getOutputSize();

    public abstract void keyAgreeInit(SecureRandom var1) throws JSAFE_InvalidUseException;

    public abstract void keyAgreeInit(JSAFE_Parameters var1, SecureRandom var2) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException;

    public abstract void keyAgreeInit(JSAFE_Parameters var1, JSAFE_PublicKey var2, SecureRandom var3) throws JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException;

    public abstract void keyAgreeInit(JSAFE_PublicKey var1, SecureRandom var2) throws JSAFE_InvalidKeyException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException;

    public abstract void keyAgreeInit(JSAFE_Parameters var1, JSAFE_PrivateKey var2, SecureRandom var3) throws JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException;

    public abstract void keyAgreeInit(JSAFE_PrivateKey var1, SecureRandom var2) throws JSAFE_InvalidKeyException, JSAFE_InvalidParameterException, JSAFE_InvalidUseException;

    public abstract void keyAgreeReInit() throws JSAFE_InvalidUseException;

    public byte[] keyAgreePhase1() throws JSAFE_InvalidUseException {
        int n = this.getOutputSize();
        byte[] byArray = new byte[n];
        int n2 = this.keyAgreePhase1(byArray, 0);
        if (n2 == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3];
            byArray[n3] = 0;
            ++n3;
        }
        return byArray2;
    }

    public abstract int keyAgreePhase1(byte[] var1, int var2) throws JSAFE_InvalidUseException;

    public abstract JSAFE_PublicKey generateMyPublicValue() throws JSAFE_InvalidUseException;

    public byte[] keyAgreePhase2(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        int n3 = this.getOutputSize();
        byte[] byArray2 = new byte[n3];
        int n4 = this.keyAgreePhase2(byArray, n, n2, byArray2, 0);
        if (n4 == n3) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        while (n5 < n4) {
            byArray3[n5] = byArray2[n5];
            byArray2[n5] = 0;
            ++n5;
        }
        return byArray3;
    }

    public abstract int keyAgreePhase2(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException;

    public byte[] generateSharedSecret() throws JSAFE_InvalidUseException {
        int n = this.getOutputSize();
        byte[] byArray = new byte[n];
        int n2 = this.generateSharedSecret(byArray, 0);
        if (n2 == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3];
            byArray[n3] = 0;
            ++n3;
        }
        return byArray2;
    }

    public abstract int generateSharedSecret(byte[] var1, int var2) throws JSAFE_InvalidUseException;

    public byte[] generateSharedSecret(JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        int n = this.getOutputSize();
        byte[] byArray = new byte[n];
        int n2 = this.generateSharedSecret(jSAFE_PublicKey, byArray, 0);
        if (n2 == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3];
            byArray[n3] = 0;
            ++n3;
        }
        return byArray2;
    }

    public abstract int generateSharedSecret(JSAFE_PublicKey var1, byte[] var2, int var3) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException;

    public byte[] getPrivateValue() throws JSAFE_InvalidUseException {
        int n = this.getOutputSize();
        byte[] byArray = new byte[n];
        int n2 = this.getPrivateValue(byArray, 0);
        if (n2 == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3];
            byArray[n3] = 0;
            ++n3;
        }
        return byArray2;
    }

    public abstract int getPrivateValue(byte[] var1, int var2) throws JSAFE_InvalidUseException;

    public abstract JSAFE_PrivateKey getPrivateValueAsKey() throws JSAFE_InvalidUseException;

    protected void setJSAFELevelValues(JSAFE_KeyAgree jSAFE_KeyAgree) {
        this.theDevice = jSAFE_KeyAgree.theDevice;
        this.theDeviceList = new String[jSAFE_KeyAgree.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_KeyAgree.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_KeyAgree.theDeviceList[n];
            ++n;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray[n].startsWith("DH", 0)) {
                return new JA_DH();
            }
            return null;
        }
    }
}

