/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeDigestMAC;
import com.rsa.jsafe.JA_HMAC;
import com.rsa.jsafe.JA_MD5;
import com.rsa.jsafe.JA_PKCS12PBE;
import com.rsa.jsafe.JA_PKCS12V1PBE;
import com.rsa.jsafe.JA_PKIXPBE;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JG_DigestMAC;
import com.rsa.jsafe.JG_PasswordDigestMAC;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_MAC
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private static boolean[] strict = new boolean[]{true, true, true};
    private static String[] interfaceList = new String[]{"com.rsa.jsafe.JA_AlgaeDigestMAC", "com.rsa.jsafe.JA_AlgaeDigest", "com.rsa.jsafe.JA_PasswordStandard"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_MAC";

    public static JSAFE_MAC getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        String string2 = null;
        try {
            string2 = AlgorithmID.berDecodeAlgID(byArray, n, 10, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
        JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance(string2, string);
        jSAFE_MAC.setAlgorithmBER(byArray, n);
        return jSAFE_MAC;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, -1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        throw new JSAFE_UnimplementedException("Cannot instantiate, unknown BER algorithm ID.");
    }

    public static JSAFE_MAC getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                if (jSAFE_DeviceBuilderArray[n] == null) {
                    jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
                }
                try {
                    JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                    if (jSAFE_MAC != null) {
                        jSAFE_MAC.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                        jSAFE_MAC.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                        return jSAFE_MAC;
                    }
                }
                catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                    if (n < stringArray.length) break block7;
                    throw jSAFE_InvalidParameterException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_MAC object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_MAC getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        Object[] objectArray;
        int n = stringArray.length;
        if (n == 4) {
            objectArray = new String[3];
            int n2 = 0;
            while (n2 < 3) {
                objectArray[n2] = stringArray[n2 + 1];
                ++n2;
            }
            stringArray = objectArray;
            n = 3;
        }
        if (n < 2 || n > 3) {
            return null;
        }
        objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 3, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_MAC) {
            return (JSAFE_MAC)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeDigestMAC)objectArray[0]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[1]);
        ((JA_AlgaeDigest)objectArray[1]).setInstantiationParameters(nArray);
        switch (n) {
            case 2: {
                return new JG_DigestMAC((JA_AlgaeDigestMAC)objectArray[0], (JA_AlgaeDigest)objectArray[1]);
            }
            case 3: {
                nArray = JA_ParseList.getParameterList(stringArray[2]);
                ((JA_PasswordStandard)objectArray[2]).setInstantiationParameters(nArray);
                return new JG_PasswordDigestMAC((JA_AlgaeDigestMAC)objectArray[0], (JA_AlgaeDigest)objectArray[1], (JA_PasswordStandard)objectArray[2]);
            }
        }
        return null;
    }

    public abstract byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException;

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getMACAlgorithm();

    public abstract String getDigestAlgorithm();

    public abstract int[] getAlgorithmParameters();

    public abstract int getMACSize();

    public JSAFE_SecretKey getBlankKey() {
        String string = this.getMACAlgorithm();
        String string2 = this.getDevice();
        try {
            return JSAFE_SecretKey.getInstance(string, string2);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return null;
        }
    }

    public abstract void macInit(JSAFE_SecretKey var1, SecureRandom var2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException;

    public abstract void macReInit() throws JSAFE_InvalidUseException;

    public abstract void macUpdate(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException;

    public byte[] getSalt() {
        return null;
    }

    public void setSalt(byte[] byArray, int n, int n2) {
    }

    public void generateSalt(SecureRandom secureRandom) throws JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Salt is not used in the current");
    }

    public byte[] macFinal() throws JSAFE_InvalidUseException {
        byte[] byArray = new byte[this.getMACSize()];
        int n = this.macFinal(byArray, 0);
        return byArray;
    }

    public abstract int macFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException;

    public abstract void verifyInit(JSAFE_SecretKey var1, SecureRandom var2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException;

    public abstract void verifyReInit() throws JSAFE_InvalidUseException;

    public abstract void verifyUpdate(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException;

    public abstract boolean verifyFinal(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException;

    protected void setJSAFELevelValues(JSAFE_MAC jSAFE_MAC) {
        this.theDevice = jSAFE_MAC.theDevice;
        this.theDeviceList = new String[jSAFE_MAC.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_MAC.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_MAC.theDeviceList[n];
            ++n;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (n == 0) {
                if (stringArray[n].startsWith("HMAC", 0)) {
                    return new JA_HMAC();
                }
                return null;
            }
            if (n == 1) {
                if (stringArray[n].startsWith("SHA1", 0)) {
                    return new JA_SHA1();
                }
                if (stringArray[n].startsWith("MD5", 0)) {
                    return new JA_MD5();
                }
                return null;
            }
            if (n == 2) {
                if (stringArray[n].startsWith("PKCS12V1PBE", 0)) {
                    return new JA_PKCS12V1PBE();
                }
                if (stringArray[n].startsWith("PKCS12PBE", 0)) {
                    return new JA_PKCS12PBE();
                }
                if (stringArray[n].startsWith("PKIXPBE", 0)) {
                    return new JA_PKIXPBE();
                }
                if (stringArray[n].startsWith("PKCS5V2PBE", 0)) {
                    return new JA_PKIXPBE();
                }
                return null;
            }
            return null;
        }
    }
}

