/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_MD2;
import com.rsa.jsafe.JA_MD5;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_RIPEMD160;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JA_SHA256;
import com.rsa.jsafe.JA_SHA384;
import com.rsa.jsafe.JA_SHA512;
import com.rsa.jsafe.JG_Digest;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;

public abstract class JSAFE_MessageDigest
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private static final boolean[] strict = new boolean[]{true};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JA_AlgaeDigest"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_MessageDigest";

    public static JSAFE_MessageDigest getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        String string2 = null;
        try {
            string2 = AlgorithmID.berDecodeAlgID(byArray, n, 10, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
        JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance(string2, string);
        jSAFE_MessageDigest.setAlgorithmBER(byArray, n);
        return jSAFE_MessageDigest;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, 10);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        throw new JSAFE_UnimplementedException("Cannot instantiate, unknown BER algorithm ID.");
    }

    public static JSAFE_MessageDigest getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                if (jSAFE_DeviceBuilderArray[n] == null) {
                    jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
                }
                try {
                    JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                    if (jSAFE_MessageDigest != null) {
                        jSAFE_MessageDigest.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                        jSAFE_MessageDigest.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                        return jSAFE_MessageDigest;
                    }
                }
                catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                    if (n < stringArray.length) break block7;
                    throw jSAFE_InvalidParameterException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_MessageDigest object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_MessageDigest getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length != 1) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 4, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_MessageDigest) {
            return (JSAFE_MessageDigest)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeDigest)objectArray[0]).setInstantiationParameters(nArray);
        return new JG_Digest((JA_AlgaeDigest)objectArray[0]);
    }

    public abstract byte[] getDERAlgorithmID();

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getAlgorithm();

    public abstract int getDigestSize();

    public abstract int getEncodedDigestSize();

    public abstract void digestInit();

    public abstract void digestUpdate(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException;

    public byte[] digestFinal() throws JSAFE_InvalidUseException {
        byte[] byArray = new byte[this.getDigestSize()];
        int n = this.digestFinal(byArray, 0);
        return byArray;
    }

    public abstract int digestFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException;

    public byte[] derEncode(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.getEncodedDigestSize()];
        int n2 = this.derEncode(byArray, n, byArray2, 0);
        return byArray2;
    }

    public abstract int derEncode(byte[] var1, int var2, byte[] var3, int var4);

    public static String berDecodeAlgorithm(byte[] byArray, int n) throws JSAFE_InputException {
        String string = null;
        try {
            string = AlgorithmID.berDecodeAlgID(byArray, n, 10, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InputException("Could not decode BER(" + aSN_Exception.getMessage() + ")");
        }
        return string;
    }

    public static byte[] berDecodeDigest(byte[] byArray, int n) throws JSAFE_InputException {
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        SequenceContainer sequenceContainer2 = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        OIDContainer oIDContainer = new OIDContainer(0, 10);
        EncodedContainer encodedContainer = new EncodedContainer(77824);
        Object var7_7 = null;
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, sequenceContainer2, oIDContainer, encodedContainer, endContainer, octetStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_InputException("Could not decode BER. (" + aSN_Exception.getMessage() + ")");
        }
        byte[] byArray2 = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, byArray2, 0, octetStringContainer.dataLen);
        return byArray2;
    }

    protected void setJSAFELevelValues(JSAFE_MessageDigest jSAFE_MessageDigest) {
        this.theDevice = jSAFE_MessageDigest.theDevice;
        this.theDeviceList = new String[jSAFE_MessageDigest.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_MessageDigest.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_MessageDigest.theDeviceList[n];
            ++n;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray[n].startsWith("SHA1", 0)) {
                return new JA_SHA1();
            }
            if (stringArray[n].startsWith("MD5", 0)) {
                return new JA_MD5();
            }
            if (stringArray[n].startsWith("MD2", 0)) {
                return new JA_MD2();
            }
            if (stringArray[n].startsWith("SHA256", 0)) {
                return new JA_SHA256();
            }
            if (stringArray[n].startsWith("SHA384", 0)) {
                return new JA_SHA384();
            }
            if (stringArray[n].startsWith("SHA512", 0)) {
                return new JA_SHA512();
            }
            if (stringArray[n].startsWith("RIPEMD160", 0)) {
                return new JA_RIPEMD160();
            }
            return null;
        }
    }
}

