/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_DHParameters;
import com.rsa.jsafe.JA_DSAParameters;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_Parameters
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private static final boolean[] strict = new boolean[]{true};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JSAFE_Parameters"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_Parameters";
    private static final String[] suffix = new String[]{"Parameters"};

    public static JSAFE_Parameters getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        String string2 = null;
        try {
            string2 = AlgorithmID.berDecodeAlgID(byArray, n, 4, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
        JSAFE_Parameters jSAFE_Parameters = JSAFE_Parameters.getInstance(string2, string);
        jSAFE_Parameters.setAlgorithmBER(byArray, n);
        return jSAFE_Parameters;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, 4);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        throw new JSAFE_UnimplementedException("Cannot instantiate, unknown BER algorithm ID.");
    }

    public static JSAFE_Parameters getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                if (jSAFE_DeviceBuilderArray[n] == null) {
                    jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
                }
                try {
                    JSAFE_Parameters jSAFE_Parameters = JSAFE_Parameters.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                    if (jSAFE_Parameters != null) {
                        jSAFE_Parameters.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                        jSAFE_Parameters.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                        return jSAFE_Parameters;
                    }
                }
                catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                    if (n < stringArray.length) break block7;
                    throw jSAFE_InvalidParameterException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_Parameters object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_Parameters getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length != 1) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, suffix, 5, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JSAFE_Parameters)objectArray[0]).setInstantiationParameters(nArray);
        return (JSAFE_Parameters)objectArray[0];
    }

    protected void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected none");
        }
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        return this.getDERAlgorithmID(null);
    }

    public abstract byte[] getDERAlgorithmID(String var1) throws JSAFE_UnimplementedException;

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getAlgorithm();

    public abstract String[] getSupportedSetFormats();

    public abstract String[] getSupportedGetFormats();

    public abstract void setParameterData(String var1, byte[][] var2) throws JSAFE_InputException, JSAFE_UnimplementedException;

    public abstract void setParameterData(byte[][] var1) throws JSAFE_InputException;

    public abstract byte[][] getParameterData(String var1) throws JSAFE_UnimplementedException;

    public abstract byte[][] getParameterData();

    public abstract void generateInit(int[] var1, SecureRandom var2) throws JSAFE_InvalidParameterException;

    public abstract void generateInit(int[] var1, SecureRandom var2, JSAFE_Session[] var3) throws JSAFE_InvalidParameterException;

    public void generateFIPSInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        throw new JSAFE_InvalidUseException("Use generateFips only with DSA parameters.");
    }

    public abstract void generateReInit() throws JSAFE_InvalidUseException;

    public abstract void generate() throws JSAFE_InvalidUseException;

    public abstract Object clone() throws CloneNotSupportedException;

    protected void setJSAFELevelValues(JSAFE_Parameters jSAFE_Parameters) {
        this.theDevice = jSAFE_Parameters.theDevice;
        this.theDeviceList = new String[jSAFE_Parameters.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_Parameters.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_Parameters.theDeviceList[n];
            ++n;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray[n].startsWith("DSA", 0)) {
                return new JA_DSAParameters();
            }
            if (stringArray[n].startsWith("DH", 0)) {
                return new JA_DHParameters();
            }
            return null;
        }
    }
}

