/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_DHPrivateKey;
import com.rsa.jsafe.JA_DSAPrivateKey;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_PrivateKeyBER;
import com.rsa.jsafe.JA_RSAPrivateKey;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.Serializable;

public abstract class JSAFE_PrivateKey
extends JSAFE_Object
implements JSAFE_Key,
Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private static final boolean[] strict = new boolean[]{true};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JSAFE_PrivateKey"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_PrivateKey";
    private static final String[] suffix = new String[]{"PrivateKey"};

    public static JSAFE_PrivateKey getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException {
        String string2 = null;
        try {
            string2 = AlgorithmID.berDecodeAlgID(byArray, n, 2, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
        JSAFE_PrivateKey jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance(string2, string);
        try {
            jSAFE_PrivateKey.setKeyDataBER(byArray, n);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new JSAFE_UnimplementedException("Key BER info is incorrect.");
        }
        return jSAFE_PrivateKey;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return n + JA_PrivateKeyBER.berDecodePrivateKeyInfo(byArray, n, null, null, null);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.");
        }
    }

    void setKeyDataBER(byte[] byArray, int n) throws JSAFE_InvalidKeyException {
        throw new JSAFE_InvalidKeyException("Cannot read the BER.");
    }

    public static JSAFE_PrivateKey getInstance(String string, String string2) throws JSAFE_UnimplementedException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            if (jSAFE_DeviceBuilderArray[n] == null) {
                jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
            }
            try {
                JSAFE_PrivateKey jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                if (jSAFE_PrivateKey != null) {
                    jSAFE_PrivateKey.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                    jSAFE_PrivateKey.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                    return jSAFE_PrivateKey;
                }
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                // empty catch block
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_PrivateKey object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_PrivateKey getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length != 1) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, suffix, 6, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JSAFE_PrivateKey)objectArray[0]).setInstantiationParameters(nArray);
        return (JSAFE_PrivateKey)objectArray[0];
    }

    protected void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected none.");
        }
    }

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getAlgorithm();

    public abstract Object clone() throws CloneNotSupportedException;

    protected void setJSAFELevelValues(JSAFE_PrivateKey jSAFE_PrivateKey) {
        this.theDevice = jSAFE_PrivateKey.theDevice;
        this.theDeviceList = new String[jSAFE_PrivateKey.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_PrivateKey.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_PrivateKey.theDeviceList[n];
            ++n;
        }
    }

    public String getKeyWrappingFormat(boolean bl) {
        return this.getAlgorithm() + "PrivateKeyBER";
    }

    public abstract boolean dataEquals(Object var1);

    protected boolean compareKeyArrays(byte[] byArray, ObfuscatorItem obfuscatorItem, byte[] byArray2, ObfuscatorItem obfuscatorItem2) {
        if (byArray != null) {
            if (byArray2 == null) {
                return false;
            }
            if (byArray.length != byArray2.length) {
                return false;
            }
            if (obfuscatorItem != null) {
                obfuscatorItem.deobfuscate();
            }
            if (obfuscatorItem2 != null) {
                obfuscatorItem2.deobfuscate();
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) break;
                ++n;
            }
            if (obfuscatorItem != null) {
                obfuscatorItem.obfuscate();
            }
            if (obfuscatorItem2 != null) {
                obfuscatorItem2.obfuscate();
            }
            return n >= byArray.length;
        }
        return byArray2 == null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    public abstract void setKeyData(String var1, byte[][] var2) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException;

    public abstract void setKeyData(byte[][] var1) throws JSAFE_InvalidKeyException;

    public abstract byte[][] getKeyData(String var1) throws JSAFE_UnimplementedException;

    public abstract byte[][] getKeyData();

    public abstract String[] getSupportedSetFormats();

    public abstract String[] getSupportedGetFormats();

    public abstract int getMinimumKeyLength();

    public abstract int getMaximumKeyLength();

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray[n].startsWith("RSA", 0)) {
                return new JA_RSAPrivateKey();
            }
            if (stringArray[n].startsWith("DSA", 0)) {
                return new JA_DSAPrivateKey();
            }
            if (stringArray[n].startsWith("DH", 0)) {
                return new JA_DHPrivateKey();
            }
            return null;
        }
    }
}

