/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_AlgaeRecode;
import com.rsa.jsafe.JA_Base64;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JG_Recode;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public abstract class JSAFE_Recode
extends JSAFE_Object {
    private String theDevice;
    private String[] theDeviceList;
    private static final boolean[] strict = new boolean[]{true};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JA_AlgaeRecode"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_Recode";

    public static JSAFE_Recode getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                if (jSAFE_DeviceBuilderArray[n] == null) {
                    jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
                }
                try {
                    JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                    if (jSAFE_Recode != null) {
                        jSAFE_Recode.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                        jSAFE_Recode.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                        return jSAFE_Recode;
                    }
                }
                catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                    if (n < stringArray.length) break block7;
                    throw jSAFE_InvalidParameterException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_Recode object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_Recode getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length != 1) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 8, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_Recode) {
            return (JSAFE_Recode)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_AlgaeRecode)objectArray[0]).setInstantiationParameters(nArray);
        return new JG_Recode((JA_AlgaeRecode)objectArray[0]);
    }

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getAlgorithm();

    public abstract int[] getAlgorithmParameters();

    public abstract int getOutputBufferSize(int var1);

    public abstract void encodeInit() throws JSAFE_InvalidUseException;

    public byte[] encodeUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException {
        byte[] byArray2 = new byte[this.getOutputBufferSize(n2)];
        int n3 = this.encodeUpdate(byArray, n, n2, byArray2, 0);
        if (n3 == 0) {
            return new byte[0];
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        JSAFE_Obfuscator.overwrite(byArray2);
        return byArray3;
    }

    public abstract int encodeUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException;

    public byte[] encodeFinal() throws JSAFE_InvalidUseException, JSAFE_InputException {
        byte[] byArray = new byte[this.getOutputBufferSize(0)];
        int n = this.encodeFinal(byArray, 0);
        if (n == 0) {
            return new byte[0];
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        JSAFE_Obfuscator.overwrite(byArray);
        return byArray2;
    }

    public abstract int encodeFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException;

    public abstract void decodeInit() throws JSAFE_InvalidUseException;

    public byte[] decodeUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        byte[] byArray2 = new byte[this.getOutputBufferSize(n2)];
        int n3 = this.decodeUpdate(byArray, n, n2, byArray2, 0);
        if (n3 == 0) {
            return new byte[0];
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        JSAFE_Obfuscator.overwrite(byArray2);
        return byArray3;
    }

    public abstract int decodeUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException, JSAFE_InputException;

    public byte[] decodeFinal() throws JSAFE_InvalidUseException, JSAFE_InputException {
        byte[] byArray = new byte[this.getOutputBufferSize(0)];
        int n = this.decodeFinal(byArray, 0);
        if (n == 0) {
            return new byte[0];
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        JSAFE_Obfuscator.overwrite(byArray);
        return byArray2;
    }

    public abstract int decodeFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException, JSAFE_InputException;

    protected void setJSAFELevelValues(JSAFE_Recode jSAFE_Recode) {
        this.theDevice = jSAFE_Recode.theDevice;
        this.theDeviceList = jSAFE_Recode.theDeviceList;
        int n = 0;
        while (n < jSAFE_Recode.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_Recode.theDeviceList[n];
            ++n;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray[n].startsWith("Base64", 0)) {
                return new JA_Base64();
            }
            return null;
        }
    }
}

