/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_3DES_EDEKey;
import com.rsa.jsafe.JA_AES128Key;
import com.rsa.jsafe.JA_AES192Key;
import com.rsa.jsafe.JA_AES256Key;
import com.rsa.jsafe.JA_AESKey;
import com.rsa.jsafe.JA_DESKey;
import com.rsa.jsafe.JA_DESXKey;
import com.rsa.jsafe.JA_HMACKey;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_RC2Key;
import com.rsa.jsafe.JA_RC4Key;
import com.rsa.jsafe.JA_RC5Key;
import com.rsa.jsafe.JA_SecretKeyBER;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.ObfuscatorItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_SecretKey
extends JSAFE_Object
implements JSAFE_Key,
Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    protected String algorithmName;
    private int keyType;
    public static final int ENCRYPT_KEY = 0;
    public static final int MAC_KEY = 1;
    private SecureRandom random;
    private byte[] randomSerialize;
    private String randomAlgorithm;
    protected int MIN_KEY_BITS = 0;
    protected int MAX_KEY_BITS = -1;
    protected static final byte[][] weakKeys = new byte[0][];
    private int keyGenerationLength = -15;
    protected transient ObfuscatorItem keyOI;
    protected byte[] keyData;
    protected transient ObfuscatorItem passOI;
    protected short[] password;
    private static final boolean[] strict = new boolean[]{true};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JSAFE_SecretKey"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_SecretKey";
    private static final String[] suffix = new String[]{"Key"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JSAFE_SecretKey getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException {
        JSAFE_SecretKey jSAFE_SecretKey;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = null;
        try {
            try {
                byArray2 = JA_SecretKeyBER.getKeyInfoBER(stringBuffer, byArray, n);
                JSAFE_SecretKey jSAFE_SecretKey2 = JSAFE_SecretKey.getInstance(stringBuffer.toString(), string);
                jSAFE_SecretKey2.setSecretKeyData(byArray2, 0, byArray2.length);
                jSAFE_SecretKey = jSAFE_SecretKey2;
                Object var8_8 = null;
                if (byArray2 == null) return jSAFE_SecretKey;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new JSAFE_UnimplementedException("Could not read BER info.");
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (byArray2 == null) throw throwable;
            JSAFE_Obfuscator.overwrite(byArray2);
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(byArray2);
        return jSAFE_SecretKey;
    }

    public static JSAFE_SecretKey getInstance(String string, String string2) throws JSAFE_UnimplementedException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            if (jSAFE_DeviceBuilderArray[n] == null) {
                jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
            }
            try {
                JSAFE_SecretKey jSAFE_SecretKey = JSAFE_SecretKey.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                if (jSAFE_SecretKey != null) {
                    jSAFE_SecretKey.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                    jSAFE_SecretKey.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                    return jSAFE_SecretKey;
                }
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                // empty catch block
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_SecretKey object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_SecretKey getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length != 1) {
            return null;
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, suffix, 9, strict, interfaceList, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JSAFE_SecretKey)objectArray[0]).setInstantiationParameters(nArray);
        return (JSAFE_SecretKey)objectArray[0];
    }

    protected JSAFE_SecretKey(String string, int n, int n2) {
        this.algorithmName = string;
        this.MIN_KEY_BITS = n;
        this.MAX_KEY_BITS = n2;
        this.keyType = 0;
    }

    protected JSAFE_SecretKey(String string, int n, int n2, int n3) {
        this.algorithmName = string;
        this.MIN_KEY_BITS = n;
        this.MAX_KEY_BITS = n2;
        this.keyType = n3;
    }

    int getKeyType() {
        return this.keyType;
    }

    protected void setInstantiationParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected none.");
        }
    }

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    abstract int getKeyBitLength(int var1);

    public void setPassword(char[] cArray, int n, int n2) {
        if (this.password != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.password, this.passOI);
            this.passOI = null;
            this.password = null;
        }
        if (cArray == null) {
            return;
        }
        this.password = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.password[n3] = (short)cArray[n];
            ++n3;
            ++n;
        }
        this.passOI = JSAFE_Obfuscator.register(this.password);
        this.passOI.obfuscate();
    }

    public char[] getPassword() throws JSAFE_InvalidKeyException {
        if (this.password == null) {
            throw new JSAFE_InvalidKeyException("Key object not set with password.");
        }
        char[] cArray = new char[this.password.length];
        this.passOI.deobfuscate();
        int n = 0;
        while (n < this.password.length) {
            cArray[n] = (char)this.password[n];
            ++n;
        }
        this.passOI.obfuscate();
        return cArray;
    }

    public int getMaximumKeyLength() {
        return this.MAX_KEY_BITS;
    }

    public int getMinimumKeyLength() {
        return this.MIN_KEY_BITS;
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"Clear"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.keyData == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{"Clear"};
        return stringArray;
    }

    public String getKeyWrappingFormat(boolean bl) {
        if (!bl) {
            return "Clear";
        }
        return this.algorithmName + "SecretKeyBER";
    }

    public void setSecretKeyData(String string, byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException {
        if (string.compareTo("Clear") != 0) {
            throw new JSAFE_UnimplementedException("Unimplemented key format: " + string);
        }
        this.setSecretKeyData(byArray, n, n2);
    }

    public void setSecretKeyData(byte[] byArray, int n, int n2) throws JSAFE_InvalidKeyException {
        if (this.keyData != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.keyData, this.keyOI);
            this.keyOI = null;
            this.keyData = null;
        }
        if (!this.checkKeyLength(n2 * 8)) {
            throw new JSAFE_InvalidKeyException("Invalid key data length");
        }
        this.keyData = new byte[n2];
        System.arraycopy(byArray, n, this.keyData, 0, n2);
        this.keyOI = JSAFE_Obfuscator.register(this.keyData);
        this.keyOI.obfuscate();
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException {
        if (byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid key data.");
        }
        this.setSecretKeyData(string, byArray[0], 0, byArray[0].length);
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        if (byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid key data.");
        }
        this.setSecretKeyData(byArray[0], 0, byArray[0].length);
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        byte[] byArray = this.getSecretKeyData(string);
        if (this.keyData == null) {
            return new byte[0][];
        }
        byte[][] byArrayArray = new byte[][]{byArray};
        return byArrayArray;
    }

    public byte[][] getKeyData() {
        if (this.keyData == null) {
            return new byte[0][];
        }
        byte[][] byArrayArray = new byte[][]{this.getSecretKeyData()};
        return byArrayArray;
    }

    public byte[] getSecretKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("Clear") == 0) {
            return this.getSecretKeyData();
        }
        if (string.compareTo(this.algorithmName + "SecretKeyBER") != 0) {
            throw new JSAFE_UnimplementedException("Unimplemented key format: " + string);
        }
        return this.getSecretKeyDataBER();
    }

    public byte[] getSecretKeyData() {
        if (this.keyData == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.keyData.length];
        this.keyOI.deobfuscate();
        System.arraycopy(this.keyData, 0, byArray, 0, this.keyData.length);
        this.keyOI.obfuscate();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getSecretKeyDataBER() throws JSAFE_UnimplementedException {
        byte[] byArray;
        byte[] byArray2 = null;
        try {
            try {
                byArray2 = this.getSecretKeyData();
                byArray = JA_SecretKeyBER.getKeyDataBER(this.algorithmName, byArray2);
                Object var4_4 = null;
                if (byArray2 == null) return byArray;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new JSAFE_UnimplementedException("Cannot compute Secret Key BER.");
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (byArray2 == null) throw throwable;
            JSAFE_Obfuscator.overwrite(byArray2);
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(byArray2);
        return byArray;
    }

    public boolean checkKeyLength(int n) {
        return n <= this.MAX_KEY_BITS && n >= this.MIN_KEY_BITS;
    }

    boolean isWeakKeyData(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        int n = 0;
        while (n < weakKeys.length) {
            if (weakKeys[n] != null && byArray.length == weakKeys[n].length) {
                int n2 = 0;
                while (n2 < byArray.length) {
                    if (byArray[n2] != weakKeys[n][n2]) break;
                    ++n2;
                }
                if (n2 == byArray.length) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public void generateInit(int[] nArray, SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        if (nArray == null) {
            nArray = new int[]{this.getKeyBitLength(-1)};
        }
        if (nArray.length != 1) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters for key generation: expected 1");
        }
        if (!this.checkKeyLength(nArray[0])) {
            throw new JSAFE_InvalidParameterException("Incorrect key length requested for key generation");
        }
        this.keyGenerationLength = nArray[0];
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (this.random == null) {
            throw new JSAFE_InvalidUseException("Need a random object.");
        }
    }

    public void generateReInit() throws JSAFE_InvalidUseException {
        if (this.keyGenerationLength < 0) {
            throw new JSAFE_InvalidUseException("Cannot ReInit, object not initialized.");
        }
    }

    public void generate() throws JSAFE_InvalidParameterException {
        byte[] byArray = null;
        int n = (this.keyGenerationLength + 7) / 8;
        if (this.keyGenerationLength < 0) {
            throw new JSAFE_InvalidParameterException("Cannot generate, object not initialized.");
        }
        byArray = new byte[n];
        int n2 = 0;
        boolean bl = true;
        do {
            if (++n2 > 100) {
                throw new JSAFE_InvalidParameterException("Invalid key length.");
            }
            this.random.nextBytes(byArray);
            int n3 = this.keyGenerationLength % 8;
            if (n3 == 0) continue;
            n3 = 8 - n3;
            byArray[0] = (byte)((byArray[0] & 0xFF) >>> n3);
        } while (bl = this.isWeakKeyData(byArray));
        try {
            try {
                this.setSecretKeyData(byArray, 0, byArray.length);
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_InvalidParameterException("Invalid Key Length for Generation.");
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JSAFE_Obfuscator.overwrite(byArray);
            throw throwable;
        }
        JSAFE_Obfuscator.overwrite(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.prepareSerialization();
        objectOutputStream.defaultWriteObject();
        this.restoreAfterSerialization(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.restoreAfterDeserialization();
    }

    private JSAFE_SecureRandom prepareSerialization() {
        if (this.keyOI != null) {
            this.keyOI.deobfuscate();
        }
        if (this.passOI != null) {
            this.passOI.deobfuscate();
        }
        if (this.random == null) {
            return null;
        }
        if (!(this.random instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.random;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.randomAlgorithm = jSAFE_SecureRandom.getAlgorithm();
        this.randomSerialize = jSAFE_SecureRandom.serializeRandom();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.random;
        this.random = null;
        return jSAFE_SecureRandom2;
    }

    private void restoreAfterSerialization(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.keyOI != null) {
            this.keyOI.obfuscate();
        }
        if (this.passOI != null) {
            this.passOI.obfuscate();
        }
        if (this.randomSerialize == null) {
            return;
        }
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
        this.random = jSAFE_SecureRandom;
    }

    private void restoreAfterDeserialization() {
        if (this.keyData != null) {
            this.keyOI = JSAFE_Obfuscator.register(this.keyData);
            this.keyOI.obfuscate();
        }
        if (this.password != null) {
            this.passOI = JSAFE_Obfuscator.register(this.password);
            this.passOI.obfuscate();
        }
        if (this.randomSerialize == null) {
            return;
        }
        this.random = JSAFE_SecureRandom.deserializeRandom(this.randomAlgorithm, this.randomSerialize);
        int n = 0;
        while (n < this.randomSerialize.length) {
            this.randomSerialize[n] = 0;
            ++n;
        }
        this.randomSerialize = null;
        this.randomAlgorithm = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JSAFE_SecretKey jSAFE_SecretKey = (JSAFE_SecretKey)super.clone();
        jSAFE_SecretKey.keyData = null;
        jSAFE_SecretKey.keyOI = null;
        jSAFE_SecretKey.password = null;
        jSAFE_SecretKey.passOI = null;
        if (this.keyData != null) {
            jSAFE_SecretKey.keyData = (byte[])JSAFE_Obfuscator.copy(this.keyData, this.keyOI);
            jSAFE_SecretKey.keyOI = JSAFE_Obfuscator.getObfuscatorItem(jSAFE_SecretKey.keyData);
        }
        if (this.password != null) {
            jSAFE_SecretKey.password = (short[])JSAFE_Obfuscator.copy(this.password, this.passOI);
            jSAFE_SecretKey.passOI = JSAFE_Obfuscator.getObfuscatorItem(jSAFE_SecretKey.password);
        }
        jSAFE_SecretKey.setJSAFELevelValues(this);
        return jSAFE_SecretKey;
    }

    protected void setJSAFELevelValues(JSAFE_SecretKey jSAFE_SecretKey) {
        this.theDevice = jSAFE_SecretKey.theDevice;
        if (jSAFE_SecretKey.theDeviceList != null) {
            this.theDeviceList = new String[jSAFE_SecretKey.theDeviceList.length];
            int n = 0;
            while (n < jSAFE_SecretKey.theDeviceList.length) {
                this.theDeviceList[n] = jSAFE_SecretKey.theDeviceList[n];
                ++n;
            }
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.keyData != null) {
            JSAFE_Obfuscator.deregisterOrOverwrite(this.keyData, this.keyOI);
        }
        this.keyData = null;
        this.keyOI = null;
        this.keyGenerationLength = -15;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray[n].startsWith("RC4", 0)) {
                return new JA_RC4Key();
            }
            if (stringArray[n].compareTo("AES") == 0) {
                return new JA_AESKey();
            }
            if (stringArray[n].compareTo("AES128") == 0) {
                return new JA_AES128Key();
            }
            if (stringArray[n].compareTo("AES192") == 0) {
                return new JA_AES192Key();
            }
            if (stringArray[n].compareTo("AES256") == 0) {
                return new JA_AES256Key();
            }
            if (stringArray[n].compareTo("DES") == 0) {
                return new JA_DESKey();
            }
            if (stringArray[n].startsWith("3DES_EDE", 0)) {
                return new JA_3DES_EDEKey();
            }
            if (stringArray[n].startsWith("HMAC", 0)) {
                return new JA_HMACKey();
            }
            if (stringArray[n].startsWith("RC2", 0)) {
                return new JA_RC2Key();
            }
            if (stringArray[n].startsWith("RC5", 0)) {
                return new JA_RC5Key();
            }
            if (stringArray[n].startsWith("DESX", 0)) {
                return new JA_DESXKey();
            }
            return null;
        }
    }
}

