/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JA_AlgaeChainDigestRandom;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeRandom;
import com.rsa.jsafe.JA_DummyRandom;
import com.rsa.jsafe.JA_MD2;
import com.rsa.jsafe.JA_MD5;
import com.rsa.jsafe.JA_MD5Random;
import com.rsa.jsafe.JA_NoDigest;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JA_SHA1Random;
import com.rsa.jsafe.JA_X931Random;
import com.rsa.jsafe.JG_ChainDigestRandom;
import com.rsa.jsafe.JG_DigestedRandom;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_Object;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public abstract class JSAFE_SecureRandom
extends SecureRandom
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private long tempLongSeed;
    private int tempLongSeedSet;
    private byte[] tempByteSeed;
    private int tempByteSeedSet;
    private static final boolean[] strictHW = new boolean[]{true, false};
    private static final String[] interfaceListHW = new String[]{"com.rsa.jsafe.JA_AlgaeRandom", "com.rsa.jsafe.JA_AlgaeDigest"};
    private static final boolean[] strictChain = new boolean[]{true};
    private static final String[] interfaceListChain = new String[]{"com.rsa.jsafe.JA_AlgaeChainDigestRandom"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_SecureRandom";

    protected boolean fipsIsRequired() {
        return CryptoJ.fipsIsRequired();
    }

    JSAFE_SecureRandom() {
        super(new byte[4]);
        if (this.tempLongSeedSet == 0) {
            this.setSeed(0L);
        }
        if (this.tempByteSeedSet == 0) {
            this.setSeed(new byte[4]);
        }
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new NoSuchAlgorithmException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new NoSuchAlgorithmException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            if (jSAFE_DeviceBuilderArray[n] == null) {
                jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
            }
            try {
                JSAFE_SecureRandom jSAFE_SecureRandom = JSAFE_SecureRandom.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                if (jSAFE_SecureRandom != null) {
                    jSAFE_SecureRandom.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                    jSAFE_SecureRandom.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                    return jSAFE_SecureRandom;
                }
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                // empty catch block
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("A JSAFE_SecureRandom object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_SecureRandom getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        if (stringArray.length == 1) {
            Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 10, strictChain, interfaceListChain, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
            if (objectArray == null) {
                return null;
            }
            int[] nArray = null;
            nArray = JA_ParseList.getParameterList(stringArray[0]);
            ((JA_AlgaeChainDigestRandom)objectArray[0]).setInstantiationParameters(nArray);
            if (((JA_AlgaeChainDigestRandom)objectArray[0]).getAlgorithm().startsWith("X9")) {
                return (JSAFE_SecureRandom)objectArray[0];
            }
            return new JG_ChainDigestRandom((JA_AlgaeChainDigestRandom)objectArray[0]);
        }
        if (stringArray.length != 2) {
            return null;
        }
        int[] nArray = JA_ParseList.getParameterList(stringArray[0]);
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 10, strictHW, interfaceListHW, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        return new JG_DigestedRandom((JA_AlgaeRandom)objectArray[0], (JA_AlgaeDigest)objectArray[1]);
    }

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public int[] getAlgorithmParameters() {
        return new int[0];
    }

    public abstract String getAlgorithm();

    public abstract void seed(byte[] var1);

    public void extraSeed(byte[] byArray) throws JSAFE_InputException {
        this.seed(byArray);
    }

    public abstract void autoseed();

    public void setSeed(long l) {
        if (this.tempLongSeedSet == 0) {
            this.tempLongSeed = l;
            this.tempLongSeedSet = 1;
            return;
        }
        this.setLongSeed(this.tempLongSeed);
        this.setLongSeed(l);
    }

    private void setLongSeed(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>>= 8;
            ++n;
        }
        this.seed(byArray);
        JSAFE_Obfuscator.overwrite(byArray);
    }

    public void setSeed(byte[] byArray) {
        if (this.tempByteSeedSet == 0) {
            this.tempByteSeed = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.tempByteSeed, 0, byArray.length);
            this.tempByteSeedSet = 1;
            return;
        }
        this.seed(this.tempByteSeed);
        this.seed(byArray);
    }

    public void nextBytes(byte[] byArray) {
        this.generateRandomBytes(byArray, 0, byArray.length);
    }

    public short nextShort() {
        byte[] byArray = new byte[2];
        this.generateRandomBytes(byArray, 0, 2);
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        JSAFE_Obfuscator.overwrite(byArray);
        return (short)n;
    }

    public int nextInt() {
        byte[] byArray = new byte[4];
        this.generateRandomBytes(byArray, 0, 4);
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        JSAFE_Obfuscator.overwrite(byArray);
        return n;
    }

    public long nextLong() {
        byte[] byArray = new byte[8];
        this.generateRandomBytes(byArray, 0, 8);
        long l = (long)(byArray[0] & 0xFF) | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[7] & 0xFF) << 56;
        JSAFE_Obfuscator.overwrite(byArray);
        return l;
    }

    public double nextDouble() {
        long l = this.nextLong();
        if ((l &= Long.MAX_VALUE) == 0L) {
            return this.nextDouble();
        }
        if ((l & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            return this.nextDouble();
        }
        double d = Double.longBitsToDouble(l);
        l = 0L;
        return d;
    }

    public float nextFloat() {
        int n = this.nextInt();
        if ((n = (int)((long)n & Long.MAX_VALUE)) == 0) {
            return this.nextFloat();
        }
        if ((n & 0x7F800000) == 2139095040) {
            return this.nextFloat();
        }
        float f = Float.intBitsToFloat(n);
        n = 0;
        return f;
    }

    public byte[] generateRandomBytes(int n) {
        byte[] byArray = new byte[n];
        this.generateRandomBytes(byArray, 0, n);
        return byArray;
    }

    public abstract void generateRandomBytes(byte[] var1, int var2, int var3);

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    byte[] serializeRandom() {
        return this.generateRandomBytes(256);
    }

    static JSAFE_SecureRandom deserializeRandom(String string, byte[] byArray) {
        JSAFE_SecureRandom jSAFE_SecureRandom = null;
        try {
            jSAFE_SecureRandom = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance(string, "Java");
            jSAFE_SecureRandom.seed(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            jSAFE_SecureRandom = null;
        }
        return jSAFE_SecureRandom;
    }

    protected void setJSAFELevelValues(JSAFE_SecureRandom jSAFE_SecureRandom) throws CloneNotSupportedException {
        this.theDevice = jSAFE_SecureRandom.theDevice;
        this.theDeviceList = jSAFE_SecureRandom.theDeviceList;
        this.tempLongSeed = jSAFE_SecureRandom.tempLongSeed;
        this.tempLongSeedSet = jSAFE_SecureRandom.tempLongSeedSet;
        if (jSAFE_SecureRandom.tempByteSeed != null) {
            this.tempByteSeed = (byte[])jSAFE_SecureRandom.tempByteSeed.clone();
        }
        this.tempByteSeedSet = jSAFE_SecureRandom.tempByteSeedSet;
    }

    public void clearSensitiveData() {
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (n == 0) {
                if (stringArray[n].startsWith("SHA1", 0)) {
                    return new JA_SHA1Random();
                }
                if (stringArray[n].startsWith("MD5", 0)) {
                    return new JA_MD5Random();
                }
                if (stringArray[n].startsWith("X931", 0)) {
                    return new JA_X931Random();
                }
                if (stringArray[n].startsWith("DummyRandom", 0)) {
                    return new JA_DummyRandom();
                }
            }
            return this.getDigest(stringArray, n, string, stringArray2);
        }

        public Object getDigest(String[] stringArray, int n, String string, String[] stringArray2) {
            if (!string.startsWith("com.rsa.jsafe")) {
                return null;
            }
            if (stringArray[n].startsWith("SHA1", 0)) {
                return new JA_SHA1();
            }
            if (stringArray[n].startsWith("No", 0)) {
                return new JA_NoDigest();
            }
            if (stringArray[n].startsWith("MD5", 0)) {
                return new JA_MD5();
            }
            if (stringArray[n].startsWith("MD2", 0)) {
                return new JA_MD2();
            }
            return null;
        }
    }
}

