/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeSignature;
import com.rsa.jsafe.JA_DSA;
import com.rsa.jsafe.JA_MD2;
import com.rsa.jsafe.JA_MD5;
import com.rsa.jsafe.JA_MGF1;
import com.rsa.jsafe.JA_MGFUnderlyingAlgorithm;
import com.rsa.jsafe.JA_MaskGeneratingFunction;
import com.rsa.jsafe.JA_NoDigest;
import com.rsa.jsafe.JA_NoPad;
import com.rsa.jsafe.JA_PKCS1Block01Pad;
import com.rsa.jsafe.JA_PKCS1V2PSS;
import com.rsa.jsafe.JA_PSSDigest;
import com.rsa.jsafe.JA_PSSPadding;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_RIPEMD160;
import com.rsa.jsafe.JA_RSA;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JA_SHA256;
import com.rsa.jsafe.JA_SHA384;
import com.rsa.jsafe.JA_SHA512;
import com.rsa.jsafe.JA_SignatureAlgID;
import com.rsa.jsafe.JA_SignaturePaddingScheme;
import com.rsa.jsafe.JA_X931Pad;
import com.rsa.jsafe.JA_X931RSA;
import com.rsa.jsafe.JG_Signature;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_Signature
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private JSAFE_Signature[] allObjects;
    private int chosenIndex;
    private static final boolean[] strict = new boolean[]{false, true, false};
    private static final String[] interfaceList = new String[]{"com.rsa.jsafe.JA_AlgaeDigest", "com.rsa.jsafe.JA_AlgaeSignature", "com.rsa.jsafe.JA_SignaturePaddingScheme"};
    private static boolean[] strictPSS = new boolean[]{false, true, false, false, false};
    private static String[] interfacePSS = new String[]{"com.rsa.jsafe.JA_PSSDigest", "com.rsa.jsafe.JA_AlgaeSignature", "com.rsa.jsafe.JA_PSSPadding", "com.rsa.jsafe.JA_MaskGeneratingFunction", "com.rsa.jsafe.JA_MGFUnderlyingAlgorithm"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_Signature";

    public static JSAFE_Signature getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JA_SignatureAlgID jA_SignatureAlgID = new JA_SignatureAlgID();
        jA_SignatureAlgID.decodeAlgID(byArray, n);
        JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance(jA_SignatureAlgID.transformation, string);
        jSAFE_Signature.setAlgorithmBER(byArray, n);
        return jSAFE_Signature;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (this.allObjects == null) {
            this.setAlgBER(byArray, n);
            return;
        }
        int n2 = 0;
        while (n2 < this.allObjects.length) {
            if (this.allObjects[n2] != null) {
                this.allObjects[n2].setAlgBER(byArray, n);
            }
            ++n2;
        }
    }

    protected abstract void setAlgBER(byte[] var1, int var2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException;

    /*
     * Unable to fully structure code
     */
    public static JSAFE_Signature getInstance(String var0, String var1_1) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (var1_1 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (var0 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        var2_2 = JA_ParseList.parseElements(var1_1);
        var3_3 = new JSAFE_DeviceBuilder[var2_2.length];
        var4_4 = new JSAFE_Signature[var2_2.length];
        var5_5 = JA_ParseList.parseElements(var0);
        var6_6 = 0;
        while (var6_6 < var2_2.length) {
            block13: {
                if (var3_3[var6_6] == null) {
                    var3_3[var6_6] = JA_ParseDevice.getDeviceObject(var2_2[var6_6]);
                }
                try {
                    var7_7 = JSAFE_Signature.getInstance(var5_5, var2_2, var3_3[var6_6], var3_3);
                    if (var7_7 != null) {
                        var7_7.theDevice = var3_3[var6_6].getDevice();
                        var7_7.theDeviceList = var3_3[var6_6].getDeviceList();
                        var4_4[var6_6] = var7_7;
                    }
                    break block13;
                }
                catch (JSAFE_InvalidParameterException var7_8) {
                    if (var6_6 < var2_2.length) break block13;
                    var8_10 = 0;
                    ** while (var8_10 < var4_4.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (var4_4[var8_10] != null) break;
                    ++var8_10;
                    continue;
                }
lbl28:
                // 2 sources

                if (var8_10 >= var4_4.length) {
                    throw var7_8;
                }
            }
            ++var6_6;
        }
        var7_9 = 0;
        var8_10 = -1;
        while (var7_9 < var4_4.length) {
            if (var4_4[var7_9] != null) {
                if (var8_10 == -1) {
                    var8_10 = var7_9;
                    var4_4[var8_10].allObjects = var4_4;
                }
                var4_4[var7_9].chosenIndex = -1;
            }
            ++var7_9;
        }
        if (var8_10 != -1) {
            return var4_4[var8_10];
        }
        throw new JSAFE_UnimplementedException("A JSAFE_Signature object of " + var0 + " is not available on any of the devices. (" + var1_1 + ")");
    }

    private static JSAFE_Signature getInstance(String[] objectArray, String[] stringArray, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        Object[] objectArray2;
        if (objectArray.length == 2) {
            objectArray2 = new String[]{objectArray[0], objectArray[1], "NoPad"};
            objectArray = objectArray2;
        }
        if (objectArray.length == 5) {
            return JSAFE_Signature.getInstancePSS((String[])objectArray, stringArray, jSAFE_DeviceBuilder, jSAFE_DeviceBuilderArray);
        }
        if (objectArray.length != 3) {
            return null;
        }
        objectArray2 = jSAFE_DeviceBuilder.buildObjects((String[])objectArray, null, 11, strict, interfaceList, fullyQualClassName, stringArray, jSAFE_DeviceBuilderArray);
        if (objectArray2 == null) {
            return null;
        }
        if (objectArray2[0] instanceof JSAFE_Signature) {
            return (JSAFE_Signature)objectArray2[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList((String)objectArray[0]);
        ((JA_AlgaeDigest)objectArray2[0]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList((String)objectArray[1]);
        ((JA_AlgaeSignature)objectArray2[1]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList((String)objectArray[2]);
        ((JA_SignaturePaddingScheme)objectArray2[2]).setInstantiationParameters(nArray);
        if (!((JA_AlgaeSignature)objectArray2[1]).isValidDigestAlgorithm((JA_AlgaeDigest)objectArray2[0])) {
            throw new JSAFE_InvalidParameterException("Invalid digest algorithm");
        }
        if (!((JA_AlgaeSignature)objectArray2[1]).isValidPaddingScheme((JA_SignaturePaddingScheme)objectArray2[2])) {
            throw new JSAFE_InvalidParameterException("Invalid padding scheme.");
        }
        return new JG_Signature((JA_AlgaeDigest)objectArray2[0], (JA_AlgaeSignature)objectArray2[1], (JA_SignaturePaddingScheme)objectArray2[2]);
    }

    private static JSAFE_Signature getInstancePSS(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 11, strictPSS, interfacePSS, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_Signature) {
            return (JSAFE_Signature)objectArray[0];
        }
        int[] nArray = null;
        nArray = JA_ParseList.getParameterList(stringArray[0]);
        ((JA_PSSDigest)objectArray[0]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[1]);
        ((JA_AlgaeSignature)objectArray[1]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[2]);
        ((JA_PSSPadding)objectArray[2]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[3]);
        ((JA_MaskGeneratingFunction)objectArray[3]).setInstantiationParameters(nArray);
        nArray = JA_ParseList.getParameterList(stringArray[4]);
        ((JA_MGFUnderlyingAlgorithm)objectArray[4]).setInstantiationParameters(nArray);
        ((JA_MaskGeneratingFunction)objectArray[3]).setUnderlyingAlgorithm((JA_MGFUnderlyingAlgorithm)objectArray[4]);
        ((JA_PSSPadding)objectArray[2]).setPSSComponents((JA_PSSDigest)objectArray[0], (JA_MaskGeneratingFunction)objectArray[3]);
        if (!((JA_AlgaeSignature)objectArray[1]).isValidDigestAlgorithm((JA_PSSDigest)objectArray[0])) {
            throw new JSAFE_InvalidParameterException("Invalid digest algorithm");
        }
        if (!((JA_AlgaeSignature)objectArray[1]).isValidPaddingScheme((JA_PSSPadding)objectArray[2])) {
            throw new JSAFE_InvalidParameterException("Invalid padding scheme.");
        }
        return new JG_Signature((JA_PSSDigest)objectArray[0], (JA_AlgaeSignature)objectArray[1], (JA_PSSPadding)objectArray[2]);
    }

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        return this.getDERAlgorithmID(null, true);
    }

    public byte[] getDERAlgorithmID(String string, boolean bl) throws JSAFE_UnimplementedException {
        if (this.allObjects == null) {
            return this.getDERAlgID(string, bl);
        }
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].getDERAlgID(string, bl);
        }
        int n = 0;
        while (n < this.allObjects.length) {
            block6: {
                try {
                    if (this.allObjects[n] != null) {
                        return this.allObjects[n].getDERAlgID(string, bl);
                    }
                }
                catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                    if (n != this.allObjects.length - 1) break block6;
                    throw jSAFE_UnimplementedException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("Unknown Alg ID");
    }

    protected abstract byte[] getDERAlgID(String var1, boolean var2) throws JSAFE_UnimplementedException;

    public String getDevice() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].theDevice;
        }
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = null;
        int n = 0;
        if (this.chosenIndex == -1) {
            stringArray = new String[this.theDeviceList.length];
            while (n < this.theDeviceList.length) {
                stringArray[n] = this.theDeviceList[n];
                ++n;
            }
        } else {
            stringArray = new String[this.allObjects[this.chosenIndex].theDeviceList.length];
            while (n < this.allObjects[this.chosenIndex].theDeviceList.length) {
                stringArray[n] = this.allObjects[this.chosenIndex].theDeviceList[n];
                ++n;
            }
        }
        return stringArray;
    }

    public abstract String getSignatureAlgorithm();

    public abstract String getDigestAlgorithm();

    public abstract String getPaddingScheme();

    public int getMaxInputLen() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].doGetMaxInputLen();
        }
        return this.doGetMaxInputLen();
    }

    protected abstract int doGetMaxInputLen();

    public int getSignatureSize() {
        if (this.chosenIndex != -1) {
            return this.allObjects[this.chosenIndex].doGetSignatureSize();
        }
        return this.doGetSignatureSize();
    }

    protected abstract int doGetSignatureSize();

    public void signInit(JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        try {
            this.signInit(jSAFE_PrivateKey, null, secureRandom, null);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new JSAFE_InvalidUseException(jSAFE_InvalidParameterException.getMessage());
        }
    }

    public void signInit(JSAFE_PrivateKey jSAFE_PrivateKey, JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_InvalidParameterException {
        this.signInit(jSAFE_PrivateKey, jSAFE_Parameters, secureRandom, null);
    }

    public void signInit(JSAFE_PrivateKey jSAFE_PrivateKey, JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_InvalidParameterException {
        int[] nArray = new int[1];
        String string = null;
        if (this.allObjects == null) {
            string = this.doSignInit(jSAFE_PrivateKey, jSAFE_Parameters, secureRandom, jSAFE_SessionArray, nArray);
            if (string == null) {
                return;
            }
        } else {
            this.chosenIndex = -1;
            int n = 0;
            while (n < this.allObjects.length) {
                if (this.allObjects[n] != null && (string = this.allObjects[n].doSignInit(jSAFE_PrivateKey, jSAFE_Parameters, secureRandom, jSAFE_SessionArray, nArray)) == null) {
                    this.chosenIndex = n;
                    return;
                }
                ++n;
            }
        }
        switch (nArray[0]) {
            case 1: {
                throw new JSAFE_InvalidKeyException(string);
            }
            case 2: {
                throw new JSAFE_InvalidParameterException(string);
            }
        }
        throw new JSAFE_InvalidUseException(string);
    }

    protected abstract String doSignInit(JSAFE_PrivateKey var1, JSAFE_Parameters var2, SecureRandom var3, JSAFE_Session[] var4, int[] var5);

    public void signReInit() throws JSAFE_InvalidUseException {
        if (this.allObjects == null) {
            this.doSignReInit();
            return;
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot signReInit, not initialized.");
        }
        this.allObjects[this.chosenIndex].doSignReInit();
    }

    protected abstract void doSignReInit() throws JSAFE_InvalidUseException;

    public void signUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        if (this.allObjects == null) {
            this.doSignUpdate(byArray, n, n2);
            return;
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        this.allObjects[this.chosenIndex].doSignUpdate(byArray, n, n2);
    }

    protected abstract void doSignUpdate(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException, JSAFE_InputException;

    public byte[] signFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        int n = this.getSignatureSize();
        byte[] byArray = new byte[n];
        if ((n = this.signFinal(byArray, 0)) == 0) {
            return null;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        this.overwrite(byArray);
        return byArray2;
    }

    public int signFinal(byte[] byArray, int n) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        if (this.allObjects == null) {
            return this.doSignFinal(byArray, n);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        return this.allObjects[this.chosenIndex].doSignFinal(byArray, n);
    }

    protected abstract int doSignFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException;

    public void verifyInit(JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException {
        try {
            this.verifyInit(jSAFE_PublicKey, null, secureRandom, null);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new JSAFE_InvalidUseException(jSAFE_InvalidParameterException.getMessage());
        }
    }

    public void verifyInit(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_InvalidParameterException {
        this.verifyInit(jSAFE_PublicKey, jSAFE_Parameters, secureRandom, null);
    }

    public void verifyInit(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_Parameters jSAFE_Parameters, SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_InvalidParameterException {
        int[] nArray = new int[1];
        String string = null;
        if (this.allObjects == null) {
            string = this.doVerifyInit(jSAFE_PublicKey, jSAFE_Parameters, secureRandom, jSAFE_SessionArray, nArray);
            if (string == null) {
                return;
            }
        } else {
            this.chosenIndex = -1;
            int n = 0;
            while (n < this.allObjects.length) {
                if (this.allObjects[n] != null && (string = this.allObjects[n].doVerifyInit(jSAFE_PublicKey, jSAFE_Parameters, secureRandom, jSAFE_SessionArray, nArray)) == null) {
                    this.chosenIndex = n;
                    return;
                }
                ++n;
            }
        }
        switch (nArray[0]) {
            case 1: {
                throw new JSAFE_InvalidKeyException(string);
            }
            case 2: {
                throw new JSAFE_InvalidParameterException(string);
            }
        }
        throw new JSAFE_InvalidUseException(string);
    }

    protected abstract String doVerifyInit(JSAFE_PublicKey var1, JSAFE_Parameters var2, SecureRandom var3, JSAFE_Session[] var4, int[] var5);

    public void verifyReInit() throws JSAFE_InvalidUseException {
        if (this.allObjects == null) {
            this.doVerifyReInit();
            return;
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Cannot verifyReInit, not initialized.");
        }
        this.allObjects[this.chosenIndex].doVerifyReInit();
    }

    protected abstract void doVerifyReInit() throws JSAFE_InvalidUseException;

    public void verifyUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException {
        if (this.allObjects == null) {
            this.doVerifyUpdate(byArray, n, n2);
            return;
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        this.allObjects[this.chosenIndex].doVerifyUpdate(byArray, n, n2);
    }

    protected abstract void doVerifyUpdate(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException, JSAFE_InputException;

    public boolean verifyFinal(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException {
        if (this.allObjects == null) {
            return this.doVerifyFinal(byArray, n, n2);
        }
        if (this.chosenIndex == -1) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        return this.allObjects[this.chosenIndex].doVerifyFinal(byArray, n, n2);
    }

    protected abstract boolean doVerifyFinal(byte[] var1, int var2, int var3) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_PaddingException;

    protected void setJSAFELevelValues(JSAFE_Signature jSAFE_Signature) {
        this.theDevice = jSAFE_Signature.theDevice;
        this.theDeviceList = new String[jSAFE_Signature.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_Signature.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_Signature.theDeviceList[n];
            ++n;
        }
        this.chosenIndex = jSAFE_Signature.chosenIndex;
        if (jSAFE_Signature.allObjects != null) {
            this.allObjects = new JSAFE_Signature[jSAFE_Signature.allObjects.length];
            boolean bl = false;
            try {
                int n2 = 0;
                while (n2 < jSAFE_Signature.allObjects.length) {
                    if (jSAFE_Signature.allObjects[n2] != null) {
                        if (!bl) {
                            this.allObjects[n2] = this;
                            bl = true;
                        } else {
                            this.allObjects[n2] = (JSAFE_Signature)jSAFE_Signature.allObjects[n2].clone();
                        }
                    }
                    ++n2;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.allObjects == null) {
            this.doClearSensitiveData();
        } else {
            int n = 0;
            while (n < this.allObjects.length) {
                if (this.allObjects[n] != null) {
                    this.allObjects[n].doClearSensitiveData();
                }
                ++n;
            }
        }
        this.chosenIndex = -1;
    }

    protected abstract void doClearSensitiveData();

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            switch (n) {
                case 0: {
                    if (stringArray[n].startsWith("SHA1", 0)) {
                        return new JA_SHA1();
                    }
                    if (stringArray[n].startsWith("MD5", 0)) {
                        return new JA_MD5();
                    }
                    if (stringArray[n].startsWith("MD2", 0)) {
                        return new JA_MD2();
                    }
                    if (stringArray[n].startsWith("SHA256", 0)) {
                        return new JA_SHA256();
                    }
                    if (stringArray[n].startsWith("SHA384", 0)) {
                        return new JA_SHA384();
                    }
                    if (stringArray[n].startsWith("SHA512", 0)) {
                        return new JA_SHA512();
                    }
                    if (stringArray[n].startsWith("RIPEMD160", 0)) {
                        return new JA_RIPEMD160();
                    }
                    if (stringArray[n].startsWith("NoDigest", 0)) {
                        return new JA_NoDigest();
                    }
                    return null;
                }
                case 1: {
                    if (stringArray[n].startsWith("RSA", 0)) {
                        return new JA_RSA();
                    }
                    if (stringArray[n].startsWith("X931RSA", 0)) {
                        return new JA_X931RSA();
                    }
                    if (stringArray[n].startsWith("DSA", 0)) {
                        return new JA_DSA();
                    }
                    return null;
                }
                case 2: {
                    if (stringArray[n].startsWith("PKCS1Block01Pad", 0)) {
                        return new JA_PKCS1Block01Pad();
                    }
                    if (stringArray[n].startsWith("X931Pad", 0)) {
                        return new JA_X931Pad();
                    }
                    if (stringArray[n].startsWith("PKCS1V2PSS", 0)) {
                        return new JA_PKCS1V2PSS();
                    }
                    if (stringArray[n].startsWith("NoPad", 0)) {
                        return new JA_NoPad();
                    }
                    return null;
                }
                case 3: {
                    if (stringArray[n].startsWith("MGF1", 0)) {
                        return new JA_MGF1();
                    }
                    return null;
                }
                case 4: {
                    if (stringArray[n].startsWith("SHA1", 0)) {
                        return new JA_SHA1();
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

