/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.EncodedContainer;
import com.rsa.jsafe.JA_3DES_EDE;
import com.rsa.jsafe.JA_AES;
import com.rsa.jsafe.JA_AES128;
import com.rsa.jsafe.JA_AES192;
import com.rsa.jsafe.JA_AES256;
import com.rsa.jsafe.JA_AlgaeBlockCipher;
import com.rsa.jsafe.JA_AlgaeDigest;
import com.rsa.jsafe.JA_AlgaeStreamCipher;
import com.rsa.jsafe.JA_CBC;
import com.rsa.jsafe.JA_CFB;
import com.rsa.jsafe.JA_DES;
import com.rsa.jsafe.JA_DESX;
import com.rsa.jsafe.JA_ECB;
import com.rsa.jsafe.JA_FeedbackMode;
import com.rsa.jsafe.JA_MD2;
import com.rsa.jsafe.JA_MD5;
import com.rsa.jsafe.JA_NoPad;
import com.rsa.jsafe.JA_OFB;
import com.rsa.jsafe.JA_PKCS12PBE;
import com.rsa.jsafe.JA_PKCS12V1PBE;
import com.rsa.jsafe.JA_PKCS5PBE;
import com.rsa.jsafe.JA_PKCS5Padding;
import com.rsa.jsafe.JA_PKCS5V2PBE;
import com.rsa.jsafe.JA_ParseDevice;
import com.rsa.jsafe.JA_ParseList;
import com.rsa.jsafe.JA_ParseSpecificTrans;
import com.rsa.jsafe.JA_PasswordStandard;
import com.rsa.jsafe.JA_RC2;
import com.rsa.jsafe.JA_RC4;
import com.rsa.jsafe.JA_RC5;
import com.rsa.jsafe.JA_RIPEMD160;
import com.rsa.jsafe.JA_SHA1;
import com.rsa.jsafe.JA_SHA256;
import com.rsa.jsafe.JA_SHA384;
import com.rsa.jsafe.JA_SHA512;
import com.rsa.jsafe.JA_SSLCKeyEncode;
import com.rsa.jsafe.JA_SSLCPBE;
import com.rsa.jsafe.JA_SymmetricPaddingScheme;
import com.rsa.jsafe.JG_BlockCipher;
import com.rsa.jsafe.JG_PasswordBlockCipher;
import com.rsa.jsafe.JG_PasswordStreamCipher;
import com.rsa.jsafe.JG_StreamCipher;
import com.rsa.jsafe.JSAFE_DeviceBuilder;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class JSAFE_SymmetricCipher
extends JSAFE_Object
implements Cloneable,
Serializable {
    private String theDevice;
    private String[] theDeviceList;
    private static boolean[] strictStream = new boolean[]{true};
    private static boolean[] strictBlock = new boolean[]{true, false, false};
    private static boolean[] strictPassBlock = new boolean[]{true, true, false, false};
    private static boolean[] strictPassStream = new boolean[]{true, true, false};
    private static String[] interfaceBlock = new String[]{"com.rsa.jsafe.JA_AlgaeBlockCipher", "com.rsa.jsafe.JA_FeedbackMode", "com.rsa.jsafe.JA_SymmetricPaddingScheme"};
    private static String[] interfaceStream = new String[]{"com.rsa.jsafe.JA_AlgaeStreamCipher"};
    private static String[] interfacePassBlock = new String[]{"com.rsa.jsafe.JA_AlgaeDigest", "com.rsa.jsafe.JA_AlgaeBlockCipher", "com.rsa.jsafe.JA_FeedbackMode", "com.rsa.jsafe.JA_PasswordStandard"};
    private static String[] interfacePassStream = new String[]{"com.rsa.jsafe.JA_AlgaeDigest", "com.rsa.jsafe.JA_AlgaeStreamCipher", "com.rsa.jsafe.JA_PasswordStandard"};
    private static final String fullyQualClassName = "com.rsa.jsafe.JSAFE_SymmetricCipher";
    private static final int STREAM = 1;
    private static final int BLOCK = 3;
    private static final int PASSWORD_STREAM = 4;
    private static final int PASSWORD_BLOCK = 5;

    public static JSAFE_SymmetricCipher getInstance(byte[] byArray, int n, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        String string2 = null;
        EncodedContainer encodedContainer = null;
        try {
            encodedContainer = new EncodedContainer(130816, false, 0, null, 0, 0);
            string2 = AlgorithmID.berDecodeAlgID(byArray, n, 6, encodedContainer);
        }
        catch (ASN_Exception aSN_Exception) {
            try {
                byte[] byArray2 = new byte[8];
                string2 = JA_SSLCKeyEncode.decodeSSLCEncodedKey(byArray, 0, byArray2);
                JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(string2, string);
                jSAFE_SymmetricCipher.setSalt(byArray2, 0, 8);
                return jSAFE_SymmetricCipher;
            }
            catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                throw new JSAFE_UnimplementedException("Could not decode the data.(" + jSAFE_InvalidKeyException.getMessage() + ")");
            }
        }
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(string2, string);
        jSAFE_SymmetricCipher.setAlgorithmBER(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
        return jSAFE_SymmetricCipher;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n, 6);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    void setAlgorithmBER(byte[] byArray, int n, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        throw new JSAFE_UnimplementedException("Cannot instantiate, unknown BER algorithm ID.");
    }

    public static JSAFE_SymmetricCipher getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        JSAFE_Object.checkIntegrity();
        if (string2 == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no device given.");
        }
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        String[] stringArray = JA_ParseList.parseElements(string2);
        JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray = new JSAFE_DeviceBuilder[stringArray.length];
        String[] stringArray2 = JA_ParseList.parseElements(string);
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                if (jSAFE_DeviceBuilderArray[n] == null) {
                    jSAFE_DeviceBuilderArray[n] = JA_ParseDevice.getDeviceObject(stringArray[n]);
                }
                try {
                    JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(stringArray2, stringArray, jSAFE_DeviceBuilderArray[n], jSAFE_DeviceBuilderArray);
                    if (jSAFE_SymmetricCipher != null) {
                        jSAFE_SymmetricCipher.theDevice = jSAFE_DeviceBuilderArray[n].getDevice();
                        jSAFE_SymmetricCipher.theDeviceList = jSAFE_DeviceBuilderArray[n].getDeviceList();
                        return jSAFE_SymmetricCipher;
                    }
                }
                catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                    if (n < stringArray.length) break block7;
                    throw jSAFE_InvalidParameterException;
                }
            }
            ++n;
        }
        throw new JSAFE_UnimplementedException("A JSAFE_SymmetricCipher object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_SymmetricCipher getInstance(String[] stringArray, String[] stringArray2, JSAFE_DeviceBuilder jSAFE_DeviceBuilder, JSAFE_DeviceBuilder[] jSAFE_DeviceBuilderArray) throws JSAFE_InvalidParameterException {
        boolean[] blArray = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n = stringArray.length;
        switch (n) {
            case 1: {
                blArray = strictStream;
                stringArray3 = interfaceStream;
                break;
            }
            case 3: {
                blArray = strictBlock;
                stringArray3 = interfaceBlock;
                break;
            }
            case 4: {
                blArray = strictPassStream;
                stringArray3 = interfacePassStream;
                stringArray4 = new String[3];
                int n2 = 0;
                while (n2 < 3) {
                    stringArray4[n2] = stringArray[n2 + 1];
                    ++n2;
                }
                stringArray = stringArray4;
                break;
            }
            case 5: {
                blArray = strictPassBlock;
                stringArray3 = interfacePassBlock;
                stringArray4 = new String[4];
                int n3 = 0;
                while (n3 < 4) {
                    stringArray4[n3] = stringArray[n3 + 1];
                    ++n3;
                }
                stringArray = stringArray4;
                break;
            }
            default: {
                return null;
            }
        }
        Object[] objectArray = jSAFE_DeviceBuilder.buildObjects(stringArray, null, 12, blArray, stringArray3, fullyQualClassName, stringArray2, jSAFE_DeviceBuilderArray);
        if (objectArray == null) {
            return null;
        }
        if (objectArray[0] instanceof JSAFE_SymmetricCipher) {
            return (JSAFE_SymmetricCipher)objectArray[0];
        }
        int[] nArray = null;
        switch (n) {
            case 1: {
                nArray = JA_ParseList.getParameterList(stringArray[0]);
                ((JA_AlgaeStreamCipher)objectArray[0]).setInstantiationParameters(nArray);
                return new JG_StreamCipher((JA_AlgaeStreamCipher)objectArray[0]);
            }
            case 3: {
                nArray = JA_ParseList.getParameterList(stringArray[0]);
                ((JA_AlgaeBlockCipher)objectArray[0]).setInstantiationParameters(nArray);
                nArray = JA_ParseList.getParameterList(stringArray[1]);
                ((JA_FeedbackMode)objectArray[1]).setInstantiationParameters(nArray);
                nArray = JA_ParseList.getParameterList(stringArray[2]);
                ((JA_SymmetricPaddingScheme)objectArray[2]).setInstantiationParameters(nArray);
                return new JG_BlockCipher((JA_AlgaeBlockCipher)objectArray[0], (JA_FeedbackMode)objectArray[1], (JA_SymmetricPaddingScheme)objectArray[2]);
            }
            case 4: {
                nArray = JA_ParseList.getParameterList(stringArray[0]);
                ((JA_AlgaeDigest)objectArray[0]).setInstantiationParameters(nArray);
                nArray = JA_ParseList.getParameterList(stringArray[1]);
                ((JA_AlgaeStreamCipher)objectArray[1]).setInstantiationParameters(nArray);
                nArray = JA_ParseList.getParameterList(stringArray[2]);
                ((JA_PasswordStandard)objectArray[2]).setInstantiationParameters(nArray);
                return new JG_PasswordStreamCipher((JA_AlgaeDigest)objectArray[0], (JA_AlgaeStreamCipher)objectArray[1], (JA_PasswordStandard)objectArray[2]);
            }
            case 5: {
                nArray = JA_ParseList.getParameterList(stringArray[0]);
                ((JA_AlgaeDigest)objectArray[0]).setInstantiationParameters(nArray);
                nArray = JA_ParseList.getParameterList(stringArray[3]);
                ((JA_PasswordStandard)objectArray[3]).setInstantiationParameters(nArray);
                int n4 = -1;
                if (nArray != null && nArray.length >= 2) {
                    n4 = nArray[1];
                }
                nArray = JA_ParseList.getParameterList(stringArray[1]);
                String string = ((JA_AlgaeBlockCipher)objectArray[1]).getAlgorithm();
                if (string.startsWith("RC2") && n4 >= 0) {
                    nArray = new int[]{n4};
                }
                ((JA_AlgaeBlockCipher)objectArray[1]).setInstantiationParameters(nArray);
                nArray = JA_ParseList.getParameterList(stringArray[2]);
                ((JA_FeedbackMode)objectArray[2]).setInstantiationParameters(nArray);
                return new JG_PasswordBlockCipher((JA_AlgaeDigest)objectArray[0], (JA_AlgaeBlockCipher)objectArray[1], (JA_FeedbackMode)objectArray[2], (JA_PasswordStandard)objectArray[3]);
            }
        }
        return null;
    }

    public abstract byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException;

    public String getDevice() {
        return this.theDevice;
    }

    public String[] getDeviceList() {
        String[] stringArray = new String[this.theDeviceList.length];
        int n = 0;
        while (n < this.theDeviceList.length) {
            stringArray[n] = this.theDeviceList[n];
            ++n;
        }
        return stringArray;
    }

    public abstract String getEncryptionAlgorithm();

    public String getFeedbackMode() {
        return null;
    }

    public String getPaddingScheme() {
        return null;
    }

    public String getDigestAlgorithm() {
        return null;
    }

    public String getPasswordStandard() {
        return null;
    }

    public int getBlockSize() {
        return 1;
    }

    public JSAFE_SecretKey getBlankKey() {
        String string = this.getEncryptionAlgorithm();
        String string2 = this.getDevice();
        try {
            return JSAFE_SecretKey.getInstance(string, string2);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return null;
        }
    }

    public abstract int[] getAlgorithmParameters();

    public abstract void setAlgorithmParameters(int[] var1) throws JSAFE_InvalidParameterException;

    public int[] getFeedbackParameters() {
        return new int[0];
    }

    public int[] getPaddingParameters() {
        return new int[0];
    }

    public int[] getPBEParameters() {
        return new int[0];
    }

    public void setPBEParameters(int[] nArray) throws JSAFE_InvalidParameterException {
    }

    public void generateIV(SecureRandom secureRandom) throws JSAFE_IVException, JSAFE_InvalidUseException {
    }

    public void setIV(byte[] byArray, int n, int n2) throws JSAFE_IVException {
    }

    public byte[] getIV() {
        return null;
    }

    public void generateSalt(SecureRandom secureRandom) throws JSAFE_InvalidUseException {
    }

    public void setSalt(byte[] byArray, int n, int n2) {
    }

    public byte[] getSalt() {
        return null;
    }

    public abstract int getOutputBufferSize(int var1);

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.encryptInit(jSAFE_SecretKey, null);
    }

    public abstract void encryptInit(JSAFE_SecretKey var1, SecureRandom var2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException;

    public abstract void encryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException;

    public byte[] encryptUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_IVException {
        int n3 = 0;
        if (n2 <= 0) {
            n3 = this.encryptUpdate(byArray, n, n2, null, 0);
            return new byte[0];
        }
        n3 = this.getOutputBufferSize(n2);
        if (n3 == 0) {
            n3 = this.encryptUpdate(byArray, n, n2, null, 0);
            return new byte[0];
        }
        byte[] byArray2 = new byte[n3];
        if ((n3 = this.encryptUpdate(byArray, n, n2, byArray2, 0)) == 0) {
            return new byte[0];
        }
        if (n3 < byArray2.length) {
            byte[] byArray3 = new byte[n3];
            int n4 = 0;
            while (n4 < n3) {
                byArray3[n4] = byArray2[n4];
                byArray2[n4] = 0;
                ++n4;
            }
            while (n4 < byArray2.length) {
                byArray2[n4] = 0;
                ++n4;
            }
            return byArray3;
        }
        return byArray2;
    }

    public abstract int encryptUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException, JSAFE_IVException;

    public byte[] wrapPrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey, boolean bl) throws JSAFE_InvalidUseException {
        return this.wrapPrivateKey(jSAFE_PrivateKey, bl, null);
    }

    public byte[] wrapPrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey, boolean bl, String string) throws JSAFE_InvalidUseException {
        if (jSAFE_PrivateKey == null) {
            throw new JSAFE_InvalidUseException("The key to wrap is null.");
        }
        if (string != null) {
            if (string.endsWith("PEM") || string.startsWith("SSLC")) {
                return this.wrapPrivateKeySpecialFormat(jSAFE_PrivateKey, string);
            }
            String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n]) && string.endsWith("BER")) break;
                ++n;
            }
            if (n >= stringArray.length) {
                throw new JSAFE_InvalidUseException("The  format, " + string + ", is not valid for this key");
            }
        }
        return this.wrapKey(jSAFE_PrivateKey, bl, string);
    }

    protected byte[] wrapPrivateKeySpecialFormat(JSAFE_PrivateKey jSAFE_PrivateKey, String string) throws JSAFE_InvalidUseException {
        return new byte[0];
    }

    public byte[] wrapPublicKey(JSAFE_PublicKey jSAFE_PublicKey, boolean bl) throws JSAFE_InvalidUseException {
        if (jSAFE_PublicKey == null) {
            throw new JSAFE_InvalidUseException("The key to wrap is null.");
        }
        return this.wrapKey(jSAFE_PublicKey, bl);
    }

    public byte[] wrapSecretKey(JSAFE_SecretKey jSAFE_SecretKey, boolean bl) throws JSAFE_InvalidUseException {
        if (jSAFE_SecretKey == null) {
            throw new JSAFE_InvalidUseException("The key to wrap is null.");
        }
        return this.wrapKey(jSAFE_SecretKey, bl);
    }

    private byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl) throws JSAFE_InvalidUseException {
        return this.wrapKey(jSAFE_Key, bl, null);
    }

    private byte[] wrapKey(JSAFE_Key jSAFE_Key, boolean bl, String string) throws JSAFE_InvalidUseException {
        byte[] byArray = null;
        int n = 0;
        if (bl) {
            try {
                byArray = this.getDERAlgorithmID();
                if (byArray == null) {
                    throw new JSAFE_InvalidUseException("Cannot wrap the given key into a BER.");
                }
                n = byArray.length;
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidUseException("Cannot wrap the given key into a BER.");
            }
        }
        return this.wrapKeyObject(jSAFE_Key, bl, string, byArray, 0, n);
    }

    protected abstract byte[] wrapKeyObject(JSAFE_Key var1, boolean var2, byte[] var3, int var4, int var5) throws JSAFE_InvalidUseException;

    protected abstract byte[] wrapKeyObject(JSAFE_Key var1, boolean var2, String var3, byte[] var4, int var5, int var6) throws JSAFE_InvalidUseException;

    public byte[] encryptFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        int n = this.getOutputBufferSize(0);
        if (n == 0) {
            n = this.encryptFinal(null, 0);
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        if ((n = this.encryptFinal(byArray, 0)) == 0) {
            return new byte[0];
        }
        if (n < byArray.length) {
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray2[n2] = byArray[n2];
                byArray[n2] = 0;
                ++n2;
            }
            while (n2 < byArray.length) {
                byArray[n2] = 0;
                ++n2;
            }
            return byArray2;
        }
        return byArray;
    }

    public abstract int encryptFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException;

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.decryptInit(jSAFE_SecretKey, null);
    }

    public abstract void decryptInit(JSAFE_SecretKey var1, SecureRandom var2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException;

    public abstract void decryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException;

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n, int n2, boolean bl) throws JSAFE_InvalidUseException {
        return this.unwrapPrivateKey(byArray, n, n2, bl, null);
    }

    public abstract JSAFE_PrivateKey unwrapPrivateKey(byte[] var1, int var2, int var3, boolean var4, String var5) throws JSAFE_InvalidUseException;

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n, int n2, boolean bl) throws JSAFE_InvalidUseException {
        return this.unwrapPublicKey(byArray, n, n2, bl, null);
    }

    public abstract JSAFE_PublicKey unwrapPublicKey(byte[] var1, int var2, int var3, boolean var4, String var5) throws JSAFE_InvalidUseException;

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n, int n2, boolean bl, String string) throws JSAFE_InvalidUseException {
        return this.unwrapSecretKey(byArray, n, n2, bl, string, null);
    }

    public abstract JSAFE_SecretKey unwrapSecretKey(byte[] var1, int var2, int var3, boolean var4, String var5, String var6) throws JSAFE_InvalidUseException;

    public byte[] decryptUpdate(byte[] byArray, int n, int n2) throws JSAFE_InvalidUseException, JSAFE_IVException {
        if (n2 <= 0) {
            int n3 = this.decryptUpdate(byArray, n, n2, null, 0);
            return new byte[0];
        }
        int n4 = this.getOutputBufferSize(n2);
        if (n4 == 0) {
            n4 = this.decryptUpdate(byArray, n, n2, null, 0);
            return new byte[0];
        }
        byte[] byArray2 = new byte[n4];
        if ((n4 = this.decryptUpdate(byArray, n, n2, byArray2, 0)) == 0) {
            return new byte[0];
        }
        if (n4 < byArray2.length) {
            byte[] byArray3 = new byte[n4];
            int n5 = 0;
            while (n5 < n4) {
                byArray3[n5] = byArray2[n5];
                byArray2[n5] = 0;
                ++n5;
            }
            while (n5 < byArray2.length) {
                byArray2[n5] = 0;
                ++n5;
            }
            return byArray3;
        }
        return byArray2;
    }

    public abstract int decryptUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws JSAFE_InvalidUseException, JSAFE_IVException;

    public byte[] decryptFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        int n = this.getOutputBufferSize(0);
        if (n == 0) {
            n = this.decryptFinal(null, 0);
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        if ((n = this.decryptFinal(byArray, 0)) == 0) {
            return new byte[0];
        }
        if (n < byArray.length) {
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray2[n2] = byArray[n2];
                byArray[n2] = 0;
                ++n2;
            }
            while (n2 < byArray.length) {
                byArray[n2] = 0;
                ++n2;
            }
            return byArray2;
        }
        return byArray;
    }

    public abstract int decryptFinal(byte[] var1, int var2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException;

    protected void setJSAFELevelValues(JSAFE_SymmetricCipher jSAFE_SymmetricCipher) {
        this.theDevice = jSAFE_SymmetricCipher.theDevice;
        this.theDeviceList = new String[jSAFE_SymmetricCipher.theDeviceList.length];
        int n = 0;
        while (n < jSAFE_SymmetricCipher.theDeviceList.length) {
            this.theDeviceList[n] = jSAFE_SymmetricCipher.theDeviceList[n];
            ++n;
        }
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
    }

    static JA_ParseSpecificTrans getTransformationParser() {
        return new TransformationParser();
    }

    static class TransformationParser
    implements JA_ParseSpecificTrans {
        private int transType;

        TransformationParser() {
        }

        public Object getJavaObject(String[] stringArray, int n, String string, String[] stringArray2) {
            if (stringArray.length == 1) {
                if (stringArray[n].startsWith("RC4", 0)) {
                    return new JA_RC4();
                }
                return null;
            }
            if (stringArray.length == 4) {
                this.transType = 3;
            }
            switch (n) {
                case 0: {
                    if (this.transType != 3) {
                        this.transType = 1;
                        Object object = this.getBlockCipher(stringArray[n]);
                        if (object != null) {
                            return object;
                        }
                        this.transType = 2;
                    }
                    if (stringArray[n].startsWith("SHA1", 0)) {
                        return new JA_SHA1();
                    }
                    if (stringArray[n].startsWith("MD5", 0)) {
                        return new JA_MD5();
                    }
                    if (stringArray[n].startsWith("MD2", 0)) {
                        return new JA_MD2();
                    }
                    if (stringArray[n].startsWith("SHA256", 0)) {
                        return new JA_SHA256();
                    }
                    if (stringArray[n].startsWith("SHA384", 0)) {
                        return new JA_SHA384();
                    }
                    if (stringArray[n].startsWith("SHA512", 0)) {
                        return new JA_SHA512();
                    }
                    if (stringArray[n].startsWith("RIPEMD160", 0)) {
                        return new JA_RIPEMD160();
                    }
                    return null;
                }
                case 1: {
                    if (this.transType == 1) {
                        return this.getFeedback(stringArray[n]);
                    }
                    if (this.transType == 3) {
                        return this.getBlockCipher(stringArray[n]);
                    }
                    if (stringArray[n].startsWith("RC4", 0)) {
                        return new JA_RC4();
                    }
                    return null;
                }
                case 2: {
                    if (this.transType == 1) {
                        if (stringArray[n].startsWith("PKCS5Padding", 0)) {
                            return new JA_PKCS5Padding();
                        }
                        if (stringArray[n].startsWith("NoPad", 0)) {
                            return new JA_NoPad();
                        }
                        return null;
                    }
                    if (this.transType == 3) {
                        return this.getFeedback(stringArray[n]);
                    }
                }
                case 3: {
                    if (stringArray[n].startsWith("PKCS5PBE", 0)) {
                        return new JA_PKCS5PBE();
                    }
                    if (stringArray[n].startsWith("PKCS5V2PBE", 0)) {
                        return new JA_PKCS5V2PBE();
                    }
                    if (stringArray[n].startsWith("PKCS12V1PBE", 0)) {
                        return new JA_PKCS12V1PBE();
                    }
                    if (stringArray[n].startsWith("PKCS12PBE", 0)) {
                        return new JA_PKCS12PBE();
                    }
                    if (!stringArray[n].startsWith("SSLCPBE", 0)) break;
                    return new JA_SSLCPBE();
                }
            }
            return null;
        }

        private Object getBlockCipher(String string) {
            if (string.startsWith("AES")) {
                if (string.length() == 3) {
                    return new JA_AES();
                }
                if (string.endsWith("128")) {
                    return new JA_AES128();
                }
                if (string.endsWith("192")) {
                    return new JA_AES192();
                }
                if (string.endsWith("256")) {
                    return new JA_AES256();
                }
            }
            if (string.compareTo("DES") == 0) {
                return new JA_DES();
            }
            if (string.startsWith("3DES_EDE", 0)) {
                return new JA_3DES_EDE();
            }
            if (string.startsWith("RC2", 0)) {
                return new JA_RC2();
            }
            if (string.startsWith("RC5", 0)) {
                return new JA_RC5();
            }
            if (string.startsWith("DESX", 0)) {
                return new JA_DESX();
            }
            return null;
        }

        private Object getFeedback(String string) {
            if (string.startsWith("CBC", 0)) {
                return new JA_CBC();
            }
            if (string.startsWith("ECB", 0)) {
                return new JA_ECB();
            }
            if (string.startsWith("CFB", 0)) {
                return new JA_CFB();
            }
            if (string.startsWith("OFB", 0)) {
                return new JA_OFB();
            }
            return null;
        }
    }
}

