/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.Utils;

public class KATDES {
    static byte[] keyData = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
    static byte[] initVector = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    static byte[] dataToEncrypt = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};
    static byte[][] expectedResult = new byte[][]{{-107, -8, -91, -27, -35, 49, -39, 0}, {-107, -8, -91, -27, -35, 49, -39, 0}, {12, -90, 77, -23, -63, -79, 35, -89}, {12, -90, 77, -23, -63, -79, 35, -89}};
    static final String[] feedbackModes = new String[]{"ECB", "CBC", "CFB", "OFB"};

    public boolean test() {
        JSAFE_Obfuscator.setPower(true);
        JSAFE_SecureRandom jSAFE_SecureRandom = null;
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher2 = null;
        JSAFE_SecretKey jSAFE_SecretKey = null;
        try {
            jSAFE_SecureRandom = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance("SHA1Random", "Java");
            int n = 0;
            while (n < feedbackModes.length) {
                String string = "DES/" + feedbackModes[n] + "/NoPad";
                jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance(string, "Java");
                jSAFE_SymmetricCipher2 = JSAFE_SymmetricCipher.getInstance(string, "Java");
                if (n != 0) {
                    jSAFE_SymmetricCipher.setIV(initVector, 0, initVector.length);
                    jSAFE_SymmetricCipher2.setIV(initVector, 0, initVector.length);
                }
                jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
                jSAFE_SecretKey.setSecretKeyData("Clear", keyData, 0, keyData.length);
                byte[] byArray = new byte[jSAFE_SymmetricCipher.getOutputBufferSize(dataToEncrypt.length)];
                jSAFE_SymmetricCipher.encryptInit(jSAFE_SecretKey, jSAFE_SecureRandom);
                int n2 = jSAFE_SymmetricCipher.encryptUpdate(dataToEncrypt, 0, dataToEncrypt.length, byArray, 0);
                n2 += jSAFE_SymmetricCipher.encryptFinal(byArray, n2);
                Utils.assertEquals("encryptedData and expectedResult", byArray, 0, n2, expectedResult[n], 0, expectedResult[n].length);
                byte[] byArray2 = new byte[jSAFE_SymmetricCipher2.getOutputBufferSize(byArray.length)];
                jSAFE_SymmetricCipher2.decryptInit(jSAFE_SecretKey);
                int n3 = jSAFE_SymmetricCipher2.decryptUpdate(byArray, 0, byArray.length, byArray2, 0);
                n3 += jSAFE_SymmetricCipher2.decryptFinal(byArray2, n3);
                Utils.assertEquals("decryptedData and dataToEncrypt", byArray2, 0, n3, dataToEncrypt, 0, dataToEncrypt.length);
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }
}

