/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JSAFE_Obfuscator;
import com.rsa.jsafe.ObfuscatorItemFunction;
import java.io.Serializable;

final class ObfuscatorItem
implements Serializable {
    private Object data;
    private int dataType;
    private ObfuscatorItemFunction oif;
    private boolean power = false;
    private boolean obfuscated = false;

    ObfuscatorItem(Object object, int n, boolean bl) {
        this.dataType = n;
        if (this.dataType == 4) {
            return;
        }
        this.data = object;
        this.power = bl;
        if (this.power) {
            this.oif = new ObfuscatorItemFunction(n);
            this.obfuscate();
        }
    }

    boolean getPower() {
        return this.power;
    }

    boolean getObfuscationState() {
        return this.obfuscated;
    }

    void obfuscate() {
        if (this.obfuscated || !this.power || this.oif == null) {
            return;
        }
        this.oif.performXOR(this.data);
        this.obfuscated = true;
    }

    void deobfuscate() {
        if (!this.obfuscated || !this.power || this.oif == null) {
            return;
        }
        this.oif.performXOR(this.data);
        this.obfuscated = false;
    }

    void overwrite() {
        JSAFE_Obfuscator.overwrite(this.data);
        this.obfuscated = false;
    }

    synchronized void copy(Object object) {
        if (!this.obfuscated) {
            return;
        }
        this.oif.performXOR(object);
    }

    protected void destroy() {
        if (this.data != null) {
            JSAFE_Obfuscator.overwrite(this.data);
        }
        if (this.oif != null) {
            this.oif.destroy();
        }
        this.data = null;
        this.dataType = 4;
        this.oif = null;
        this.obfuscated = false;
    }
}

