/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.AssertFailedError;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Utils {
    public static int DSA_BLOCK_SIZE = 20;
    public static final PrintWriter STDOUT = new PrintWriter(System.out, true);

    protected Utils() {
    }

    public static void assertTrue(String string, boolean bl) {
        if (!bl) {
            Utils.fail(string);
        }
    }

    public static void assertTrue(boolean bl) {
        Utils.assertTrue(null, bl);
    }

    public static void fail(String string) {
        throw new AssertFailedError(string);
    }

    public static void fail() {
        Utils.fail(null);
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        Utils.failNotEquals(string, object, object2);
    }

    public static void assertEquals(Object object, Object object2) {
        Utils.assertEquals(null, object, object2);
    }

    public static void assertEquals(String string, double d, double d2, double d3) {
        if (Double.isInfinite(d)) {
            if (d != d2) {
                Utils.failNotEquals(string, new Double(d), new Double(d2));
            }
        } else if (!(Math.abs(d - d2) <= d3)) {
            Utils.failNotEquals(string, new Double(d), new Double(d2));
        }
    }

    public static void assertEquals(double d, double d2, double d3) {
        Utils.assertEquals(null, d, d2, d3);
    }

    public static void assertEquals(String string, float f, float f2, float f3) {
        if (Float.isInfinite(f)) {
            if (f != f2) {
                Utils.failNotEquals(string, new Float(f), new Float(f2));
            }
        } else if (!(Math.abs(f - f2) <= f3)) {
            Utils.failNotEquals(string, new Float(f), new Float(f2));
        }
    }

    public static void assertEquals(float f, float f2, float f3) {
        Utils.assertEquals(null, f, f2, f3);
    }

    public static void assertEquals(String string, long l, long l2) {
        Utils.assertEquals(string, new Long(l), new Long(l2));
    }

    public static void assertEquals(long l, long l2) {
        Utils.assertEquals(null, l, l2);
    }

    public static void assertEquals(String string, boolean bl, boolean bl2) {
        Utils.assertEquals(string, new Boolean(bl), new Boolean(bl2));
    }

    public static void assertEquals(boolean bl, boolean bl2) {
        Utils.assertEquals(null, bl, bl2);
    }

    public static void assertEquals(String string, byte by, byte by2) {
        Utils.assertEquals(string, new Byte(by), new Byte(by2));
    }

    public static void assertEquals(byte by, byte by2) {
        Utils.assertEquals(null, by, by2);
    }

    public static void assertEquals(String string, char c, char c2) {
        Utils.assertEquals(string, new Character(c), new Character(c2));
    }

    public static void assertEquals(char c, char c2) {
        Utils.assertEquals(null, c, c2);
    }

    public static void assertEquals(String string, short s, short s2) {
        Utils.assertEquals(string, new Short(s), new Short(s2));
    }

    public static void assertEquals(short s, short s2) {
        Utils.assertEquals(null, s, s2);
    }

    public static void assertEquals(String string, int n, int n2) {
        Utils.assertEquals(string, new Integer(n), new Integer(n2));
    }

    public static void assertEquals(int n, int n2) {
        Utils.assertEquals(null, n, n2);
    }

    public static void assertNotNull(Object object) {
        Utils.assertNotNull(null, object);
    }

    public static void assertNotNull(String string, Object object) {
        Utils.assertTrue(string, object != null);
    }

    public static void assertNull(Object object) {
        Utils.assertNull(null, object);
    }

    public static void assertNull(String string, Object object) {
        Utils.assertTrue(string, object == null);
    }

    public static void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        Utils.failNotSame(string, object, object2);
    }

    public static void assertSame(Object object, Object object2) {
        Utils.assertSame(null, object, object2);
    }

    private static void failNotEquals(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Utils.fail(string2 + "expected:<" + object + "> but was:<" + object2 + ">");
    }

    private static void failNotSame(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Utils.fail(string2 + "expected same");
    }

    public static void assertEquals(byte[] byArray, byte[] byArray2) {
        Utils.assertEquals(null, byArray, byArray2);
    }

    public static void assertEquals(String string, byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return;
        }
        if (byArray != null && Utils.equals(byArray, byArray2)) {
            return;
        }
        Utils.failNotEqualsByteArray(string, byArray, byArray2);
    }

    public static void assertEquals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        Utils.assertEquals(null, byArray, n, n2, byArray2, n3, n4);
    }

    public static void assertEquals(String string, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == null && byArray2 == null) {
            return;
        }
        if (byArray != null && Utils.equals(byArray, n, n2, byArray2, n3, n4)) {
            return;
        }
        Utils.failNotEqualsByteArray(string, byArray, n, n2, byArray2, n3, n4);
    }

    public static void assertNotEquals(String string, byte[] byArray, byte[] byArray2) {
        if (!Utils.equals(byArray, byArray2)) {
            return;
        }
        String string2 = Utils.byteBufferToHexString(byArray, 0, byArray.length, false);
        String string3 = Utils.byteBufferToHexString(byArray2, 0, byArray2.length, false);
        Utils.failEquals(string, string2, string3);
    }

    private static void failEquals(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " - ";
        }
        Utils.fail(string2 + "Not expected:<" + object + "> yet it was:<" + object2 + ">");
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        return Utils.equals(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equals(byte[] var0, int var1_1, int var2_2, byte[] var3_3, int var4_4, int var5_5) {
        if (var0 == null || var3_3 == null) {
            return var0 == null && var3_3 == null;
        }
        if (var2_2 == var5_5) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (var0[var1_1] != var3_3[var4_4]) {
                return false;
            }
            ++var1_1;
            ++var4_4;
lbl9:
            // 2 sources

            ** while (var1_1 < var2_2)
        }
lbl10:
        // 1 sources

        return true;
    }

    private static void failNotEqualsByteArray(String string, byte[] byArray, byte[] byArray2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        String string3 = Utils.byteBufferToHexString(byArray, 0, byArray.length, false);
        String string4 = Utils.byteBufferToHexString(byArray2, 0, byArray2.length, false);
        Utils.fail(string2 + "expected:<" + string3 + "> but was:<" + string4 + ">");
    }

    private static void failNotEqualsByteArray(String string, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        String string3 = Utils.byteBufferToHexString(byArray, n, n2, false);
        String string4 = Utils.byteBufferToHexString(byArray2, n3, n4, false);
        Utils.fail(string2 + "expected:<" + string3 + "> but was:<" + string4 + ">");
    }

    public static String byteBufferToHexString(byte[] byArray, int n, int n2, boolean bl) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return Utils.byteBufferToHexString(byArray2, bl);
    }

    public static String byteBufferToHexString(byte[] byArray, boolean bl) {
        String string = "";
        int n = 0;
        int n2 = byArray.length;
        while (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < 8) {
                if (n2 == 0) break;
                int n4 = byArray[n] & 0xFF;
                String string2 = Integer.toHexString(n4);
                if (bl) {
                    stringBuffer = string2.length() == 1 ? stringBuffer.append(" 0x0") : stringBuffer.append(" 0x");
                }
                stringBuffer = stringBuffer.append(string2);
                if (bl && --n2 != 0) {
                    stringBuffer = stringBuffer.append(",");
                }
                ++n3;
                ++n;
            }
            string = string + stringBuffer.toString();
        }
        return string;
    }

    public static byte[] hexStringToByteArray(String string) {
        if (string.equals("")) {
            return new byte[0];
        }
        byte[] byArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        if (string2.substring(0, 2).equals("0x")) {
            string2 = string2.substring(2);
        }
        byArray = new byte[(string2.length() + 1) / 2];
        int n = 0;
        int n2 = 0;
        if (string2.length() % 2 != 0) {
            try {
                byArray[0] = Byte.parseByte("0" + string2.substring(0, 1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n = 1;
            n2 = 1;
        }
        try {
            while (n < byArray.length) {
                byte by;
                byArray[n] = by = Byte.parseByte(string2.substring(n2, n2 + 1), 16);
                byArray[n] = (byte)(byArray[n] * 16);
                byte by2 = Byte.parseByte(string2.substring(n2 + 1, n2 + 2), 16);
                byArray[n] = (byte)(byArray[n] + by2);
                ++n;
                n2 += 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            int n3 = byArray[n2] & 0xFF;
            String string = Integer.toHexString(n3);
            if (string.length() == 1) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer = stringBuffer.append(string);
            --n;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n2 > 0) {
            int n4 = byArray[n3] & 0xFF;
            String string = Integer.toHexString(n4);
            if (string.length() == 1) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer = stringBuffer.append(string);
            --n2;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static byte[] berEncodeDSASignature(byte[] byArray) throws Throwable {
        byte[] byArray2 = new byte[DSA_BLOCK_SIZE];
        byte[] byArray3 = new byte[DSA_BLOCK_SIZE];
        System.arraycopy(byArray, 0, byArray2, 0, DSA_BLOCK_SIZE);
        System.arraycopy(byArray, DSA_BLOCK_SIZE, byArray3, 0, DSA_BLOCK_SIZE);
        return Utils.doBEREncodeDSASignature(byArray2, byArray3);
    }

    public static byte[] doBEREncodeDSASignature(byte[] byArray, byte[] byArray2) throws Throwable {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
        IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, byArray2, 0, byArray2.length, true);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
        return ASN1.derEncode(aSN1ContainerArray);
    }

    public static byte[] berDecodeDSASignature(byte[] byArray) throws Exception {
        byte[][] byArray2 = Utils.doBERDecodeDSASignature(byArray);
        byte[] byArray3 = new byte[2 * DSA_BLOCK_SIZE];
        System.arraycopy(byArray2[0], 0, byArray3, 0, DSA_BLOCK_SIZE);
        System.arraycopy(byArray2[1], 0, byArray3, DSA_BLOCK_SIZE, DSA_BLOCK_SIZE);
        return byArray3;
    }

    public static byte[][] doBERDecodeDSASignature(byte[] byArray) throws Exception {
        byte[][] byArrayArray = new byte[][]{new byte[DSA_BLOCK_SIZE], new byte[DSA_BLOCK_SIZE]};
        byte[] byArray2 = byArrayArray[0];
        byte[] byArray3 = byArrayArray[1];
        try {
            try {
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                IntegerContainer integerContainer = new IntegerContainer(0, true, 0, 0);
                IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, 0);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
                int n = ASN1.berDecode(byArray, 0, aSN1ContainerArray);
                int n2 = integerContainer.dataOffset + integerContainer.dataLen - 1;
                int n3 = DSA_BLOCK_SIZE - 1;
                while (n3 >= 0) {
                    if (n2 >= integerContainer.dataOffset) {
                        byArray2[n3] = integerContainer.data[n2];
                    }
                    --n3;
                    --n2;
                }
                int n4 = integerContainer2.dataOffset + integerContainer2.dataLen - 1;
                int n5 = DSA_BLOCK_SIZE - 1;
                while (n5 >= 0) {
                    if (n4 >= integerContainer2.dataOffset) {
                        byArray3[n5] = integerContainer2.data[n4];
                    }
                    --n5;
                    --n4;
                }
                byte[][] byArrayArray2 = byArrayArray;
                Object var16_16 = null;
                return byArrayArray2;
            }
            catch (ASN_Exception aSN_Exception) {
                throw new Exception(aSN_Exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            throw throwable;
        }
    }
}

