/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSDate;
import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSCurrData;
import com.siebel.om.om.CSSLocale;

public class CSSCurrency
extends CSSNumber {
    private String m_currencyCode;
    private double m_minAcctUnit;
    private CSSDate m_exchangeDate;
    private boolean m_bEuro;

    public CSSCurrency(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSCurrency(CSSCurrency cSSCurrency) {
        super(cSSCurrency.getLocale());
        try {
            this.copy(cSSCurrency);
        }
        catch (CSSException cSSException) {
            // empty catch block
        }
    }

    public CSSCurrency(double d, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(d);
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            this.finalCSSDatumAssign(cSSDatum);
            if (this.m_bNull) {
                this.m_value = 0.0;
            } else if (cSSDatum instanceof CSSCurrency) {
                this.setValue((CSSCurrency)cSSDatum);
            } else if (cSSDatum instanceof CSSNumber) {
                this.setValue(((CSSNumber)cSSDatum).getValue());
            } else if (cSSDatum instanceof CSSString) {
                this.setAsString(((CSSString)cSSDatum).getValue());
            }
            this.setError(false);
        }
        catch (CSSException cSSException) {
            this.m_bNull = true;
            this.m_value = 0.0;
            this.setError(true);
            throw cSSException;
        }
    }

    @Override
    public int compare(CSSDatum cSSDatum, boolean bl) {
        CSSCurrency cSSCurrency = new CSSCurrency(this.m_locale);
        try {
            cSSCurrency.copy(cSSDatum);
        }
        catch (CSSException cSSException) {
            return -1;
        }
        cSSCurrency.setCurrency(this.m_currencyCode);
        int n = this.isNull() || cSSCurrency.isNull() ? (this.isNull() ? 1 : 0) - (cSSCurrency.isNull() ? 1 : 0) : (this.m_value > cSSCurrency.m_value ? 1 : (this.m_value < cSSCurrency.m_value ? -1 : 0));
        return n;
    }

    @Override
    public void copy(CSSDatum cSSDatum) throws CSSException {
        if (cSSDatum instanceof CSSCurrency) {
            this.m_currencyCode = ((CSSCurrency)cSSDatum).m_currencyCode;
            this.m_exchangeDate = ((CSSCurrency)cSSDatum).m_exchangeDate;
            this.m_minAcctUnit = ((CSSCurrency)cSSDatum).m_minAcctUnit;
            this.m_bEuro = ((CSSCurrency)cSSDatum).m_bEuro;
        }
        super.copy(cSSDatum);
    }

    @Override
    public int getDataType() {
        return 7;
    }

    @Override
    public String getFormat() {
        return CSSUtilities.isEmpty(this.m_format) ? this.getLocale().getProfile(6) : this.m_format;
    }

    @Override
    public void init() {
        super.init();
        this.m_minAcctUnit = 0.01;
        this.m_bEuro = false;
        this.m_currencyCode = "";
        this.m_exchangeDate = new CSSDate(this.getLocale());
    }

    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSCurrency cSSCurrency = new CSSCurrency(this.m_locale);
        switch (s) {
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                try {
                    cSSCurrency.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                if (this.isNull() || cSSCurrency.isNull()) {
                    cSSCurrency.setAsString(null);
                    break;
                }
                switch (s) {
                    case 12: {
                        cSSCurrency.copy(this.plus(cSSCurrency));
                        break;
                    }
                    case 13: {
                        cSSCurrency.copy(this.minus(cSSCurrency));
                        break;
                    }
                    case 14: {
                        cSSCurrency.copy(this.mul(cSSCurrency.getValue()));
                        break;
                    }
                    case 15: {
                        if (cSSCurrency.m_value != 0.0) {
                            cSSCurrency.copy(this.div(cSSCurrency));
                            break;
                        }
                        if (bl2) break;
                        throw new CSSException(7668090);
                    }
                }
                break;
            }
            default: {
                return this.finalCSSDatumOperate(s, cSSDatum, bl, bl2);
            }
        }
        return cSSCurrency;
    }

    @Override
    public void setAsFormattedString(String string, String string2) throws CSSException {
        if (CSSUtilities.isEmpty(string)) {
            this.init();
        }
        super.setAsFormattedString(string, string2);
    }

    @Override
    public void setAsString(String string) throws CSSException {
        if (CSSUtilities.isEmpty(string)) {
            this.init();
        }
        super.setAsString(string);
    }

    @Override
    public double getValue() {
        return this.m_value;
    }

    public final void setValue(CSSCurrency cSSCurrency) {
        this.m_bNull = cSSCurrency.m_bNull;
        int n = this.m_bEuro || cSSCurrency.m_bEuro ? 1 : 0;
        this.m_value = cSSCurrency.getAsForeignCurrency(this.m_currencyCode, n);
    }

    @Override
    public void setValue(double d) {
        this.m_bNull = false;
        this.m_value = d;
    }

    public final CSSCurrency plus(CSSCurrency cSSCurrency) {
        CSSCurrency cSSCurrency2 = new CSSCurrency(this);
        cSSCurrency2.add(cSSCurrency);
        return cSSCurrency2;
    }

    public final CSSCurrency minus(CSSCurrency cSSCurrency) {
        CSSCurrency cSSCurrency2 = new CSSCurrency(this);
        cSSCurrency2.subtract(cSSCurrency);
        return cSSCurrency2;
    }

    public final CSSNumber div(CSSCurrency cSSCurrency) {
        return new CSSNumber(this.m_value / cSSCurrency.getAsForeignCurrency(this.m_currencyCode, this.m_bEuro || cSSCurrency.m_bEuro ? 1 : 0), this.getLocale());
    }

    public final void add(CSSCurrency cSSCurrency) {
        this.m_bNull = false;
        this.m_value += cSSCurrency.getAsForeignCurrency(this.m_currencyCode, this.m_bEuro || cSSCurrency.m_bEuro ? 1 : 0);
    }

    public final void subtract(CSSCurrency cSSCurrency) {
        this.m_bNull = false;
        this.m_value -= cSSCurrency.getAsForeignCurrency(this.m_currencyCode, this.m_bEuro || cSSCurrency.m_bEuro ? 1 : 0);
    }

    @Override
    public final CSSNumber plus(double d) {
        CSSCurrency cSSCurrency = new CSSCurrency(this);
        cSSCurrency.add(d);
        return cSSCurrency;
    }

    @Override
    public final CSSNumber minus(double d) {
        CSSCurrency cSSCurrency = new CSSCurrency(this);
        cSSCurrency.subtract(d);
        return cSSCurrency;
    }

    @Override
    public final CSSNumber mul(double d) {
        CSSCurrency cSSCurrency = new CSSCurrency(this);
        cSSCurrency.multiply(d);
        return cSSCurrency;
    }

    @Override
    public final CSSNumber div(double d) {
        CSSCurrency cSSCurrency = new CSSCurrency(this);
        cSSCurrency.divide(d);
        return cSSCurrency;
    }

    @Override
    public final void add(double d) {
        this.m_bNull = false;
        this.m_value += d;
    }

    @Override
    public final void subtract(double d) {
        this.m_bNull = false;
        this.m_value -= d;
    }

    @Override
    public final void multiply(double d) {
        this.m_bNull = false;
        this.m_value *= d;
    }

    @Override
    public final void divide(double d) {
        this.m_bNull = false;
        this.m_value /= d;
    }

    public final double getAsForeignCurrency(String string) {
        return this.getAsForeignCurrency(string, -1);
    }

    public final double getAsForeignCurrency(String string, int n) {
        double d;
        if (this.m_value == 0.0) {
            return 0.0;
        }
        if (CSSUtilities.isEmpty(this.m_currencyCode) || CSSUtilities.isEmpty(string) || this.m_currencyCode.equals(string)) {
            return this.m_value;
        }
        CSSLocale cSSLocale = this.getLocale();
        if (n == -1) {
            CSSCurrData cSSCurrData;
            int n2 = n = this.m_bEuro || (cSSCurrData = cSSLocale.getCurrency(string)) != null && cSSCurrData.m_bEuro ? 1 : 0;
        }
        if (n == 0) {
            double d2 = cSSLocale.getExchangeRate(this.m_currencyCode, string, this.m_exchangeDate);
            d = this.m_value * d2;
        } else {
            double d3;
            if (!this.m_bEuro) {
                d3 = cSSLocale.getExchangeRate(this.m_currencyCode, "EUR", this.m_exchangeDate);
                d = this.m_value * d3;
            } else {
                d3 = cSSLocale.getExchangeRate("EUR", this.m_currencyCode, this.m_exchangeDate);
                d = this.m_value / d3;
            }
            d3 = cSSLocale.getExchangeRate("EUR", string, this.m_exchangeDate);
            d *= d3;
        }
        return d;
    }

    public final String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public final String getCurrencySymbol() {
        return this.m_dispCurrSymbol;
    }

    public final CSSDate getExchangeDate() {
        return new CSSDate(this.m_exchangeDate);
    }

    public final double getMinAccountableUnit() {
        return this.m_minAcctUnit;
    }

    public final void setCurrency(String string) {
        CSSCurrData cSSCurrData;
        CSSLocale cSSLocale = this.getLocale();
        if (!CSSUtilities.isEmpty(string) && (cSSCurrData = cSSLocale.getCurrency(string)) != null) {
            this.m_value = this.getAsForeignCurrency(string);
            this.m_currencyCode = string;
            this.m_dispCurrSymbol = cSSCurrData.m_symbol;
            this.m_dispScale = cSSCurrData.m_stdScale;
            this.m_scale = cSSCurrData.m_extScale;
            this.m_minAcctUnit = cSSCurrData.m_minAcctUnit;
            this.m_bEuro = cSSCurrData.m_bEuro;
        } else {
            boolean bl = this.m_bNull;
            double d = this.m_value;
            CSSDate cSSDate = new CSSDate(this.m_exchangeDate);
            this.init();
            this.m_bNull = bl;
            this.m_value = d;
            this.m_exchangeDate.setValue(cSSDate);
        }
    }

    public final void setExchangeDate(CSSDate cSSDate) {
        this.m_exchangeDate.setValue(cSSDate);
    }

    public final void setToFunctionalCurrency() {
        this.setCurrency(this.getLocale().getFuncCurrCode());
    }

    public final double getRoundValue() {
        if (this.m_minAcctUnit == 0.0) {
            return 0.0;
        }
        return Math.floor((this.m_value + this.m_minAcctUnit / 2.0) / this.m_minAcctUnit) * this.m_minAcctUnit;
    }

    public final double getTruncValue() {
        if (this.m_minAcctUnit == 0.0) {
            return 0.0;
        }
        return Math.floor(this.m_value / this.m_minAcctUnit) * this.m_minAcctUnit;
    }
}

