/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSDateTime;
import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSInteger;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSLocale;

public class CSSDate
extends CSSDateTime {
    public CSSDate(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSDate(CSSDate cSSDate) {
        super(cSSDate.getLocale());
        try {
            this.copy(cSSDate);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    public CSSDate(long l, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(l);
    }

    public CSSDate(String string, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(string);
    }

    public CSSDate(int n, int n2, int n3, CSSLocale cSSLocale) {
        super(cSSLocale);
        try {
            this.setDate(n, n2, n3);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            this.finalCSSDatumAssign(cSSDatum);
        }
        catch (CSSException cSSException) {
            this.setValue((String)null);
            this.setError(true);
            throw cSSException;
        }
        if (this.m_bNull) {
            this.setAsString(null);
        } else if (cSSDatum instanceof CSSDateTime) {
            this.setValue((CSSDateTime)cSSDatum);
        } else if (cSSDatum instanceof CSSNumber) {
            this.setValue((long)((CSSNumber)cSSDatum).getValue());
        } else if (cSSDatum instanceof CSSString) {
            this.setAsString(((CSSString)cSSDatum).getValue());
        }
        this.setError(false);
    }

    @Override
    public boolean canAssign(CSSDatum cSSDatum) {
        return cSSDatum instanceof CSSDateTime || cSSDatum instanceof CSSNumber || cSSDatum instanceof CSSString;
    }

    @Override
    public int compare(CSSDatum cSSDatum, boolean bl) {
        CSSDate cSSDate = new CSSDate(this.m_locale);
        try {
            cSSDate.copy(cSSDatum);
        }
        catch (CSSException cSSException) {
            return -1;
        }
        int n = this.m_bNull || cSSDate.m_bNull ? (this.m_bNull ? 1 : 0) - (cSSDate.m_bNull ? 1 : 0) : (this.m_julian > cSSDate.m_julian ? 1 : (this.m_julian < cSSDate.m_julian ? -1 : 0));
        return n;
    }

    @Override
    public String getAsString() {
        return this._getAsFormattedString("%m/%d/%Y");
    }

    @Override
    public int getDataType() {
        return 10;
    }

    @Override
    public String getFormat() {
        if (!CSSUtilities.isEmpty(this.m_format)) {
            return this.m_format;
        }
        return this.getLocale().getProfile(3);
    }

    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSDate cSSDate = new CSSDate(this.m_locale);
        CSSInteger cSSInteger = new CSSInteger(this.getLocale());
        CSSDatum cSSDatum2 = cSSDate;
        switch (s) {
            case 13: {
                if (!(cSSDatum instanceof CSSNumber)) {
                    try {
                        cSSDate.copy(cSSDatum);
                        if (!this.isNull() && !cSSDate.isNull()) {
                            cSSInteger.setValue(this.getValue() - cSSDate.getValue());
                        }
                        cSSDatum2 = cSSInteger;
                        break;
                    }
                    catch (CSSException cSSException) {
                        // empty catch block
                    }
                }
            }
            case 12: {
                try {
                    cSSInteger.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                if (this.isNull() || cSSInteger.isNull()) break;
                cSSDate.copy(this);
                if (s == 12) {
                    cSSDate.addDays((int)cSSInteger.getValue());
                    break;
                }
                cSSDate.addDays(-((int)cSSInteger.getValue()));
                break;
            }
            default: {
                return super.operate(s, cSSDatum, bl, bl2);
            }
        }
        return cSSDatum2;
    }

    public final long getValue() {
        return this.m_julian;
    }

    public final void setValue(CSSDate cSSDate) {
        this.m_bNull = cSSDate.m_bNull;
        this.m_year = cSSDate.m_year;
        this.m_month = cSSDate.m_month;
        this.m_day = cSSDate.m_day;
        this.m_julian = cSSDate.m_julian;
    }

    public final void setValue(long l) {
        this.m_bNull = false;
        this.m_julian = l;
        this.julianToDate();
    }

    @Override
    public void setValue(String string) {
        try {
            this.setAsString(string);
        }
        catch (CSSException cSSException) {
            // empty catch block
        }
    }

    public boolean areDatesInSameWeek(CSSDate cSSDate, boolean bl) {
        CSSDate cSSDate2 = new CSSDate(this);
        CSSDate cSSDate3 = new CSSDate(cSSDate);
        int n = cSSDate2.getDayOfWeek();
        int n2 = cSSDate3.getDayOfWeek();
        if (!bl) {
            if (--n == -1) {
                n = 6;
            }
            if (--n2 == -1) {
                n2 = 6;
            }
        }
        cSSDate2.addDays(-n);
        cSSDate3.addDays(-n2);
        return cSSDate2.compare(cSSDate3, true) == 0;
    }
}

