/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSStringRef;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSLocale;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CSSDateTime
extends CSSDatum {
    protected int m_year;
    protected int m_month;
    protected int m_day;
    protected long m_julian;
    protected int m_hour;
    protected int m_minute;
    protected int m_second;
    protected static final int[] nDaysInMonth = new int[]{29, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public CSSDateTime(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSDateTime(CSSDateTime cSSDateTime) {
        super(cSSDateTime.getLocale());
        try {
            this.copy(cSSDateTime);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    public CSSDateTime(String string, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(string);
    }

    public CSSDateTime(int n, int n2, int n3, int n4, int n5, int n6, CSSLocale cSSLocale) {
        super(cSSLocale);
        try {
            this.setDateTime(n, n2, n3, n4, n5, n6);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            super.assign(cSSDatum);
        }
        catch (CSSException cSSException) {
            this.setValue((String)null);
            this.setError(true);
            throw cSSException;
        }
        if (this.m_bNull) {
            this.setValue((String)null);
        } else if (cSSDatum instanceof CSSDateTime) {
            this.setValue((CSSDateTime)cSSDatum);
        } else if (cSSDatum instanceof CSSString) {
            this.setValue(((CSSString)cSSDatum).getValue());
        }
        this.setError(false);
    }

    @Override
    public boolean canAssign(CSSDatum cSSDatum) {
        return cSSDatum instanceof CSSDateTime || cSSDatum instanceof CSSString;
    }

    @Override
    public int compare(CSSDatum cSSDatum, boolean bl) {
        CSSDateTime cSSDateTime = new CSSDateTime(this.getLocale());
        try {
            cSSDateTime.copy(cSSDatum);
        }
        catch (CSSException cSSException) {
            return -1;
        }
        int n = this.m_bNull || cSSDateTime.m_bNull ? (this.m_bNull ? 1 : 0) - (cSSDateTime.m_bNull ? 1 : 0) : (this.m_julian > cSSDateTime.m_julian ? 1 : (this.m_julian < cSSDateTime.m_julian ? -1 : (this.m_hour > cSSDateTime.m_hour ? 1 : (this.m_hour < cSSDateTime.m_hour ? -1 : (this.m_minute > cSSDateTime.m_minute ? 1 : (this.m_minute < cSSDateTime.m_minute ? -1 : (this.m_second > cSSDateTime.m_second ? 1 : (this.m_second < cSSDateTime.m_second ? -1 : 0))))))));
        return n;
    }

    @Override
    public String getAsFormattedString(String string) {
        if (this.m_bNull) {
            String string2 = "";
            return string2;
        }
        String string3 = "";
        CSSString cSSString = new CSSString(string, this.getLocale());
        CSSLocale cSSLocale = this.getLocale();
        if (CSSUtilities.isEmpty(string)) {
            string = this.getFormat();
        } else {
            this.preParseFormat(cSSString);
            string = cSSString.getValue();
        }
        int n = 0;
        block34: while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case 'Y': {
                    int n2 = 0;
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                        ++n2;
                    }
                    switch (n2) {
                        case 1: {
                            string3 = string3 + "%#y";
                            continue block34;
                        }
                        case 2: {
                            string3 = string3 + "%y";
                            continue block34;
                        }
                        case 3: {
                            string3 = string3 + "%#Y";
                            continue block34;
                        }
                    }
                    string3 = string3 + "%Y";
                    continue block34;
                }
                case 'M': {
                    int n2 = 0;
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                        ++n2;
                    }
                    switch (n2) {
                        case 1: {
                            string3 = string3 + "%#m";
                            continue block34;
                        }
                        case 2: {
                            string3 = string3 + "%m";
                            continue block34;
                        }
                        case 3: {
                            string3 = string3 + "%b";
                            continue block34;
                        }
                    }
                    string3 = string3 + "%B";
                    continue block34;
                }
                case 'D': {
                    int n2 = 0;
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                        ++n2;
                    }
                    switch (n2) {
                        case 1: {
                            string3 = string3 + "%#d";
                            continue block34;
                        }
                        case 2: {
                            string3 = string3 + "%d";
                            continue block34;
                        }
                        case 3: {
                            string3 = string3 + "%a";
                            continue block34;
                        }
                    }
                    string3 = string3 + "%A";
                    continue block34;
                }
                case 'H': {
                    int n2 = 0;
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                        ++n2;
                    }
                    switch (n2) {
                        case 1: {
                            string3 = string3 + "%#H";
                            continue block34;
                        }
                    }
                    string3 = string3 + "%H";
                    continue block34;
                }
                case 'h': {
                    int n2 = 0;
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                        ++n2;
                    }
                    switch (n2) {
                        case 1: {
                            string3 = string3 + "%#I";
                            continue block34;
                        }
                    }
                    string3 = string3 + "%I";
                    continue block34;
                }
                case 'm': {
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                    }
                    string3 = string3 + "%M";
                    continue block34;
                }
                case 's': {
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                    }
                    string3 = string3 + "%S";
                    continue block34;
                }
                case 'p': {
                    while (n < string.length() && string.charAt(n) == c) {
                        ++n;
                    }
                    string3 = string3 + "%p";
                    continue block34;
                }
                case '/': {
                    string3 = string3 + cSSLocale.getDispDateSeparator();
                    ++n;
                    continue block34;
                }
                case ':': {
                    string3 = string3 + cSSLocale.getDispTimeSeparator();
                    ++n;
                    continue block34;
                }
                case '%': {
                    string3 = string3 + "%%";
                    ++n;
                }
            }
            string3 = string3 + String.valueOf(string.charAt(n));
            ++n;
        }
        return this._getAsFormattedString(string3);
    }

    @Override
    public String getAsString() {
        return this._getAsFormattedString("%m/%d/%Y %H:%M:%S");
    }

    @Override
    public int getDataType() {
        return 12;
    }

    @Override
    public String getFormat() {
        if (!CSSUtilities.isEmpty(this.m_format)) {
            return this.m_format;
        }
        return this.getLocale().getProfile(2);
    }

    @Override
    public void init() {
        super.init();
        this.m_year = 0;
        this.m_month = 0;
        this.m_day = 0;
        this.m_julian = 0L;
        this.m_hour = 0;
        this.m_minute = 0;
        this.m_second = 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSDateTime cSSDateTime = new CSSDateTime(this.getLocale());
        CSSNumber cSSNumber = new CSSNumber(this.getLocale());
        CSSDateTime cSSDateTime2 = cSSDateTime;
        switch (s) {
            case 13: {
                void var7_9;
                try {
                    cSSDateTime.copy(cSSDatum);
                    if (!this.isNull() && !cSSDateTime.isNull()) {
                        long l = ((long)this.m_hour - (long)cSSDateTime.m_hour) * 3600L + ((long)this.m_minute - (long)cSSDateTime.m_minute) * 60L + ((long)this.m_second - (long)cSSDateTime.m_second);
                        cSSNumber.setValue((double)(this.m_julian - cSSDateTime.m_julian) + (double)l / 86400.0);
                    }
                    CSSNumber cSSNumber2 = cSSNumber;
                    return var7_9;
                }
                catch (CSSException cSSException) {
                    // empty catch block
                }
            }
            case 12: {
                void var7_9;
                try {
                    cSSNumber.copy(cSSDatum);
                    if (this.isNull() || cSSNumber.isNull()) return var7_9;
                    try {
                        cSSDateTime.copy(this);
                        if (s == 13) {
                            cSSNumber.negate();
                        }
                        cSSDateTime.addDays((int)cSSNumber.getValue());
                        cSSDateTime.addTime(0, 0, (int)(cSSNumber.minus(Math.floor(cSSNumber.getValue())).getValue() * 86400.0));
                        return var7_9;
                    }
                    catch (CSSException cSSException) {
                        throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                    }
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
            }
            default: {
                return super.operate(s, cSSDatum, bl, bl2);
            }
        }
    }

    @Override
    public void setAsFormattedString(String string, String string2) throws CSSException {
        block43: {
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block42: {
                this.m_bNull = CSSUtilities.isEmpty(string);
                if (this.m_bNull) {
                    this.setAsString(null);
                    return;
                }
                CSSString cSSString = new CSSString(string2, this.getLocale());
                n6 = -1;
                n5 = -1;
                n4 = -1;
                n3 = 0;
                n2 = 0;
                n = 0;
                bl2 = false;
                bl = false;
                CSSStringRef cSSStringRef = new CSSStringRef();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                String string3 = string;
                nArray2[0] = 0;
                CSSDateTime.getNextInt(string3, nArray2, cSSStringRef, 1);
                if (cSSStringRef.toString().length() == 0) break block43;
                CSSLocale cSSLocale = this.getLocale();
                if (CSSUtilities.isEmpty(string2)) {
                    string2 = this.getFormat();
                } else {
                    this.preParseFormat(cSSString);
                    string2 = cSSString.getValue();
                }
                int n7 = 0;
                nArray[0] = 0;
                block9: while (n7 < string2.length()) {
                    char c = string2.charAt(n7);
                    switch (c) {
                        case 'Y': {
                            int n8 = 0;
                            while (n7 < string2.length() && string2.charAt(n7) == c) {
                                ++n7;
                                ++n8;
                            }
                            n6 = n8 <= 2 && n7 < string2.length() && (string2.charAt(n7) == 'M' || string2.charAt(n7) == 'D' || string2.charAt(n7) == 'H' || string2.charAt(n7) == 'h' || string2.charAt(n7) == 'm' || string2.charAt(n7) == 's') ? CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2) : CSSDateTime.getNextInt(string, nArray, cSSStringRef, 4);
                            if (cSSStringRef.toString().length() == 0) {
                                n6 = -1;
                                break block42;
                            }
                            if (cSSStringRef.toString().length() > 2) continue block9;
                            n6 += n6 >= 50 ? 1900 : 2000;
                            break;
                        }
                        case 'M': {
                            n5 = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
                            if (cSSStringRef.toString().length() == 0) {
                                n5 = -1;
                                break block42;
                            }
                            while (n7 < string2.length() && string2.charAt(n7) == c) {
                                ++n7;
                            }
                            continue block9;
                        }
                        case 'D': {
                            n4 = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
                            if (cSSStringRef.toString().length() == 0) {
                                n4 = -1;
                                break block42;
                            }
                            while (n7 < string2.length() && string2.charAt(n7) == c) {
                                ++n7;
                            }
                            continue block9;
                        }
                        case 'H': 
                        case 'h': {
                            string3 = string.substring(nArray[0]);
                            nArray2[0] = 0;
                            CSSDateTime.getNextInt(string3, nArray2, cSSStringRef, 6);
                            int n8 = cSSStringRef.toString().length();
                            n3 = n8 == 3 || n8 == 5 ? CSSDateTime.getNextInt(string, nArray, cSSStringRef, 1) : CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
                            if (cSSStringRef.toString().length() != 0) {
                                while (n7 < string2.length() && string2.charAt(n7) == c) {
                                    ++n7;
                                }
                                continue block9;
                            }
                            break block42;
                        }
                        case 'm': {
                            nArray2[0] = nArray[0];
                            n2 = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
                            if (cSSStringRef.toString().length() == 0) {
                                nArray[0] = nArray2[0];
                            }
                            while (n7 < string2.length() && string2.charAt(n7) == c) {
                                ++n7;
                            }
                            continue block9;
                        }
                        case 's': {
                            nArray2[0] = nArray[0];
                            n = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
                            if (cSSStringRef.toString().length() == 0) {
                                nArray[0] = nArray2[0];
                            }
                            while (n7 < string2.length() && string2.charAt(n7) == c) {
                                ++n7;
                            }
                            continue block9;
                        }
                        case 'p': {
                            bl2 = true;
                            boolean bl3 = bl = n3 >= 8 && n3 < 12;
                            while (nArray[0] < string.length() && !Character.isDigit(string.charAt(nArray[0]))) {
                                CSSString cSSString2 = new CSSString(cSSLocale.getDispTimeAM(), this.getLocale());
                                CSSString cSSString3 = new CSSString(cSSLocale.getDispTimePM(), this.getLocale());
                                if (cSSString2.compareNoCase(string.substring(nArray[0]), cSSString2.getLength()) == 0) {
                                    bl = true;
                                    nArray[0] = nArray[0] + cSSString2.getLength();
                                    break;
                                }
                                if (cSSString3.compareNoCase(string.substring(nArray[0]), cSSString3.getLength()) == 0) {
                                    bl = false;
                                    nArray[0] = nArray[0] + cSSString3.getLength();
                                    break;
                                }
                                nArray[0] = nArray[0] + 1;
                            }
                            while (n7 < string2.length() && string2.charAt(n7) == c) {
                                ++n7;
                            }
                            continue block9;
                        }
                        default: {
                            ++n7;
                            break;
                        }
                    }
                }
                CSSDateTime.getNextInt(string, nArray, cSSStringRef, 1);
                if (cSSStringRef.toString().length() != 0) break block43;
            }
            if (n6 == -1 && n5 == -1 && n4 == -1) {
                this.setToNow();
                n6 = this.m_year;
                n5 = this.m_month;
                n4 = this.m_day;
            } else {
                if (n6 == -1) {
                    this.setToNow();
                    n6 = this.m_year;
                }
                if (n5 == -1) {
                    n5 = 1;
                }
                if (n4 == -1) {
                    n4 = 1;
                }
            }
            if (bl2) {
                if (bl && n3 == 12) {
                    n3 = 0;
                }
                if (!bl && n3 > 0 && n3 < 12) {
                    n3 += 12;
                }
            }
            this.setDateTime(n6, n5, n4, n3, n2, n);
            return;
        }
        this.m_bNull = true;
        this.setValue((String)null);
        this.setError(true);
        throw new CSSException(7668071, string);
    }

    @Override
    public void setAsString(String string) throws CSSException {
        block6: {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            int[] nArray5;
            int[] nArray6;
            int[] nArray7;
            boolean bl;
            boolean bl2;
            block8: {
                block7: {
                    block5: {
                        this.m_bNull = CSSUtilities.isEmpty(string);
                        if (this.m_bNull) {
                            this.m_year = 0;
                            this.m_month = 0;
                            this.m_day = 0;
                            this.m_julian = 0L;
                            this.m_hour = 0;
                            this.m_minute = 0;
                            this.m_second = 0;
                            return;
                        }
                        bl2 = false;
                        bl = false;
                        nArray7 = new int[]{0};
                        nArray6 = new int[]{0};
                        nArray5 = new int[]{0};
                        nArray4 = new int[]{0};
                        nArray3 = new int[]{0};
                        nArray2 = new int[]{0};
                        nArray = new int[]{0};
                        if (string.indexOf(47) == -1) break block5;
                        if (!this.parseDate(string, nArray, nArray7, nArray6, nArray5)) break block6;
                        bl2 = true;
                        break block7;
                    }
                    this.setToNow();
                    nArray7[0] = this.m_year;
                    nArray6[0] = this.m_month;
                    nArray5[0] = this.m_day;
                }
                if (nArray[0] >= string.length() || string.substring(nArray[0]).indexOf(58) == -1) break block8;
                if (!this.parseTime(string, nArray, nArray4, nArray3, nArray2)) break block6;
                bl = true;
            }
            if (nArray[0] == string.length() && (bl2 || bl)) {
                this.setDateTime(nArray7[0], nArray6[0], nArray5[0], nArray4[0], nArray3[0], nArray2[0]);
                return;
            }
        }
        throw new CSSException(7668071, string);
    }

    @Override
    public void setFormat(String string) {
        CSSString cSSString = new CSSString(string, this.getLocale());
        this.preParseFormat(cSSString);
        this.m_format = cSSString.getValue();
    }

    public final void setValue(CSSDateTime cSSDateTime) {
        this.m_bNull = cSSDateTime.m_bNull;
        this.m_year = cSSDateTime.m_year;
        this.m_month = cSSDateTime.m_month;
        this.m_day = cSSDateTime.m_day;
        this.m_julian = cSSDateTime.m_julian;
        this.m_hour = cSSDateTime.m_hour;
        this.m_minute = cSSDateTime.m_minute;
        this.m_second = cSSDateTime.m_second;
    }

    public void setValue(String string) {
        try {
            this.setAsString(string);
        }
        catch (CSSException cSSException) {
            // empty catch block
        }
    }

    public final GregorianCalendar getDate() {
        return new GregorianCalendar(this.m_year, this.m_month - 1, this.m_day, this.m_hour, this.m_minute, this.m_second);
    }

    public final void addDays(int n) {
        if (n != 0) {
            this.m_julian += (long)n;
            this.julianToDate();
        }
    }

    public final void addMonths(int n) {
        if (n != 0) {
            this.m_month += n;
            if (this.m_month < 1 || this.m_month > 12) {
                int n2 = this.m_month < 1 ? this.m_month / 12 - 1 : (this.m_month - 1) / 12;
                this.m_year += n2;
                this.m_month -= n2 * 12;
            }
            this.m_day = Math.min(this.m_day, this.getDaysInMonth());
            this.dateToJulian();
        }
    }

    public final void addTime(int n, int n2, int n3) {
        int n4 = 0;
        if (n == 0 && n2 == 0 && n3 == 0) {
            return;
        }
        long l = ((long)this.m_hour + (long)n) * 3600L + ((long)this.m_minute + (long)n2) * 60L + ((long)this.m_second + (long)n3);
        if (l < 0L) {
            n4 = (int)(l / 86400L - 1L);
        } else if (l > 86400L) {
            n4 = (int)(l / 86400L);
        }
        this.addDays(n4);
        this.m_hour = (int)(l -= (long)(n4 * 86400)) / 3600;
        this.m_minute = (int)((l %= 3600L) / 60L);
        this.m_second = (int)(l % 60L);
    }

    public final void addYears(int n) {
        if (n != 0) {
            this.m_year += n;
            this.m_day = Math.min(this.m_day, this.getDaysInMonth());
            this.dateToJulian();
        }
    }

    public final int getDay() {
        return this.m_day;
    }

    public final int getDayOfWeek() {
        String string = this._getAsFormattedString("%w");
        return Integer.parseInt(string);
    }

    public final String getDayOfWeek(boolean bl) {
        return this._getAsFormattedString(bl ? "%a" : "%A");
    }

    public final int getDayOfYear() {
        String string = this._getAsFormattedString("%j");
        return Integer.parseInt(string);
    }

    public final int getDaysInMonth() {
        if (this.m_month == 2 && this.isLeapYear()) {
            return nDaysInMonth[0];
        }
        return nDaysInMonth[this.m_month];
    }

    public final int getHour() {
        return this.m_hour;
    }

    public final int getMinute() {
        return this.m_minute;
    }

    public final int getMonth() {
        return this.m_month;
    }

    public final String getMonth(boolean bl) {
        return this._getAsFormattedString(bl ? "%b" : "%B");
    }

    public final int getSecond() {
        return this.m_second;
    }

    public final int getWeek(boolean bl) {
        String string = this._getAsFormattedString(bl ? "%U" : "%W");
        return Integer.parseInt(string);
    }

    public final int getYear() {
        return this.m_year;
    }

    public final boolean isLeapYear() {
        boolean bl = false;
        if (this.m_year % 4 == 0) {
            bl = true;
        }
        if (this.m_year % 100 == 0) {
            bl = false;
        }
        if (this.m_year % 400 == 0) {
            bl = true;
        }
        return bl;
    }

    public final void setDate(int n, int n2, int n3) throws CSSException {
        if (n2 >= 1 && n2 <= 12 && n3 >= 1) {
            this.m_bNull = false;
            this.m_year = n;
            this.m_month = n2;
            this.m_day = Math.min(n3, this.getDaysInMonth());
            this.dateToJulian();
            this.setError(false);
            return;
        }
        this.m_bNull = true;
        this.setValue((String)null);
        this.setError(true);
        throw new CSSException(7668133);
    }

    public final void setDateTime(int n, int n2, int n3, int n4, int n5, int n6) throws CSSException {
        this.setDate(n, n2, n3);
        this.setTime(n4, n5, n6);
    }

    public final void setTime(int n, int n2, int n3) throws CSSException {
        if (n >= 0 && n <= 23 && n2 >= 0 && n2 <= 59 && n3 >= 0 && n3 <= 59) {
            if (this.m_bNull) {
                this.setToNow();
            }
            this.m_bNull = false;
            this.m_hour = n;
            this.m_minute = n2;
            this.m_second = n3;
            this.setError(false);
            return;
        }
        this.m_bNull = true;
        this.setValue((String)null);
        this.setError(true);
        throw new CSSException(7668133);
    }

    public final void setToNow() {
        Calendar calendar = Calendar.getInstance();
        this.m_bNull = false;
        this.m_year = calendar.get(1);
        this.m_month = calendar.get(2) + 1;
        this.m_day = calendar.get(5);
        this.dateToJulian();
        this.m_hour = calendar.get(11);
        this.m_minute = calendar.get(12);
        this.m_second = calendar.get(13);
    }

    public final void setToToday() {
        this.setToNow();
    }

    public final String _getAsFormattedString(String string) {
        String string2 = "";
        if (this.m_bNull) {
            return string2;
        }
        CSSNumber cSSNumber = new CSSNumber(this.getLocale());
        CSSLocale cSSLocale = this.getLocale();
        for (int i = 0; i < string.length(); ++i) {
            String string3;
            char c;
            if (string.charAt(i) != '%') {
                string2 = string2 + String.valueOf(string.charAt(i));
                continue;
            }
            if (++i >= string.length()) {
                string2 = string2 + "%";
                break;
            }
            if (string.charAt(i) == '#') {
                c = string.charAt(i);
                if (++i >= string.length()) {
                    string2 = string2 + "%#";
                    break;
                }
            } else {
                c = '\u0000';
            }
            switch (string.charAt(i)) {
                case 'a': {
                    string3 = cSSLocale.getDayOfWeek((int)((this.m_julian + 1L) % 7L), true);
                    break;
                }
                case 'A': {
                    string3 = cSSLocale.getDayOfWeek((int)((this.m_julian + 1L) % 7L), false);
                    break;
                }
                case 'b': {
                    string3 = cSSLocale.getMonth(this.m_month, true);
                    break;
                }
                case 'B': {
                    string3 = cSSLocale.getMonth(this.m_month, false);
                    break;
                }
                case 'd': {
                    cSSNumber.setValue(this.m_day);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'H': {
                    cSSNumber.setValue(this.m_hour);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'I': {
                    if (this.m_hour == 0) {
                        cSSNumber.setValue(12.0);
                    } else if (this.m_hour <= 12) {
                        cSSNumber.setValue(this.m_hour);
                    } else {
                        cSSNumber.setValue(this.m_hour - 12);
                    }
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'm': {
                    cSSNumber.setValue(this.m_month);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'M': {
                    cSSNumber.setValue(this.m_minute);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'p': {
                    string3 = this.m_hour < 12 ? cSSLocale.getDispTimeAM() : cSSLocale.getDispTimePM();
                    break;
                }
                case 'S': {
                    cSSNumber.setValue(this.m_second);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'w': {
                    cSSNumber.setValue((this.m_julian + 1L) % 7L);
                    string3 = cSSNumber.getAsString();
                    break;
                }
                case 'y': {
                    cSSNumber.setValue(this.m_year % 100);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("00");
                    break;
                }
                case 'Y': {
                    cSSNumber.setValue(this.m_year);
                    if (c == '#') {
                        string3 = cSSNumber.getAsString();
                        break;
                    }
                    string3 = cSSNumber.getAsFormattedString("0000");
                    break;
                }
                case '%': {
                    string3 = "%";
                    break;
                }
                case 'U': 
                case 'W': 
                case 'X': 
                case 'j': 
                case 'x': {
                    CSSUtilities.ASSERT(false);
                }
                default: {
                    string3 = "%";
                    if (c != '\u0000') {
                        string3 = string3 + c;
                    }
                    string3 = string3 + String.valueOf(string.charAt(i));
                }
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    protected final void dateToJulian() {
        int n = this.m_day;
        int n2 = this.m_year;
        int n3 = this.m_month;
        float f = (float)(n2 > 0 ? 0.0 : 0.75);
        if (n3 <= 2) {
            --n2;
            n3 += 12;
        }
        int n4 = 0;
        if ((double)n2 * 10000.0 + (double)n3 * 100.0 + (double)n >= 1.5821015E7) {
            int n5 = n2 / 100;
            n4 = 2 - n5 + n5 / 4;
        }
        this.m_julian = (long)(365.25 * (double)n2 - (double)f) + (long)(30.6001 * (double)(n3 + 1)) + (long)n + 1720995L + (long)n4;
    }

    protected static final int getNextInt(String string, int[] nArray, CSSStringRef cSSStringRef, int n) {
        String string2 = "";
        while (nArray[0] < string.length() && !Character.isDigit(string.charAt(nArray[0]))) {
            nArray[0] = nArray[0] + 1;
        }
        int n2 = nArray[0];
        for (int i = 0; i < n && nArray[0] < string.length() && Character.isDigit(string.charAt(nArray[0])); ++i) {
            nArray[0] = nArray[0] + 1;
        }
        string2 = string.substring(n2, nArray[0]);
        cSSStringRef.setValue(string2);
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n3;
    }

    protected final void julianToDate() {
        long l;
        long l2 = this.m_julian;
        if (l2 < 2299161L) {
            l = l2;
        } else {
            long l3 = (long)(((double)l2 - 1867216.25) / 36524.25);
            l = l2 + 1L + l3 - l3 / 4L;
        }
        long l4 = l + 1524L;
        long l5 = (long)(((double)l4 - 122.1) / 365.25);
        long l6 = (long)(365.25 * (double)l5);
        long l7 = (long)((double)(l4 - l6) / 30.6001);
        this.m_day = (int)(l4 - l6 - (long)(30.6001 * (double)l7));
        this.m_month = (int)((double)l7 < 13.5 ? l7 - 1L : l7 - 13L);
        this.m_year = (int)((double)this.m_month > 2.5 ? l5 - 4716L : l5 - 4715L);
    }

    protected final boolean parseDate(String string, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        boolean bl = false;
        CSSStringRef cSSStringRef = new CSSStringRef();
        nArray3[0] = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
        if (cSSStringRef.toString().length() != 0 && nArray[0] < string.length() && string.charAt(nArray[0]) == '/') {
            nArray4[0] = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
            if (cSSStringRef.toString().length() != 0 && nArray[0] < string.length() && string.charAt(nArray[0]) == '/') {
                nArray2[0] = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 4);
                if (!(cSSStringRef.toString().length() != 2 && cSSStringRef.toString().length() != 4 || nArray[0] != string.length() && string.charAt(nArray[0]) != ' ')) {
                    if (cSSStringRef.toString().length() == 2) {
                        nArray2[0] = nArray2[0] + (nArray2[0] >= 50 ? 1900 : 2000);
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected final boolean parseTime(String string, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        boolean bl = false;
        CSSStringRef cSSStringRef = new CSSStringRef();
        nArray2[0] = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
        if (cSSStringRef.toString().length() != 0 && nArray[0] < string.length() && string.charAt(nArray[0]) == ':') {
            nArray3[0] = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
            if (cSSStringRef.toString().length() != 0 && nArray[0] < string.length() && string.charAt(nArray[0]) == ':') {
                nArray4[0] = CSSDateTime.getNextInt(string, nArray, cSSStringRef, 2);
                if (nArray[0] == string.length()) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private final void preParseFormat(CSSString cSSString) {
        CSSLocale cSSLocale = this.getLocale();
        cSSString.subst(CSSMsgMgr.get(7717870), cSSLocale.getProfile(3), 1);
        if (cSSString.subst(CSSMsgMgr.get(7717872), cSSLocale.getProfile(5), 1) == 0) {
            cSSString.subst(CSSMsgMgr.get(7717871), cSSLocale.getProfile(4), 1);
        }
    }
}

