/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.SiebelErrorMsg;
import java.util.Enumeration;
import java.util.Vector;

public class CSSException
extends Exception {
    private static int s_majorNumber = 4096;
    private static String ERR_START_TAG = "<Error>";
    private static String ERR_END_TAG = "</Error>";
    private Vector m_errorObjArray = new Vector();

    protected CSSException() {
        this.m_errorObjArray.addElement(new SiebelErrorMsg());
    }

    public CSSException(int n) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n));
    }

    public CSSException(int n, String string) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n, string));
    }

    public CSSException(int n, String[] stringArray) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n, stringArray));
    }

    public CSSException(int n, String string, boolean bl) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n, string, bl));
    }

    public CSSException(int n, CSSException cSSException) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n));
        this.addErrorMsg(cSSException);
    }

    public CSSException(int n, String string, CSSException cSSException) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n, string));
        this.addErrorMsg(cSSException);
    }

    public CSSException(int n, String[] stringArray, CSSException cSSException) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n, stringArray));
        this.addErrorMsg(cSSException);
    }

    public final void setErrorInfo(int n, String string) {
        SiebelErrorMsg siebelErrorMsg = (SiebelErrorMsg)this.m_errorObjArray.elementAt(0);
        siebelErrorMsg.setErrorCode(n);
        siebelErrorMsg.setErrorMsg(string);
    }

    public final void setErrorInfo(CSSException cSSException) {
        SiebelErrorMsg siebelErrorMsg = (SiebelErrorMsg)this.m_errorObjArray.elementAt(0);
        siebelErrorMsg.setErrorCode(cSSException.getErrorCode());
        siebelErrorMsg.setErrorMsg(cSSException.getErrorMessage());
    }

    public final void setErrorInfo(SiebelErrorMsg siebelErrorMsg) {
        this.m_errorObjArray.addElement(siebelErrorMsg);
    }

    public final void addErrorMsg(int n, String string) {
        this.m_errorObjArray.addElement(new SiebelErrorMsg(n, string, true));
    }

    public final void addErrorMsg(SiebelErrorMsg siebelErrorMsg) {
        this.m_errorObjArray.addElement(siebelErrorMsg);
    }

    public final void addErrorMsg(CSSException cSSException) {
        int n = cSSException.getErrorCount();
        for (int i = 0; i < n; ++i) {
            this.m_errorObjArray.addElement(cSSException.getErrorMsgAt(i));
        }
    }

    public final Enumeration enumErrors() {
        return this.m_errorObjArray.elements();
    }

    public final SiebelErrorMsg getErrorMsgAt(int n) {
        return (SiebelErrorMsg)this.m_errorObjArray.elementAt(n);
    }

    public int getMajorCode() {
        return s_majorNumber;
    }

    public final int getErrorCode() {
        return ((SiebelErrorMsg)this.m_errorObjArray.elementAt(0)).getErrorCode();
    }

    public final String getErrorMessage() {
        return ((SiebelErrorMsg)this.m_errorObjArray.elementAt(0)).getErrorMsg();
    }

    public final int getErrorCount() {
        return this.m_errorObjArray.size();
    }

    @Override
    public String toString() {
        String string = new String("<" + this.getClass().getName() + ">\n");
        for (int i = 0; i < this.getErrorCount(); ++i) {
            string = string.concat(ERR_START_TAG + ((SiebelErrorMsg)this.m_errorObjArray.elementAt(i)).toString() + ERR_END_TAG + "\n");
        }
        string = string + "</" + this.getClass().getName() + ">";
        return string;
    }
}

