/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSBool;
import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSLocale;

public class CSSInteger
extends CSSNumber {
    public CSSInteger(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSInteger(CSSInteger cSSInteger) {
        super(cSSInteger.getLocale());
        try {
            this.copy(cSSInteger);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    public CSSInteger(long l, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(l);
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            this.finalCSSDatumAssign(cSSDatum);
        }
        catch (CSSException cSSException) {
            this.m_bNull = true;
            this.m_value = 0.0;
            this.setError(true);
            throw cSSException;
        }
        if (this.m_bNull) {
            this.m_value = 0.0;
        } else if (cSSDatum instanceof CSSBool) {
            this.setValue(((CSSBool)cSSDatum).getValue() ? 1.0 : 0.0);
        } else if (cSSDatum instanceof CSSNumber) {
            this.setValue(((CSSInteger)cSSDatum).getValue());
        } else if (cSSDatum instanceof CSSString) {
            this.setAsString(((CSSString)cSSDatum).getValue());
        }
        this.setError(false);
    }

    @Override
    public int getDataType() {
        return 9;
    }

    @Override
    public String getFormat() {
        if (!CSSUtilities.isEmpty(this.m_format)) {
            return this.m_format;
        }
        return this.getLocale().getProfile(1);
    }

    public void init(boolean bl) {
        super.init();
        this.m_scale = 0;
    }

    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSInteger cSSInteger = new CSSInteger(this.getLocale());
        switch (s) {
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                try {
                    cSSInteger.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                if (this.isNull() || cSSInteger.isNull()) {
                    cSSInteger.setAsString(null);
                    break;
                }
                switch (s) {
                    case 12: {
                        cSSInteger.copy(this.plus(cSSInteger.m_value));
                        break;
                    }
                    case 13: {
                        cSSInteger.copy(this.minus(cSSInteger.m_value));
                        break;
                    }
                    case 14: {
                        cSSInteger.copy(this.mul(cSSInteger.m_value));
                        break;
                    }
                    case 15: {
                        if (cSSInteger.m_value != 0.0) {
                            cSSInteger.copy(this.div(cSSInteger.m_value));
                            break;
                        }
                        if (bl2) break;
                        throw new CSSException(7668090);
                    }
                }
                break;
            }
            default: {
                return this.finalCSSDatumOperate(s, cSSDatum, bl, bl2);
            }
        }
        return cSSInteger;
    }

    @Override
    public void setAsString(String string) throws CSSException {
        this.m_bNull = CSSUtilities.isEmpty(string);
        if (this.m_bNull) {
            this.m_value = 0.0;
        } else {
            double d;
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            if (d > 2.147483648E9 || d < -2.147483647E9) {
                throw new CSSException(7668188, new String[]{string, Long.toString(-2147483647L), Long.toString(0x80000000L)});
            }
            this.setValue(d);
        }
    }

    @Override
    public double getValue() {
        long l = (long)this.m_value;
        return l;
    }

    @Override
    public void setValue(double d) {
        this.m_bNull = false;
        this.m_value = d;
    }

    public boolean equals(long l) {
        return this.m_value == (double)l;
    }

    public boolean notEquals(long l) {
        return this.m_value != (double)l;
    }

    @Override
    public CSSNumber plus(double d) {
        return new CSSInteger((long)this.m_value + (long)d, this.getLocale());
    }

    @Override
    public CSSNumber minus(double d) {
        return new CSSInteger((long)this.m_value - (long)d, this.getLocale());
    }

    @Override
    public CSSNumber mul(double d) {
        return new CSSInteger((long)this.m_value * (long)d, this.getLocale());
    }

    @Override
    public CSSNumber div(double d) {
        return new CSSInteger((long)this.m_value / (long)d, this.getLocale());
    }

    @Override
    public void add(double d) {
        this.m_bNull = false;
        this.m_value += (double)((long)d);
    }

    @Override
    public void subtract(double d) {
        this.m_bNull = false;
        this.m_value -= (double)((long)d);
    }

    @Override
    public void multiply(double d) {
        this.m_bNull = false;
        this.m_value *= (double)((long)d);
    }

    @Override
    public void divide(double d) {
        this.m_bNull = false;
        this.m_value /= (double)((long)d);
    }

    @Override
    public void setScale(int n) {
    }
}

