/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSBool;
import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSLocale;

public class CSSNumber
extends CSSDatum {
    protected double m_value;
    protected int m_scale;
    protected int m_dispScale;
    protected String m_dispCurrSymbol;

    public CSSNumber(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSNumber(CSSNumber cSSNumber) {
        super(cSSNumber.getLocale());
        try {
            this.copy(cSSNumber);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    public CSSNumber(double d, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(d);
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            super.assign(cSSDatum);
        }
        catch (CSSException cSSException) {
            this.m_bNull = true;
            this.m_value = 0.0;
            throw cSSException;
        }
        if (this.m_bNull) {
            this.m_value = 0.0;
        } else if (cSSDatum instanceof CSSBool) {
            this.setValue(((CSSBool)cSSDatum).getValue() ? 1.0 : 0.0);
        } else if (cSSDatum instanceof CSSNumber) {
            this.setValue(((CSSNumber)cSSDatum).getValue());
        } else if (cSSDatum instanceof CSSString) {
            this.setAsString(((CSSString)cSSDatum).getValue());
        }
        this.setError(false);
    }

    @Override
    public boolean canAssign(CSSDatum cSSDatum) {
        return cSSDatum instanceof CSSBool || cSSDatum instanceof CSSNumber || cSSDatum instanceof CSSString;
    }

    @Override
    public int compare(CSSDatum cSSDatum, boolean bl) {
        CSSNumber cSSNumber = new CSSNumber(this.m_locale);
        try {
            cSSNumber.copy(cSSDatum);
        }
        catch (CSSException cSSException) {
            return -1;
        }
        int n = this.isNull() || cSSNumber.isNull() ? (this.isNull() ? 1 : 0) - (cSSNumber.isNull() ? 1 : 0) : (this.m_value > cSSNumber.m_value ? 1 : (this.m_value < cSSNumber.m_value ? -1 : 0));
        return n;
    }

    @Override
    public void copy(CSSDatum cSSDatum) throws CSSException {
        if (cSSDatum instanceof CSSNumber) {
            this.m_scale = ((CSSNumber)cSSDatum).m_scale;
            this.m_dispScale = ((CSSNumber)cSSDatum).m_dispScale;
            this.m_dispCurrSymbol = ((CSSNumber)cSSDatum).m_dispCurrSymbol;
        }
        super.copy(cSSDatum);
    }

    @Override
    public String getAsFormattedString(String string) {
        int n;
        if (this.m_bNull) {
            return "";
        }
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        CSSString cSSString = new CSSString(this.getLocale());
        boolean bl = false;
        boolean bl2 = false;
        CSSLocale cSSLocale = this.getLocale();
        if (CSSUtilities.isEmpty(string)) {
            string = this.getFormat();
        }
        boolean bl3 = false;
        block15: for (n = 0; n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '0': {
                    if (bl3) {
                        ++n4;
                    } else {
                        ++n2;
                    }
                }
                case '#': {
                    if (bl3) {
                        ++n5;
                        continue block15;
                    }
                    ++n3;
                    continue block15;
                }
                case '.': {
                    bl3 = true;
                    continue block15;
                }
                case '(': 
                case ')': 
                case '+': 
                case '-': {
                    bl = true;
                }
            }
        }
        if (bl3 && n5 == 0) {
            cSSString.m_scale = this.m_dispScale;
            cSSString.m_minScale = this.m_dispScale;
        } else {
            cSSString.m_scale = n5;
            cSSString.m_minScale = n4;
        }
        cSSString.setValue(Math.abs(this.m_value));
        if (cSSString.charAt(0) == '0' && cSSString.charAt(1) == '.') {
            cSSString.truncate(-1);
        }
        if (cSSString.getLength() == 0 && n2 == 0) {
            return string2;
        }
        n6 = cSSString.find('.');
        if (n6 == -1) {
            n6 = cSSString.getLength();
        } else {
            n7 = cSSString.getLength() - n6 - 1;
        }
        if (!bl && this.m_value < 0.0) {
            string2 = "-";
        }
        bl3 = false;
        int n8 = 0;
        block16: for (n = 0; n < string.length(); ++n) {
            if (n6 > n3 && (string.charAt(n) == '0' || string.charAt(n) == '#' || string.charAt(n) == '.')) {
                while (n6 > n3) {
                    string2 = string2 + String.valueOf(cSSString.charAt(n8++));
                    --n6;
                }
            }
            switch (string.charAt(n)) {
                case '0': {
                    if (bl3) {
                        string2 = string2 + String.valueOf(cSSString.charAt(n8++));
                    } else if (n6 >= n2) {
                        string2 = string2 + String.valueOf(cSSString.charAt(n8++));
                    } else {
                        ++n6;
                        string2 = string2 + "0";
                        continue block16;
                    }
                    bl2 = true;
                    continue block16;
                }
                case '#': {
                    if (bl3) {
                        if (n7 <= n4) continue block16;
                        --n7;
                        string2 = string2 + String.valueOf(cSSString.charAt(n8++));
                        bl2 = true;
                        continue block16;
                    }
                    if (n6 == n3) {
                        string2 = string2 + String.valueOf(cSSString.charAt(n8++));
                        bl2 = true;
                        continue block16;
                    }
                    --n3;
                    continue block16;
                }
                case ',': {
                    if (!bl2) continue block16;
                    string2 = string2 + cSSLocale.getDispNumberSeparator();
                    continue block16;
                }
                case '.': {
                    bl3 = true;
                    if (cSSString.charAt(n8) != '.') continue block16;
                    ++n8;
                    string2 = string2 + cSSLocale.getDispNumberDecimal();
                    if (n7 <= n5) continue block16;
                    while (n7 > n5) {
                        string2 = string2 + String.valueOf(cSSString.charAt(n8++));
                        --n7;
                    }
                    continue block16;
                }
                case '$': {
                    string2 = string2 + this.m_dispCurrSymbol;
                    continue block16;
                }
                case '(': 
                case ')': 
                case '-': {
                    if (!(this.m_value < 0.0)) continue block16;
                    string2 = string2 + String.valueOf(string.charAt(n));
                    continue block16;
                }
                case '+': {
                    string2 = string2 + (this.m_value >= 0.0 ? "+" : "-");
                    continue block16;
                }
                default: {
                    string2 = string2 + String.valueOf(string.charAt(n));
                }
            }
        }
        return string2;
    }

    @Override
    public String getAsString() {
        String string = "";
        if (!this.isNull()) {
            CSSString cSSString = new CSSString(this.getLocale());
            cSSString.m_scale = this.m_scale;
            cSSString.m_minScale = 0;
            cSSString.setValue(this.m_value);
            string = cSSString.getAsString();
        }
        return string;
    }

    @Override
    public int getDataType() {
        return 6;
    }

    @Override
    public String getFormat() {
        if (!CSSUtilities.isEmpty(this.m_format)) {
            return this.m_format;
        }
        return this.getLocale().getProfile(0);
    }

    @Override
    public void init() {
        super.init();
        this.m_value = 0.0;
        this.m_scale = 15;
        this.m_dispScale = this.getLocale().getDispNumberScale();
        this.m_dispCurrSymbol = "";
    }

    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSNumber cSSNumber;
        CSSNumber cSSNumber2 = cSSNumber = new CSSNumber(this.m_locale);
        switch (s) {
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                try {
                    cSSNumber.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                if (this.isNull() || cSSNumber.isNull()) {
                    cSSNumber.setAsString(null);
                    break;
                }
                switch (s) {
                    case 12: {
                        cSSNumber.copy(this.plus(cSSNumber.m_value));
                        break;
                    }
                    case 13: {
                        cSSNumber.copy(this.minus(cSSNumber.m_value));
                        break;
                    }
                    case 14: {
                        cSSNumber.copy(this.mul(cSSNumber.m_value));
                        break;
                    }
                    case 15: {
                        if (cSSNumber.m_value != 0.0) {
                            cSSNumber.copy(this.div(cSSNumber.m_value));
                            break;
                        }
                        if (bl2) break;
                        throw new CSSException(7668090);
                    }
                }
                break;
            }
            default: {
                return super.operate(s, cSSDatum, bl, bl2);
            }
        }
        return cSSNumber2;
    }

    @Override
    public void setAsFormattedString(String string, String string2) throws CSSException {
        this.m_bNull = CSSUtilities.isEmpty(string);
        if (this.m_bNull) {
            this.m_value = 0.0;
            return;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        char[] cArray = new char[128];
        CSSLocale cSSLocale = this.getLocale();
        CSSString cSSString = new CSSString(cSSLocale.getDispNumberDecimal(), this.getLocale());
        CSSString cSSString2 = new CSSString(cSSLocale.getDispNumberSeparator(), this.getLocale());
        if (string.length() >= 128) {
            this.m_value = 0.0;
            this.m_bNull = true;
            this.setError(true);
            throw new CSSException(7668133);
        }
        if (string.indexOf(45) != -1 || string.indexOf(40) != -1 || string.indexOf(41) != -1) {
            cArray[n++] = 45;
        }
        while (n2 < string.length() && !CSSNumber.isdigit(string.charAt(n2)) && cSSString.compareNoCase(string.substring(n2), cSSString.getLength()) != 0) {
            ++n2;
        }
        while (n2 < string.length()) {
            if (CSSNumber.isdigit(string.charAt(n2))) {
                bl = true;
                while (n2 < string.length() && CSSNumber.isdigit(string.charAt(n2))) {
                    cArray[n++] = string.charAt(n2++);
                }
                continue;
            }
            if (cSSString.compareNoCase(string.substring(n2), cSSString.getLength()) == 0) {
                cArray[n++] = 46;
                n2 += cSSString.getLength();
                continue;
            }
            if (cSSString2.compareNoCase(string.substring(n2), cSSString2.getLength()) == 0) {
                n2 += cSSString2.getLength();
                continue;
            }
            if (string.charAt(n2) != ' ') break;
            ++n2;
        }
        if (!bl) {
            this.m_value = 0.0;
            this.m_bNull = true;
            this.setError(true);
            throw new CSSException(7668133);
        }
        while (n2 < string.length() && !CSSNumber.isdigit(string.charAt(n2))) {
            ++n2;
        }
        if (n2 < string.length()) {
            this.m_value = 0.0;
            this.m_bNull = true;
            this.setError(true);
            throw new CSSException(7668133);
        }
        this.setAsString(new String(cArray, 0, n));
    }

    @Override
    public void setAsString(String string) throws CSSException {
        this.m_bNull = CSSUtilities.isEmpty(string);
        if (this.m_bNull) {
            this.m_value = 0.0;
        } else {
            double d;
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
            this.setValue(d);
        }
    }

    public double getValue() {
        return this.m_value;
    }

    public void setValue(CSSNumber cSSNumber) {
        this.m_bNull = false;
        this.m_value = cSSNumber.getValue();
    }

    public void setValue(double d) {
        this.m_bNull = false;
        this.m_value = d;
    }

    public void negate() {
        this.m_bNull = false;
        this.m_value = -this.m_value;
    }

    public void increment() {
        this.m_bNull = false;
        this.m_value += 1.0;
    }

    public void decrement() {
        this.m_bNull = false;
        this.m_value -= 1.0;
    }

    public CSSNumber plus(double d) {
        return new CSSNumber(this.m_value + d, this.getLocale());
    }

    public CSSNumber minus(double d) {
        return new CSSNumber(this.m_value - d, this.getLocale());
    }

    public CSSNumber mul(double d) {
        return new CSSNumber(this.m_value * d, this.getLocale());
    }

    public CSSNumber div(double d) {
        return new CSSNumber(this.m_value / d, this.getLocale());
    }

    public void add(double d) {
        this.m_bNull = false;
        this.m_value += d;
    }

    public void subtract(double d) {
        this.m_bNull = false;
        this.m_value -= d;
    }

    public void multiply(double d) {
        this.m_bNull = false;
        this.m_value *= d;
    }

    public void divide(double d) {
        this.m_bNull = false;
        this.m_value /= d;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int n) {
        this.m_scale = n;
    }

    private static final boolean isdigit(char c) {
        return Character.isDigit(c);
    }

    public String toString() {
        return "CSSNumber [m_value=" + this.m_value + ",currSymbol=" + this.m_dispCurrSymbol + "]";
    }
}

