/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSHashtable;
import com.siebel.common.common.CSSStringRef;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class CSSPropertySet
implements Serializable {
    private CSSHashtable m_propertyMap = new CSSHashtable();
    private CSSHashtable m_subsetMap = new CSSHashtable();
    private String m_type;

    public CSSPropertySet() {
    }

    public CSSPropertySet(String string) {
        this.m_type = string;
    }

    public void addProperty(String string, String string2) {
        this.m_propertyMap.put(string, string2 == null ? "" : string2);
    }

    public void addSubset(CSSPropertySet cSSPropertySet) {
        this.m_subsetMap.put(cSSPropertySet.getType(), cSSPropertySet);
    }

    public Enumeration enumPropertyKeys() {
        return this.m_propertyMap.keys();
    }

    public Enumeration enumSubsets() {
        return this.m_subsetMap.elements();
    }

    public Enumeration enumSubsetKeys() {
        return this.m_subsetMap.keys();
    }

    public String getProperty(String string) {
        try {
            return (String)this.m_propertyMap.get(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public boolean getProperty(String string, CSSStringRef cSSStringRef) {
        String string2;
        try {
            string2 = (String)this.m_propertyMap.get(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = null;
        }
        cSSStringRef.setValue(string2);
        return string2 != null;
    }

    public String getSubProperty(String string, String string2) {
        CSSPropertySet cSSPropertySet = this.getSubset(string);
        if (cSSPropertySet != null) {
            return cSSPropertySet.getProperty(string2);
        }
        return null;
    }

    public boolean getSubProperty(String string, String string2, CSSStringRef cSSStringRef) {
        CSSPropertySet cSSPropertySet = this.getSubset(string);
        if (cSSPropertySet != null) {
            return cSSPropertySet.getProperty(string2, cSSStringRef);
        }
        return false;
    }

    public CSSPropertySet getSubset(String string) {
        return (CSSPropertySet)this.m_subsetMap.get(string);
    }

    public String getType() {
        return this.m_type;
    }

    public boolean removeProperty(String string) {
        return this.m_propertyMap.remove(string) != null;
    }

    public boolean removeSubset(String string) {
        return this.m_subsetMap.remove(string) != null;
    }

    public void reset() {
        this.m_propertyMap.clear();
        this.m_subsetMap.clear();
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void Copy(CSSPropertySet cSSPropertySet) {
        this.reset();
        this.m_type = cSSPropertySet.m_type;
        Enumeration enumeration = cSSPropertySet.enumPropertyKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = cSSPropertySet.getProperty(string);
            this.addProperty(string, string2);
        }
        Enumeration enumeration2 = cSSPropertySet.enumSubsetKeys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            CSSPropertySet cSSPropertySet2 = cSSPropertySet.getSubset(string);
            CSSPropertySet cSSPropertySet3 = new CSSPropertySet();
            cSSPropertySet3.Copy(cSSPropertySet2);
            this.addSubset(cSSPropertySet3);
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_type.length());
        stringBuffer.append("#");
        stringBuffer.append(this.m_type);
        stringBuffer.append(this.m_propertyMap.size());
        stringBuffer.append("#");
        Enumeration enumeration = this.m_propertyMap.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = (String)this.m_propertyMap.get(string);
            stringBuffer.append(string.length());
            stringBuffer.append("#");
            stringBuffer.append(string);
            stringBuffer.append(string2.length());
            stringBuffer.append("#");
            stringBuffer.append(string2);
        }
        stringBuffer.append(this.m_subsetMap.size());
        stringBuffer.append("#");
        enumeration = this.m_subsetMap.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            CSSPropertySet cSSPropertySet = (CSSPropertySet)this.m_subsetMap.get(string);
            stringBuffer.append(string.length());
            stringBuffer.append("#");
            stringBuffer.append(string);
            stringBuffer.append(cSSPropertySet.toString());
        }
        return stringBuffer.toString();
    }
}

