/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.util.Base64;
import com.siebel.common.util.FileManager;
import com.siebel.integration.util.SiebelTrace;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CSSPropertySetEx
implements Serializable {
    private static final int STREAM_CHUNK_SIZE = 1617;
    protected Hashtable m_propertyMap = new Hashtable();
    protected Vector m_childArray = new Vector();
    protected String m_type;
    protected String m_value;
    protected byte[] m_byteValue;
    protected boolean m_byteValSet = false;
    protected boolean m_fileRefSet = false;
    protected String m_encoded;
    protected File m_encodedFile;
    protected RandomAccessFile m_randomAccessEncodedFile = null;
    protected int m_posEncoded;
    protected boolean m_bEncodingOK;
    protected StringBuffer m_sbWriteEncoded;
    protected BufferedWriter m_bfwWriteEncoded;
    protected DataOutputStream m_dos;
    private String m_separator = "*";
    protected String m_fileRef;
    protected int m_readCount = 1;
    protected int m_chunkSize = 1617;
    protected boolean m_bDecodeFile = false;
    protected boolean m_bEncodeToFile = false;
    public final int CCFVT_NULL = 0;
    public final int CCFVT_INT = 1;
    public final int CCFVT_MEMBLOCK = 2;
    public final int CCFVT_STRING = 3;
    public final int CCFVT_UTF8 = 4;
    public final int CCFVT_UTF16 = 5;
    public final int CCFVT_OSCP = 6;
    public final int CCFVT_EXT_FILE_REFERENCE = 10;
    public final int CCFEFR_MEMBLOCK = 12;
    public final int CCFEFR_STRING = 13;

    public CSSPropertySetEx() {
        this.m_type = "";
        this.m_value = "";
    }

    public CSSPropertySetEx(String string) {
        this.m_type = string;
        this.m_value = "";
    }

    public String getType() {
        return this.m_type;
    }

    public String getFileRef() {
        return this.m_fileRef;
    }

    public void setFileRef(String string) {
        this.m_fileRef = string;
        this.m_fileRefSet = true;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public void setByteValue(byte[] byArray) {
        if (byArray != null) {
            this.copyByteValue(byArray);
            this.m_byteValSet = true;
        }
    }

    public void copyByteValue(byte[] byArray) {
        if (byArray != null) {
            this.m_byteValue = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.m_byteValue, 0, byArray.length);
        }
    }

    public byte[] getByteValue() {
        byte[] byArray = null;
        if (this.m_byteValSet) {
            byArray = this.m_byteValue;
        }
        return byArray;
    }

    public boolean isStringValue() {
        return !this.m_byteValSet && !this.m_fileRefSet;
    }

    public boolean isFileRef() {
        return this.m_fileRefSet;
    }

    public void setFileReference(String string) {
        if (string != null) {
            this.setValue(string);
            this.m_byteValSet = true;
            this.m_fileRef = string;
            this.m_fileRefSet = true;
        }
    }

    public String getFileReference() {
        String string = null;
        if (this.m_fileRefSet) {
            string = this.getValue();
        }
        return string;
    }

    public boolean isFileReference() {
        return this.m_fileRefSet;
    }

    public String getProperty(String string) {
        return (String)this.m_propertyMap.get(string);
    }

    public void setProperty(String string, String string2) {
        this.m_propertyMap.put(string, string2);
    }

    public int getPropertyCount() {
        return this.m_propertyMap.size();
    }

    public boolean removeProperty(String string) {
        return this.m_propertyMap.remove(string) != null;
    }

    public Enumeration enumProperties() {
        return this.m_propertyMap.keys();
    }

    public int addChild(CSSPropertySetEx cSSPropertySetEx) {
        this.m_childArray.addElement(cSSPropertySetEx);
        return this.m_childArray.size() - 1;
    }

    public boolean insertChildAt(CSSPropertySetEx cSSPropertySetEx, int n) {
        int n2 = this.m_childArray.size();
        if (n > n2 - 1) {
            return false;
        }
        this.m_childArray.insertElementAt(cSSPropertySetEx, n);
        return true;
    }

    public int getChildCount(String string) {
        int n = 0;
        if (string == null) {
            return this.m_childArray.size();
        }
        for (int i = 0; i < this.m_childArray.size(); ++i) {
            CSSPropertySetEx cSSPropertySetEx = (CSSPropertySetEx)this.m_childArray.elementAt(i);
            if (cSSPropertySetEx == null || !cSSPropertySetEx.m_type.equals(string)) continue;
            ++n;
        }
        return n;
    }

    public CSSPropertySetEx getChild(int n) {
        if (n < 0 || n >= this.m_childArray.size()) {
            return null;
        }
        return (CSSPropertySetEx)this.m_childArray.elementAt(n);
    }

    public boolean removeChild(int n) {
        if (n < 0 || n >= this.m_childArray.size()) {
            return false;
        }
        this.m_childArray.removeElementAt(n);
        return true;
    }

    public Enumeration enumChildren() {
        return this.enumChildren(null);
    }

    public Enumeration enumChildren(String string) {
        return new CSSPropertySetExEnumeration(this.m_childArray.elements(), string);
    }

    public void reset() {
        this.m_type = "";
        this.m_value = "";
        this.m_childArray.removeAllElements();
        this.m_propertyMap.clear();
    }

    public static String encodeArrayAsString(Vector vector) {
        String string = "";
        String string2 = "";
        String string3 = new String("");
        for (int i = 0; i < vector.size(); ++i) {
            string = (String)vector.elementAt(i);
            int n = string.length();
            string2 = new Integer(n).toString();
            string2 = string2 + "*";
            string2 = string2 + string;
            string3 = string3 + string2;
        }
        return string3;
    }

    public static Vector decodeStringAsArray(String string) {
        char c;
        String string2 = "";
        String string3 = "";
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length && (c = cArray[n]) != '\u0000') {
            if (c >= '0' && c <= '9') {
                string2 = string2 + new Character(c).toString();
                ++n;
                continue;
            }
            if (c != '*') {
                return null;
            }
            c = cArray[++n];
            if (string2.length() < 1) {
                return null;
            }
            int n2 = new Integer(string2);
            if (n2 < 0) {
                return null;
            }
            string3 = n2 == 0 ? "" : string.substring(n, n + n2);
            if (string3.length() < n2) {
                return null;
            }
            vector.addElement(string3);
            n += n2;
            string2 = "";
        }
        return vector;
    }

    public String encodeAsString() {
        String string;
        this.m_sbWriteEncoded = new StringBuffer("@");
        try {
            if (!this.writeHeader() || !this.writePropertySet(this)) {
                System.out.println("Unable to encode property set");
                string = null;
            } else {
                string = this.m_sbWriteEncoded.toString();
            }
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::encodeAsString", "IO Exception occured.");
            this.m_sbWriteEncoded = null;
            return "";
        }
        this.m_sbWriteEncoded = null;
        return string;
    }

    public boolean encodeToFile(File file) throws IOException {
        this.m_bEncodeToFile = true;
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.m_bfwWriteEncoded = new BufferedWriter(fileWriter);
            this.m_bfwWriteEncoded.append("@");
            if (!this.writeHeader() || !this.writePropertySet(this)) {
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySet::encodeToFile", CSSMsgMgr.get(8718799));
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::encodeToFile", 8718791 + this.getStackTrace(throwable));
            throw iOException;
        }
        finally {
            if (this.m_bfwWriteEncoded != null) {
                this.m_bfwWriteEncoded.close();
            }
        }
        return true;
    }

    public String encodeSessionTokenAsString() {
        this.m_separator = "`";
        String string = this.encodeAsString();
        this.m_separator = "*";
        return string;
    }

    public String encodeOldFormat() {
        String string = new String("");
        String string2 = "";
        String string3 = "";
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.m_type);
        vector.addElement(this.m_value);
        int n = this.m_propertyMap.size();
        string3 = new Integer(n).toString();
        vector.addElement(string3);
        Enumeration enumeration = this.m_propertyMap.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string3 = (String)this.m_propertyMap.get(string2);
            vector.addElement(string2);
            vector.addElement(string3);
        }
        int n2 = this.m_childArray.size();
        string3 = new Integer(n2).toString();
        vector.addElement(string3);
        for (int i = 0; i < n2; ++i) {
            CSSPropertySetEx cSSPropertySetEx = (CSSPropertySetEx)this.m_childArray.elementAt(i);
            string3 = cSSPropertySetEx.encodeAsString();
            vector.addElement(string3);
        }
        return CSSPropertySetEx.encodeArrayAsString(vector);
    }

    public boolean decodeFromString(String string) {
        this.reset();
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.charAt(0) != '@') {
            return this.decodeOldFormat(string);
        }
        this.m_encoded = string;
        this.m_posEncoded = 1;
        this.m_bEncodingOK = true;
        try {
            if (!this.readHeader() || !this.readPropertySet(this) || this.m_posEncoded != string.length()) {
                this.m_encoded = null;
                this.reset();
                System.out.println("Invalid encoded property set string");
                return false;
            }
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::decodeFromString", "IO Exception occured.");
            this.m_encoded = null;
            return false;
        }
        this.m_encoded = null;
        return true;
    }

    public boolean decodeFromFile(File file) throws IOException {
        this.m_bDecodeFile = true;
        String string = null;
        if (file == null) {
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySet::decodeFromFile", CSSMsgMgr.get(8718800));
            return false;
        }
        this.m_encodedFile = file;
        try {
            this.m_randomAccessEncodedFile = new RandomAccessFile(file, "r");
            this.m_randomAccessEncodedFile.seek(0L);
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::DecodeFromFile", "IO Exception while working with Random Accces File" + this.m_randomAccessEncodedFile.getFD() + this.getStackTrace(throwable));
            throw iOException;
        }
        string = this.readDataFromFile(this.m_randomAccessEncodedFile, this.m_chunkSize);
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.charAt(0) != '@') {
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySet::decodeFromFile", CSSMsgMgr.get(8718804));
            return false;
        }
        this.m_encoded = string;
        this.m_posEncoded = 1;
        this.m_bEncodingOK = true;
        try {
            if (!this.readHeader() || !this.readPropertySet(this)) {
                this.reset();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySet::encodeToFile", CSSMsgMgr.get(8718800));
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::encodeToFile", 8718792 + this.getStackTrace(throwable));
            throw iOException;
        }
        finally {
            this.m_encoded = null;
            this.m_encodedFile = null;
            try {
                this.m_randomAccessEncodedFile.close();
                this.m_randomAccessEncodedFile = null;
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.fillInStackTrace();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::decodeFromFile", CSSMsgMgr.get(8718794) + this.getStackTrace(throwable));
                IOException iOException2 = new IOException(new CSSException(8718794));
                throw iOException2;
            }
        }
        return true;
    }

    public String readDataFromFile(RandomAccessFile randomAccessFile, int n) throws IOException {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byte[] byArray = this.readBytesFromFile(randomAccessFile, n);
            byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            byteArrayOutputStream.write(byArray);
            string = byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::readDataFromFile", "IO Exception while reading data from file" + randomAccessFile.getFD() + this.getStackTrace(throwable));
            throw iOException;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        return string;
    }

    public byte[] readBytesFromFile(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2 = 0;
        byte[] byArray = null;
        try {
            byte[] byArray2 = new byte[n];
            System.out.println(randomAccessFile.getFilePointer());
            n2 = randomAccessFile.read(byArray2);
            if (n2 != -1) {
                byArray = byArray2;
            }
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::readDataFromFile", "IO Exception while reading data from file" + randomAccessFile.getFD() + this.getStackTrace(throwable));
            throw iOException;
        }
        return byArray;
    }

    public boolean decodeSessionTokenFromString(String string) {
        this.m_separator = "`";
        boolean bl = this.decodeFromString(string);
        this.m_separator = "*";
        return bl;
    }

    public boolean decodeOldFormat(String string) {
        int n;
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Vector vector = CSSPropertySetEx.decodeStringAsArray(string);
        if (vector == null) {
            return false;
        }
        this.reset();
        if (n2 >= vector.size()) {
            return false;
        }
        this.m_type = (String)vector.elementAt(n2++);
        if (n2 >= vector.size()) {
            return false;
        }
        this.m_value = (String)vector.elementAt(n2++);
        if (n2 >= vector.size()) {
            return false;
        }
        int n3 = new Integer((String)vector.elementAt(n2++));
        for (n = 0; n < n3; ++n) {
            if (n2 >= vector.size()) {
                return false;
            }
            string2 = (String)vector.elementAt(n2++);
            if (n2 >= vector.size()) {
                return false;
            }
            string3 = (String)vector.elementAt(n2++);
            this.m_propertyMap.put(string2, string3);
        }
        if (n2 >= vector.size()) {
            return false;
        }
        int n4 = new Integer((String)vector.elementAt(n2++));
        for (n = 0; n < n4; ++n) {
            if (n2 >= vector.size()) {
                return false;
            }
            CSSPropertySetEx cSSPropertySetEx = new CSSPropertySetEx();
            if (!cSSPropertySetEx.decodeOldFormat(string3 = (String)vector.elementAt(n2++))) {
                return false;
            }
            this.m_childArray.addElement(cSSPropertySetEx);
        }
        return true;
    }

    public void copy(CSSPropertySetEx cSSPropertySetEx) {
        this.reset();
        this.m_type = cSSPropertySetEx.getType();
        this.m_value = cSSPropertySetEx.getValue();
        Enumeration enumeration = cSSPropertySetEx.enumProperties();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = cSSPropertySetEx.getProperty(string);
            this.setProperty(string, string2);
        }
        enumeration = cSSPropertySetEx.enumChildren();
        while (enumeration.hasMoreElements()) {
            CSSPropertySetEx cSSPropertySetEx2 = (CSSPropertySetEx)enumeration.nextElement();
            CSSPropertySetEx cSSPropertySetEx3 = new CSSPropertySetEx();
            cSSPropertySetEx3.copy(cSSPropertySetEx2);
            this.addChild(cSSPropertySetEx3);
        }
        this.copyByteValue(cSSPropertySetEx.m_byteValue);
        this.setFileReference(cSSPropertySetEx.m_value);
        this.m_byteValSet = cSSPropertySetEx.m_byteValSet;
        this.m_fileRefSet = cSSPropertySetEx.m_fileRefSet;
    }

    public CSSPropertySetEx copy() {
        Object object;
        CSSPropertySetEx cSSPropertySetEx = null;
        CSSPropertySetEx cSSPropertySetEx2 = null;
        cSSPropertySetEx = new CSSPropertySetEx();
        cSSPropertySetEx.setType(this.m_type);
        cSSPropertySetEx.setValue(this.m_value);
        Enumeration enumeration = this.enumProperties();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = this.getProperty((String)object);
            cSSPropertySetEx.setProperty((String)object, string);
        }
        enumeration = this.enumChildren();
        while (enumeration.hasMoreElements()) {
            object = (CSSPropertySetEx)enumeration.nextElement();
            cSSPropertySetEx2 = new CSSPropertySetEx();
            cSSPropertySetEx2.copy((CSSPropertySetEx)object);
            cSSPropertySetEx.addChild(cSSPropertySetEx2);
        }
        cSSPropertySetEx.copyByteValue(this.m_byteValue);
        cSSPropertySetEx.setFileReference(this.m_value);
        cSSPropertySetEx.m_byteValSet = this.m_byteValSet;
        cSSPropertySetEx.m_fileRefSet = this.m_fileRefSet;
        return cSSPropertySetEx;
    }

    protected boolean readHeader() throws IOException {
        int n = this.readInteger();
        int n2 = this.readInteger();
        return this.m_bEncodingOK;
    }

    protected int readInteger() throws IOException {
        int n;
        boolean bl = false;
        String string = null;
        Throwable throwable = null;
        int n2 = this.m_encoded.indexOf(this.m_separator, this.m_posEncoded);
        if ((this.m_posEncoded >= this.m_encoded.length() || n2 <= this.m_posEncoded) && this.m_bDecodeFile) {
            try {
                int n3 = this.m_encoded.length();
                String string2 = this.m_encoded.substring(this.m_posEncoded, n3);
                string = this.getNextChunk(this.m_randomAccessEncodedFile, this.m_chunkSize);
                this.m_encoded = string2 + string;
                this.m_posEncoded = 0;
                n2 = this.m_encoded.indexOf(this.m_separator, this.m_posEncoded);
                ++this.m_readCount;
            }
            catch (IOException iOException) {
                this.m_bEncodingOK = false;
                throwable = iOException.fillInStackTrace();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::ReadInteger", "IO Exception while reading data from file" + this.m_randomAccessEncodedFile.getFD() + this.getStackTrace(throwable));
                throw iOException;
            }
        }
        try {
            n = Integer.parseInt(this.m_encoded.substring(this.m_posEncoded, n2), 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_bEncodingOK = false;
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::ReadInteger", "NumberFormatException while performing substring on EncodedValue" + this.m_randomAccessEncodedFile.getFD());
            return 0;
        }
        this.m_posEncoded = n2 + 1;
        return n;
    }

    protected boolean readPropertySet(CSSPropertySetEx cSSPropertySetEx) throws IOException {
        int n;
        int n2 = this.readInteger();
        if (!this.m_bEncodingOK) {
            return false;
        }
        int n3 = this.readInteger();
        if (!this.m_bEncodingOK) {
            return false;
        }
        String string = this.readString();
        if (string == null) {
            return false;
        }
        if (!this.readValueVariant(cSSPropertySetEx)) {
            return false;
        }
        cSSPropertySetEx.setType(string);
        for (n = 0; n < n2; ++n) {
            String string2 = this.readString();
            if (string2 == null) {
                return false;
            }
            string = this.readString();
            if (string == null) {
                return false;
            }
            cSSPropertySetEx.setProperty(string2, string);
        }
        for (n = 0; n < n3; ++n) {
            CSSPropertySetEx cSSPropertySetEx2 = new CSSPropertySetEx();
            cSSPropertySetEx.addChild(cSSPropertySetEx2);
            if (this.readPropertySet(cSSPropertySetEx2)) continue;
            return false;
        }
        return true;
    }

    protected String readString() throws IOException {
        String string = null;
        boolean bl = false;
        int n = this.readInteger();
        if (!this.m_bEncodingOK || n < 0) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        if ((this.m_posEncoded >= this.m_encoded.length() || this.m_posEncoded + n >= this.m_encoded.length()) && this.m_bDecodeFile) {
            try {
                int n2 = this.m_encoded.length();
                int n3 = n2 - this.m_posEncoded;
                String string2 = this.m_encoded.substring(this.m_posEncoded, n2);
                int n4 = n - n3 > this.m_chunkSize ? n - n3 : this.m_chunkSize;
                string = this.getNextChunk(this.m_randomAccessEncodedFile, n4);
                this.m_encoded = string2 + string;
                this.m_posEncoded = 0;
            }
            catch (IOException iOException) {
                bl = true;
                Throwable throwable = iOException.fillInStackTrace();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::ReadString", 8718792 + this.getStackTrace(throwable));
                throw iOException;
            }
        }
        String string3 = this.m_encoded.substring(this.m_posEncoded, this.m_posEncoded + n);
        this.m_posEncoded += n;
        return string3;
    }

    protected String getNextChunk(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2 = this.m_encoded.length();
        String string = this.m_encoded.substring(this.m_posEncoded, n2);
        String string2 = this.readDataFromFile(randomAccessFile, n);
        this.m_encoded = string + string2;
        this.m_posEncoded = 0;
        return string2;
    }

    protected boolean readValueVariant(CSSPropertySetEx cSSPropertySetEx) throws IOException {
        String string = null;
        int n = this.readInteger();
        if (!this.m_bEncodingOK) {
            return false;
        }
        switch (n) {
            case 12: {
                string = this.processFileRef(this.m_encodedFile, m_Base64Action.BASE64_DECODE);
                cSSPropertySetEx.setValue(string);
                cSSPropertySetEx.setFileReference(string);
                return true;
            }
            case 13: {
                string = this.processFileRef(this.m_encodedFile, m_Base64Action.BASE64_NONE);
                cSSPropertySetEx.setValue(string);
                return true;
            }
        }
        switch (n) {
            case 0: {
                cSSPropertySetEx.setValue("");
                return true;
            }
            case 1: {
                int n2 = this.readInteger();
                if (!this.m_bEncodingOK) {
                    return false;
                }
                cSSPropertySetEx.setValue(new Integer(n2).toString());
                return true;
            }
            case 2: 
            case 4: 
            case 5: {
                byte[] byArray;
                String string2 = this.readBase64(n == 5);
                if (string2 == null) {
                    return false;
                }
                try {
                    byArray = Base64.decode(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                    return false;
                }
                cSSPropertySetEx.setByteValue(byArray);
                return true;
            }
            case 3: 
            case 6: {
                String string3 = this.readString();
                if (string3 == "") {
                    return true;
                }
                cSSPropertySetEx.setValue(string3);
                return true;
            }
        }
        System.out.println("Unsupported property set value type: " + n);
        return false;
    }

    protected String readBase64(boolean bl) throws IOException {
        String string = null;
        int n = this.readInteger();
        if (!this.m_bEncodingOK || n < 0) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        if (bl) {
            n = 2 * n;
        }
        int n2 = (n + 2) / 3 * 4;
        while (this.m_posEncoded >= this.m_encoded.length() || this.m_posEncoded + n2 >= this.m_encoded.length()) {
            if (!this.m_bDecodeFile) continue;
            try {
                int n3 = this.m_encoded.length();
                int n4 = n3 - this.m_posEncoded;
                int n5 = n2 - n4 > this.m_chunkSize ? n2 - n4 : this.m_chunkSize;
                string = this.getNextChunk(this.m_randomAccessEncodedFile, n5);
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.fillInStackTrace();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::DecodeFrom File::readBase64", 8718791 + this.getStackTrace(throwable));
                throw iOException;
            }
        }
        String string2 = this.m_encoded.substring(this.m_posEncoded, this.m_posEncoded + n2);
        this.m_posEncoded += n2;
        return string2;
    }

    protected String readBase64() throws IOException {
        return this.readBase64(false);
    }

    protected boolean writeHeader() throws IOException {
        this.writeInteger(0);
        this.writeInteger(0);
        return true;
    }

    protected void writeInteger(int n) throws IOException {
        if (!this.m_bEncodeToFile) {
            this.m_sbWriteEncoded.append(n);
            this.m_sbWriteEncoded.append(this.m_separator);
        } else {
            try {
                this.m_bfwWriteEncoded.append(Integer.toString(n));
                this.m_bfwWriteEncoded.append(this.m_separator);
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.fillInStackTrace();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::WriteInteger", "IO Exception occured while appending int value to File" + this.getStackTrace(throwable));
                throw iOException;
            }
        }
    }

    protected boolean writePropertySet(CSSPropertySetEx cSSPropertySetEx) throws IOException {
        int n = cSSPropertySetEx.getPropertyCount();
        int n2 = cSSPropertySetEx.m_childArray.size();
        this.writeInteger(n);
        this.writeInteger(n2);
        this.writeString(cSSPropertySetEx.getType());
        boolean bl = this.writeValueVariant(cSSPropertySetEx);
        if (!bl) {
            return false;
        }
        Enumeration enumeration = cSSPropertySetEx.m_propertyMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.writeString(string);
            this.writeString((String)cSSPropertySetEx.m_propertyMap.get(string));
        }
        for (int i = 0; i < n2; ++i) {
            CSSPropertySetEx cSSPropertySetEx2 = (CSSPropertySetEx)cSSPropertySetEx.m_childArray.elementAt(i);
            if (this.writePropertySet(cSSPropertySetEx2)) continue;
            return false;
        }
        return true;
    }

    protected void writeString(String string) throws IOException {
        if (string == null) {
            string = "";
        }
        this.writeInteger(string.length());
        if (!this.m_bEncodeToFile) {
            this.m_sbWriteEncoded.append(string);
        } else {
            try {
                this.m_bfwWriteEncoded.append(string);
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.fillInStackTrace();
                SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::EncodeToFile::WriteString", "IO Exception occured while appending String value to File" + this.getStackTrace(throwable));
                throw iOException;
            }
        }
    }

    protected void writeBase64(byte[] byArray) throws IOException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        try {
            this.writeInteger(byArray.length);
            String string = Base64.encode(byArray);
            if (!this.m_bEncodeToFile) {
                this.m_sbWriteEncoded.append(string);
            } else {
                this.m_bfwWriteEncoded.append(string);
            }
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::EncodeToFile::WriteBase64", 8718792 + this.getStackTrace(throwable));
            throw iOException;
        }
    }

    protected void writeBase64EncodedDataToFile(String string, boolean bl) throws IOException {
        File file = new File(string);
        m_Base64Action m_Base64Action2 = bl ? m_Base64Action.BASE64_ENCODE : m_Base64Action.BASE64_NONE;
        try {
            this.processFileRef(file, m_Base64Action2);
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.fillInStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::EncodeToFile::WriteBase64EncodedDataToFile", 8718792 + file.getAbsolutePath() + this.getStackTrace(throwable));
            throw iOException;
        }
    }

    protected boolean writeValueVariant(CSSPropertySetEx cSSPropertySetEx) throws IOException {
        if (cSSPropertySetEx.isFileReference()) {
            String string = cSSPropertySetEx.getFileReference();
            if (string == null || string.length() == 0 || !new File(string).exists()) {
                return true;
            }
            if (cSSPropertySetEx.isStringValue()) {
                this.writeInteger(13);
                this.writeBase64EncodedDataToFile(string, false);
            } else {
                this.writeInteger(12);
                this.writeBase64EncodedDataToFile(string, true);
            }
        } else if (cSSPropertySetEx.isStringValue()) {
            this.writeInteger(3);
            this.writeString(cSSPropertySetEx.m_value);
        } else {
            this.writeInteger(2);
            this.writeBase64(cSSPropertySetEx.getByteValue());
        }
        return true;
    }

    protected String processFileRef(File file, m_Base64Action m_Base64Action2) throws IOException {
        int n = 0;
        int n2 = (int)file.length();
        byte[] byArray = null;
        boolean bl = false;
        boolean bl2 = false;
        File file2 = null;
        BufferedWriter bufferedWriter = null;
        FilterOutputStream filterOutputStream = null;
        switch (m_Base64Action2) {
            case BASE64_ENCODE: {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    this.m_bfwWriteEncoded.append(String.valueOf(n2));
                    this.m_bfwWriteEncoded.append(this.m_separator);
                    randomAccessFile.seek(0L);
                    while (randomAccessFile.getFilePointer() < (long)n2) {
                        int n3 = (int)((long)this.m_chunkSize > (long)n2 - randomAccessFile.getFilePointer() ? (long)n2 - randomAccessFile.getFilePointer() : (long)this.m_chunkSize);
                        byte[] byArray2 = this.readBytesFromFile(randomAccessFile, n3);
                        String string = Base64.encode(byArray2);
                        int n4 = byArray2.length;
                        int n5 = Base64.getBase64EncodedStringLength(n4);
                        n5 += string.length();
                        this.m_bfwWriteEncoded.append(string);
                    }
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException.fillInStackTrace();
                    SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::EncodeToFile::WriteBase64EncodedDataToFile", 8718791 + file.getAbsolutePath() + this.getStackTrace(throwable));
                    throw iOException;
                }
                return "";
            }
            case BASE64_DECODE: {
                try {
                    RandomAccessFile randomAccessFile = this.m_randomAccessEncodedFile;
                    System.out.println(randomAccessFile.getFilePointer());
                    Object var16_21 = null;
                    String string = Thread.currentThread().getId() + "_" + System.currentTimeMillis() + "_";
                    FileManager fileManager = new FileManager();
                    file2 = FileManager.createTempFile(string, ".tmp");
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    int n6 = this.readInteger();
                    if (n6 < 0) {
                        String string2 = null;
                        return string2;
                    }
                    if (n6 == 0) {
                        String string3 = "";
                        return string3;
                    }
                    int n7 = (n6 + 2) / 3 * 4;
                    int n8 = (int)randomAccessFile.getFilePointer();
                    String string4 = this.m_encoded.substring(this.m_posEncoded, this.m_encoded.length());
                    this.m_encoded = "";
                    this.m_posEncoded = 0;
                    if (string4 != "") {
                        randomAccessFile.seek(n8 -= string4.length());
                    }
                    int n9 = n8 + n7;
                    int n10 = (this.m_chunkSize + 2) / 3 * 4;
                    while (n8 < n9) {
                        int n11 = n10 > n9 - n8 ? n9 - n8 : n10;
                        string4 = this.readDataFromFile(randomAccessFile, n11);
                        byArray = Base64.decode(string4);
                        filterOutputStream.write(byArray);
                        ((BufferedOutputStream)filterOutputStream).flush();
                        n8 = (int)randomAccessFile.getFilePointer();
                    }
                }
                catch (IOException iOException) {
                    bl2 = true;
                    Throwable throwable = iOException.fillInStackTrace();
                    SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::DecodeFromFile::ReadValueVariant", 8718792 + this.m_encodedFile.getAbsolutePath() + this.getStackTrace(throwable));
                    throw iOException;
                }
                finally {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    if (bl2 && file2 != null) {
                        file2.delete();
                    }
                }
                return file2.getAbsolutePath();
            }
            case BASE64_NONE: {
                try {
                    String string;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    do {
                        string = this.readDataFromFile(randomAccessFile, this.m_chunkSize);
                        this.m_bfwWriteEncoded.append(string);
                        boolean bl3 = bl = (n += this.m_chunkSize) >= n2;
                    } while (!bl && string != null);
                    String string5 = "Success";
                    return string5;
                }
                catch (IOException iOException) {
                    bl2 = true;
                    Throwable throwable = iOException.fillInStackTrace();
                    SiebelTrace.getInstance().trace(null, 1, "CSSPropertySetEx::DecodeFromFile::ReadValueVariant", 8718791 + this.m_encodedFile.getAbsolutePath() + this.getStackTrace(throwable));
                    throw iOException;
                }
                finally {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (bl2 && file2 != null) {
                        file2.delete();
                    }
                }
            }
        }
        return "Success";
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    class CSSPropertySetExEnumeration
    implements Enumeration {
        private String m_type;
        private Enumeration m_enum;
        private CSSPropertySetEx m_curr;

        CSSPropertySetExEnumeration(Enumeration enumeration, String string) {
            this.m_enum = enumeration;
            this.m_type = string;
            this.shift();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_curr != null;
        }

        public Object nextElement() {
            CSSPropertySetEx cSSPropertySetEx = this.m_curr;
            this.shift();
            return cSSPropertySetEx;
        }

        private void shift() {
            while (this.m_enum.hasMoreElements()) {
                this.m_curr = (CSSPropertySetEx)this.m_enum.nextElement();
                if (this.m_type != null && !this.m_type.equals(this.m_curr.m_type)) continue;
                return;
            }
            this.m_curr = null;
        }
    }

    public static enum m_Base64Action {
        BASE64_NONE,
        BASE64_ENCODE,
        BASE64_DECODE;

    }
}

