/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSBool;
import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSLocale;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class CSSString
extends CSSDatum {
    private String m_value;
    private short m_forceCase;
    protected int m_scale;
    protected int m_minScale;
    protected DecimalFormat m_decimalFormat;

    public CSSString(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSString(CSSString cSSString) {
        super(cSSString.getLocale());
        try {
            this.copy(cSSString);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    public CSSString(String string, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(string);
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            super.assign(cSSDatum);
        }
        catch (CSSException cSSException) {
            this.m_value = "";
            this.setError(true);
            throw cSSException;
        }
        if (this.m_bNull) {
            this.m_value = "";
        } else if (cSSDatum instanceof CSSBool) {
            this.setValue(((CSSBool)cSSDatum).getValue());
        } else if (cSSDatum instanceof CSSNumber) {
            this.setValue(((CSSNumber)cSSDatum).getValue());
        } else if (cSSDatum instanceof CSSString) {
            this.setValue(((CSSString)cSSDatum).getValue());
        } else {
            this.setValue(cSSDatum.getAsString());
        }
        this.setError(false);
    }

    @Override
    public boolean canAssign(CSSDatum cSSDatum) {
        return true;
    }

    @Override
    public int compare(CSSDatum cSSDatum, boolean bl) {
        CSSString cSSString = new CSSString(this.getLocale());
        try {
            cSSString.copy(cSSDatum);
        }
        catch (CSSException cSSException) {
            return -1;
        }
        return bl ? CSSUtilities.compareNoCase(this.m_value, cSSString.m_value) : CSSUtilities.compare(this.m_value, cSSString.m_value);
    }

    @Override
    public void copy(CSSDatum cSSDatum) throws CSSException {
        if (cSSDatum instanceof CSSString) {
            this.m_forceCase = ((CSSString)cSSDatum).m_forceCase;
            this.m_scale = ((CSSString)cSSDatum).m_scale;
            this.m_minScale = ((CSSString)cSSDatum).m_minScale;
        }
        super.copy(cSSDatum);
    }

    @Override
    public String getAsString() {
        return this.m_value;
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public boolean hasFormat() {
        return this.m_forceCase != 0;
    }

    @Override
    public void init() {
        super.init();
        this.m_value = "";
        this.m_forceCase = 0;
        this.m_scale = 15;
        this.m_minScale = 0;
        this.m_decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
        this.m_decimalFormat.setGroupingUsed(false);
        this.m_decimalFormat.setDecimalSeparatorAlwaysShown(false);
        this.m_decimalFormat.setNegativePrefix("-");
        this.m_decimalFormat.setNegativeSuffix("");
        this.m_decimalFormat.setPositivePrefix("");
        this.m_decimalFormat.setPositiveSuffix("");
        this.m_decimalFormat.setMultiplier(1);
    }

    @Override
    public boolean isNull() {
        return CSSUtilities.isEmpty(this.m_value);
    }

    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSString cSSString = new CSSString(this.getLocale());
        CSSBool cSSBool = new CSSBool(this.getLocale());
        CSSDatum cSSDatum2 = cSSString;
        switch (s) {
            case 12: {
                try {
                    cSSString.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                cSSString.copy(this.plus(cSSString.getValue()));
                break;
            }
            case 1: 
            case 2: {
                try {
                    cSSString.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                cSSDatum2 = cSSBool;
                if (this.isNull() || cSSString.isNull()) {
                    cSSBool.setAsString(null);
                    break;
                }
                cSSBool.setValue(this.isLike(cSSString, bl));
                if (s != 2) break;
                cSSBool.setValue(!cSSBool.getValue());
                break;
            }
            case 3: {
                try {
                    cSSString.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                cSSDatum2 = cSSBool;
                if (this.isNull() || cSSDatum.isNull()) {
                    cSSBool.setAsString(null);
                    break;
                }
                cSSBool.setValue(this.soundex() == cSSString.soundex());
                break;
            }
            default: {
                return super.operate(s, cSSDatum, bl, bl2);
            }
        }
        return cSSDatum2;
    }

    @Override
    public void setAsString(String string) {
        this.setValue(string);
    }

    public final String getValue() {
        return this.m_value;
    }

    public final void setValue(CSSString cSSString) {
        if (this.compare(cSSString) != 0) {
            this.setValue(cSSString.getValue());
        }
    }

    public final void setValue(char c) {
        this.setValue(String.valueOf(c));
    }

    public final void setValue(String string) {
        this.m_value = string == null ? "" : string;
        this.forceCase();
    }

    public final void setValue(boolean bl) {
        this.m_value = bl ? "Y" : "N";
    }

    public final void setValue(double d) {
        this.m_decimalFormat.setMaximumFractionDigits(this.m_scale);
        this.m_decimalFormat.setMinimumFractionDigits(this.m_minScale);
        this.m_value = this.m_decimalFormat.format(d);
    }

    public final void append(char c) {
        this.m_value = this.m_value.concat(String.valueOf(c));
        this.forceCase();
    }

    public final void append(String string) {
        this.m_value = this.m_value.concat(string);
        this.forceCase();
    }

    public final CSSString plus(char c) {
        return new CSSString(this.m_value + String.valueOf(c), this.getLocale());
    }

    public final CSSString plus(String string) {
        return new CSSString(this.m_value + string, this.getLocale());
    }

    public final char charAt(int n) {
        return n >= this.m_value.length() ? (char)'\u0000' : this.m_value.charAt(n);
    }

    public final int compare(String string, int n) {
        int n2 = -1;
        if (string != null) {
            int n3 = Math.max(0, Math.min(n, this.m_value.length()));
            int n4 = Math.max(0, Math.min(n, string.length()));
            try {
                n2 = CSSUtilities.compare(this.m_value.substring(0, n3), string.substring(0, n4));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return n2;
    }

    public final int compareNoCase(String string, int n) {
        int n2 = -1;
        if (string != null) {
            int n3 = Math.max(0, Math.min(n, this.m_value.length()));
            int n4 = Math.max(0, Math.min(n, string.length()));
            try {
                n2 = CSSUtilities.compareNoCase(this.m_value.substring(0, n3), string.substring(0, n4));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return n2;
    }

    public final char getAt(int n) {
        return n >= this.m_value.length() ? (char)'\u0000' : this.m_value.charAt(n);
    }

    public final int getLength() {
        return this.m_value.length();
    }

    public final CSSString left(int n) {
        CSSString cSSString = new CSSString(this.getLocale());
        if (n > 0) {
            try {
                int n2 = Math.max(0, Math.min(n, this.m_value.length()));
                cSSString.setValue(this.m_value.substring(0, n2));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return cSSString;
    }

    public final CSSString mid(int n) {
        CSSString cSSString = new CSSString(this.getLocale());
        try {
            int n2 = Math.max(0, Math.min(n, this.m_value.length()));
            cSSString.setValue(this.m_value.substring(n2));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return cSSString;
    }

    public final CSSString mid(int n, int n2) {
        CSSString cSSString = new CSSString(this.getLocale());
        if (n2 > 0) {
            try {
                int n3 = this.m_value.length();
                int n4 = Math.max(0, Math.min(n, n3));
                int n5 = Math.min(n4 + n2, n3);
                cSSString.setValue(this.m_value.substring(n4, n5));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return cSSString;
    }

    public final CSSString right(int n) {
        CSSString cSSString = new CSSString(this.getLocale());
        if (n > 0) {
            try {
                int n2 = this.m_value.length();
                int n3 = Math.max(0, Math.min(n2, n2 - n));
                int n4 = Math.min(n3 + n, n2);
                if (n3 <= n4) {
                    cSSString.setValue(this.m_value.substring(n3, n4));
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return cSSString;
    }

    public final void truncate(int n) {
        if (n != 0) {
            int n2 = this.m_value.length();
            int n3 = 0;
            int n4 = n2;
            if (n < 0) {
                n = -n;
                n3 = Math.min(n, n2);
                n4 = n2;
            } else if (n > 0) {
                n3 = 0;
                n4 = Math.max(0, n2 - n);
            }
            if (n3 < n4) {
                try {
                    this.m_value = this.m_value.substring(n3, n4);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            } else {
                this.empty();
            }
        }
    }

    public final int find(String string) {
        return CSSUtilities.isEmpty(this.m_value) ? -1 : this.m_value.indexOf(string);
    }

    public final int findNoneOf(String string) {
        int n;
        String string2 = "";
        if (CSSUtilities.isEmpty(this.m_value) || CSSUtilities.isEmpty(string)) {
            return -1;
        }
        for (n = 0; n < this.m_value.length() && string.indexOf(this.m_value.charAt(n)) != -1; ++n) {
        }
        return n >= this.m_value.length() ? -1 : n;
    }

    public final int findOneOf(String string) {
        int n;
        String string2 = "";
        if (CSSUtilities.isEmpty(this.m_value) || CSSUtilities.isEmpty(string)) {
            return -1;
        }
        for (n = 0; n < this.m_value.length() && string.indexOf(this.m_value.charAt(n)) == -1; ++n) {
        }
        return n >= this.m_value.length() ? -1 : n;
    }

    public final int compare(String string) {
        return CSSUtilities.compare(this.m_value, string);
    }

    public final int compareNoCase(String string) {
        return CSSUtilities.compareNoCase(this.m_value, string);
    }

    public final void empty() {
        this.m_value = "";
    }

    public final int find(char c) {
        return CSSUtilities.isEmpty(this.m_value) ? -1 : this.m_value.indexOf(c);
    }

    public final boolean isEmpty() {
        return CSSUtilities.isEmpty(this.m_value);
    }

    public final boolean isLowerCase() {
        return this.m_forceCase == 2;
    }

    public final boolean isUpperCase() {
        return this.m_forceCase == 1;
    }

    public final String makeFirstUpper(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 || bl) {
                stringBuffer.setCharAt(i, Character.toUpperCase(c));
            }
            bl = c == ' ';
        }
        return stringBuffer.toString();
    }

    public final void setFirstUpperCase() {
        this.m_forceCase = (short)3;
        this.m_value = this.makeFirstUpper(this.m_value);
    }

    public final void setLowerCase() {
        this.m_forceCase = (short)2;
        this.m_value.toLowerCase();
    }

    public final void setUpperCase() {
        this.m_forceCase = 1;
        this.m_value.toUpperCase();
    }

    public final int subst(String string, String string2, int n) {
        int n2 = 0;
        String string3 = "";
        if (!CSSUtilities.isEmpty(this.m_value)) {
            int n3;
            int n4 = string.length();
            while ((n3 = this.m_value.indexOf(string)) != -1) {
                ++n2;
                if (n == 1) {
                    this.m_value = this.m_value.substring(0, n3) + string2 + this.m_value.substring(n3 + n4, this.m_value.length());
                    break;
                }
                string3 = string3 + this.m_value.substring(0, n3) + string2;
                this.m_value = this.m_value.substring(n3 + n4, this.m_value.length());
                if (n <= 1 || n2 < n) continue;
            }
            if (string3.length() > 0) {
                this.m_value = string3 + this.m_value;
            }
        }
        return n2;
    }

    private final void forceCase() {
        switch (this.m_forceCase) {
            case 1: {
                this.m_value = this.m_value.toUpperCase();
                break;
            }
            case 2: {
                this.m_value = this.m_value.toLowerCase();
                break;
            }
            case 3: {
                this.m_value = this.makeFirstUpper(this.m_value);
            }
        }
    }

    protected final int soundex() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_value.length();
        int n5 = 100;
        int n6 = 0;
        String string = this.m_value.toLowerCase();
        for (n = 0; n < n4 && (string.charAt(n) < 'a' || string.charAt(n) > 'z'); ++n) {
        }
        if (n == n4) {
            return 0;
        }
        n6 = (string.charAt(n) - 97 + 1) * 1000;
        ++n;
        while (n < n4 && n2 < 3) {
            int n7;
            switch (string.charAt(n)) {
                case 'b': 
                case 'f': 
                case 'p': 
                case 'v': {
                    n7 = 1;
                    break;
                }
                case 'c': 
                case 'g': 
                case 'j': 
                case 'k': 
                case 'q': 
                case 's': 
                case 'x': 
                case 'z': {
                    n7 = 2;
                    break;
                }
                case 'd': 
                case 't': {
                    n7 = 3;
                    break;
                }
                case 'l': {
                    n7 = 4;
                    break;
                }
                case 'm': 
                case 'n': {
                    n7 = 5;
                    break;
                }
                case 'r': {
                    n7 = 6;
                    break;
                }
                default: {
                    n7 = 0;
                }
            }
            if (n7 != n3) {
                n3 = n7;
                if (n7 > 0) {
                    n6 += n7 * n5;
                    n5 /= 10;
                    ++n2;
                }
            }
            ++n;
        }
        return n6;
    }
}

