/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSDateTime;
import com.siebel.common.common.CSSDatum;
import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSInteger;
import com.siebel.common.common.CSSNumber;
import com.siebel.common.common.CSSString;
import com.siebel.common.common.CSSUtilities;
import com.siebel.om.om.CSSLocale;

public class CSSTime
extends CSSDateTime {
    public CSSTime(CSSLocale cSSLocale) {
        super(cSSLocale);
    }

    public CSSTime(CSSTime cSSTime) {
        super(cSSTime.getLocale());
        try {
            this.copy(cSSTime);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    public CSSTime(long l, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(l);
    }

    public CSSTime(String string, CSSLocale cSSLocale) {
        super(cSSLocale);
        this.setValue(string);
    }

    public CSSTime(int n, int n2, int n3, CSSLocale cSSLocale) {
        super(cSSLocale);
        try {
            this.setTime(n, n2, n3);
        }
        catch (CSSException cSSException) {
            this.init();
        }
    }

    @Override
    public void assign(CSSDatum cSSDatum) throws CSSException {
        try {
            this.finalCSSDatumAssign(cSSDatum);
        }
        catch (CSSException cSSException) {
            this.setValue((String)null);
            this.setError(true);
            throw cSSException;
        }
        if (this.m_bNull) {
            this.setValue((String)null);
        } else if (cSSDatum instanceof CSSDateTime) {
            this.setValue((CSSDateTime)cSSDatum);
        } else if (cSSDatum instanceof CSSNumber) {
            this.setValue((long)((CSSNumber)cSSDatum).getValue());
        } else if (cSSDatum instanceof CSSString) {
            this.setValue(((CSSString)cSSDatum).getValue());
        }
        this.setError(false);
    }

    @Override
    public boolean canAssign(CSSDatum cSSDatum) {
        return cSSDatum instanceof CSSDateTime || cSSDatum instanceof CSSNumber || cSSDatum instanceof CSSString;
    }

    @Override
    public int compare(CSSDatum cSSDatum, boolean bl) {
        CSSTime cSSTime = new CSSTime(this.m_locale);
        try {
            cSSTime.copy(cSSDatum);
        }
        catch (CSSException cSSException) {
            return -1;
        }
        int n = this.m_bNull || cSSTime.m_bNull ? (this.isNull() ? 1 : 0) - (cSSTime.isNull() ? 1 : 0) : (this.getValue() > cSSTime.getValue() ? 1 : (this.getValue() < cSSTime.getValue() ? -1 : 0));
        return n;
    }

    @Override
    public String getAsString() {
        return this._getAsFormattedString("%H:%M:%S");
    }

    @Override
    public int getDataType() {
        return 11;
    }

    @Override
    public String getFormat() {
        if (!CSSUtilities.isEmpty(this.m_format)) {
            return this.m_format;
        }
        return this.getLocale().getProfile(4);
    }

    @Override
    public CSSDatum operate(short s, CSSDatum cSSDatum, boolean bl, boolean bl2) throws CSSException {
        CSSTime cSSTime = new CSSTime(this.m_locale);
        CSSInteger cSSInteger = new CSSInteger(this.getLocale());
        CSSDatum cSSDatum2 = cSSTime;
        switch (s) {
            case 13: {
                try {
                    cSSTime.copy(cSSDatum);
                    if (!this.isNull() && !cSSTime.isNull()) {
                        cSSInteger.setValue(this.getValue() - cSSTime.getValue());
                    }
                    cSSDatum2 = cSSInteger;
                    break;
                }
                catch (CSSException cSSException) {
                    // empty catch block
                }
            }
            case 12: {
                try {
                    cSSInteger.copy(cSSDatum);
                }
                catch (CSSException cSSException) {
                    throw new CSSException(7668192, new String[]{CSSDatum.operErrName[s], this.getClass().getName(), cSSDatum.getClass().getName()});
                }
                if (this.isNull() || cSSInteger.isNull()) break;
                cSSTime.copy(this);
                if (s == 12) {
                    cSSTime.addTime(0, 0, (int)cSSInteger.getValue(), true);
                    break;
                }
                cSSTime.addTime(0, 0, -((int)cSSInteger.getValue()), true);
                break;
            }
            default: {
                return super.operate(s, cSSDatum, bl, bl2);
            }
        }
        return cSSDatum2;
    }

    public final long getValue() {
        return (long)this.m_hour * 3600L + (long)this.m_minute * 60L + (long)this.m_second;
    }

    public final void setValue(CSSTime cSSTime) {
        this.m_bNull = cSSTime.m_bNull;
        this.m_hour = cSSTime.m_hour;
        this.m_minute = cSSTime.m_minute;
        this.m_second = cSSTime.m_second;
    }

    public final void setValue(long l) {
        this.m_bNull = false;
        this.m_hour = (int)((l %= 86400L) / 3600L);
        this.m_minute = (int)((l %= 3600L) / 60L);
        this.m_second = (int)(l % 60L);
    }

    @Override
    public void setValue(String string) {
        try {
            this.setAsString(string);
        }
        catch (CSSException cSSException) {
            // empty catch block
        }
    }

    public final int addTime(int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        if (n == 0 && n2 == 0 && n3 == 0) {
            return 0;
        }
        long l = this.getValue() + (long)n * 3600L + (long)n2 * 60L + (long)n3;
        if (l < 0L) {
            n4 = (int)(l / 86400L - 1L);
            l = !bl ? 0L : (l -= (long)(n4 * 86400));
        } else if (l >= 86400L) {
            n4 = (int)(l / 86400L);
            l = !bl ? 86399L : (l -= (long)(n4 * 86400));
        }
        this.setValue(l);
        return n4;
    }

    public final String[] getClockHours() {
        String[] stringArray;
        CSSTime cSSTime = new CSSTime(0, 0, 0, this.m_locale);
        CSSLocale cSSLocale = this.getLocale();
        String string = cSSLocale.getProfile(5);
        if (string.charAt(0) == 'H') {
            string = string.substring(0, string.indexOf(58));
            stringArray = new String[24];
            cSSTime.m_hour = 0;
            while (cSSTime.m_hour < 24) {
                String string2;
                stringArray[cSSTime.m_hour] = string2 = cSSTime.getAsFormattedString(string);
                ++cSSTime.m_hour;
            }
        } else {
            string = string.substring(0, string.indexOf(58));
            stringArray = new String[12];
            cSSTime.m_hour = 0;
            while (cSSTime.m_hour < 12) {
                String string3;
                stringArray[cSSTime.m_hour] = string3 = cSSTime.getAsFormattedString(string);
                ++cSSTime.m_hour;
            }
        }
        return stringArray;
    }

    public final String[] getAmPmStrings() {
        String[] stringArray = new String[2];
        CSSLocale cSSLocale = this.getLocale();
        String string = cSSLocale.getProfile(5);
        if (string.charAt(0) == 'H') {
            stringArray[0] = "";
            stringArray[1] = "";
        } else {
            stringArray[0] = cSSLocale.getProfile(16);
            stringArray[1] = cSSLocale.getProfile(17);
        }
        return stringArray;
    }

    public final String getSeparatorString() {
        return this.getLocale().getProfile(15);
    }
}

