/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.common;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSStringRef;
import com.siebel.common.util.CSSSystem;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class CSSUtilities {
    static final char escChar = '\\';
    static final int[] specialChars = new int[]{92, 63, 42};
    private static StringBuffer textBuffer;
    private static boolean m_bInASSERT;

    public static String addQuotes(String string, char c) {
        int n;
        if (string == null) {
            return null;
        }
        char c2 = c;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        stringBuffer.append(c);
        while ((n = string.indexOf(c2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n)).append(c).append(c);
            n2 = n + 1;
        }
        stringBuffer.append(string.substring(n2));
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public static String fieldDataToSearch(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 1; i < specialChars.length; ++i) {
            if (string.indexOf(specialChars[i]) == -1) continue;
            bl = true;
            break;
        }
        String string2 = string;
        if (bl) {
            for (int i = 0; i < specialChars.length; ++i) {
                int n;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer("");
                while ((n = string2.indexOf(specialChars[i], n2)) != -1) {
                    stringBuffer.append(string2.substring(n2, n)).append('\\').append((char)specialChars[i]);
                    n2 = n + 1;
                }
                stringBuffer.append(string2.substring(n2));
                string2 = stringBuffer.toString();
            }
        }
        return CSSUtilities.addQuotes(string2, '\"');
    }

    public static String stripQuotes(String string) {
        if (CSSUtilities.isEmpty(string)) {
            return string;
        }
        char c = string.charAt(0);
        if ((c == '\"' || c == '\'') && string.length() > 1 && string.charAt(string.length() - 1) == c) {
            string = CSSUtilities.delQuotes(string, c);
        }
        return string;
    }

    public static String delQuotes(String string, char c) {
        int n;
        String string2 = "";
        String string3 = string;
        if (string.charAt(0) != c || string.charAt(string.length() - 1) != c) {
            return string;
        }
        string3 = string.substring(1, string.length() - 2);
        String string4 = new String(new char[]{c});
        string4 = string4 + string4;
        while ((n = string3.indexOf(string4)) > 0) {
            string2 = string2 + string3.substring(0, n + 1);
            string3 = string3.substring(n + 2);
        }
        string2 = string2 + string3;
        return string2;
    }

    public static String searchToFieldData(String string) {
        int n;
        String string2 = "";
        if (CSSUtilities.isEmpty(string = CSSUtilities.stripQuotes(string)) || string.indexOf("?*") < 0) {
            return string;
        }
        while (!CSSUtilities.isEmpty(string) && (n = string.indexOf("\\")) > -1 && n + 1 != string.length()) {
            string2 = string2 + string.substring(n);
            string2 = string2 + string.substring(n + 1, n + 2);
            string = string.substring(n + 2);
        }
        return string2 + string;
    }

    public static String[] getNextToken(String string) {
        int n = 0;
        String[] stringArray = new String[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n");
        try {
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(0) == '\"' || string2.charAt(0) == '\'') {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string.trim(), "'\"");
                string2 = stringTokenizer2.nextToken();
                if (stringTokenizer2.hasMoreElements()) {
                    n = 1;
                }
            }
            stringArray[0] = string2;
            stringArray[1] = string.substring(string.indexOf(string2) + string2.length() + n);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return stringArray;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(CSSStringRef cSSStringRef) {
        return CSSUtilities.isEmpty(cSSStringRef.getValue());
    }

    public static final int compareNoCase(String string, String string2) {
        int n = CSSUtilities.isEmpty(string) || CSSUtilities.isEmpty(string2) ? (CSSUtilities.isEmpty(string) ? 0 : 1) - (CSSUtilities.isEmpty(string2) ? 0 : 1) : string.toLowerCase().compareTo(string2.toLowerCase());
        if (n < 0) {
            n = -1;
        }
        if (n > 0) {
            n = 1;
        }
        return n;
    }

    public static final int compare(String string, String string2) {
        int n = CSSUtilities.isEmpty(string) || CSSUtilities.isEmpty(string2) ? (CSSUtilities.isEmpty(string) ? 0 : 1) - (CSSUtilities.isEmpty(string2) ? 0 : 1) : string.compareTo(string2);
        if (n < 0) {
            n = -1;
        }
        if (n > 0) {
            n = 1;
        }
        return n;
    }

    public static final String makeString(char c, int n) {
        String string = "";
        String string2 = String.valueOf(c);
        while (n-- > 0) {
            string = string + string2;
        }
        return string;
    }

    public static final int btoi(boolean bl) {
        return bl ? 1 : 0;
    }

    public static final boolean itob(int n) {
        return n != 0;
    }

    public static final String itoa(int n) {
        return String.valueOf(n);
    }

    private static final boolean getURL(String string, CSSStringRef cSSStringRef) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string.toLowerCase().trim();
        if (string2.indexOf("://") != -1) {
            bl = true;
            bl2 = true;
        } else if (string2.startsWith("www.")) {
            bl = true;
        }
        String string3 = !bl2 ? "http://" + string : string;
        cSSStringRef.setValue(string3);
        return bl;
    }

    public static final void SSExecuteFile(String string) throws CSSException {
        String string2;
        String string3 = CSSMsgMgr.getEmptyString();
        String string4 = null;
        CSSStringRef cSSStringRef = new CSSStringRef();
        Hashtable hashtable = CSSSystem.getCfgSection(CSSMsgMgr.get(8767128));
        if (hashtable == null) {
            throw new CSSException(8716432, CSSMsgMgr.get(8767128));
        }
        boolean bl = CSSUtilities.getURL(string, cSSStringRef);
        if (bl) {
            string3 = CSSMsgMgr.get(8767279);
            string = cSSStringRef.getValue();
        } else {
            File file = new File(string);
            if (!file.exists()) {
                throw new CSSException(8716439, string);
            }
            String string5 = file.getName();
            try {
                int n = string5.indexOf(".");
                string3 = n != -1 ? string5.substring(n + 1) : CSSMsgMgr.get(8767280);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string3 = CSSMsgMgr.get(8767280);
            }
        }
        string4 = (String)hashtable.get(string3);
        if (string4 == null) {
            throw new CSSException(8716453, string3);
        }
        try {
            int n = string4.indexOf("%f");
            if (n == -1) {
                string2 = string4 + " " + string;
            } else {
                String string6 = string4.substring(0, n);
                String string7 = string4.substring(n + 2);
                string2 = string6 + " " + string + " " + string7;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string2 = string4 + " " + string;
        }
        try {
            CSSUtilities.SSShellExecute(string2);
        }
        catch (CSSException cSSException) {
            throw new CSSException(8716388, string2, cSSException);
        }
    }

    public static final void SSShellExecute(String string) throws CSSException {
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(string);
        }
        catch (IOException iOException) {
            throw new CSSException(7864504, iOException.getMessage());
        }
    }

    public static final void TRACE(String string) {
    }

    public static final void TRACE(Object object) {
    }

    public static final boolean inASSERT() {
        return m_bInASSERT;
    }

    public static final void ASSERT(boolean bl) {
        if (!bl) {
            m_bInASSERT = true;
            Exception exception = new Exception("Siebel JTC: Assert failed.");
            exception.printStackTrace();
            m_bInASSERT = false;
        }
    }

    public static final void ASSERT(Object object) {
        if (object == null) {
            CSSUtilities.ASSERT(false);
        }
    }

    public static String getStoreString(String string) {
        if (CSSUtilities.isEmpty(string)) {
            return string;
        }
        int n = string.indexOf(10);
        int n2 = 0;
        CSSUtilities.resetTextBuffer();
        while (n != -1) {
            textBuffer.append(string.substring(n2, n));
            textBuffer.append("\r\n");
            n2 = n + 1;
            n = string.indexOf(10, n2);
        }
        textBuffer.append(string.substring(n2));
        return textBuffer.toString();
    }

    public static String getDisplayString(String string) {
        if (CSSUtilities.isEmpty(string)) {
            return string;
        }
        int n = string.indexOf("\r\n");
        int n2 = 0;
        CSSUtilities.resetTextBuffer();
        while (n != -1) {
            textBuffer.append(string.substring(n2, n));
            textBuffer.append("\n");
            n2 = n + 2;
            n = string.indexOf("\r\n", n2);
        }
        textBuffer.append(string.substring(n2));
        return textBuffer.toString();
    }

    private static void resetTextBuffer() {
        if (textBuffer == null) {
            textBuffer = new StringBuffer();
        } else {
            textBuffer.setLength(0);
        }
    }

    public static String getFirstLine(String string) {
        if (CSSUtilities.isEmpty(string)) {
            return string;
        }
        if (string.indexOf("\r\n") > -1) {
            return string.substring(0, string.indexOf("\r\n"));
        }
        if (string.indexOf("\n") > -1) {
            return string.substring(0, string.indexOf("\n"));
        }
        return string;
    }

    public static String ValidateAndFormatLogFileName(String string) {
        String string2;
        if (CSSUtilities.isEmpty(string)) {
            return null;
        }
        String string3 = string.trim();
        string3 = string3.toLowerCase();
        String string4 = System.getenv("WINDIR");
        if (string4 != null) {
            string4 = string4.toLowerCase();
        }
        if ((string2 = System.getenv("PROGRAMFILES")) != null) {
            string2 = string2.toLowerCase();
        }
        if (string4 != null && string3.indexOf(string4) != -1 || string2 != null && string3.indexOf(string2) != -1) {
            return null;
        }
        if (!string3.endsWith(".log")) {
            string3 = string3 + ".log";
        }
        return string3;
    }

    static {
        m_bInASSERT = false;
    }
}

