/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.crypt;

import com.siebel.common.common.CSSException;
import com.siebel.common.crypt.CryptIntr;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JCECrypt
implements CryptIntr {
    private static final String RC4_ALGORITHM = "RC4";
    private static final String RSA_ALGORITHM = "RSA";
    private static final String SHA1_RANDOM = "SHA1PRNG";
    private static final int RSA_MODULUS_BITS = 512;
    private Cipher m_helloHandShake = null;
    private Cipher m_encryptCipher = null;
    private Cipher m_decryptCipher = null;
    private KeyPair m_rsaKP = null;
    private KeyPairGenerator m_rsaKPGen = null;
    private SecretKey m_sessionKey = null;
    private int[] m_keyGenParam = null;
    private boolean m_bMustEncrypt = false;

    @Override
    public void init() throws CSSException {
        try {
            this.m_helloHandShake = Cipher.getInstance(RSA_ALGORITHM);
            this.m_rsaKPGen = KeyPairGenerator.getInstance(RSA_ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance(SHA1_RANDOM);
            this.m_rsaKPGen.initialize(512, secureRandom);
            this.m_rsaKP = this.m_rsaKPGen.genKeyPair();
            this.m_helloHandShake.init(2, this.m_rsaKP.getPrivate());
        }
        catch (Exception exception) {
            throw new CSSException(8716610, exception.getMessage());
        }
    }

    @Override
    public byte[] getPublicKey() throws CSSException {
        if (this.m_rsaKP == null) {
            throw new CSSException(8716613);
        }
        try {
            return this.m_rsaKP.getPublic().getEncoded();
        }
        catch (Exception exception) {
            throw new CSSException(8716611, exception.getMessage());
        }
    }

    @Override
    public void importSessionKey(byte[] byArray) throws CSSException {
        if (byArray != null) {
            if (this.m_bMustEncrypt) {
                throw new CSSException(8716614);
            }
            try {
                byte[] byArray2 = this.m_helloHandShake.doFinal(byArray);
                this.m_sessionKey = new SecretKeySpec(byArray2, 0, byArray2.length, RC4_ALGORITHM);
                this.m_encryptCipher = Cipher.getInstance(RC4_ALGORITHM);
                this.m_decryptCipher = Cipher.getInstance(RC4_ALGORITHM);
                this.m_encryptCipher.init(1, this.m_sessionKey);
                this.m_decryptCipher.init(2, this.m_sessionKey);
                this.m_bMustEncrypt = true;
            }
            catch (Exception exception) {
                throw new CSSException(8716612, exception.getMessage());
            }
        } else {
            throw new CSSException(8716615);
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n, int n2) throws CSSException {
        if (!this.m_bMustEncrypt) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        try {
            this.m_decryptCipher.init(2, this.m_sessionKey);
            byte[] byArray3 = this.m_decryptCipher.doFinal(byArray, n, n2);
            return byArray3;
        }
        catch (Exception exception) {
            throw new CSSException(8716608, exception.getMessage());
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, int n2) throws CSSException {
        if (!this.m_bMustEncrypt) {
            throw new CSSException(8716613);
        }
        try {
            this.m_encryptCipher.init(1, this.m_sessionKey);
            byte[] byArray2 = this.m_encryptCipher.doFinal(byArray, n, n2);
            return byArray2;
        }
        catch (Exception exception) {
            throw new CSSException(8716609, exception.getMessage());
        }
    }

    protected void finalize() {
    }

    @Override
    public void generateKey() throws CSSException {
        throw new CSSException(8716798, "Method not implemented");
    }
}

