/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.crypt;

import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.siebel.common.common.CSSException;
import com.siebel.common.crypt.CryptIntr;
import java.security.SecureRandom;

public class RSACrypt
implements CryptIntr {
    private static final String JAVA_PROVIDER = "Java";
    private static final String RC4_ALGORITHM = "RC4";
    private static final String MD5_ALGORITHM = "MD5";
    private static final String RSA_ALGORITHM = "RSA";
    private static final String SHA1_RANDOM = "SHA1Random";
    private static final String BER_BYTE_FORMAT = "RSAPublicKeyBER";
    private static final String TRANSFORMATION_VALUE = "Base64-76";
    private static final int RSA_MODULUS_BITS = 512;
    private static final int FERMAT_NO = 7;
    private JSAFE_AsymmetricCipher m_helloHandShake = null;
    private JSAFE_SymmetricCipher m_encryptCipher = null;
    private JSAFE_SymmetricCipher m_decryptCipher = null;
    private JSAFE_KeyPair m_rsaKP = null;
    private JSAFE_SecretKey m_sessionKey = null;
    private int[] m_keyGenParam = null;
    private boolean m_bMustEncrypt = false;

    @Override
    public void init() throws CSSException {
        this.m_keyGenParam = new int[]{512, 7};
        try {
            this.m_helloHandShake = JSAFE_AsymmetricCipher.getInstance(RSA_ALGORITHM, JAVA_PROVIDER);
            this.m_rsaKP = this.m_helloHandShake.getBlankKeyPair();
            SecureRandom secureRandom = JSAFE_SecureRandom.getInstance(SHA1_RANDOM, JAVA_PROVIDER);
            this.m_rsaKP.generateInit(null, this.m_keyGenParam, secureRandom);
            this.m_rsaKP.generate();
            this.m_helloHandShake.decryptInit(this.m_rsaKP.getPrivateKey());
        }
        catch (Exception exception) {
            throw new CSSException(8716610, exception.getMessage());
        }
    }

    @Override
    public byte[] getPublicKey() throws CSSException {
        if (this.m_rsaKP == null) {
            throw new CSSException(8716613);
        }
        try {
            return this.m_rsaKP.getPublicKey().getKeyData(BER_BYTE_FORMAT)[0];
        }
        catch (Exception exception) {
            throw new CSSException(8716611, exception.getMessage());
        }
    }

    @Override
    public void importSessionKey(byte[] byArray) throws CSSException {
        if (byArray != null) {
            if (this.m_bMustEncrypt) {
                throw new CSSException(8716614);
            }
            try {
                byte[] byArray2 = this.m_helloHandShake.decryptUpdate(byArray, 0, byArray.length);
                byte[] byArray3 = this.m_helloHandShake.decryptFinal();
                int n = 0;
                if (byArray2 != null) {
                    n += byArray2.length;
                }
                if (byArray3 != null) {
                    n += byArray3.length;
                }
                byte[] byArray4 = new byte[n];
                n = 0;
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                    n += byArray2.length;
                }
                if (byArray3 != null) {
                    System.arraycopy(byArray3, 0, byArray4, n, byArray3.length);
                }
                this.m_sessionKey = JSAFE_SecretKey.getInstance(RC4_ALGORITHM, JAVA_PROVIDER);
                this.m_encryptCipher = JSAFE_SymmetricCipher.getInstance(RC4_ALGORITHM, JAVA_PROVIDER);
                this.m_decryptCipher = JSAFE_SymmetricCipher.getInstance(RC4_ALGORITHM, JAVA_PROVIDER);
                this.m_sessionKey.setSecretKeyData(byArray4, 0, byArray4.length);
                this.m_encryptCipher.encryptInit(this.m_sessionKey);
                this.m_decryptCipher.decryptInit(this.m_sessionKey);
                this.m_bMustEncrypt = true;
            }
            catch (Exception exception) {
                throw new CSSException(8716612, exception.getMessage());
            }
        } else {
            throw new CSSException(8716615);
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n, int n2) throws CSSException {
        if (!this.m_bMustEncrypt) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        try {
            this.m_decryptCipher.decryptInit(this.m_sessionKey);
            byte[] byArray3 = this.m_decryptCipher.decryptUpdate(byArray, n, n2);
            this.m_decryptCipher.decryptFinal();
            return byArray3;
        }
        catch (Exception exception) {
            throw new CSSException(8716608, exception.getMessage());
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, int n2) throws CSSException {
        if (!this.m_bMustEncrypt) {
            throw new CSSException(8716613);
        }
        try {
            this.m_encryptCipher.encryptInit(this.m_sessionKey);
            byte[] byArray2 = this.m_encryptCipher.encryptUpdate(byArray, n, n2);
            this.m_encryptCipher.encryptFinal();
            return byArray2;
        }
        catch (Exception exception) {
            throw new CSSException(8716609, exception.getMessage());
        }
    }

    @Override
    public void generateKey() throws CSSException {
        throw new CSSException(8716798, "Method not implemented");
    }

    protected void finalize() {
        this.m_rsaKP.clearSensitiveData();
        this.m_helloHandShake.clearSensitiveData();
        this.m_encryptCipher.clearSensitiveData();
        this.m_decryptCipher.clearSensitiveData();
        this.m_sessionKey.clearSensitiveData();
    }
}

