/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.util;

public class Base64 {
    private static String NEWLINE = System.getProperty("line.separator");
    private static final short ZERO_LENGTH = 1;
    private static final short LENGTH_ERROR = 2;
    private static final short ENCODING_ERROR = 3;
    public static char[] mapping = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (i % 3 == 0) {
                stringBuffer.append(mapping[(byArray[i] & 0xFC) >> 2]);
            }
            if (i % 3 == 1) {
                stringBuffer.append(mapping[(byArray[i - 1] & 3) << 4 | (byArray[i] & 0xF0) >> 4]);
            }
            if (i % 3 != 2) continue;
            stringBuffer.append(mapping[(byArray[i - 1] & 0xF) << 2 | (byArray[i] & 0xC0) >> 6]);
            stringBuffer.append(mapping[byArray[i] & 0x3F]);
        }
        if ((n - 1) % 3 == 0) {
            stringBuffer.append(mapping[(byArray[n - 1] & 3) << 4]);
            stringBuffer.append("==");
        } else if ((n - 1) % 3 == 1) {
            stringBuffer.append(mapping[(byArray[n - 1] & 0xF) << 2]);
            stringBuffer.append("=");
        }
        return new String(stringBuffer);
    }

    public static byte[] decode(String string) {
        String string2 = Base64.removeNewlines(string);
        short s = 0;
        if (!Base64.isBase64(string, s)) {
            switch (s) {
                case 1: {
                    return new byte[0];
                }
                case 2: {
                    throw new IllegalArgumentException("Input not a valid base64-encoding (length not a multiple of 4): " + string2);
                }
                case 3: {
                    throw new IllegalArgumentException("Input not a valid base64-encoding (more than 2 ='s at the end): " + string2);
                }
            }
        }
        int n = string2.length();
        int n2 = n / 4 * 3;
        while (string2.charAt(n - 1) == '=') {
            --n2;
            if (--n >= string2.length() - 2) continue;
            throw new IllegalArgumentException("Input not a valid base64-encoding (more than 2 ='s at the end): " + string2);
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = Base64.unmap(string2.charAt(i));
            if (i % 4 == 0) {
                byArray[n3] = (byte)(n4 << 2);
                continue;
            }
            if (i % 4 == 1) {
                byArray[n3] = (byte)(byArray[n3] | n4 >> 4);
                if (++n3 >= n2) continue;
                byArray[n3] = (byte)((n4 & 0xF) << 4);
                continue;
            }
            if (i % 4 == 2) {
                byArray[n3] = (byte)(byArray[n3] | n4 >> 2);
                if (++n3 >= n2) continue;
                byArray[n3] = (byte)((n4 & 3) << 6);
                continue;
            }
            if (i % 4 != 3) continue;
            byArray[n3] = (byte)(byArray[n3] | n4);
            ++n3;
        }
        return byArray;
    }

    public static int getBase64EncodedStringLength(int n) {
        return (n + 2) / 3 * 4;
    }

    public static boolean isBase64(String string, short s) {
        String string2 = Base64.removeNewlines(string);
        int n = string2.length();
        s = 0;
        if (n == 0) {
            s = 1;
            return false;
        }
        if (n % 4 != 0) {
            s = (short)2;
            return false;
        }
        if (string2.charAt(n - 1) != '=') {
            s = (short)3;
            return false;
        }
        int n2 = n / 4 * 3;
        while (string2.charAt(n - 1) == '=') {
            --n2;
            if (--n >= string2.length() - 2) continue;
            s = (short)3;
            return false;
        }
        return true;
    }

    private static String removeNewlines(String string) {
        String string2 = "";
        int n = string.indexOf(NEWLINE);
        while (n > 0) {
            string2 = string2 + string.substring(0, n);
            string = string.substring(n + NEWLINE.length());
            n = string.indexOf(NEWLINE);
        }
        string2 = string2 + string;
        return string2;
    }

    private static int unmap(char c) {
        int n;
        if ('A' <= c && c <= 'Z') {
            n = c - 65;
        } else if ('a' <= c && c <= 'z') {
            n = c - 97 + 26;
        } else if ('0' <= c && c <= '9') {
            n = c - 48 + 52;
        } else if (c == '+') {
            n = 62;
        } else if (c == '/') {
            n = 63;
        } else {
            throw new IllegalArgumentException("Input not a valid base64-encoding; it contains an illegal character: " + c);
        }
        return n;
    }
}

