/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.util;

import com.siebel.common.util.BitmapImageFormatException;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class BitmapImageDecoder {
    public static final int BITMAPFILEHEADER_SIZE = 14;
    public static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bfType;
    private int bfOffBits;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private int biPlanes;
    private int biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;
    private int[] bitmap;
    private Image img;
    private IndexColorModel icm;
    private int bits;
    private int size;
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private byte[] bmpbytes;
    private Color bgColor;
    private int[] palatte;
    private int numColors;
    private boolean debug;

    public BitmapImageDecoder(byte[] byArray, Color color) throws BitmapImageFormatException {
        this(byArray, color, false);
    }

    public BitmapImageDecoder(byte[] byArray, Color color, boolean bl) throws BitmapImageFormatException {
        this.bmpbytes = byArray;
        this.bgColor = color;
        if (!bl) {
            this.bgColor = null;
        }
        try {
            this.readHeader();
            if (!this.isValidBitmap()) {
                throw new BitmapImageFormatException();
            }
            if (!this.isSupportedBitmap()) {
                throw new BitmapImageFormatException();
            }
            this.readBitmap();
            this.img = this.generateTrnsprntBgImage();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BitmapImageFormatException();
        }
    }

    private Image generateTrnsprntBgImage() {
        int n;
        int n2 = -1;
        Image image = null;
        this.bits = this.biBitCount;
        this.size = this.numColors;
        this.red = new byte[this.numColors];
        this.green = new byte[this.numColors];
        this.blue = new byte[this.numColors];
        int[] nArray = new int[this.numColors];
        for (n = 0; n < this.numColors; ++n) {
            Color color = new Color(this.palatte[n]);
            this.red[n] = (byte)color.getRed();
            this.green[n] = (byte)color.getGreen();
            this.blue[n] = (byte)color.getBlue();
            nArray[n] = color.getRGB();
            if (!color.equals(this.bgColor)) continue;
            n2 = n;
        }
        for (n = 0; n < this.bitmap.length; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                if (this.bitmap[n] != nArray[i]) continue;
                this.bitmap[n] = i;
            }
        }
        this.icm = new IndexColorModel(this.bits, this.size, this.red, this.green, this.blue, n2);
        image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.biWidth, this.biHeight, (ColorModel)this.icm, this.bitmap, 0, this.biWidth));
        return image;
    }

    public Image getImage() {
        return this.img;
    }

    public Image getImage(Color color) {
        if (this.bgColor == null || this.bgColor != color) {
            int n = -1;
            for (int i = 0; i < this.numColors; ++i) {
                Color color2 = new Color(this.palatte[i]);
                if (!color2.equals(color)) continue;
                n = i;
            }
            this.icm = new IndexColorModel(this.bits, this.size, this.red, this.green, this.blue, n);
            this.img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.biWidth, this.biHeight, (ColorModel)this.icm, this.bitmap, 0, this.biWidth));
        }
        return this.img;
    }

    public int getWidth() {
        return this.biWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public int getBitmapBitCount() {
        return this.biBitCount;
    }

    private boolean isValidBitmap() {
        return this.bfType[0] == 66 && this.bfType[1] == 77 && this.bfOffBits == this.bmpbytes.length;
    }

    private boolean isSupportedBitmap() {
        return this.biPlanes == 1 && (this.biBitCount == 4 || this.biBitCount == 8 || this.biBitCount == 24) && this.biCompression == 0;
    }

    private void readHeader() {
        this.bfType = new byte[2];
        this.bfType[0] = this.bmpbytes[0];
        this.bfType[1] = this.bmpbytes[1];
        this.bfOffBits = this.readInt(this.bmpbytes, 2);
        int n = 14;
        this.biSize = this.readInt(this.bmpbytes, n);
        this.biWidth = this.readInt(this.bmpbytes, n += 4);
        this.biHeight = this.readInt(this.bmpbytes, n += 4);
        this.biPlanes = this.readShort(this.bmpbytes, n += 4);
        this.biBitCount = this.readShort(this.bmpbytes, n += 2);
        this.biCompression = this.readInt(this.bmpbytes, n += 2);
        this.biSizeImage = this.readInt(this.bmpbytes, n += 4);
        this.biXPelsPerMeter = this.readInt(this.bmpbytes, n += 4);
        this.biYPelsPerMeter = this.readInt(this.bmpbytes, n += 4);
        this.biClrUsed = this.readInt(this.bmpbytes, n += 4);
        this.biClrImportant = this.readInt(this.bmpbytes, n += 4);
        n += 4;
    }

    private void readBitmap() {
        int n;
        this.palatte = null;
        int n2 = 54;
        if (this.biBitCount != 24) {
            this.numColors = this.biClrUsed;
            if (this.numColors == 0) {
                this.numColors = 1 << this.biBitCount;
            }
            this.palatte = new int[this.numColors];
            for (n = 0; n < this.numColors; ++n) {
                this.palatte[n] = 0xFF000000 | (this.bmpbytes[n2 + 2] & 0xFF) << 16 | (this.bmpbytes[n2 + 1] & 0xFF) << 8 | this.bmpbytes[n2] & 0xFF;
                n2 += 4;
            }
            if (this.biSizeImage == 0) {
                this.biSizeImage = (this.biWidth * this.biBitCount + 31 & 0xFFFFFFE0) >> 3;
                this.biSizeImage *= this.biHeight;
            }
        }
        n = this.biSizeImage / this.biHeight - (this.biWidth * this.biBitCount / 8 + (this.biWidth * this.biBitCount % 8 == 0 ? 0 : 1));
        this.bitmap = new int[this.biWidth * this.biHeight];
        for (int i = 0; i < this.biHeight; ++i) {
            switch (this.biBitCount) {
                case 24: {
                    int n3;
                    for (n3 = 0; n3 < this.biWidth; ++n3) {
                        this.bitmap[this.biWidth * (this.biHeight - i - 1) + n3] = 0xFF000000 | (this.bmpbytes[n2 + 2] & 0xFF) << 16 | (this.bmpbytes[n2 + 1] & 0xFF) << 8 | this.bmpbytes[n2] & 0xFF;
                        n2 += 3;
                    }
                    break;
                }
                case 8: {
                    int n3;
                    for (n3 = 0; n3 < this.biWidth; ++n3) {
                        this.bitmap[this.biWidth * (this.biHeight - i - 1) + n3] = this.palatte[this.bmpbytes[n2] & 0xFF];
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    int n3;
                    for (n3 = 0; n3 < this.biWidth; n3 += 2) {
                        this.bitmap[this.biWidth * (this.biHeight - i - 1) + n3] = this.palatte[(this.bmpbytes[n2] & 0xF0) >> 4];
                        if (n3 + 1 < this.biWidth) {
                            this.bitmap[this.biWidth * (this.biHeight - i - 1) + n3 + 1] = this.palatte[this.bmpbytes[n2] & 0xF];
                        }
                        ++n2;
                    }
                    break;
                }
            }
            n2 += n;
        }
    }

    private int readInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private int readShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }
}

