/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class CSSRect {
    public int left = 0;
    public int top = 0;
    public int right = 0;
    public int bottom = 0;

    public CSSRect() {
    }

    public CSSRect(int n, int n2, int n3, int n4) {
        this.setRect(n, n2, n3, n4);
    }

    public CSSRect(Rectangle rectangle) {
        this.setRect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public int width() {
        return this.right - this.left;
    }

    public int height() {
        return this.bottom - this.top;
    }

    public Dimension size() {
        return new Dimension(this.width(), this.height());
    }

    public Point topLeft() {
        return new Point(this.left, this.top);
    }

    public Point bottomRight() {
        return new Point(this.right, this.bottom);
    }

    public Point centerPoint() {
        return new Point((this.left + this.right) / 2, (this.top + this.bottom) / 2);
    }

    public boolean isRectEmpty() {
        return this.width() == 0 || this.height() == 0;
    }

    public boolean isRectNull() {
        return this.left == 0 && this.right == 0 && this.top == 0 && this.bottom == 0;
    }

    public boolean ptInRect(Point point) {
        return point.x <= this.right && point.x >= this.left && point.y <= this.bottom && point.y >= this.top;
    }

    public void setRect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public void setRectEmpty() {
        this.setRect(0, 0, 0, 0);
    }

    public void copyRect(CSSRect cSSRect) {
        this.setRect(cSSRect.left, cSSRect.top, cSSRect.right, cSSRect.bottom);
    }

    public boolean equalRect(CSSRect cSSRect) {
        return cSSRect.left == this.left && cSSRect.top == this.top && cSSRect.right == this.right && cSSRect.bottom == this.bottom;
    }

    public void inflateRect(int n, int n2) {
        this.left -= n;
        this.right += n;
        this.top -= n2;
        this.bottom += n2;
    }

    public void deflateRect(int n, int n2) {
        this.inflateRect(-n, -n2);
    }

    public void normalizeRect() {
        int n;
        if (this.left > this.right) {
            n = this.left;
            this.left = this.right;
            this.right = n;
        }
        if (this.top > this.bottom) {
            n = this.top;
            this.bottom = this.top = this.bottom;
        }
    }

    public void offsetRect(int n, int n2) {
        this.left += n;
        this.right += n;
        this.top += n2;
        this.bottom += n2;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.right - this.left, this.bottom - this.top, this.width(), this.height());
    }

    public static CSSRect reflectIn(CSSRect cSSRect, CSSRect cSSRect2) {
        cSSRect.offsetRect(cSSRect2.left + cSSRect2.right - cSSRect.left - cSSRect.right, 0);
        return cSSRect;
    }
}

