/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.util;

import com.siebel.common.common.CSSUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class CSSSystem {
    private static final String m_thisClass = "CSSSystem";
    private static String m_lang = "ENU";
    private static String m_rootJar;
    private static boolean m_bInit;
    private static String m_classPath;
    private static String m_rootPath;
    private static String m_userPath;
    private static String m_pathSeparator;
    private static String m_fileSeparator;
    private static String m_temp;
    private static Hashtable m_cfgSections;
    private static String m_alternateColor;
    private static Hashtable m_timers;

    protected CSSSystem() {
    }

    public static void setLanguage(String string) {
        if (!CSSUtilities.isEmpty(string)) {
            m_lang = string;
        }
        m_rootJar = "siebeltc_" + m_lang + ".jar";
    }

    public static String getRootPath() {
        CSSSystem.initStatic();
        return m_rootPath;
    }

    public static String getRootJarPath() {
        return CSSSystem.getRootPath() + m_rootJar;
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readConfigFile(String string) {
        StreamTokenizer streamTokenizer = null;
        Hashtable<String, String> hashtable = null;
        m_cfgSections.clear();
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.commentChar(59);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.quoteChar(34);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype == 91) {
                    if (streamTokenizer.nextToken() != -3) continue;
                    String string2 = streamTokenizer.sval;
                    if (streamTokenizer.nextToken() != 93) continue;
                    hashtable = new Hashtable<String, String>();
                    m_cfgSections.put(string2, hashtable);
                    continue;
                }
                if (streamTokenizer.ttype != -3) continue;
                String string3 = streamTokenizer.sval;
                if (streamTokenizer.nextToken() != 61) continue;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 34) {
                    if (streamTokenizer.ttype != -3) continue;
                }
                String string4 = streamTokenizer.sval;
                hashtable.put(string3, string4);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Hashtable getCfgSection(String string) {
        if (m_cfgSections == null) {
            return null;
        }
        return (Hashtable)m_cfgSections.get(string);
    }

    public static boolean isListAlternateColor() {
        if (m_alternateColor == null) {
            String string;
            m_alternateColor = "false";
            Hashtable hashtable = CSSSystem.getCfgSection("Preferences");
            if (hashtable != null && (string = (String)hashtable.get("ListAlternateColor")) != null && string.equalsIgnoreCase("true")) {
                m_alternateColor = "true";
            }
        }
        return m_alternateColor.equalsIgnoreCase("true");
    }

    public static void startTimer(String string) {
        Timer timer = (Timer)m_timers.get(string);
        if (timer == null) {
            timer = new Timer(string);
            m_timers.put(string, timer);
        }
        timer.start();
    }

    public static void stopTimer(String string) {
        Timer timer = (Timer)m_timers.get(string);
        if (timer != null) {
            timer.stop();
        }
    }

    public static void resetTimer(String string) {
        Timer timer = (Timer)m_timers.get(string);
        if (timer != null) {
            timer.reset();
        }
    }

    public static void printTimer(String string) {
        Timer timer = (Timer)m_timers.get(string);
        if (timer != null) {
            timer.print();
        }
    }

    public static void printTimers() {
        Enumeration enumeration = m_timers.elements();
        while (enumeration.hasMoreElements()) {
            Timer timer = (Timer)enumeration.nextElement();
            if (timer == null) continue;
            timer.print();
        }
    }

    public static void removeTimer(String string) {
        m_timers.remove(string);
    }

    public static void removeTimers() {
        m_timers.clear();
    }

    private static void initStatic() {
        if (m_bInit) {
            return;
        }
        m_userPath = System.getProperty("user.dir");
        m_classPath = System.getProperty("java.class.path");
        m_pathSeparator = System.getProperty("path.separator");
        m_fileSeparator = System.getProperty("file.separator");
        m_rootPath = m_userPath;
        if (m_pathSeparator == null) {
            m_pathSeparator = ";";
        }
        if (m_fileSeparator == null) {
            m_fileSeparator = "\\";
        }
        m_bInit = CSSSystem.isOurRoot(m_userPath);
        String string = CSSSystem.getNextPart(m_classPath, m_pathSeparator, true);
        while (!m_bInit && string != null) {
            m_bInit = CSSSystem.isOurRoot(string);
            string = CSSSystem.getNextPart(m_classPath, m_pathSeparator, false);
        }
        if (!m_bInit) {
            CSSUtilities.ASSERT(false);
        }
    }

    private static String getNextPart(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            m_temp = string;
        }
        if (m_temp == null) {
            return null;
        }
        if (m_temp.indexOf(string2) >= 0) {
            string3 = m_temp.substring(0, m_temp.indexOf(string2));
            m_temp = m_temp.substring(m_temp.indexOf(string2) + string2.length());
        } else {
            string3 = m_temp = null;
        }
        return string3;
    }

    private static boolean isOurRoot(String string) {
        String string2 = m_temp;
        String string3 = string.toLowerCase();
        if (string3.endsWith(m_rootJar) && CSSSystem.fileExists(string)) {
            m_rootPath = string.substring(0, string3.indexOf("siebeltc"));
            return true;
        }
        if (!string.endsWith(m_fileSeparator)) {
            string = string + m_fileSeparator;
        }
        String string4 = string;
        CSSSystem cSSSystem = new CSSSystem();
        String string5 = cSSSystem.getClass().getName();
        string5 = string5.substring(0, string5.indexOf(m_thisClass));
        String string6 = CSSSystem.getNextPart(string5, ".", true);
        while (!m_bInit && string6 != null) {
            string = string + string6 + m_fileSeparator;
            string6 = CSSSystem.getNextPart(string5, ".", false);
        }
        m_temp = string2;
        if (CSSSystem.fileExists(string + m_thisClass + ".class")) {
            m_rootPath = string4;
            return true;
        }
        return false;
    }

    static {
        m_bInit = false;
        m_cfgSections = new Hashtable();
        m_alternateColor = null;
        m_timers = new Hashtable();
    }

    static class Timer {
        protected String m_name;
        protected long m_time;
        protected long m_max;
        protected long m_min;
        protected long m_total;
        protected int m_count;

        Timer(String string) {
            this.m_name = string;
            this.reset();
        }

        void start() {
            this.m_time = System.currentTimeMillis();
        }

        void stop() {
            long l = System.currentTimeMillis();
            this.m_total += (l -= this.m_time);
            if (l > this.m_max) {
                this.m_max = l;
            }
            if (l < this.m_min) {
                this.m_min = l;
            }
            ++this.m_count;
            this.m_time = System.currentTimeMillis();
        }

        void reset() {
            this.m_time = System.currentTimeMillis();
            this.m_max = 0L;
            this.m_min = Long.MAX_VALUE;
            this.m_total = 0L;
            this.m_count = 0;
        }

        void print() {
            System.out.println("Timer: " + this.m_name + "\tTotal: " + NumberFormat.getInstance().format((double)this.m_total / 1000.0) + "\tCalls: " + this.m_count + "\tAve.: " + NumberFormat.getInstance().format((double)this.m_total / 1000.0 / (double)this.m_count) + "\tMax: " + NumberFormat.getInstance().format((double)this.m_max / 1000.0) + "\tMin: " + NumberFormat.getInstance().format((double)this.m_min / 1000.0));
        }
    }
}

